
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A custom space reference frame type defined through a 2-D Cartesian mapping (rotate and scale)
 * 
 * <p>Java class for cart1DRefFrameType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="cart1DRefFrameType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}coordRefFrameType">
 *       <sequence>
 *         <element name="Scale" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double1Type"/>
 *       </sequence>
 *       <attribute name="id" type="{http://www.w3.org/2001/XMLSchema}ID" />
 *       <attribute name="projection" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}projectionType" default="" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "cart1DRefFrameType", propOrder = {
    "scale"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Cart1DRefFrameType
    extends CoordRefFrameType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(name = "Scale", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double1Type scale;
    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String id;
    @XmlAttribute(name = "projection")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String projection;

    /**
     * Default no-arg constructor
     * 
     */
    public Cart1DRefFrameType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Cart1DRefFrameType(final String name, final Object refFrameId, final Double1Type scale, final String id, final String projection) {
        super(name, refFrameId);
        this.scale = scale;
        this.id = id;
        this.projection = projection;
    }

    /**
     * Gets the value of the scale property.
     * 
     * @return
     *     possible object is
     *     {@link Double1Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double1Type getScale() {
        return scale;
    }

    /**
     * Sets the value of the scale property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double1Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setScale(Double1Type value) {
        this.scale = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the projection property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getProjection() {
        if (projection == null) {
            return "";
        } else {
            return projection;
        }
    }

    /**
     * Sets the value of the projection property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setProjection(String value) {
        this.projection = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Cart1DRefFrameType that = ((Cart1DRefFrameType) object);
        {
            Double1Type leftScale;
            leftScale = this.getScale();
            Double1Type rightScale;
            rightScale = that.getScale();
            if (this.scale!= null) {
                if (that.scale!= null) {
                    if (!leftScale.equals(rightScale)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.scale!= null) {
                    return false;
                }
            }
        }
        {
            String leftId;
            leftId = this.getId();
            String rightId;
            rightId = that.getId();
            if (this.id!= null) {
                if (that.id!= null) {
                    if (!leftId.equals(rightId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.id!= null) {
                    return false;
                }
            }
        }
        {
            String leftProjection;
            leftProjection = this.getProjection();
            String rightProjection;
            rightProjection = that.getProjection();
            if (this.projection!= null) {
                if (that.projection!= null) {
                    if (!leftProjection.equals(rightProjection)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.projection!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            Double1Type theScale;
            theScale = this.getScale();
            if (this.scale!= null) {
                currentHashCode += theScale.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theId;
            theId = this.getId();
            if (this.id!= null) {
                currentHashCode += theId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theProjection;
            theProjection = this.getProjection();
            if (this.projection!= null) {
                currentHashCode += theProjection.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            Double1Type theScale;
            theScale = this.getScale();
            strategy.appendField(locator, this, "scale", buffer, theScale, (this.scale!= null));
        }
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId, (this.id!= null));
        }
        {
            String theProjection;
            theProjection = this.getProjection();
            strategy.appendField(locator, this, "projection", buffer, theProjection, (this.projection!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Cart1DRefFrameType) {
            final Cart1DRefFrameType target = this;
            final Cart1DRefFrameType leftObject = ((Cart1DRefFrameType) left);
            final Cart1DRefFrameType rightObject = ((Cart1DRefFrameType) right);
            {
                Boolean scaleShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.scale!= null), (rightObject.scale!= null));
                if (scaleShouldBeMergedAndSet == Boolean.TRUE) {
                    Double1Type lhsScale;
                    lhsScale = leftObject.getScale();
                    Double1Type rhsScale;
                    rhsScale = rightObject.getScale();
                    Double1Type mergedScale = ((Double1Type) strategy.merge(LocatorUtils.property(leftLocator, "scale", lhsScale), LocatorUtils.property(rightLocator, "scale", rhsScale), lhsScale, rhsScale, (leftObject.scale!= null), (rightObject.scale!= null)));
                    target.setScale(mergedScale);
                } else {
                    if (scaleShouldBeMergedAndSet == Boolean.FALSE) {
                        target.scale = null;
                    }
                }
            }
            {
                Boolean idShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.id!= null), (rightObject.id!= null));
                if (idShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsId;
                    lhsId = leftObject.getId();
                    String rhsId;
                    rhsId = rightObject.getId();
                    String mergedId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "id", lhsId), LocatorUtils.property(rightLocator, "id", rhsId), lhsId, rhsId, (leftObject.id!= null), (rightObject.id!= null)));
                    target.setId(mergedId);
                } else {
                    if (idShouldBeMergedAndSet == Boolean.FALSE) {
                        target.id = null;
                    }
                }
            }
            {
                Boolean projectionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.projection!= null), (rightObject.projection!= null));
                if (projectionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsProjection;
                    lhsProjection = leftObject.getProjection();
                    String rhsProjection;
                    rhsProjection = rightObject.getProjection();
                    String mergedProjection = ((String) strategy.merge(LocatorUtils.property(leftLocator, "projection", lhsProjection), LocatorUtils.property(rightLocator, "projection", rhsProjection), lhsProjection, rhsProjection, (leftObject.projection!= null), (rightObject.projection!= null)));
                    target.setProjection(mergedProjection);
                } else {
                    if (projectionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.projection = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Cart1DRefFrameType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Cart1DRefFrameType clone() {
        final Cart1DRefFrameType _newObject;
        _newObject = ((Cart1DRefFrameType) super.clone());
        _newObject.scale = ((this.scale == null)?null:this.scale.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Cart1DRefFrameType createCopy() {
        final Cart1DRefFrameType _newObject = ((Cart1DRefFrameType) super.createCopy());
        _newObject.scale = ((this.scale == null)?null:this.scale.createCopy());
        _newObject.id = this.id;
        _newObject.projection = this.projection;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Cart1DRefFrameType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Cart1DRefFrameType _newObject = ((Cart1DRefFrameType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree scalePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("scale"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(scalePropertyTree!= null):((scalePropertyTree == null)||(!scalePropertyTree.isLeaf())))) {
            _newObject.scale = ((this.scale == null)?null:this.scale.createCopy(scalePropertyTree, _propertyTreeUse));
        }
        final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
            _newObject.id = this.id;
        }
        final PropertyTree projectionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("projection"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(projectionPropertyTree!= null):((projectionPropertyTree == null)||(!projectionPropertyTree.isLeaf())))) {
            _newObject.projection = this.projection;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Cart1DRefFrameType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Cart1DRefFrameType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Cart1DRefFrameType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Cart1DRefFrameType.Modifier();
        }
        return ((Cart1DRefFrameType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Cart1DRefFrameType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.scale = ((this.scale == null)?null:this.scale.newCopyBuilder(_other));
        _other.id = this.id;
        _other.projection = this.projection;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Cart1DRefFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Cart1DRefFrameType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Cart1DRefFrameType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Cart1DRefFrameType.Builder<Void> builder() {
        return new Cart1DRefFrameType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Cart1DRefFrameType.Builder<_B> copyOf(final CoordRefFrameType _other) {
        final Cart1DRefFrameType.Builder<_B> _newBuilder = new Cart1DRefFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Cart1DRefFrameType.Builder<_B> copyOf(final Cart1DRefFrameType _other) {
        final Cart1DRefFrameType.Builder<_B> _newBuilder = new Cart1DRefFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Cart1DRefFrameType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree scalePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("scale"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(scalePropertyTree!= null):((scalePropertyTree == null)||(!scalePropertyTree.isLeaf())))) {
            _other.scale = ((this.scale == null)?null:this.scale.newCopyBuilder(_other, scalePropertyTree, _propertyTreeUse));
        }
        final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
            _other.id = this.id;
        }
        final PropertyTree projectionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("projection"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(projectionPropertyTree!= null):((projectionPropertyTree == null)||(!projectionPropertyTree.isLeaf())))) {
            _other.projection = this.projection;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Cart1DRefFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Cart1DRefFrameType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Cart1DRefFrameType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Cart1DRefFrameType.Builder<_B> copyOf(final CoordRefFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Cart1DRefFrameType.Builder<_B> _newBuilder = new Cart1DRefFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Cart1DRefFrameType.Builder<_B> copyOf(final Cart1DRefFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Cart1DRefFrameType.Builder<_B> _newBuilder = new Cart1DRefFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Cart1DRefFrameType.Builder<Void> copyExcept(final CoordRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Cart1DRefFrameType.Builder<Void> copyExcept(final Cart1DRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Cart1DRefFrameType.Builder<Void> copyOnly(final CoordRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Cart1DRefFrameType.Builder<Void> copyOnly(final Cart1DRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Cart1DRefFrameType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(Cart1DRefFrameType.PropInfo.SCALE, this))&&(this.scale!= null)) {
            this.scale.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(Cart1DRefFrameType.PropInfo.ID, this));
        _visitor_.visit(new SingleProperty<>(Cart1DRefFrameType.PropInfo.PROJECTION, this));
        return this;
    }

    public static class Builder<_B >
        extends CoordRefFrameType.Builder<_B>
        implements Buildable
    {

        private Double1Type.Builder<Cart1DRefFrameType.Builder<_B>> scale;
        private String id;
        private String projection = "";

        public Builder(final _B _parentBuilder, final Cart1DRefFrameType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.scale = ((_other.scale == null)?null:_other.scale.newCopyBuilder(this));
                this.id = _other.id;
                this.projection = _other.projection;
            }
        }

        public Builder(final _B _parentBuilder, final Cart1DRefFrameType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree scalePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("scale"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(scalePropertyTree!= null):((scalePropertyTree == null)||(!scalePropertyTree.isLeaf())))) {
                    this.scale = ((_other.scale == null)?null:_other.scale.newCopyBuilder(this, scalePropertyTree, _propertyTreeUse));
                }
                final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
                    this.id = _other.id;
                }
                final PropertyTree projectionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("projection"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(projectionPropertyTree!= null):((projectionPropertyTree == null)||(!projectionPropertyTree.isLeaf())))) {
                    this.projection = _other.projection;
                }
            }
        }

        protected<_P extends Cart1DRefFrameType >_P init(final _P _product) {
            _product.scale = ((this.scale == null)?null:this.scale.build());
            _product.id = this.id;
            _product.projection = this.projection;
            return super.init(_product);
        }

        /**
         * Sets the new value of "scale" (any previous value will be replaced)
         * 
         * @param scale
         *     New value of the "scale" property.
         */
        public Cart1DRefFrameType.Builder<_B> withScale(final Double1Type scale) {
            this.scale = ((scale == null)?null:new Double1Type.Builder<>(this, scale, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "scale"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double1Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "scale" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double1Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double1Type.Builder<? extends Cart1DRefFrameType.Builder<_B>> withScale() {
            if (this.scale!= null) {
                return this.scale;
            }
            return this.scale = new Double1Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        public Cart1DRefFrameType.Builder<_B> withId(final String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the new value of "projection" (any previous value will be replaced)
         * 
         * @param projection
         *     New value of the "projection" property.
         */
        public Cart1DRefFrameType.Builder<_B> withProjection(final String projection) {
            this.projection = projection;
            return this;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        @Override
        public Cart1DRefFrameType.Builder<_B> withName(final String name) {
            super.withName(name);
            return this;
        }

        /**
         * Sets the new value of "refFrameId" (any previous value will be replaced)
         * 
         * @param refFrameId
         *     New value of the "refFrameId" property.
         */
        @Override
        public Cart1DRefFrameType.Builder<_B> withRefFrameId(final Object refFrameId) {
            super.withRefFrameId(refFrameId);
            return this;
        }

        @Override
        public Cart1DRefFrameType build() {
            if (_storedValue == null) {
                return this.init(new Cart1DRefFrameType());
            } else {
                return ((Cart1DRefFrameType) _storedValue);
            }
        }

        public Cart1DRefFrameType.Builder<_B> copyOf(final Cart1DRefFrameType _other) {
            _other.copyTo(this);
            return this;
        }

        public Cart1DRefFrameType.Builder<_B> copyOf(final Cart1DRefFrameType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends CoordRefFrameType.Modifier
    {


        public void setScale(final Double1Type scale) {
            Cart1DRefFrameType.this.setScale(scale);
        }

        public void setId(final String id) {
            Cart1DRefFrameType.this.setId(id);
        }

        public void setProjection(final String projection) {
            Cart1DRefFrameType.this.setProjection(projection);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Cart1DRefFrameType, Double1Type> SCALE = new SinglePropertyInfo<Cart1DRefFrameType,Double1Type>("scale", Cart1DRefFrameType.class, Double1Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Scale"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double1Type"), false) {


            @Override
            public Double1Type get(final Cart1DRefFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.scale);
            }

            @Override
            public void set(final Cart1DRefFrameType _instance_, final Double1Type _value_) {
                if (_instance_!= null) {
                    _instance_.scale = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Cart1DRefFrameType, String> ID = new SinglePropertyInfo<Cart1DRefFrameType,String>("id", Cart1DRefFrameType.class, String.class, false, null, new QName("", "id"), new QName("http://www.w3.org/2001/XMLSchema", "ID"), true) {


            @Override
            public String get(final Cart1DRefFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.id);
            }

            @Override
            public void set(final Cart1DRefFrameType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.id = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Cart1DRefFrameType, String> PROJECTION = new SinglePropertyInfo<Cart1DRefFrameType,String>("projection", Cart1DRefFrameType.class, String.class, false, "", new QName("", "projection"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "projectionType"), true) {


            @Override
            public String get(final Cart1DRefFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.projection);
            }

            @Override
            public void set(final Cart1DRefFrameType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.projection = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Cart1DRefFrameType.Selector<Cart1DRefFrameType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Cart1DRefFrameType.Select _root() {
            return new Cart1DRefFrameType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends CoordRefFrameType.Selector<TRoot, TParent>
    {

        private Double1Type.Selector<TRoot, Cart1DRefFrameType.Selector<TRoot, TParent>> scale = null;
        private com.kscs.util.jaxb.Selector<TRoot, Cart1DRefFrameType.Selector<TRoot, TParent>> id = null;
        private com.kscs.util.jaxb.Selector<TRoot, Cart1DRefFrameType.Selector<TRoot, TParent>> projection = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.scale!= null) {
                products.put("scale", this.scale.init());
            }
            if (this.id!= null) {
                products.put("id", this.id.init());
            }
            if (this.projection!= null) {
                products.put("projection", this.projection.init());
            }
            return products;
        }

        public Double1Type.Selector<TRoot, Cart1DRefFrameType.Selector<TRoot, TParent>> scale() {
            return ((this.scale == null)?this.scale = new Double1Type.Selector<>(this._root, this, "scale"):this.scale);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Cart1DRefFrameType.Selector<TRoot, TParent>> id() {
            return ((this.id == null)?this.id = new com.kscs.util.jaxb.Selector<>(this._root, this, "id"):this.id);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Cart1DRefFrameType.Selector<TRoot, TParent>> projection() {
            return ((this.projection == null)?this.projection = new com.kscs.util.jaxb.Selector<>(this._root, this, "projection"):this.projection);
        }

    }

}
