
package org.javastro.ivoa.entities.stc.v1;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Circle shape: center and radius
 * 
 * <p>Java class for circleType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="circleType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}shapeType">
 *       <sequence>
 *         <element name="Center" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double2Type"/>
 *         <element name="Radius" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double1Type"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "circleType", propOrder = {
    "center",
    "radius"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class CircleType
    extends ShapeType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The coordinates of the circle's center
     * 
     */
    @XmlElement(name = "Center", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double2Type center;
    /**
     * The radius of the circle
     * 
     */
    @XmlElement(name = "Radius", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double1Type radius;

    /**
     * Default no-arg constructor
     * 
     */
    public CircleType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public CircleType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final Boolean loInclude, final Boolean hiInclude, final Float fillFactor, final Object frameId, final BigDecimal epoch, final String unit, final RegionAreaType area, final String note, final Object coordSystemId, final Double2Type center, final Double1Type radius) {
        super(id, idref, ucd, type, href, idType, idrefType, loInclude, hiInclude, fillFactor, frameId, epoch, unit, area, note, coordSystemId);
        this.center = center;
        this.radius = radius;
    }

    /**
     * The coordinates of the circle's center
     * 
     * @return
     *     possible object is
     *     {@link Double2Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double2Type getCenter() {
        return center;
    }

    /**
     * Sets the value of the center property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double2Type }
     *     
     * @see #getCenter()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setCenter(Double2Type value) {
        this.center = value;
    }

    /**
     * The radius of the circle
     * 
     * @return
     *     possible object is
     *     {@link Double1Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double1Type getRadius() {
        return radius;
    }

    /**
     * Sets the value of the radius property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double1Type }
     *     
     * @see #getRadius()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setRadius(Double1Type value) {
        this.radius = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final CircleType that = ((CircleType) object);
        {
            Double2Type leftCenter;
            leftCenter = this.getCenter();
            Double2Type rightCenter;
            rightCenter = that.getCenter();
            if (this.center!= null) {
                if (that.center!= null) {
                    if (!leftCenter.equals(rightCenter)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.center!= null) {
                    return false;
                }
            }
        }
        {
            Double1Type leftRadius;
            leftRadius = this.getRadius();
            Double1Type rightRadius;
            rightRadius = that.getRadius();
            if (this.radius!= null) {
                if (that.radius!= null) {
                    if (!leftRadius.equals(rightRadius)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.radius!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            Double2Type theCenter;
            theCenter = this.getCenter();
            if (this.center!= null) {
                currentHashCode += theCenter.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Double1Type theRadius;
            theRadius = this.getRadius();
            if (this.radius!= null) {
                currentHashCode += theRadius.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            Double2Type theCenter;
            theCenter = this.getCenter();
            strategy.appendField(locator, this, "center", buffer, theCenter, (this.center!= null));
        }
        {
            Double1Type theRadius;
            theRadius = this.getRadius();
            strategy.appendField(locator, this, "radius", buffer, theRadius, (this.radius!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof CircleType) {
            final CircleType target = this;
            final CircleType leftObject = ((CircleType) left);
            final CircleType rightObject = ((CircleType) right);
            {
                Boolean centerShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.center!= null), (rightObject.center!= null));
                if (centerShouldBeMergedAndSet == Boolean.TRUE) {
                    Double2Type lhsCenter;
                    lhsCenter = leftObject.getCenter();
                    Double2Type rhsCenter;
                    rhsCenter = rightObject.getCenter();
                    Double2Type mergedCenter = ((Double2Type) strategy.merge(LocatorUtils.property(leftLocator, "center", lhsCenter), LocatorUtils.property(rightLocator, "center", rhsCenter), lhsCenter, rhsCenter, (leftObject.center!= null), (rightObject.center!= null)));
                    target.setCenter(mergedCenter);
                } else {
                    if (centerShouldBeMergedAndSet == Boolean.FALSE) {
                        target.center = null;
                    }
                }
            }
            {
                Boolean radiusShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.radius!= null), (rightObject.radius!= null));
                if (radiusShouldBeMergedAndSet == Boolean.TRUE) {
                    Double1Type lhsRadius;
                    lhsRadius = leftObject.getRadius();
                    Double1Type rhsRadius;
                    rhsRadius = rightObject.getRadius();
                    Double1Type mergedRadius = ((Double1Type) strategy.merge(LocatorUtils.property(leftLocator, "radius", lhsRadius), LocatorUtils.property(rightLocator, "radius", rhsRadius), lhsRadius, rhsRadius, (leftObject.radius!= null), (rightObject.radius!= null)));
                    target.setRadius(mergedRadius);
                } else {
                    if (radiusShouldBeMergedAndSet == Boolean.FALSE) {
                        target.radius = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new CircleType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public CircleType clone() {
        final CircleType _newObject;
        _newObject = ((CircleType) super.clone());
        _newObject.center = ((this.center == null)?null:this.center.clone());
        _newObject.radius = ((this.radius == null)?null:this.radius.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public CircleType createCopy() {
        final CircleType _newObject = ((CircleType) super.createCopy());
        _newObject.center = ((this.center == null)?null:this.center.createCopy());
        _newObject.radius = ((this.radius == null)?null:this.radius.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public CircleType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CircleType _newObject = ((CircleType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
            _newObject.center = ((this.center == null)?null:this.center.createCopy(centerPropertyTree, _propertyTreeUse));
        }
        final PropertyTree radiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radius"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusPropertyTree!= null):((radiusPropertyTree == null)||(!radiusPropertyTree.isLeaf())))) {
            _newObject.radius = ((this.radius == null)?null:this.radius.createCopy(radiusPropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public CircleType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public CircleType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public CircleType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new CircleType.Modifier();
        }
        return ((CircleType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final CircleType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.center = ((this.center == null)?null:this.center.newCopyBuilder(_other));
        _other.radius = ((this.radius == null)?null:this.radius.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >CircleType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new CircleType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public CircleType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> builder() {
        return new CircleType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final StcBaseType _other) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final CoordIntervalType _other) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final SpatialIntervalType _other) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final RegionType _other) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final ShapeType _other) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final CircleType _other) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final CircleType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
            _other.center = ((this.center == null)?null:this.center.newCopyBuilder(_other, centerPropertyTree, _propertyTreeUse));
        }
        final PropertyTree radiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radius"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusPropertyTree!= null):((radiusPropertyTree == null)||(!radiusPropertyTree.isLeaf())))) {
            _other.radius = ((this.radius == null)?null:this.radius.newCopyBuilder(_other, radiusPropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >CircleType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new CircleType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public CircleType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final CoordIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final SpatialIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final RegionType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final ShapeType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >CircleType.Builder<_B> copyOf(final CircleType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CircleType.Builder<_B> _newBuilder = new CircleType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyExcept(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyExcept(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyExcept(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyExcept(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyExcept(final CircleType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyOnly(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyOnly(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyOnly(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyOnly(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static CircleType.Builder<Void> copyOnly(final CircleType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public CircleType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(CircleType.PropInfo.CENTER, this))&&(this.center!= null)) {
            this.center.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(CircleType.PropInfo.RADIUS, this))&&(this.radius!= null)) {
            this.radius.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends ShapeType.Builder<_B>
        implements Buildable
    {

        private Double2Type.Builder<CircleType.Builder<_B>> center;
        private Double1Type.Builder<CircleType.Builder<_B>> radius;

        public Builder(final _B _parentBuilder, final CircleType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.center = ((_other.center == null)?null:_other.center.newCopyBuilder(this));
                this.radius = ((_other.radius == null)?null:_other.radius.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final CircleType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
                    this.center = ((_other.center == null)?null:_other.center.newCopyBuilder(this, centerPropertyTree, _propertyTreeUse));
                }
                final PropertyTree radiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radius"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusPropertyTree!= null):((radiusPropertyTree == null)||(!radiusPropertyTree.isLeaf())))) {
                    this.radius = ((_other.radius == null)?null:_other.radius.newCopyBuilder(this, radiusPropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends CircleType >_P init(final _P _product) {
            _product.center = ((this.center == null)?null:this.center.build());
            _product.radius = ((this.radius == null)?null:this.radius.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "center" (any previous value will be replaced)
         * 
         * @param center
         *     New value of the "center" property.
         */
        public CircleType.Builder<_B> withCenter(final Double2Type center) {
            this.center = ((center == null)?null:new Double2Type.Builder<>(this, center, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "center"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double2Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "center" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double2Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double2Type.Builder<? extends CircleType.Builder<_B>> withCenter() {
            if (this.center!= null) {
                return this.center;
            }
            return this.center = new Double2Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "radius" (any previous value will be replaced)
         * 
         * @param radius
         *     New value of the "radius" property.
         */
        public CircleType.Builder<_B> withRadius(final Double1Type radius) {
            this.radius = ((radius == null)?null:new Double1Type.Builder<>(this, radius, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "radius"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double1Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "radius" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double1Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double1Type.Builder<? extends CircleType.Builder<_B>> withRadius() {
            if (this.radius!= null) {
                return this.radius;
            }
            return this.radius = new Double1Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "area" (any previous value will be replaced)
         * 
         * @param area
         *     New value of the "area" property.
         */
        @Override
        public CircleType.Builder<_B> withArea(final RegionAreaType area) {
            super.withArea(area);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "area"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "area" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         *     return to the current builder.
         */
        public RegionAreaType.Builder<? extends CircleType.Builder<_B>> withArea() {
            return ((RegionAreaType.Builder<? extends CircleType.Builder<_B>> ) super.withArea());
        }

        /**
         * Sets the new value of "note" (any previous value will be replaced)
         * 
         * @param note
         *     New value of the "note" property.
         */
        @Override
        public CircleType.Builder<_B> withNote(final String note) {
            super.withNote(note);
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        @Override
        public CircleType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            super.withCoordSystemId(coordSystemId);
            return this;
        }

        /**
         * Sets the new value of "epoch" (any previous value will be replaced)
         * 
         * @param epoch
         *     New value of the "epoch" property.
         */
        @Override
        public CircleType.Builder<_B> withEpoch(final BigDecimal epoch) {
            super.withEpoch(epoch);
            return this;
        }

        /**
         * Sets the new value of "unit" (any previous value will be replaced)
         * 
         * @param unit
         *     New value of the "unit" property.
         */
        @Override
        public CircleType.Builder<_B> withUnit(final String unit) {
            super.withUnit(unit);
            return this;
        }

        /**
         * Sets the new value of "loInclude" (any previous value will be replaced)
         * 
         * @param loInclude
         *     New value of the "loInclude" property.
         */
        @Override
        public CircleType.Builder<_B> withLoInclude(final Boolean loInclude) {
            super.withLoInclude(loInclude);
            return this;
        }

        /**
         * Sets the new value of "hiInclude" (any previous value will be replaced)
         * 
         * @param hiInclude
         *     New value of the "hiInclude" property.
         */
        @Override
        public CircleType.Builder<_B> withHiInclude(final Boolean hiInclude) {
            super.withHiInclude(hiInclude);
            return this;
        }

        /**
         * Sets the new value of "fillFactor" (any previous value will be replaced)
         * 
         * @param fillFactor
         *     New value of the "fillFactor" property.
         */
        @Override
        public CircleType.Builder<_B> withFillFactor(final Float fillFactor) {
            super.withFillFactor(fillFactor);
            return this;
        }

        /**
         * Sets the new value of "frameId" (any previous value will be replaced)
         * 
         * @param frameId
         *     New value of the "frameId" property.
         */
        @Override
        public CircleType.Builder<_B> withFrameId(final Object frameId) {
            super.withFrameId(frameId);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public CircleType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public CircleType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public CircleType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public CircleType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public CircleType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public CircleType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public CircleType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public CircleType build() {
            if (_storedValue == null) {
                return this.init(new CircleType());
            } else {
                return ((CircleType) _storedValue);
            }
        }

        public CircleType.Builder<_B> copyOf(final CircleType _other) {
            _other.copyTo(this);
            return this;
        }

        public CircleType.Builder<_B> copyOf(final CircleType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends ShapeType.Modifier
    {


        public void setCenter(final Double2Type center) {
            CircleType.this.setCenter(center);
        }

        public void setRadius(final Double1Type radius) {
            CircleType.this.setRadius(radius);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<CircleType, Double2Type> CENTER = new SinglePropertyInfo<CircleType,Double2Type>("center", CircleType.class, Double2Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Center"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double2Type"), false) {


            @Override
            public Double2Type get(final CircleType _instance_) {
                return ((_instance_ == null)?null:_instance_.center);
            }

            @Override
            public void set(final CircleType _instance_, final Double2Type _value_) {
                if (_instance_!= null) {
                    _instance_.center = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CircleType, Double1Type> RADIUS = new SinglePropertyInfo<CircleType,Double1Type>("radius", CircleType.class, Double1Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Radius"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double1Type"), false) {


            @Override
            public Double1Type get(final CircleType _instance_) {
                return ((_instance_ == null)?null:_instance_.radius);
            }

            @Override
            public void set(final CircleType _instance_, final Double1Type _value_) {
                if (_instance_!= null) {
                    _instance_.radius = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends CircleType.Selector<CircleType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static CircleType.Select _root() {
            return new CircleType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends ShapeType.Selector<TRoot, TParent>
    {

        private Double2Type.Selector<TRoot, CircleType.Selector<TRoot, TParent>> center = null;
        private Double1Type.Selector<TRoot, CircleType.Selector<TRoot, TParent>> radius = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.center!= null) {
                products.put("center", this.center.init());
            }
            if (this.radius!= null) {
                products.put("radius", this.radius.init());
            }
            return products;
        }

        public Double2Type.Selector<TRoot, CircleType.Selector<TRoot, TParent>> center() {
            return ((this.center == null)?this.center = new Double2Type.Selector<>(this._root, this, "center"):this.center);
        }

        public Double1Type.Selector<TRoot, CircleType.Selector<TRoot, TParent>> radius() {
            return ((this.radius == null)?this.radius = new Double1Type.Selector<>(this._root, this, "radius"):this.radius);
        }

    }

}
