
package org.javastro.ivoa.entities.stc.v1;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A convex hull: the smallest convex polygon that contains all its points; in spherical coordinates all points have to be contained within a hemisphere
 * 
 * <p>Java class for convexHullType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="convexHullType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}shapeType">
 *       <sequence>
 *         <element name="Point" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double3Type" maxOccurs="unbounded"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "convexHullType", propOrder = {
    "points"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class ConvexHullType
    extends ShapeType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(name = "Point", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<Double3Type> points;

    /**
     * Default no-arg constructor
     * 
     */
    public ConvexHullType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public ConvexHullType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final Boolean loInclude, final Boolean hiInclude, final Float fillFactor, final Object frameId, final BigDecimal epoch, final String unit, final RegionAreaType area, final String note, final Object coordSystemId, final List<Double3Type> points) {
        super(id, idref, ucd, type, href, idType, idrefType, loInclude, hiInclude, fillFactor, frameId, epoch, unit, area, note, coordSystemId);
        this.points = points;
    }

    /**
     * Gets the value of the points property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the points property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPoints().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Double3Type }
     * </p>
     * 
     * 
     * @return
     *     The value of the points property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<Double3Type> getPoints() {
        if (points == null) {
            points = new ArrayList<>();
        }
        return this.points;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final ConvexHullType that = ((ConvexHullType) object);
        {
            List<Double3Type> leftPoints;
            leftPoints = (((this.points!= null)&&(!this.points.isEmpty()))?this.getPoints():null);
            List<Double3Type> rightPoints;
            rightPoints = (((that.points!= null)&&(!that.points.isEmpty()))?that.getPoints():null);
            if ((this.points!= null)&&(!this.points.isEmpty())) {
                if ((that.points!= null)&&(!that.points.isEmpty())) {
                    if (!leftPoints.equals(rightPoints)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.points!= null)&&(!that.points.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<Double3Type> thePoints;
            thePoints = (((this.points!= null)&&(!this.points.isEmpty()))?this.getPoints():null);
            if ((this.points!= null)&&(!this.points.isEmpty())) {
                currentHashCode += thePoints.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<Double3Type> thePoints;
            thePoints = (((this.points!= null)&&(!this.points.isEmpty()))?this.getPoints():null);
            strategy.appendField(locator, this, "points", buffer, thePoints, ((this.points!= null)&&(!this.points.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof ConvexHullType) {
            final ConvexHullType target = this;
            final ConvexHullType leftObject = ((ConvexHullType) left);
            final ConvexHullType rightObject = ((ConvexHullType) right);
            {
                Boolean pointsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.points!= null)&&(!leftObject.points.isEmpty())), ((rightObject.points!= null)&&(!rightObject.points.isEmpty())));
                if (pointsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Double3Type> lhsPoints;
                    lhsPoints = (((leftObject.points!= null)&&(!leftObject.points.isEmpty()))?leftObject.getPoints():null);
                    List<Double3Type> rhsPoints;
                    rhsPoints = (((rightObject.points!= null)&&(!rightObject.points.isEmpty()))?rightObject.getPoints():null);
                    List<Double3Type> mergedPoints = ((List<Double3Type> ) strategy.merge(LocatorUtils.property(leftLocator, "points", lhsPoints), LocatorUtils.property(rightLocator, "points", rhsPoints), lhsPoints, rhsPoints, ((leftObject.points!= null)&&(!leftObject.points.isEmpty())), ((rightObject.points!= null)&&(!rightObject.points.isEmpty()))));
                    target.points = null;
                    if (mergedPoints!= null) {
                        List<Double3Type> uniquePointsl = target.getPoints();
                        uniquePointsl.addAll(mergedPoints);
                    }
                } else {
                    if (pointsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.points = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new ConvexHullType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ConvexHullType clone() {
        final ConvexHullType _newObject;
        _newObject = ((ConvexHullType) super.clone());
        if (this.points == null) {
            _newObject.points = null;
        } else {
            _newObject.points = new ArrayList<>();
            for (Double3Type _item: this.points) {
                _newObject.points.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ConvexHullType createCopy() {
        final ConvexHullType _newObject = ((ConvexHullType) super.createCopy());
        if (this.points == null) {
            _newObject.points = null;
        } else {
            _newObject.points = new ArrayList<>();
            for (Double3Type _item: this.points) {
                _newObject.points.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ConvexHullType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ConvexHullType _newObject = ((ConvexHullType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree pointsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("points"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pointsPropertyTree!= null):((pointsPropertyTree == null)||(!pointsPropertyTree.isLeaf())))) {
            if (this.points == null) {
                _newObject.points = null;
            } else {
                _newObject.points = new ArrayList<>();
                for (Double3Type _item: this.points) {
                    _newObject.points.add(((_item == null)?null:_item.createCopy(pointsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ConvexHullType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ConvexHullType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ConvexHullType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new ConvexHullType.Modifier();
        }
        return ((ConvexHullType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final ConvexHullType.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.points == null) {
            _other.points = null;
        } else {
            _other.points = new ArrayList<>();
            for (Double3Type _item: this.points) {
                _other.points.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >ConvexHullType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new ConvexHullType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ConvexHullType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> builder() {
        return new ConvexHullType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final StcBaseType _other) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final CoordIntervalType _other) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final SpatialIntervalType _other) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final RegionType _other) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final ShapeType _other) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final ConvexHullType _other) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final ConvexHullType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree pointsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("points"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pointsPropertyTree!= null):((pointsPropertyTree == null)||(!pointsPropertyTree.isLeaf())))) {
            if (this.points == null) {
                _other.points = null;
            } else {
                _other.points = new ArrayList<>();
                for (Double3Type _item: this.points) {
                    _other.points.add(((_item == null)?null:_item.newCopyBuilder(_other, pointsPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >ConvexHullType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new ConvexHullType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ConvexHullType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final CoordIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final SpatialIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final RegionType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final ShapeType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ConvexHullType.Builder<_B> copyOf(final ConvexHullType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ConvexHullType.Builder<_B> _newBuilder = new ConvexHullType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyExcept(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyExcept(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyExcept(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyExcept(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyExcept(final ConvexHullType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyOnly(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyOnly(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyOnly(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyOnly(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ConvexHullType.Builder<Void> copyOnly(final ConvexHullType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ConvexHullType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty<>(ConvexHullType.PropInfo.POINTS, this))&&(this.points!= null)) {
            for (Double3Type _item_: this.points) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends ShapeType.Builder<_B>
        implements Buildable
    {

        private List<Double3Type.Builder<ConvexHullType.Builder<_B>>> points;

        public Builder(final _B _parentBuilder, final ConvexHullType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.points == null) {
                    this.points = null;
                } else {
                    this.points = new ArrayList<>();
                    for (Double3Type _item: _other.points) {
                        this.points.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final ConvexHullType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree pointsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("points"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pointsPropertyTree!= null):((pointsPropertyTree == null)||(!pointsPropertyTree.isLeaf())))) {
                    if (_other.points == null) {
                        this.points = null;
                    } else {
                        this.points = new ArrayList<>();
                        for (Double3Type _item: _other.points) {
                            this.points.add(((_item == null)?null:_item.newCopyBuilder(this, pointsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
            }
        }

        protected<_P extends ConvexHullType >_P init(final _P _product) {
            if (this.points!= null) {
                final List<Double3Type> points = new ArrayList<>(this.points.size());
                for (Double3Type.Builder<ConvexHullType.Builder<_B>> _item: this.points) {
                    points.add(_item.build());
                }
                _product.points = points;
            }
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "points"
         * 
         * @param points
         *     Items to add to the value of the "points" property
         */
        public ConvexHullType.Builder<_B> addPoints(final Iterable<? extends Double3Type> points) {
            if (points!= null) {
                if (this.points == null) {
                    this.points = new ArrayList<>();
                }
                for (Double3Type _item: points) {
                    this.points.add(new Double3Type.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "points" (any previous value will be replaced)
         * 
         * @param points
         *     New value of the "points" property.
         */
        public ConvexHullType.Builder<_B> withPoints(final Iterable<? extends Double3Type> points) {
            if (this.points!= null) {
                this.points.clear();
            }
            return addPoints(points);
        }

        /**
         * Adds the given items to the value of "points"
         * 
         * @param points
         *     Items to add to the value of the "points" property
         */
        public ConvexHullType.Builder<_B> addPoints(Double3Type... points) {
            addPoints(Arrays.asList(points));
            return this;
        }

        /**
         * Sets the new value of "points" (any previous value will be replaced)
         * 
         * @param points
         *     New value of the "points" property.
         */
        public ConvexHullType.Builder<_B> withPoints(Double3Type... points) {
            withPoints(Arrays.asList(points));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Points" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double3Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Points" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double3Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double3Type.Builder<? extends ConvexHullType.Builder<_B>> addPoints() {
            if (this.points == null) {
                this.points = new ArrayList<>();
            }
            final Double3Type.Builder<ConvexHullType.Builder<_B>> points_Builder = new Double3Type.Builder<>(this, null, false);
            this.points.add(points_Builder);
            return points_Builder;
        }

        /**
         * Sets the new value of "area" (any previous value will be replaced)
         * 
         * @param area
         *     New value of the "area" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withArea(final RegionAreaType area) {
            super.withArea(area);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "area"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "area" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         *     return to the current builder.
         */
        public RegionAreaType.Builder<? extends ConvexHullType.Builder<_B>> withArea() {
            return ((RegionAreaType.Builder<? extends ConvexHullType.Builder<_B>> ) super.withArea());
        }

        /**
         * Sets the new value of "note" (any previous value will be replaced)
         * 
         * @param note
         *     New value of the "note" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withNote(final String note) {
            super.withNote(note);
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            super.withCoordSystemId(coordSystemId);
            return this;
        }

        /**
         * Sets the new value of "epoch" (any previous value will be replaced)
         * 
         * @param epoch
         *     New value of the "epoch" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withEpoch(final BigDecimal epoch) {
            super.withEpoch(epoch);
            return this;
        }

        /**
         * Sets the new value of "unit" (any previous value will be replaced)
         * 
         * @param unit
         *     New value of the "unit" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withUnit(final String unit) {
            super.withUnit(unit);
            return this;
        }

        /**
         * Sets the new value of "loInclude" (any previous value will be replaced)
         * 
         * @param loInclude
         *     New value of the "loInclude" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withLoInclude(final Boolean loInclude) {
            super.withLoInclude(loInclude);
            return this;
        }

        /**
         * Sets the new value of "hiInclude" (any previous value will be replaced)
         * 
         * @param hiInclude
         *     New value of the "hiInclude" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withHiInclude(final Boolean hiInclude) {
            super.withHiInclude(hiInclude);
            return this;
        }

        /**
         * Sets the new value of "fillFactor" (any previous value will be replaced)
         * 
         * @param fillFactor
         *     New value of the "fillFactor" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withFillFactor(final Float fillFactor) {
            super.withFillFactor(fillFactor);
            return this;
        }

        /**
         * Sets the new value of "frameId" (any previous value will be replaced)
         * 
         * @param frameId
         *     New value of the "frameId" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withFrameId(final Object frameId) {
            super.withFrameId(frameId);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public ConvexHullType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public ConvexHullType build() {
            if (_storedValue == null) {
                return this.init(new ConvexHullType());
            } else {
                return ((ConvexHullType) _storedValue);
            }
        }

        public ConvexHullType.Builder<_B> copyOf(final ConvexHullType _other) {
            _other.copyTo(this);
            return this;
        }

        public ConvexHullType.Builder<_B> copyOf(final ConvexHullType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends ShapeType.Modifier
    {


        public List<Double3Type> getPoints() {
            if (ConvexHullType.this.points == null) {
                ConvexHullType.this.points = new ArrayList<>();
            }
            return ConvexHullType.this.points;
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<ConvexHullType, Double3Type> POINTS = new CollectionPropertyInfo<ConvexHullType,Double3Type>("points", ConvexHullType.class, Double3Type.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Point"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double3Type"), false) {


            @Override
            public List<Double3Type> get(final ConvexHullType _instance_) {
                return ((_instance_ == null)?null:_instance_.points);
            }

            @Override
            public void set(final ConvexHullType _instance_, final List<Double3Type> _value_) {
                if (_instance_!= null) {
                    _instance_.points = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends ConvexHullType.Selector<ConvexHullType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static ConvexHullType.Select _root() {
            return new ConvexHullType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends ShapeType.Selector<TRoot, TParent>
    {

        private Double3Type.Selector<TRoot, ConvexHullType.Selector<TRoot, TParent>> points = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.points!= null) {
                products.put("points", this.points.init());
            }
            return products;
        }

        public Double3Type.Selector<TRoot, ConvexHullType.Selector<TRoot, TParent>> points() {
            return ((this.points == null)?this.points = new Double3Type.Selector<>(this._root, this, "points"):this.points);
        }

    }

}
