
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A curve in 3-D space, defined by its end points and a shape attribute (default: line or great circle)
 * 
 * <p>Java class for curve3Type complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="curve3Type">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}stcBaseType">
 *       <sequence>
 *         <element name="P1" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double3Type"/>
 *         <element name="P2" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double3Type"/>
 *       </sequence>
 *       <attribute name="curve_shape" type="{http://www.w3.org/2001/XMLSchema}string" default="line" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "curve3Type", propOrder = {
    "p1",
    "p2"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Curve3Type
    extends StcBaseType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(name = "P1", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double3Type p1;
    @XmlElement(name = "P2", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double3Type p2;
    @XmlAttribute(name = "curve_shape")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String curveShape;

    /**
     * Default no-arg constructor
     * 
     */
    public Curve3Type() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Curve3Type(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final Double3Type p1, final Double3Type p2, final String curveShape) {
        super(id, idref, ucd, type, href, idType, idrefType);
        this.p1 = p1;
        this.p2 = p2;
        this.curveShape = curveShape;
    }

    /**
     * Gets the value of the p1 property.
     * 
     * @return
     *     possible object is
     *     {@link Double3Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double3Type getP1() {
        return p1;
    }

    /**
     * Sets the value of the p1 property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double3Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setP1(Double3Type value) {
        this.p1 = value;
    }

    /**
     * Gets the value of the p2 property.
     * 
     * @return
     *     possible object is
     *     {@link Double3Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double3Type getP2() {
        return p2;
    }

    /**
     * Sets the value of the p2 property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double3Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setP2(Double3Type value) {
        this.p2 = value;
    }

    /**
     * Gets the value of the curveShape property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getCurveShape() {
        if (curveShape == null) {
            return "line";
        } else {
            return curveShape;
        }
    }

    /**
     * Sets the value of the curveShape property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setCurveShape(String value) {
        this.curveShape = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Curve3Type that = ((Curve3Type) object);
        {
            Double3Type leftP1;
            leftP1 = this.getP1();
            Double3Type rightP1;
            rightP1 = that.getP1();
            if (this.p1 != null) {
                if (that.p1 != null) {
                    if (!leftP1 .equals(rightP1)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.p1 != null) {
                    return false;
                }
            }
        }
        {
            Double3Type leftP2;
            leftP2 = this.getP2();
            Double3Type rightP2;
            rightP2 = that.getP2();
            if (this.p2 != null) {
                if (that.p2 != null) {
                    if (!leftP2 .equals(rightP2)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.p2 != null) {
                    return false;
                }
            }
        }
        {
            String leftCurveShape;
            leftCurveShape = this.getCurveShape();
            String rightCurveShape;
            rightCurveShape = that.getCurveShape();
            if (this.curveShape!= null) {
                if (that.curveShape!= null) {
                    if (!leftCurveShape.equals(rightCurveShape)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.curveShape!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            Double3Type theP1;
            theP1 = this.getP1();
            if (this.p1 != null) {
                currentHashCode += theP1 .hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Double3Type theP2;
            theP2 = this.getP2();
            if (this.p2 != null) {
                currentHashCode += theP2 .hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCurveShape;
            theCurveShape = this.getCurveShape();
            if (this.curveShape!= null) {
                currentHashCode += theCurveShape.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            Double3Type theP1;
            theP1 = this.getP1();
            strategy.appendField(locator, this, "p1", buffer, theP1, (this.p1 != null));
        }
        {
            Double3Type theP2;
            theP2 = this.getP2();
            strategy.appendField(locator, this, "p2", buffer, theP2, (this.p2 != null));
        }
        {
            String theCurveShape;
            theCurveShape = this.getCurveShape();
            strategy.appendField(locator, this, "curveShape", buffer, theCurveShape, (this.curveShape!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Curve3Type) {
            final Curve3Type target = this;
            final Curve3Type leftObject = ((Curve3Type) left);
            final Curve3Type rightObject = ((Curve3Type) right);
            {
                Boolean p1ShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.p1 != null), (rightObject.p1 != null));
                if (p1ShouldBeMergedAndSet == Boolean.TRUE) {
                    Double3Type lhsP1;
                    lhsP1 = leftObject.getP1();
                    Double3Type rhsP1;
                    rhsP1 = rightObject.getP1();
                    Double3Type mergedP1 = ((Double3Type) strategy.merge(LocatorUtils.property(leftLocator, "p1", lhsP1), LocatorUtils.property(rightLocator, "p1", rhsP1), lhsP1, rhsP1, (leftObject.p1 != null), (rightObject.p1 != null)));
                    target.setP1(mergedP1);
                } else {
                    if (p1ShouldBeMergedAndSet == Boolean.FALSE) {
                        target.p1 = null;
                    }
                }
            }
            {
                Boolean p2ShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.p2 != null), (rightObject.p2 != null));
                if (p2ShouldBeMergedAndSet == Boolean.TRUE) {
                    Double3Type lhsP2;
                    lhsP2 = leftObject.getP2();
                    Double3Type rhsP2;
                    rhsP2 = rightObject.getP2();
                    Double3Type mergedP2 = ((Double3Type) strategy.merge(LocatorUtils.property(leftLocator, "p2", lhsP2), LocatorUtils.property(rightLocator, "p2", rhsP2), lhsP2, rhsP2, (leftObject.p2 != null), (rightObject.p2 != null)));
                    target.setP2(mergedP2);
                } else {
                    if (p2ShouldBeMergedAndSet == Boolean.FALSE) {
                        target.p2 = null;
                    }
                }
            }
            {
                Boolean curveShapeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.curveShape!= null), (rightObject.curveShape!= null));
                if (curveShapeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsCurveShape;
                    lhsCurveShape = leftObject.getCurveShape();
                    String rhsCurveShape;
                    rhsCurveShape = rightObject.getCurveShape();
                    String mergedCurveShape = ((String) strategy.merge(LocatorUtils.property(leftLocator, "curveShape", lhsCurveShape), LocatorUtils.property(rightLocator, "curveShape", rhsCurveShape), lhsCurveShape, rhsCurveShape, (leftObject.curveShape!= null), (rightObject.curveShape!= null)));
                    target.setCurveShape(mergedCurveShape);
                } else {
                    if (curveShapeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.curveShape = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Curve3Type();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Curve3Type clone() {
        final Curve3Type _newObject;
        _newObject = ((Curve3Type) super.clone());
        _newObject.p1 = ((this.p1 == null)?null:this.p1 .clone());
        _newObject.p2 = ((this.p2 == null)?null:this.p2 .clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Curve3Type createCopy() {
        final Curve3Type _newObject = ((Curve3Type) super.createCopy());
        _newObject.p1 = ((this.p1 == null)?null:this.p1 .createCopy());
        _newObject.p2 = ((this.p2 == null)?null:this.p2 .createCopy());
        _newObject.curveShape = this.curveShape;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Curve3Type createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Curve3Type _newObject = ((Curve3Type) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree p1PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("p1"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(p1PropertyTree!= null):((p1PropertyTree == null)||(!p1PropertyTree.isLeaf())))) {
            _newObject.p1 = ((this.p1 == null)?null:this.p1 .createCopy(p1PropertyTree, _propertyTreeUse));
        }
        final PropertyTree p2PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("p2"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(p2PropertyTree!= null):((p2PropertyTree == null)||(!p2PropertyTree.isLeaf())))) {
            _newObject.p2 = ((this.p2 == null)?null:this.p2 .createCopy(p2PropertyTree, _propertyTreeUse));
        }
        final PropertyTree curveShapePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("curveShape"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(curveShapePropertyTree!= null):((curveShapePropertyTree == null)||(!curveShapePropertyTree.isLeaf())))) {
            _newObject.curveShape = this.curveShape;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Curve3Type copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Curve3Type copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Curve3Type.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Curve3Type.Modifier();
        }
        return ((Curve3Type.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Curve3Type.Builder<_B> _other) {
        super.copyTo(_other);
        _other.p1 = ((this.p1 == null)?null:this.p1 .newCopyBuilder(_other));
        _other.p2 = ((this.p2 == null)?null:this.p2 .newCopyBuilder(_other));
        _other.curveShape = this.curveShape;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Curve3Type.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Curve3Type.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Curve3Type.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Curve3Type.Builder<Void> builder() {
        return new Curve3Type.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Curve3Type.Builder<_B> copyOf(final StcBaseType _other) {
        final Curve3Type.Builder<_B> _newBuilder = new Curve3Type.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Curve3Type.Builder<_B> copyOf(final Curve3Type _other) {
        final Curve3Type.Builder<_B> _newBuilder = new Curve3Type.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Curve3Type.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree p1PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("p1"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(p1PropertyTree!= null):((p1PropertyTree == null)||(!p1PropertyTree.isLeaf())))) {
            _other.p1 = ((this.p1 == null)?null:this.p1 .newCopyBuilder(_other, p1PropertyTree, _propertyTreeUse));
        }
        final PropertyTree p2PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("p2"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(p2PropertyTree!= null):((p2PropertyTree == null)||(!p2PropertyTree.isLeaf())))) {
            _other.p2 = ((this.p2 == null)?null:this.p2 .newCopyBuilder(_other, p2PropertyTree, _propertyTreeUse));
        }
        final PropertyTree curveShapePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("curveShape"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(curveShapePropertyTree!= null):((curveShapePropertyTree == null)||(!curveShapePropertyTree.isLeaf())))) {
            _other.curveShape = this.curveShape;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Curve3Type.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Curve3Type.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Curve3Type.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Curve3Type.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Curve3Type.Builder<_B> _newBuilder = new Curve3Type.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Curve3Type.Builder<_B> copyOf(final Curve3Type _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Curve3Type.Builder<_B> _newBuilder = new Curve3Type.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Curve3Type.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Curve3Type.Builder<Void> copyExcept(final Curve3Type _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Curve3Type.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Curve3Type.Builder<Void> copyOnly(final Curve3Type _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Curve3Type visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(Curve3Type.PropInfo.P_1, this))&&(this.p1 != null)) {
            this.p1 .visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(Curve3Type.PropInfo.P_2, this))&&(this.p2 != null)) {
            this.p2 .visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(Curve3Type.PropInfo.CURVE_SHAPE, this));
        return this;
    }

    public static class Builder<_B >
        extends StcBaseType.Builder<_B>
        implements Buildable
    {

        private Double3Type.Builder<Curve3Type.Builder<_B>> p1;
        private Double3Type.Builder<Curve3Type.Builder<_B>> p2;
        private String curveShape = "line";

        public Builder(final _B _parentBuilder, final Curve3Type _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.p1 = ((_other.p1 == null)?null:_other.p1 .newCopyBuilder(this));
                this.p2 = ((_other.p2 == null)?null:_other.p2 .newCopyBuilder(this));
                this.curveShape = _other.curveShape;
            }
        }

        public Builder(final _B _parentBuilder, final Curve3Type _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree p1PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("p1"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(p1PropertyTree!= null):((p1PropertyTree == null)||(!p1PropertyTree.isLeaf())))) {
                    this.p1 = ((_other.p1 == null)?null:_other.p1 .newCopyBuilder(this, p1PropertyTree, _propertyTreeUse));
                }
                final PropertyTree p2PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("p2"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(p2PropertyTree!= null):((p2PropertyTree == null)||(!p2PropertyTree.isLeaf())))) {
                    this.p2 = ((_other.p2 == null)?null:_other.p2 .newCopyBuilder(this, p2PropertyTree, _propertyTreeUse));
                }
                final PropertyTree curveShapePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("curveShape"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(curveShapePropertyTree!= null):((curveShapePropertyTree == null)||(!curveShapePropertyTree.isLeaf())))) {
                    this.curveShape = _other.curveShape;
                }
            }
        }

        protected<_P extends Curve3Type >_P init(final _P _product) {
            _product.p1 = ((this.p1 == null)?null:this.p1 .build());
            _product.p2 = ((this.p2 == null)?null:this.p2 .build());
            _product.curveShape = this.curveShape;
            return super.init(_product);
        }

        /**
         * Sets the new value of "p1" (any previous value will be replaced)
         * 
         * @param p1
         *     New value of the "p1" property.
         */
        public Curve3Type.Builder<_B> withP1(final Double3Type p1) {
            this.p1 = ((p1 == null)?null:new Double3Type.Builder<>(this, p1, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "p1"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double3Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "p1" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double3Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double3Type.Builder<? extends Curve3Type.Builder<_B>> withP1() {
            if (this.p1 != null) {
                return this.p1;
            }
            return this.p1 = new Double3Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "p2" (any previous value will be replaced)
         * 
         * @param p2
         *     New value of the "p2" property.
         */
        public Curve3Type.Builder<_B> withP2(final Double3Type p2) {
            this.p2 = ((p2 == null)?null:new Double3Type.Builder<>(this, p2, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "p2"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double3Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "p2" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double3Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double3Type.Builder<? extends Curve3Type.Builder<_B>> withP2() {
            if (this.p2 != null) {
                return this.p2;
            }
            return this.p2 = new Double3Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "curveShape" (any previous value will be replaced)
         * 
         * @param curveShape
         *     New value of the "curveShape" property.
         */
        public Curve3Type.Builder<_B> withCurveShape(final String curveShape) {
            this.curveShape = curveShape;
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public Curve3Type.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public Curve3Type.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public Curve3Type.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public Curve3Type.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public Curve3Type.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public Curve3Type.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public Curve3Type.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public Curve3Type build() {
            if (_storedValue == null) {
                return this.init(new Curve3Type());
            } else {
                return ((Curve3Type) _storedValue);
            }
        }

        public Curve3Type.Builder<_B> copyOf(final Curve3Type _other) {
            _other.copyTo(this);
            return this;
        }

        public Curve3Type.Builder<_B> copyOf(final Curve3Type.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends StcBaseType.Modifier
    {


        public void setP1(final Double3Type p1) {
            Curve3Type.this.setP1(p1);
        }

        public void setP2(final Double3Type p2) {
            Curve3Type.this.setP2(p2);
        }

        public void setCurveShape(final String curveShape) {
            Curve3Type.this.setCurveShape(curveShape);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Curve3Type, Double3Type> P_1 = new SinglePropertyInfo<Curve3Type,Double3Type>("p1", Curve3Type.class, Double3Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "P1"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double3Type"), false) {


            @Override
            public Double3Type get(final Curve3Type _instance_) {
                return ((_instance_ == null)?null:_instance_.p1);
            }

            @Override
            public void set(final Curve3Type _instance_, final Double3Type _value_) {
                if (_instance_!= null) {
                    _instance_.p1 = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Curve3Type, Double3Type> P_2 = new SinglePropertyInfo<Curve3Type,Double3Type>("p2", Curve3Type.class, Double3Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "P2"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double3Type"), false) {


            @Override
            public Double3Type get(final Curve3Type _instance_) {
                return ((_instance_ == null)?null:_instance_.p2);
            }

            @Override
            public void set(final Curve3Type _instance_, final Double3Type _value_) {
                if (_instance_!= null) {
                    _instance_.p2 = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Curve3Type, String> CURVE_SHAPE = new SinglePropertyInfo<Curve3Type,String>("curveShape", Curve3Type.class, String.class, false, "line", new QName("", "curve_shape"), new QName("http://www.w3.org/2001/XMLSchema", "string"), true) {


            @Override
            public String get(final Curve3Type _instance_) {
                return ((_instance_ == null)?null:_instance_.curveShape);
            }

            @Override
            public void set(final Curve3Type _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.curveShape = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Curve3Type.Selector<Curve3Type.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Curve3Type.Select _root() {
            return new Curve3Type.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends StcBaseType.Selector<TRoot, TParent>
    {

        private Double3Type.Selector<TRoot, Curve3Type.Selector<TRoot, TParent>> p1 = null;
        private Double3Type.Selector<TRoot, Curve3Type.Selector<TRoot, TParent>> p2 = null;
        private com.kscs.util.jaxb.Selector<TRoot, Curve3Type.Selector<TRoot, TParent>> curveShape = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.p1 != null) {
                products.put("p1", this.p1 .init());
            }
            if (this.p2 != null) {
                products.put("p2", this.p2 .init());
            }
            if (this.curveShape!= null) {
                products.put("curveShape", this.curveShape.init());
            }
            return products;
        }

        public Double3Type.Selector<TRoot, Curve3Type.Selector<TRoot, TParent>> p1() {
            return ((this.p1 == null)?this.p1 = new Double3Type.Selector<>(this._root, this, "p1"):this.p1);
        }

        public Double3Type.Selector<TRoot, Curve3Type.Selector<TRoot, TParent>> p2() {
            return ((this.p2 == null)?this.p2 = new Double3Type.Selector<>(this._root, this, "p2"):this.p2);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Curve3Type.Selector<TRoot, TParent>> curveShape() {
            return ((this.curveShape == null)?this.curveShape = new com.kscs.util.jaxb.Selector<>(this._root, this, "curveShape"):this.curveShape);
        }

    }

}
