
package org.javastro.ivoa.entities.stc.v1;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Ellipse shape: center, semi-major, semi-minor axis and position angle; in spherical coordinates defined as the shape cut out of the sphere by a cone with elliptical cross-section
 * 
 * <p>Java class for ellipseType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ellipseType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}shapeType">
 *       <sequence>
 *         <element name="Center" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double2Type"/>
 *         <element name="SemiMajorAxis" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double1Type"/>
 *         <element name="SemiMinorAxis" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double1Type"/>
 *         <element name="PosAngle" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}posAngleType"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ellipseType", propOrder = {
    "center",
    "semiMajorAxis",
    "semiMinorAxis",
    "posAngle"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class EllipseType
    extends ShapeType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The coordinates of the circle's center
     * 
     */
    @XmlElement(name = "Center", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double2Type center;
    /**
     * The radius of the circle
     * 
     */
    @XmlElement(name = "SemiMajorAxis", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double1Type semiMajorAxis;
    /**
     * Half the minor axis of the ellipse, in radius_unit
     * 
     */
    @XmlElement(name = "SemiMinorAxis", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double1Type semiMinorAxis;
    /**
     * Position angle of major axis (Radius).
     * 
     */
    @XmlElement(name = "PosAngle", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected PosAngleType posAngle;

    /**
     * Default no-arg constructor
     * 
     */
    public EllipseType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public EllipseType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final Boolean loInclude, final Boolean hiInclude, final Float fillFactor, final Object frameId, final BigDecimal epoch, final String unit, final RegionAreaType area, final String note, final Object coordSystemId, final Double2Type center, final Double1Type semiMajorAxis, final Double1Type semiMinorAxis, final PosAngleType posAngle) {
        super(id, idref, ucd, type, href, idType, idrefType, loInclude, hiInclude, fillFactor, frameId, epoch, unit, area, note, coordSystemId);
        this.center = center;
        this.semiMajorAxis = semiMajorAxis;
        this.semiMinorAxis = semiMinorAxis;
        this.posAngle = posAngle;
    }

    /**
     * The coordinates of the circle's center
     * 
     * @return
     *     possible object is
     *     {@link Double2Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double2Type getCenter() {
        return center;
    }

    /**
     * Sets the value of the center property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double2Type }
     *     
     * @see #getCenter()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setCenter(Double2Type value) {
        this.center = value;
    }

    /**
     * The radius of the circle
     * 
     * @return
     *     possible object is
     *     {@link Double1Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double1Type getSemiMajorAxis() {
        return semiMajorAxis;
    }

    /**
     * Sets the value of the semiMajorAxis property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double1Type }
     *     
     * @see #getSemiMajorAxis()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setSemiMajorAxis(Double1Type value) {
        this.semiMajorAxis = value;
    }

    /**
     * Half the minor axis of the ellipse, in radius_unit
     * 
     * @return
     *     possible object is
     *     {@link Double1Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double1Type getSemiMinorAxis() {
        return semiMinorAxis;
    }

    /**
     * Sets the value of the semiMinorAxis property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double1Type }
     *     
     * @see #getSemiMinorAxis()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setSemiMinorAxis(Double1Type value) {
        this.semiMinorAxis = value;
    }

    /**
     * Position angle of major axis (Radius).
     * 
     * @return
     *     possible object is
     *     {@link PosAngleType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosAngleType getPosAngle() {
        return posAngle;
    }

    /**
     * Sets the value of the posAngle property.
     * 
     * @param value
     *     allowed object is
     *     {@link PosAngleType }
     *     
     * @see #getPosAngle()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setPosAngle(PosAngleType value) {
        this.posAngle = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final EllipseType that = ((EllipseType) object);
        {
            Double2Type leftCenter;
            leftCenter = this.getCenter();
            Double2Type rightCenter;
            rightCenter = that.getCenter();
            if (this.center!= null) {
                if (that.center!= null) {
                    if (!leftCenter.equals(rightCenter)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.center!= null) {
                    return false;
                }
            }
        }
        {
            Double1Type leftSemiMajorAxis;
            leftSemiMajorAxis = this.getSemiMajorAxis();
            Double1Type rightSemiMajorAxis;
            rightSemiMajorAxis = that.getSemiMajorAxis();
            if (this.semiMajorAxis!= null) {
                if (that.semiMajorAxis!= null) {
                    if (!leftSemiMajorAxis.equals(rightSemiMajorAxis)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.semiMajorAxis!= null) {
                    return false;
                }
            }
        }
        {
            Double1Type leftSemiMinorAxis;
            leftSemiMinorAxis = this.getSemiMinorAxis();
            Double1Type rightSemiMinorAxis;
            rightSemiMinorAxis = that.getSemiMinorAxis();
            if (this.semiMinorAxis!= null) {
                if (that.semiMinorAxis!= null) {
                    if (!leftSemiMinorAxis.equals(rightSemiMinorAxis)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.semiMinorAxis!= null) {
                    return false;
                }
            }
        }
        {
            PosAngleType leftPosAngle;
            leftPosAngle = this.getPosAngle();
            PosAngleType rightPosAngle;
            rightPosAngle = that.getPosAngle();
            if (this.posAngle!= null) {
                if (that.posAngle!= null) {
                    if (!leftPosAngle.equals(rightPosAngle)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.posAngle!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            Double2Type theCenter;
            theCenter = this.getCenter();
            if (this.center!= null) {
                currentHashCode += theCenter.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Double1Type theSemiMajorAxis;
            theSemiMajorAxis = this.getSemiMajorAxis();
            if (this.semiMajorAxis!= null) {
                currentHashCode += theSemiMajorAxis.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Double1Type theSemiMinorAxis;
            theSemiMinorAxis = this.getSemiMinorAxis();
            if (this.semiMinorAxis!= null) {
                currentHashCode += theSemiMinorAxis.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            PosAngleType thePosAngle;
            thePosAngle = this.getPosAngle();
            if (this.posAngle!= null) {
                currentHashCode += thePosAngle.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            Double2Type theCenter;
            theCenter = this.getCenter();
            strategy.appendField(locator, this, "center", buffer, theCenter, (this.center!= null));
        }
        {
            Double1Type theSemiMajorAxis;
            theSemiMajorAxis = this.getSemiMajorAxis();
            strategy.appendField(locator, this, "semiMajorAxis", buffer, theSemiMajorAxis, (this.semiMajorAxis!= null));
        }
        {
            Double1Type theSemiMinorAxis;
            theSemiMinorAxis = this.getSemiMinorAxis();
            strategy.appendField(locator, this, "semiMinorAxis", buffer, theSemiMinorAxis, (this.semiMinorAxis!= null));
        }
        {
            PosAngleType thePosAngle;
            thePosAngle = this.getPosAngle();
            strategy.appendField(locator, this, "posAngle", buffer, thePosAngle, (this.posAngle!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof EllipseType) {
            final EllipseType target = this;
            final EllipseType leftObject = ((EllipseType) left);
            final EllipseType rightObject = ((EllipseType) right);
            {
                Boolean centerShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.center!= null), (rightObject.center!= null));
                if (centerShouldBeMergedAndSet == Boolean.TRUE) {
                    Double2Type lhsCenter;
                    lhsCenter = leftObject.getCenter();
                    Double2Type rhsCenter;
                    rhsCenter = rightObject.getCenter();
                    Double2Type mergedCenter = ((Double2Type) strategy.merge(LocatorUtils.property(leftLocator, "center", lhsCenter), LocatorUtils.property(rightLocator, "center", rhsCenter), lhsCenter, rhsCenter, (leftObject.center!= null), (rightObject.center!= null)));
                    target.setCenter(mergedCenter);
                } else {
                    if (centerShouldBeMergedAndSet == Boolean.FALSE) {
                        target.center = null;
                    }
                }
            }
            {
                Boolean semiMajorAxisShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.semiMajorAxis!= null), (rightObject.semiMajorAxis!= null));
                if (semiMajorAxisShouldBeMergedAndSet == Boolean.TRUE) {
                    Double1Type lhsSemiMajorAxis;
                    lhsSemiMajorAxis = leftObject.getSemiMajorAxis();
                    Double1Type rhsSemiMajorAxis;
                    rhsSemiMajorAxis = rightObject.getSemiMajorAxis();
                    Double1Type mergedSemiMajorAxis = ((Double1Type) strategy.merge(LocatorUtils.property(leftLocator, "semiMajorAxis", lhsSemiMajorAxis), LocatorUtils.property(rightLocator, "semiMajorAxis", rhsSemiMajorAxis), lhsSemiMajorAxis, rhsSemiMajorAxis, (leftObject.semiMajorAxis!= null), (rightObject.semiMajorAxis!= null)));
                    target.setSemiMajorAxis(mergedSemiMajorAxis);
                } else {
                    if (semiMajorAxisShouldBeMergedAndSet == Boolean.FALSE) {
                        target.semiMajorAxis = null;
                    }
                }
            }
            {
                Boolean semiMinorAxisShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.semiMinorAxis!= null), (rightObject.semiMinorAxis!= null));
                if (semiMinorAxisShouldBeMergedAndSet == Boolean.TRUE) {
                    Double1Type lhsSemiMinorAxis;
                    lhsSemiMinorAxis = leftObject.getSemiMinorAxis();
                    Double1Type rhsSemiMinorAxis;
                    rhsSemiMinorAxis = rightObject.getSemiMinorAxis();
                    Double1Type mergedSemiMinorAxis = ((Double1Type) strategy.merge(LocatorUtils.property(leftLocator, "semiMinorAxis", lhsSemiMinorAxis), LocatorUtils.property(rightLocator, "semiMinorAxis", rhsSemiMinorAxis), lhsSemiMinorAxis, rhsSemiMinorAxis, (leftObject.semiMinorAxis!= null), (rightObject.semiMinorAxis!= null)));
                    target.setSemiMinorAxis(mergedSemiMinorAxis);
                } else {
                    if (semiMinorAxisShouldBeMergedAndSet == Boolean.FALSE) {
                        target.semiMinorAxis = null;
                    }
                }
            }
            {
                Boolean posAngleShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.posAngle!= null), (rightObject.posAngle!= null));
                if (posAngleShouldBeMergedAndSet == Boolean.TRUE) {
                    PosAngleType lhsPosAngle;
                    lhsPosAngle = leftObject.getPosAngle();
                    PosAngleType rhsPosAngle;
                    rhsPosAngle = rightObject.getPosAngle();
                    PosAngleType mergedPosAngle = ((PosAngleType) strategy.merge(LocatorUtils.property(leftLocator, "posAngle", lhsPosAngle), LocatorUtils.property(rightLocator, "posAngle", rhsPosAngle), lhsPosAngle, rhsPosAngle, (leftObject.posAngle!= null), (rightObject.posAngle!= null)));
                    target.setPosAngle(mergedPosAngle);
                } else {
                    if (posAngleShouldBeMergedAndSet == Boolean.FALSE) {
                        target.posAngle = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new EllipseType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public EllipseType clone() {
        final EllipseType _newObject;
        _newObject = ((EllipseType) super.clone());
        _newObject.center = ((this.center == null)?null:this.center.clone());
        _newObject.semiMajorAxis = ((this.semiMajorAxis == null)?null:this.semiMajorAxis.clone());
        _newObject.semiMinorAxis = ((this.semiMinorAxis == null)?null:this.semiMinorAxis.clone());
        _newObject.posAngle = ((this.posAngle == null)?null:this.posAngle.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public EllipseType createCopy() {
        final EllipseType _newObject = ((EllipseType) super.createCopy());
        _newObject.center = ((this.center == null)?null:this.center.createCopy());
        _newObject.semiMajorAxis = ((this.semiMajorAxis == null)?null:this.semiMajorAxis.createCopy());
        _newObject.semiMinorAxis = ((this.semiMinorAxis == null)?null:this.semiMinorAxis.createCopy());
        _newObject.posAngle = ((this.posAngle == null)?null:this.posAngle.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public EllipseType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final EllipseType _newObject = ((EllipseType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
            _newObject.center = ((this.center == null)?null:this.center.createCopy(centerPropertyTree, _propertyTreeUse));
        }
        final PropertyTree semiMajorAxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("semiMajorAxis"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(semiMajorAxisPropertyTree!= null):((semiMajorAxisPropertyTree == null)||(!semiMajorAxisPropertyTree.isLeaf())))) {
            _newObject.semiMajorAxis = ((this.semiMajorAxis == null)?null:this.semiMajorAxis.createCopy(semiMajorAxisPropertyTree, _propertyTreeUse));
        }
        final PropertyTree semiMinorAxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("semiMinorAxis"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(semiMinorAxisPropertyTree!= null):((semiMinorAxisPropertyTree == null)||(!semiMinorAxisPropertyTree.isLeaf())))) {
            _newObject.semiMinorAxis = ((this.semiMinorAxis == null)?null:this.semiMinorAxis.createCopy(semiMinorAxisPropertyTree, _propertyTreeUse));
        }
        final PropertyTree posAnglePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("posAngle"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posAnglePropertyTree!= null):((posAnglePropertyTree == null)||(!posAnglePropertyTree.isLeaf())))) {
            _newObject.posAngle = ((this.posAngle == null)?null:this.posAngle.createCopy(posAnglePropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public EllipseType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public EllipseType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public EllipseType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new EllipseType.Modifier();
        }
        return ((EllipseType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final EllipseType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.center = ((this.center == null)?null:this.center.newCopyBuilder(_other));
        _other.semiMajorAxis = ((this.semiMajorAxis == null)?null:this.semiMajorAxis.newCopyBuilder(_other));
        _other.semiMinorAxis = ((this.semiMinorAxis == null)?null:this.semiMinorAxis.newCopyBuilder(_other));
        _other.posAngle = ((this.posAngle == null)?null:this.posAngle.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >EllipseType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new EllipseType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public EllipseType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> builder() {
        return new EllipseType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final StcBaseType _other) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final CoordIntervalType _other) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final SpatialIntervalType _other) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final RegionType _other) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final ShapeType _other) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final EllipseType _other) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final EllipseType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
            _other.center = ((this.center == null)?null:this.center.newCopyBuilder(_other, centerPropertyTree, _propertyTreeUse));
        }
        final PropertyTree semiMajorAxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("semiMajorAxis"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(semiMajorAxisPropertyTree!= null):((semiMajorAxisPropertyTree == null)||(!semiMajorAxisPropertyTree.isLeaf())))) {
            _other.semiMajorAxis = ((this.semiMajorAxis == null)?null:this.semiMajorAxis.newCopyBuilder(_other, semiMajorAxisPropertyTree, _propertyTreeUse));
        }
        final PropertyTree semiMinorAxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("semiMinorAxis"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(semiMinorAxisPropertyTree!= null):((semiMinorAxisPropertyTree == null)||(!semiMinorAxisPropertyTree.isLeaf())))) {
            _other.semiMinorAxis = ((this.semiMinorAxis == null)?null:this.semiMinorAxis.newCopyBuilder(_other, semiMinorAxisPropertyTree, _propertyTreeUse));
        }
        final PropertyTree posAnglePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("posAngle"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posAnglePropertyTree!= null):((posAnglePropertyTree == null)||(!posAnglePropertyTree.isLeaf())))) {
            _other.posAngle = ((this.posAngle == null)?null:this.posAngle.newCopyBuilder(_other, posAnglePropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >EllipseType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new EllipseType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public EllipseType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final CoordIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final SpatialIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final RegionType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final ShapeType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >EllipseType.Builder<_B> copyOf(final EllipseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final EllipseType.Builder<_B> _newBuilder = new EllipseType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyExcept(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyExcept(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyExcept(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyExcept(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyExcept(final EllipseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyOnly(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyOnly(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyOnly(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyOnly(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static EllipseType.Builder<Void> copyOnly(final EllipseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public EllipseType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(EllipseType.PropInfo.CENTER, this))&&(this.center!= null)) {
            this.center.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(EllipseType.PropInfo.SEMI_MAJOR_AXIS, this))&&(this.semiMajorAxis!= null)) {
            this.semiMajorAxis.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(EllipseType.PropInfo.SEMI_MINOR_AXIS, this))&&(this.semiMinorAxis!= null)) {
            this.semiMinorAxis.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(EllipseType.PropInfo.POS_ANGLE, this))&&(this.posAngle!= null)) {
            this.posAngle.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends ShapeType.Builder<_B>
        implements Buildable
    {

        private Double2Type.Builder<EllipseType.Builder<_B>> center;
        private Double1Type.Builder<EllipseType.Builder<_B>> semiMajorAxis;
        private Double1Type.Builder<EllipseType.Builder<_B>> semiMinorAxis;
        private PosAngleType.Builder<EllipseType.Builder<_B>> posAngle;

        public Builder(final _B _parentBuilder, final EllipseType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.center = ((_other.center == null)?null:_other.center.newCopyBuilder(this));
                this.semiMajorAxis = ((_other.semiMajorAxis == null)?null:_other.semiMajorAxis.newCopyBuilder(this));
                this.semiMinorAxis = ((_other.semiMinorAxis == null)?null:_other.semiMinorAxis.newCopyBuilder(this));
                this.posAngle = ((_other.posAngle == null)?null:_other.posAngle.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final EllipseType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
                    this.center = ((_other.center == null)?null:_other.center.newCopyBuilder(this, centerPropertyTree, _propertyTreeUse));
                }
                final PropertyTree semiMajorAxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("semiMajorAxis"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(semiMajorAxisPropertyTree!= null):((semiMajorAxisPropertyTree == null)||(!semiMajorAxisPropertyTree.isLeaf())))) {
                    this.semiMajorAxis = ((_other.semiMajorAxis == null)?null:_other.semiMajorAxis.newCopyBuilder(this, semiMajorAxisPropertyTree, _propertyTreeUse));
                }
                final PropertyTree semiMinorAxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("semiMinorAxis"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(semiMinorAxisPropertyTree!= null):((semiMinorAxisPropertyTree == null)||(!semiMinorAxisPropertyTree.isLeaf())))) {
                    this.semiMinorAxis = ((_other.semiMinorAxis == null)?null:_other.semiMinorAxis.newCopyBuilder(this, semiMinorAxisPropertyTree, _propertyTreeUse));
                }
                final PropertyTree posAnglePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("posAngle"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posAnglePropertyTree!= null):((posAnglePropertyTree == null)||(!posAnglePropertyTree.isLeaf())))) {
                    this.posAngle = ((_other.posAngle == null)?null:_other.posAngle.newCopyBuilder(this, posAnglePropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends EllipseType >_P init(final _P _product) {
            _product.center = ((this.center == null)?null:this.center.build());
            _product.semiMajorAxis = ((this.semiMajorAxis == null)?null:this.semiMajorAxis.build());
            _product.semiMinorAxis = ((this.semiMinorAxis == null)?null:this.semiMinorAxis.build());
            _product.posAngle = ((this.posAngle == null)?null:this.posAngle.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "center" (any previous value will be replaced)
         * 
         * @param center
         *     New value of the "center" property.
         */
        public EllipseType.Builder<_B> withCenter(final Double2Type center) {
            this.center = ((center == null)?null:new Double2Type.Builder<>(this, center, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "center"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double2Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "center" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double2Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double2Type.Builder<? extends EllipseType.Builder<_B>> withCenter() {
            if (this.center!= null) {
                return this.center;
            }
            return this.center = new Double2Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "semiMajorAxis" (any previous value will be replaced)
         * 
         * @param semiMajorAxis
         *     New value of the "semiMajorAxis" property.
         */
        public EllipseType.Builder<_B> withSemiMajorAxis(final Double1Type semiMajorAxis) {
            this.semiMajorAxis = ((semiMajorAxis == null)?null:new Double1Type.Builder<>(this, semiMajorAxis, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "semiMajorAxis" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double1Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "semiMajorAxis" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double1Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double1Type.Builder<? extends EllipseType.Builder<_B>> withSemiMajorAxis() {
            if (this.semiMajorAxis!= null) {
                return this.semiMajorAxis;
            }
            return this.semiMajorAxis = new Double1Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "semiMinorAxis" (any previous value will be replaced)
         * 
         * @param semiMinorAxis
         *     New value of the "semiMinorAxis" property.
         */
        public EllipseType.Builder<_B> withSemiMinorAxis(final Double1Type semiMinorAxis) {
            this.semiMinorAxis = ((semiMinorAxis == null)?null:new Double1Type.Builder<>(this, semiMinorAxis, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "semiMinorAxis" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double1Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "semiMinorAxis" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double1Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double1Type.Builder<? extends EllipseType.Builder<_B>> withSemiMinorAxis() {
            if (this.semiMinorAxis!= null) {
                return this.semiMinorAxis;
            }
            return this.semiMinorAxis = new Double1Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "posAngle" (any previous value will be replaced)
         * 
         * @param posAngle
         *     New value of the "posAngle" property.
         */
        public EllipseType.Builder<_B> withPosAngle(final PosAngleType posAngle) {
            this.posAngle = ((posAngle == null)?null:new PosAngleType.Builder<>(this, posAngle, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "posAngle" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.PosAngleType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "posAngle" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.PosAngleType.Builder#end()} to
         *     return to the current builder.
         */
        public PosAngleType.Builder<? extends EllipseType.Builder<_B>> withPosAngle() {
            if (this.posAngle!= null) {
                return this.posAngle;
            }
            return this.posAngle = new PosAngleType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "area" (any previous value will be replaced)
         * 
         * @param area
         *     New value of the "area" property.
         */
        @Override
        public EllipseType.Builder<_B> withArea(final RegionAreaType area) {
            super.withArea(area);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "area"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "area" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         *     return to the current builder.
         */
        public RegionAreaType.Builder<? extends EllipseType.Builder<_B>> withArea() {
            return ((RegionAreaType.Builder<? extends EllipseType.Builder<_B>> ) super.withArea());
        }

        /**
         * Sets the new value of "note" (any previous value will be replaced)
         * 
         * @param note
         *     New value of the "note" property.
         */
        @Override
        public EllipseType.Builder<_B> withNote(final String note) {
            super.withNote(note);
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        @Override
        public EllipseType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            super.withCoordSystemId(coordSystemId);
            return this;
        }

        /**
         * Sets the new value of "epoch" (any previous value will be replaced)
         * 
         * @param epoch
         *     New value of the "epoch" property.
         */
        @Override
        public EllipseType.Builder<_B> withEpoch(final BigDecimal epoch) {
            super.withEpoch(epoch);
            return this;
        }

        /**
         * Sets the new value of "unit" (any previous value will be replaced)
         * 
         * @param unit
         *     New value of the "unit" property.
         */
        @Override
        public EllipseType.Builder<_B> withUnit(final String unit) {
            super.withUnit(unit);
            return this;
        }

        /**
         * Sets the new value of "loInclude" (any previous value will be replaced)
         * 
         * @param loInclude
         *     New value of the "loInclude" property.
         */
        @Override
        public EllipseType.Builder<_B> withLoInclude(final Boolean loInclude) {
            super.withLoInclude(loInclude);
            return this;
        }

        /**
         * Sets the new value of "hiInclude" (any previous value will be replaced)
         * 
         * @param hiInclude
         *     New value of the "hiInclude" property.
         */
        @Override
        public EllipseType.Builder<_B> withHiInclude(final Boolean hiInclude) {
            super.withHiInclude(hiInclude);
            return this;
        }

        /**
         * Sets the new value of "fillFactor" (any previous value will be replaced)
         * 
         * @param fillFactor
         *     New value of the "fillFactor" property.
         */
        @Override
        public EllipseType.Builder<_B> withFillFactor(final Float fillFactor) {
            super.withFillFactor(fillFactor);
            return this;
        }

        /**
         * Sets the new value of "frameId" (any previous value will be replaced)
         * 
         * @param frameId
         *     New value of the "frameId" property.
         */
        @Override
        public EllipseType.Builder<_B> withFrameId(final Object frameId) {
            super.withFrameId(frameId);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public EllipseType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public EllipseType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public EllipseType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public EllipseType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public EllipseType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public EllipseType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public EllipseType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public EllipseType build() {
            if (_storedValue == null) {
                return this.init(new EllipseType());
            } else {
                return ((EllipseType) _storedValue);
            }
        }

        public EllipseType.Builder<_B> copyOf(final EllipseType _other) {
            _other.copyTo(this);
            return this;
        }

        public EllipseType.Builder<_B> copyOf(final EllipseType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends ShapeType.Modifier
    {


        public void setCenter(final Double2Type center) {
            EllipseType.this.setCenter(center);
        }

        public void setSemiMajorAxis(final Double1Type semiMajorAxis) {
            EllipseType.this.setSemiMajorAxis(semiMajorAxis);
        }

        public void setSemiMinorAxis(final Double1Type semiMinorAxis) {
            EllipseType.this.setSemiMinorAxis(semiMinorAxis);
        }

        public void setPosAngle(final PosAngleType posAngle) {
            EllipseType.this.setPosAngle(posAngle);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<EllipseType, Double2Type> CENTER = new SinglePropertyInfo<EllipseType,Double2Type>("center", EllipseType.class, Double2Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Center"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double2Type"), false) {


            @Override
            public Double2Type get(final EllipseType _instance_) {
                return ((_instance_ == null)?null:_instance_.center);
            }

            @Override
            public void set(final EllipseType _instance_, final Double2Type _value_) {
                if (_instance_!= null) {
                    _instance_.center = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<EllipseType, Double1Type> SEMI_MAJOR_AXIS = new SinglePropertyInfo<EllipseType,Double1Type>("semiMajorAxis", EllipseType.class, Double1Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "SemiMajorAxis"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double1Type"), false) {


            @Override
            public Double1Type get(final EllipseType _instance_) {
                return ((_instance_ == null)?null:_instance_.semiMajorAxis);
            }

            @Override
            public void set(final EllipseType _instance_, final Double1Type _value_) {
                if (_instance_!= null) {
                    _instance_.semiMajorAxis = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<EllipseType, Double1Type> SEMI_MINOR_AXIS = new SinglePropertyInfo<EllipseType,Double1Type>("semiMinorAxis", EllipseType.class, Double1Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "SemiMinorAxis"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double1Type"), false) {


            @Override
            public Double1Type get(final EllipseType _instance_) {
                return ((_instance_ == null)?null:_instance_.semiMinorAxis);
            }

            @Override
            public void set(final EllipseType _instance_, final Double1Type _value_) {
                if (_instance_!= null) {
                    _instance_.semiMinorAxis = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<EllipseType, PosAngleType> POS_ANGLE = new SinglePropertyInfo<EllipseType,PosAngleType>("posAngle", EllipseType.class, PosAngleType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "PosAngle"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "posAngleType"), false) {


            @Override
            public PosAngleType get(final EllipseType _instance_) {
                return ((_instance_ == null)?null:_instance_.posAngle);
            }

            @Override
            public void set(final EllipseType _instance_, final PosAngleType _value_) {
                if (_instance_!= null) {
                    _instance_.posAngle = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends EllipseType.Selector<EllipseType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static EllipseType.Select _root() {
            return new EllipseType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends ShapeType.Selector<TRoot, TParent>
    {

        private Double2Type.Selector<TRoot, EllipseType.Selector<TRoot, TParent>> center = null;
        private Double1Type.Selector<TRoot, EllipseType.Selector<TRoot, TParent>> semiMajorAxis = null;
        private Double1Type.Selector<TRoot, EllipseType.Selector<TRoot, TParent>> semiMinorAxis = null;
        private PosAngleType.Selector<TRoot, EllipseType.Selector<TRoot, TParent>> posAngle = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.center!= null) {
                products.put("center", this.center.init());
            }
            if (this.semiMajorAxis!= null) {
                products.put("semiMajorAxis", this.semiMajorAxis.init());
            }
            if (this.semiMinorAxis!= null) {
                products.put("semiMinorAxis", this.semiMinorAxis.init());
            }
            if (this.posAngle!= null) {
                products.put("posAngle", this.posAngle.init());
            }
            return products;
        }

        public Double2Type.Selector<TRoot, EllipseType.Selector<TRoot, TParent>> center() {
            return ((this.center == null)?this.center = new Double2Type.Selector<>(this._root, this, "center"):this.center);
        }

        public Double1Type.Selector<TRoot, EllipseType.Selector<TRoot, TParent>> semiMajorAxis() {
            return ((this.semiMajorAxis == null)?this.semiMajorAxis = new Double1Type.Selector<>(this._root, this, "semiMajorAxis"):this.semiMajorAxis);
        }

        public Double1Type.Selector<TRoot, EllipseType.Selector<TRoot, TParent>> semiMinorAxis() {
            return ((this.semiMinorAxis == null)?this.semiMinorAxis = new Double1Type.Selector<>(this._root, this, "semiMinorAxis"):this.semiMinorAxis);
        }

        public PosAngleType.Selector<TRoot, EllipseType.Selector<TRoot, TParent>> posAngle() {
            return ((this.posAngle == null)?this.posAngle = new PosAngleType.Selector<>(this._root, this, "posAngle"):this.posAngle);
        }

    }

}
