
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Type for observational STC metadata
 * 
 * <p>Java class for obsDataLocationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="obsDataLocationType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}stcMetadataType">
 *       <sequence>
 *         <element name="ObservatoryLocation" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}observatoryLocationType"/>
 *         <element name="ObservationLocation" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}astroSTCDescriptionType"/>
 *         <element name="PixelSpace" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}pixelSpaceType" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "obsDataLocationType", propOrder = {
    "observatoryLocation",
    "observationLocation",
    "pixelSpace"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class ObsDataLocationType
    extends StcMetadataType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Specifies the location of the observatory during the observation
     * 
     */
    @XmlElement(name = "ObservatoryLocation", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ObservatoryLocationType observatoryLocation;
    /**
     * Describes the spatial and temporal coverage of the observation
     * 
     */
    @XmlElement(name = "ObservationLocation", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected AstroSTCDescriptionType observationLocation;
    /**
     * Defines the pixel coordinate system for pixelated data
     * 
     */
    @XmlElement(name = "PixelSpace", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected PixelSpaceType pixelSpace;

    /**
     * Default no-arg constructor
     * 
     */
    public ObsDataLocationType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public ObsDataLocationType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final ObservatoryLocationType observatoryLocation, final AstroSTCDescriptionType observationLocation, final PixelSpaceType pixelSpace) {
        super(id, idref, ucd, type, href, idType, idrefType);
        this.observatoryLocation = observatoryLocation;
        this.observationLocation = observationLocation;
        this.pixelSpace = pixelSpace;
    }

    /**
     * Specifies the location of the observatory during the observation
     * 
     * @return
     *     possible object is
     *     {@link ObservatoryLocationType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ObservatoryLocationType getObservatoryLocation() {
        return observatoryLocation;
    }

    /**
     * Sets the value of the observatoryLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ObservatoryLocationType }
     *     
     * @see #getObservatoryLocation()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setObservatoryLocation(ObservatoryLocationType value) {
        this.observatoryLocation = value;
    }

    /**
     * Describes the spatial and temporal coverage of the observation
     * 
     * @return
     *     possible object is
     *     {@link AstroSTCDescriptionType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroSTCDescriptionType getObservationLocation() {
        return observationLocation;
    }

    /**
     * Sets the value of the observationLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link AstroSTCDescriptionType }
     *     
     * @see #getObservationLocation()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setObservationLocation(AstroSTCDescriptionType value) {
        this.observationLocation = value;
    }

    /**
     * Defines the pixel coordinate system for pixelated data
     * 
     * @return
     *     possible object is
     *     {@link PixelSpaceType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PixelSpaceType getPixelSpace() {
        return pixelSpace;
    }

    /**
     * Sets the value of the pixelSpace property.
     * 
     * @param value
     *     allowed object is
     *     {@link PixelSpaceType }
     *     
     * @see #getPixelSpace()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setPixelSpace(PixelSpaceType value) {
        this.pixelSpace = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final ObsDataLocationType that = ((ObsDataLocationType) object);
        {
            ObservatoryLocationType leftObservatoryLocation;
            leftObservatoryLocation = this.getObservatoryLocation();
            ObservatoryLocationType rightObservatoryLocation;
            rightObservatoryLocation = that.getObservatoryLocation();
            if (this.observatoryLocation!= null) {
                if (that.observatoryLocation!= null) {
                    if (!leftObservatoryLocation.equals(rightObservatoryLocation)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.observatoryLocation!= null) {
                    return false;
                }
            }
        }
        {
            AstroSTCDescriptionType leftObservationLocation;
            leftObservationLocation = this.getObservationLocation();
            AstroSTCDescriptionType rightObservationLocation;
            rightObservationLocation = that.getObservationLocation();
            if (this.observationLocation!= null) {
                if (that.observationLocation!= null) {
                    if (!leftObservationLocation.equals(rightObservationLocation)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.observationLocation!= null) {
                    return false;
                }
            }
        }
        {
            PixelSpaceType leftPixelSpace;
            leftPixelSpace = this.getPixelSpace();
            PixelSpaceType rightPixelSpace;
            rightPixelSpace = that.getPixelSpace();
            if (this.pixelSpace!= null) {
                if (that.pixelSpace!= null) {
                    if (!leftPixelSpace.equals(rightPixelSpace)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.pixelSpace!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            ObservatoryLocationType theObservatoryLocation;
            theObservatoryLocation = this.getObservatoryLocation();
            if (this.observatoryLocation!= null) {
                currentHashCode += theObservatoryLocation.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            AstroSTCDescriptionType theObservationLocation;
            theObservationLocation = this.getObservationLocation();
            if (this.observationLocation!= null) {
                currentHashCode += theObservationLocation.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            PixelSpaceType thePixelSpace;
            thePixelSpace = this.getPixelSpace();
            if (this.pixelSpace!= null) {
                currentHashCode += thePixelSpace.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            ObservatoryLocationType theObservatoryLocation;
            theObservatoryLocation = this.getObservatoryLocation();
            strategy.appendField(locator, this, "observatoryLocation", buffer, theObservatoryLocation, (this.observatoryLocation!= null));
        }
        {
            AstroSTCDescriptionType theObservationLocation;
            theObservationLocation = this.getObservationLocation();
            strategy.appendField(locator, this, "observationLocation", buffer, theObservationLocation, (this.observationLocation!= null));
        }
        {
            PixelSpaceType thePixelSpace;
            thePixelSpace = this.getPixelSpace();
            strategy.appendField(locator, this, "pixelSpace", buffer, thePixelSpace, (this.pixelSpace!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof ObsDataLocationType) {
            final ObsDataLocationType target = this;
            final ObsDataLocationType leftObject = ((ObsDataLocationType) left);
            final ObsDataLocationType rightObject = ((ObsDataLocationType) right);
            {
                Boolean observatoryLocationShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.observatoryLocation!= null), (rightObject.observatoryLocation!= null));
                if (observatoryLocationShouldBeMergedAndSet == Boolean.TRUE) {
                    ObservatoryLocationType lhsObservatoryLocation;
                    lhsObservatoryLocation = leftObject.getObservatoryLocation();
                    ObservatoryLocationType rhsObservatoryLocation;
                    rhsObservatoryLocation = rightObject.getObservatoryLocation();
                    ObservatoryLocationType mergedObservatoryLocation = ((ObservatoryLocationType) strategy.merge(LocatorUtils.property(leftLocator, "observatoryLocation", lhsObservatoryLocation), LocatorUtils.property(rightLocator, "observatoryLocation", rhsObservatoryLocation), lhsObservatoryLocation, rhsObservatoryLocation, (leftObject.observatoryLocation!= null), (rightObject.observatoryLocation!= null)));
                    target.setObservatoryLocation(mergedObservatoryLocation);
                } else {
                    if (observatoryLocationShouldBeMergedAndSet == Boolean.FALSE) {
                        target.observatoryLocation = null;
                    }
                }
            }
            {
                Boolean observationLocationShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.observationLocation!= null), (rightObject.observationLocation!= null));
                if (observationLocationShouldBeMergedAndSet == Boolean.TRUE) {
                    AstroSTCDescriptionType lhsObservationLocation;
                    lhsObservationLocation = leftObject.getObservationLocation();
                    AstroSTCDescriptionType rhsObservationLocation;
                    rhsObservationLocation = rightObject.getObservationLocation();
                    AstroSTCDescriptionType mergedObservationLocation = ((AstroSTCDescriptionType) strategy.merge(LocatorUtils.property(leftLocator, "observationLocation", lhsObservationLocation), LocatorUtils.property(rightLocator, "observationLocation", rhsObservationLocation), lhsObservationLocation, rhsObservationLocation, (leftObject.observationLocation!= null), (rightObject.observationLocation!= null)));
                    target.setObservationLocation(mergedObservationLocation);
                } else {
                    if (observationLocationShouldBeMergedAndSet == Boolean.FALSE) {
                        target.observationLocation = null;
                    }
                }
            }
            {
                Boolean pixelSpaceShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.pixelSpace!= null), (rightObject.pixelSpace!= null));
                if (pixelSpaceShouldBeMergedAndSet == Boolean.TRUE) {
                    PixelSpaceType lhsPixelSpace;
                    lhsPixelSpace = leftObject.getPixelSpace();
                    PixelSpaceType rhsPixelSpace;
                    rhsPixelSpace = rightObject.getPixelSpace();
                    PixelSpaceType mergedPixelSpace = ((PixelSpaceType) strategy.merge(LocatorUtils.property(leftLocator, "pixelSpace", lhsPixelSpace), LocatorUtils.property(rightLocator, "pixelSpace", rhsPixelSpace), lhsPixelSpace, rhsPixelSpace, (leftObject.pixelSpace!= null), (rightObject.pixelSpace!= null)));
                    target.setPixelSpace(mergedPixelSpace);
                } else {
                    if (pixelSpaceShouldBeMergedAndSet == Boolean.FALSE) {
                        target.pixelSpace = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new ObsDataLocationType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ObsDataLocationType clone() {
        final ObsDataLocationType _newObject;
        _newObject = ((ObsDataLocationType) super.clone());
        _newObject.observatoryLocation = ((this.observatoryLocation == null)?null:this.observatoryLocation.clone());
        _newObject.observationLocation = ((this.observationLocation == null)?null:this.observationLocation.clone());
        _newObject.pixelSpace = ((this.pixelSpace == null)?null:this.pixelSpace.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ObsDataLocationType createCopy() {
        final ObsDataLocationType _newObject = ((ObsDataLocationType) super.createCopy());
        _newObject.observatoryLocation = ((this.observatoryLocation == null)?null:this.observatoryLocation.createCopy());
        _newObject.observationLocation = ((this.observationLocation == null)?null:this.observationLocation.createCopy());
        _newObject.pixelSpace = ((this.pixelSpace == null)?null:this.pixelSpace.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ObsDataLocationType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ObsDataLocationType _newObject = ((ObsDataLocationType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree observatoryLocationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("observatoryLocation"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(observatoryLocationPropertyTree!= null):((observatoryLocationPropertyTree == null)||(!observatoryLocationPropertyTree.isLeaf())))) {
            _newObject.observatoryLocation = ((this.observatoryLocation == null)?null:this.observatoryLocation.createCopy(observatoryLocationPropertyTree, _propertyTreeUse));
        }
        final PropertyTree observationLocationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("observationLocation"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(observationLocationPropertyTree!= null):((observationLocationPropertyTree == null)||(!observationLocationPropertyTree.isLeaf())))) {
            _newObject.observationLocation = ((this.observationLocation == null)?null:this.observationLocation.createCopy(observationLocationPropertyTree, _propertyTreeUse));
        }
        final PropertyTree pixelSpacePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pixelSpace"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pixelSpacePropertyTree!= null):((pixelSpacePropertyTree == null)||(!pixelSpacePropertyTree.isLeaf())))) {
            _newObject.pixelSpace = ((this.pixelSpace == null)?null:this.pixelSpace.createCopy(pixelSpacePropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ObsDataLocationType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ObsDataLocationType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ObsDataLocationType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new ObsDataLocationType.Modifier();
        }
        return ((ObsDataLocationType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final ObsDataLocationType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.observatoryLocation = ((this.observatoryLocation == null)?null:this.observatoryLocation.newCopyBuilder(_other));
        _other.observationLocation = ((this.observationLocation == null)?null:this.observationLocation.newCopyBuilder(_other));
        _other.pixelSpace = ((this.pixelSpace == null)?null:this.pixelSpace.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >ObsDataLocationType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new ObsDataLocationType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ObsDataLocationType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ObsDataLocationType.Builder<Void> builder() {
        return new ObsDataLocationType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ObsDataLocationType.Builder<_B> copyOf(final StcBaseType _other) {
        final ObsDataLocationType.Builder<_B> _newBuilder = new ObsDataLocationType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ObsDataLocationType.Builder<_B> copyOf(final StcMetadataType _other) {
        final ObsDataLocationType.Builder<_B> _newBuilder = new ObsDataLocationType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ObsDataLocationType.Builder<_B> copyOf(final ObsDataLocationType _other) {
        final ObsDataLocationType.Builder<_B> _newBuilder = new ObsDataLocationType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final ObsDataLocationType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree observatoryLocationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("observatoryLocation"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(observatoryLocationPropertyTree!= null):((observatoryLocationPropertyTree == null)||(!observatoryLocationPropertyTree.isLeaf())))) {
            _other.observatoryLocation = ((this.observatoryLocation == null)?null:this.observatoryLocation.newCopyBuilder(_other, observatoryLocationPropertyTree, _propertyTreeUse));
        }
        final PropertyTree observationLocationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("observationLocation"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(observationLocationPropertyTree!= null):((observationLocationPropertyTree == null)||(!observationLocationPropertyTree.isLeaf())))) {
            _other.observationLocation = ((this.observationLocation == null)?null:this.observationLocation.newCopyBuilder(_other, observationLocationPropertyTree, _propertyTreeUse));
        }
        final PropertyTree pixelSpacePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pixelSpace"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pixelSpacePropertyTree!= null):((pixelSpacePropertyTree == null)||(!pixelSpacePropertyTree.isLeaf())))) {
            _other.pixelSpace = ((this.pixelSpace == null)?null:this.pixelSpace.newCopyBuilder(_other, pixelSpacePropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >ObsDataLocationType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new ObsDataLocationType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ObsDataLocationType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ObsDataLocationType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ObsDataLocationType.Builder<_B> _newBuilder = new ObsDataLocationType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ObsDataLocationType.Builder<_B> copyOf(final StcMetadataType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ObsDataLocationType.Builder<_B> _newBuilder = new ObsDataLocationType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ObsDataLocationType.Builder<_B> copyOf(final ObsDataLocationType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ObsDataLocationType.Builder<_B> _newBuilder = new ObsDataLocationType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ObsDataLocationType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ObsDataLocationType.Builder<Void> copyExcept(final StcMetadataType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ObsDataLocationType.Builder<Void> copyExcept(final ObsDataLocationType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ObsDataLocationType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ObsDataLocationType.Builder<Void> copyOnly(final StcMetadataType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ObsDataLocationType.Builder<Void> copyOnly(final ObsDataLocationType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ObsDataLocationType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(ObsDataLocationType.PropInfo.OBSERVATORY_LOCATION, this))&&(this.observatoryLocation!= null)) {
            this.observatoryLocation.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(ObsDataLocationType.PropInfo.OBSERVATION_LOCATION, this))&&(this.observationLocation!= null)) {
            this.observationLocation.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(ObsDataLocationType.PropInfo.PIXEL_SPACE, this))&&(this.pixelSpace!= null)) {
            this.pixelSpace.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends StcMetadataType.Builder<_B>
        implements Buildable
    {

        private ObservatoryLocationType.Builder<ObsDataLocationType.Builder<_B>> observatoryLocation;
        private AstroSTCDescriptionType.Builder<ObsDataLocationType.Builder<_B>> observationLocation;
        private PixelSpaceType.Builder<ObsDataLocationType.Builder<_B>> pixelSpace;

        public Builder(final _B _parentBuilder, final ObsDataLocationType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.observatoryLocation = ((_other.observatoryLocation == null)?null:_other.observatoryLocation.newCopyBuilder(this));
                this.observationLocation = ((_other.observationLocation == null)?null:_other.observationLocation.newCopyBuilder(this));
                this.pixelSpace = ((_other.pixelSpace == null)?null:_other.pixelSpace.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final ObsDataLocationType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree observatoryLocationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("observatoryLocation"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(observatoryLocationPropertyTree!= null):((observatoryLocationPropertyTree == null)||(!observatoryLocationPropertyTree.isLeaf())))) {
                    this.observatoryLocation = ((_other.observatoryLocation == null)?null:_other.observatoryLocation.newCopyBuilder(this, observatoryLocationPropertyTree, _propertyTreeUse));
                }
                final PropertyTree observationLocationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("observationLocation"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(observationLocationPropertyTree!= null):((observationLocationPropertyTree == null)||(!observationLocationPropertyTree.isLeaf())))) {
                    this.observationLocation = ((_other.observationLocation == null)?null:_other.observationLocation.newCopyBuilder(this, observationLocationPropertyTree, _propertyTreeUse));
                }
                final PropertyTree pixelSpacePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pixelSpace"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pixelSpacePropertyTree!= null):((pixelSpacePropertyTree == null)||(!pixelSpacePropertyTree.isLeaf())))) {
                    this.pixelSpace = ((_other.pixelSpace == null)?null:_other.pixelSpace.newCopyBuilder(this, pixelSpacePropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends ObsDataLocationType >_P init(final _P _product) {
            _product.observatoryLocation = ((this.observatoryLocation == null)?null:this.observatoryLocation.build());
            _product.observationLocation = ((this.observationLocation == null)?null:this.observationLocation.build());
            _product.pixelSpace = ((this.pixelSpace == null)?null:this.pixelSpace.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "observatoryLocation" (any previous value will be
         * replaced)
         * 
         * @param observatoryLocation
         *     New value of the "observatoryLocation" property.
         */
        public ObsDataLocationType.Builder<_B> withObservatoryLocation(final ObservatoryLocationType observatoryLocation) {
            this.observatoryLocation = ((observatoryLocation == null)?null:new ObservatoryLocationType.Builder<>(this, observatoryLocation, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "observatoryLocation" property.
         * Use {@link
         * org.javastro.ivoa.entities.stc.v1.ObservatoryLocationType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "observatoryLocation" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.stc.v1.ObservatoryLocationType.Builder#end()} to
         *     return to the current builder.
         */
        public ObservatoryLocationType.Builder<? extends ObsDataLocationType.Builder<_B>> withObservatoryLocation() {
            if (this.observatoryLocation!= null) {
                return this.observatoryLocation;
            }
            return this.observatoryLocation = new ObservatoryLocationType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "observationLocation" (any previous value will be
         * replaced)
         * 
         * @param observationLocation
         *     New value of the "observationLocation" property.
         */
        public ObsDataLocationType.Builder<_B> withObservationLocation(final AstroSTCDescriptionType observationLocation) {
            this.observationLocation = ((observationLocation == null)?null:new AstroSTCDescriptionType.Builder<>(this, observationLocation, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "observationLocation" property.
         * Use {@link
         * org.javastro.ivoa.entities.stc.v1.AstroSTCDescriptionType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "observationLocation" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.stc.v1.AstroSTCDescriptionType.Builder#end()} to
         *     return to the current builder.
         */
        public AstroSTCDescriptionType.Builder<? extends ObsDataLocationType.Builder<_B>> withObservationLocation() {
            if (this.observationLocation!= null) {
                return this.observationLocation;
            }
            return this.observationLocation = new AstroSTCDescriptionType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "pixelSpace" (any previous value will be replaced)
         * 
         * @param pixelSpace
         *     New value of the "pixelSpace" property.
         */
        public ObsDataLocationType.Builder<_B> withPixelSpace(final PixelSpaceType pixelSpace) {
            this.pixelSpace = ((pixelSpace == null)?null:new PixelSpaceType.Builder<>(this, pixelSpace, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "pixelSpace" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.PixelSpaceType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "pixelSpace" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.PixelSpaceType.Builder#end()} to
         *     return to the current builder.
         */
        public PixelSpaceType.Builder<? extends ObsDataLocationType.Builder<_B>> withPixelSpace() {
            if (this.pixelSpace!= null) {
                return this.pixelSpace;
            }
            return this.pixelSpace = new PixelSpaceType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public ObsDataLocationType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public ObsDataLocationType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public ObsDataLocationType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public ObsDataLocationType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public ObsDataLocationType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public ObsDataLocationType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public ObsDataLocationType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public ObsDataLocationType build() {
            if (_storedValue == null) {
                return this.init(new ObsDataLocationType());
            } else {
                return ((ObsDataLocationType) _storedValue);
            }
        }

        public ObsDataLocationType.Builder<_B> copyOf(final ObsDataLocationType _other) {
            _other.copyTo(this);
            return this;
        }

        public ObsDataLocationType.Builder<_B> copyOf(final ObsDataLocationType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends StcMetadataType.Modifier
    {


        public void setObservatoryLocation(final ObservatoryLocationType observatoryLocation) {
            ObsDataLocationType.this.setObservatoryLocation(observatoryLocation);
        }

        public void setObservationLocation(final AstroSTCDescriptionType observationLocation) {
            ObsDataLocationType.this.setObservationLocation(observationLocation);
        }

        public void setPixelSpace(final PixelSpaceType pixelSpace) {
            ObsDataLocationType.this.setPixelSpace(pixelSpace);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<ObsDataLocationType, ObservatoryLocationType> OBSERVATORY_LOCATION = new SinglePropertyInfo<ObsDataLocationType,ObservatoryLocationType>("observatoryLocation", ObsDataLocationType.class, ObservatoryLocationType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "ObservatoryLocation"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "observatoryLocationType"), false) {


            @Override
            public ObservatoryLocationType get(final ObsDataLocationType _instance_) {
                return ((_instance_ == null)?null:_instance_.observatoryLocation);
            }

            @Override
            public void set(final ObsDataLocationType _instance_, final ObservatoryLocationType _value_) {
                if (_instance_!= null) {
                    _instance_.observatoryLocation = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ObsDataLocationType, AstroSTCDescriptionType> OBSERVATION_LOCATION = new SinglePropertyInfo<ObsDataLocationType,AstroSTCDescriptionType>("observationLocation", ObsDataLocationType.class, AstroSTCDescriptionType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "ObservationLocation"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroSTCDescriptionType"), false) {


            @Override
            public AstroSTCDescriptionType get(final ObsDataLocationType _instance_) {
                return ((_instance_ == null)?null:_instance_.observationLocation);
            }

            @Override
            public void set(final ObsDataLocationType _instance_, final AstroSTCDescriptionType _value_) {
                if (_instance_!= null) {
                    _instance_.observationLocation = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ObsDataLocationType, PixelSpaceType> PIXEL_SPACE = new SinglePropertyInfo<ObsDataLocationType,PixelSpaceType>("pixelSpace", ObsDataLocationType.class, PixelSpaceType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "PixelSpace"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "pixelSpaceType"), false) {


            @Override
            public PixelSpaceType get(final ObsDataLocationType _instance_) {
                return ((_instance_ == null)?null:_instance_.pixelSpace);
            }

            @Override
            public void set(final ObsDataLocationType _instance_, final PixelSpaceType _value_) {
                if (_instance_!= null) {
                    _instance_.pixelSpace = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends ObsDataLocationType.Selector<ObsDataLocationType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static ObsDataLocationType.Select _root() {
            return new ObsDataLocationType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends StcMetadataType.Selector<TRoot, TParent>
    {

        private ObservatoryLocationType.Selector<TRoot, ObsDataLocationType.Selector<TRoot, TParent>> observatoryLocation = null;
        private AstroSTCDescriptionType.Selector<TRoot, ObsDataLocationType.Selector<TRoot, TParent>> observationLocation = null;
        private PixelSpaceType.Selector<TRoot, ObsDataLocationType.Selector<TRoot, TParent>> pixelSpace = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.observatoryLocation!= null) {
                products.put("observatoryLocation", this.observatoryLocation.init());
            }
            if (this.observationLocation!= null) {
                products.put("observationLocation", this.observationLocation.init());
            }
            if (this.pixelSpace!= null) {
                products.put("pixelSpace", this.pixelSpace.init());
            }
            return products;
        }

        public ObservatoryLocationType.Selector<TRoot, ObsDataLocationType.Selector<TRoot, TParent>> observatoryLocation() {
            return ((this.observatoryLocation == null)?this.observatoryLocation = new ObservatoryLocationType.Selector<>(this._root, this, "observatoryLocation"):this.observatoryLocation);
        }

        public AstroSTCDescriptionType.Selector<TRoot, ObsDataLocationType.Selector<TRoot, TParent>> observationLocation() {
            return ((this.observationLocation == null)?this.observationLocation = new AstroSTCDescriptionType.Selector<>(this._root, this, "observationLocation"):this.observationLocation);
        }

        public PixelSpaceType.Selector<TRoot, ObsDataLocationType.Selector<TRoot, TParent>> pixelSpace() {
            return ((this.pixelSpace == null)?this.pixelSpace = new PixelSpaceType.Selector<>(this._root, this, "pixelSpace"):this.pixelSpace);
        }

    }

}
