
package org.javastro.ivoa.entities.stc.v1;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * If solar system positions are implied anywhere, the planetary ephemeris to be used needs to be provided - usually JPL-DE405 with ICRS and JPL-DE200 with FK5
 * 
 * <p>Java class for planetaryEphemType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="planetaryEphemType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="JPL-DE200"/>
 *     <enumeration value="JPL-DE405"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "planetaryEphemType")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public enum PlanetaryEphemType implements EnumValue<String>
{

    @XmlEnumValue("JPL-DE200")
    JPL_DE_200("JPL-DE200"),
    @XmlEnumValue("JPL-DE405")
    JPL_DE_405("JPL-DE405");
    private final String value;

    PlanetaryEphemType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PlanetaryEphemType fromValue(String v) {
        for (PlanetaryEphemType c: PlanetaryEphemType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
