
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Contains the Doppler definitions, including whether the values are velocity or redshift (value_type)
 * 
 * <p>Java class for redshiftFrameType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="redshiftFrameType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}coordFrameType">
 *       <sequence>
 *         <element name="DopplerDefinition" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}dopplerDefinitionType"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}ReferencePosition"/>
 *       </sequence>
 *       <attribute name="value_type" default="VELOCITY">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             <enumeration value="VELOCITY"/>
 *             <enumeration value="REDSHIFT"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "redshiftFrameType", propOrder = {
    "dopplerDefinition",
    "referencePosition"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class RedshiftFrameType
    extends CoordFrameType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The Doppler definition used: optical, radio, or pseudo-relativistic (i.e., how is a redshift converted to a velocity); the most common is optical, except when the reference is LSR (usually radio)
     * 
     */
    @XmlElement(name = "DopplerDefinition", required = true, nillable = true)
    @XmlSchemaType(name = "string")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected DopplerDefinitionType dopplerDefinition;
    /**
     * The reference frame for the Doppler velocities or redshfts; note presence of LSR
     * 
     */
    @XmlElementRef(name = "ReferencePosition", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected JAXBElement<? extends ReferencePositionType> referencePosition;
    @XmlAttribute(name = "value_type")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String valueType;

    /**
     * Default no-arg constructor
     * 
     */
    public RedshiftFrameType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public RedshiftFrameType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final String name, final DopplerDefinitionType dopplerDefinition, final JAXBElement<? extends ReferencePositionType> referencePosition, final String valueType) {
        super(id, idref, ucd, type, href, idType, idrefType, name);
        this.dopplerDefinition = dopplerDefinition;
        this.referencePosition = referencePosition;
        this.valueType = valueType;
    }

    /**
     * The Doppler definition used: optical, radio, or pseudo-relativistic (i.e., how is a redshift converted to a velocity); the most common is optical, except when the reference is LSR (usually radio)
     * 
     * @return
     *     possible object is
     *     {@link DopplerDefinitionType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DopplerDefinitionType getDopplerDefinition() {
        return dopplerDefinition;
    }

    /**
     * Sets the value of the dopplerDefinition property.
     * 
     * @param value
     *     allowed object is
     *     {@link DopplerDefinitionType }
     *     
     * @see #getDopplerDefinition()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setDopplerDefinition(DopplerDefinitionType value) {
        this.dopplerDefinition = value;
    }

    /**
     * The reference frame for the Doppler velocities or redshfts; note presence of LSR
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link CustomRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ReferencePositionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public JAXBElement<? extends ReferencePositionType> getReferencePosition() {
        return referencePosition;
    }

    /**
     * Sets the value of the referencePosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link CustomRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ReferencePositionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     
     * @see #getReferencePosition()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setReferencePosition(JAXBElement<? extends ReferencePositionType> value) {
        this.referencePosition = value;
    }

    /**
     * Gets the value of the valueType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getValueType() {
        if (valueType == null) {
            return "VELOCITY";
        } else {
            return valueType;
        }
    }

    /**
     * Sets the value of the valueType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setValueType(String value) {
        this.valueType = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final RedshiftFrameType that = ((RedshiftFrameType) object);
        {
            DopplerDefinitionType leftDopplerDefinition;
            leftDopplerDefinition = this.getDopplerDefinition();
            DopplerDefinitionType rightDopplerDefinition;
            rightDopplerDefinition = that.getDopplerDefinition();
            if (this.dopplerDefinition!= null) {
                if (that.dopplerDefinition!= null) {
                    if (!leftDopplerDefinition.equals(rightDopplerDefinition)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.dopplerDefinition!= null) {
                    return false;
                }
            }
        }
        {
            JAXBElement<? extends ReferencePositionType> leftReferencePosition;
            leftReferencePosition = this.getReferencePosition();
            JAXBElement<? extends ReferencePositionType> rightReferencePosition;
            rightReferencePosition = that.getReferencePosition();
            if (this.referencePosition!= null) {
                if (that.referencePosition!= null) {
                    {
                        final QName leftReferencePositionName = leftReferencePosition.getName();
                        final QName rightReferencePositionName = rightReferencePosition.getName();
                        if (leftReferencePositionName!= null) {
                            if (rightReferencePositionName!= null) {
                                if (!leftReferencePositionName.equals(rightReferencePositionName)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionName!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final ReferencePositionType leftReferencePositionValue = leftReferencePosition.getValue();
                        final ReferencePositionType rightReferencePositionValue = rightReferencePosition.getValue();
                        if (leftReferencePositionValue!= null) {
                            if (rightReferencePositionValue!= null) {
                                if (!leftReferencePositionValue.equals(rightReferencePositionValue)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionValue!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<? extends ReferencePositionType> leftReferencePositionDeclaredType = leftReferencePosition.getDeclaredType();
                        final Class<? extends ReferencePositionType> rightReferencePositionDeclaredType = rightReferencePosition.getDeclaredType();
                        if (leftReferencePositionDeclaredType!= null) {
                            if (rightReferencePositionDeclaredType!= null) {
                                if (!leftReferencePositionDeclaredType.equals(rightReferencePositionDeclaredType)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionDeclaredType!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<?> leftReferencePositionScope = leftReferencePosition.getScope();
                        final Class<?> rightReferencePositionScope = rightReferencePosition.getScope();
                        if (leftReferencePositionScope!= null) {
                            if (rightReferencePositionScope!= null) {
                                if (!leftReferencePositionScope.equals(rightReferencePositionScope)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionScope!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final boolean leftReferencePositionNil = leftReferencePosition.isNil();
                        final boolean rightReferencePositionNil = rightReferencePosition.isNil();
                        if (leftReferencePositionNil!= rightReferencePositionNil) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
            } else {
                if (that.referencePosition!= null) {
                    return false;
                }
            }
        }
        {
            String leftValueType;
            leftValueType = this.getValueType();
            String rightValueType;
            rightValueType = that.getValueType();
            if (this.valueType!= null) {
                if (that.valueType!= null) {
                    if (!leftValueType.equals(rightValueType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.valueType!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            DopplerDefinitionType theDopplerDefinition;
            theDopplerDefinition = this.getDopplerDefinition();
            if (this.dopplerDefinition!= null) {
                currentHashCode += theDopplerDefinition.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            JAXBElement<? extends ReferencePositionType> theReferencePosition;
            theReferencePosition = this.getReferencePosition();
            if (this.referencePosition!= null) {
                {
                    currentHashCode = (currentHashCode* 31);
                    final QName theReferencePositionName = theReferencePosition.getName();
                    if (theReferencePositionName!= null) {
                        currentHashCode += theReferencePositionName.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final ReferencePositionType theReferencePositionValue = theReferencePosition.getValue();
                    if (theReferencePositionValue!= null) {
                        currentHashCode += theReferencePositionValue.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<? extends ReferencePositionType> theReferencePositionDeclaredType = theReferencePosition.getDeclaredType();
                    if (theReferencePositionDeclaredType!= null) {
                        currentHashCode += theReferencePositionDeclaredType.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<?> theReferencePositionScope = theReferencePosition.getScope();
                    if (theReferencePositionScope!= null) {
                        currentHashCode += theReferencePositionScope.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final boolean theReferencePositionNil = theReferencePosition.isNil();
                    currentHashCode += (theReferencePositionNil? 1231 : 1237);
                }
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theValueType;
            theValueType = this.getValueType();
            if (this.valueType!= null) {
                currentHashCode += theValueType.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            DopplerDefinitionType theDopplerDefinition;
            theDopplerDefinition = this.getDopplerDefinition();
            strategy.appendField(locator, this, "dopplerDefinition", buffer, theDopplerDefinition, (this.dopplerDefinition!= null));
        }
        {
            JAXBElement<? extends ReferencePositionType> theReferencePosition;
            theReferencePosition = this.getReferencePosition();
            strategy.appendField(locator, this, "referencePosition", buffer, theReferencePosition, (this.referencePosition!= null));
        }
        {
            String theValueType;
            theValueType = this.getValueType();
            strategy.appendField(locator, this, "valueType", buffer, theValueType, (this.valueType!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof RedshiftFrameType) {
            final RedshiftFrameType target = this;
            final RedshiftFrameType leftObject = ((RedshiftFrameType) left);
            final RedshiftFrameType rightObject = ((RedshiftFrameType) right);
            {
                Boolean dopplerDefinitionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.dopplerDefinition!= null), (rightObject.dopplerDefinition!= null));
                if (dopplerDefinitionShouldBeMergedAndSet == Boolean.TRUE) {
                    DopplerDefinitionType lhsDopplerDefinition;
                    lhsDopplerDefinition = leftObject.getDopplerDefinition();
                    DopplerDefinitionType rhsDopplerDefinition;
                    rhsDopplerDefinition = rightObject.getDopplerDefinition();
                    DopplerDefinitionType mergedDopplerDefinition = ((DopplerDefinitionType) strategy.merge(LocatorUtils.property(leftLocator, "dopplerDefinition", lhsDopplerDefinition), LocatorUtils.property(rightLocator, "dopplerDefinition", rhsDopplerDefinition), lhsDopplerDefinition, rhsDopplerDefinition, (leftObject.dopplerDefinition!= null), (rightObject.dopplerDefinition!= null)));
                    target.setDopplerDefinition(mergedDopplerDefinition);
                } else {
                    if (dopplerDefinitionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.dopplerDefinition = null;
                    }
                }
            }
            {
                Boolean referencePositionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.referencePosition!= null), (rightObject.referencePosition!= null));
                if (referencePositionShouldBeMergedAndSet == Boolean.TRUE) {
                    JAXBElement<? extends ReferencePositionType> lhsReferencePosition;
                    lhsReferencePosition = leftObject.getReferencePosition();
                    JAXBElement<? extends ReferencePositionType> rhsReferencePosition;
                    rhsReferencePosition = rightObject.getReferencePosition();
                    JAXBElement<? extends ReferencePositionType> mergedReferencePosition = ((JAXBElement<? extends ReferencePositionType> ) strategy.merge(LocatorUtils.property(leftLocator, "referencePosition", lhsReferencePosition), LocatorUtils.property(rightLocator, "referencePosition", rhsReferencePosition), lhsReferencePosition, rhsReferencePosition, (leftObject.referencePosition!= null), (rightObject.referencePosition!= null)));
                    target.setReferencePosition(mergedReferencePosition);
                } else {
                    if (referencePositionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.referencePosition = null;
                    }
                }
            }
            {
                Boolean valueTypeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.valueType!= null), (rightObject.valueType!= null));
                if (valueTypeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsValueType;
                    lhsValueType = leftObject.getValueType();
                    String rhsValueType;
                    rhsValueType = rightObject.getValueType();
                    String mergedValueType = ((String) strategy.merge(LocatorUtils.property(leftLocator, "valueType", lhsValueType), LocatorUtils.property(rightLocator, "valueType", rhsValueType), lhsValueType, rhsValueType, (leftObject.valueType!= null), (rightObject.valueType!= null)));
                    target.setValueType(mergedValueType);
                } else {
                    if (valueTypeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.valueType = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new RedshiftFrameType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RedshiftFrameType clone() {
        final RedshiftFrameType _newObject;
        _newObject = ((RedshiftFrameType) super.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RedshiftFrameType createCopy() {
        final RedshiftFrameType _newObject = ((RedshiftFrameType) super.createCopy());
        _newObject.dopplerDefinition = this.dopplerDefinition;
        _newObject.referencePosition = this.referencePosition;
        _newObject.valueType = this.valueType;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RedshiftFrameType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final RedshiftFrameType _newObject = ((RedshiftFrameType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree dopplerDefinitionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dopplerDefinition"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dopplerDefinitionPropertyTree!= null):((dopplerDefinitionPropertyTree == null)||(!dopplerDefinitionPropertyTree.isLeaf())))) {
            _newObject.dopplerDefinition = this.dopplerDefinition;
        }
        final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
            _newObject.referencePosition = this.referencePosition;
        }
        final PropertyTree valueTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("valueType"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valueTypePropertyTree!= null):((valueTypePropertyTree == null)||(!valueTypePropertyTree.isLeaf())))) {
            _newObject.valueType = this.valueType;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RedshiftFrameType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RedshiftFrameType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RedshiftFrameType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new RedshiftFrameType.Modifier();
        }
        return ((RedshiftFrameType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final RedshiftFrameType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.dopplerDefinition = this.dopplerDefinition;
        _other.referencePosition = this.referencePosition;
        _other.valueType = this.valueType;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >RedshiftFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new RedshiftFrameType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RedshiftFrameType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static RedshiftFrameType.Builder<Void> builder() {
        return new RedshiftFrameType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >RedshiftFrameType.Builder<_B> copyOf(final StcBaseType _other) {
        final RedshiftFrameType.Builder<_B> _newBuilder = new RedshiftFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >RedshiftFrameType.Builder<_B> copyOf(final CoordFrameType _other) {
        final RedshiftFrameType.Builder<_B> _newBuilder = new RedshiftFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >RedshiftFrameType.Builder<_B> copyOf(final RedshiftFrameType _other) {
        final RedshiftFrameType.Builder<_B> _newBuilder = new RedshiftFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final RedshiftFrameType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree dopplerDefinitionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dopplerDefinition"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dopplerDefinitionPropertyTree!= null):((dopplerDefinitionPropertyTree == null)||(!dopplerDefinitionPropertyTree.isLeaf())))) {
            _other.dopplerDefinition = this.dopplerDefinition;
        }
        final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
            _other.referencePosition = this.referencePosition;
        }
        final PropertyTree valueTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("valueType"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valueTypePropertyTree!= null):((valueTypePropertyTree == null)||(!valueTypePropertyTree.isLeaf())))) {
            _other.valueType = this.valueType;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >RedshiftFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new RedshiftFrameType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RedshiftFrameType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >RedshiftFrameType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final RedshiftFrameType.Builder<_B> _newBuilder = new RedshiftFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >RedshiftFrameType.Builder<_B> copyOf(final CoordFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final RedshiftFrameType.Builder<_B> _newBuilder = new RedshiftFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >RedshiftFrameType.Builder<_B> copyOf(final RedshiftFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final RedshiftFrameType.Builder<_B> _newBuilder = new RedshiftFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static RedshiftFrameType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static RedshiftFrameType.Builder<Void> copyExcept(final CoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static RedshiftFrameType.Builder<Void> copyExcept(final RedshiftFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static RedshiftFrameType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static RedshiftFrameType.Builder<Void> copyOnly(final CoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static RedshiftFrameType.Builder<Void> copyOnly(final RedshiftFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RedshiftFrameType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(RedshiftFrameType.PropInfo.DOPPLER_DEFINITION, this));
        if (_visitor_.visit(new SingleProperty<>(RedshiftFrameType.PropInfo.REFERENCE_POSITION, this))&&(this.referencePosition!= null)) {
            this.referencePosition.getValue().visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(RedshiftFrameType.PropInfo.VALUE_TYPE, this));
        return this;
    }

    public static class Builder<_B >
        extends CoordFrameType.Builder<_B>
        implements Buildable
    {

        private DopplerDefinitionType dopplerDefinition;
        private JAXBElement<? extends ReferencePositionType> referencePosition;
        private String valueType = "VELOCITY";

        public Builder(final _B _parentBuilder, final RedshiftFrameType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.dopplerDefinition = _other.dopplerDefinition;
                this.referencePosition = _other.referencePosition;
                this.valueType = _other.valueType;
            }
        }

        public Builder(final _B _parentBuilder, final RedshiftFrameType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree dopplerDefinitionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dopplerDefinition"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dopplerDefinitionPropertyTree!= null):((dopplerDefinitionPropertyTree == null)||(!dopplerDefinitionPropertyTree.isLeaf())))) {
                    this.dopplerDefinition = _other.dopplerDefinition;
                }
                final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
                    this.referencePosition = _other.referencePosition;
                }
                final PropertyTree valueTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("valueType"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valueTypePropertyTree!= null):((valueTypePropertyTree == null)||(!valueTypePropertyTree.isLeaf())))) {
                    this.valueType = _other.valueType;
                }
            }
        }

        protected<_P extends RedshiftFrameType >_P init(final _P _product) {
            _product.dopplerDefinition = this.dopplerDefinition;
            _product.referencePosition = this.referencePosition;
            _product.valueType = this.valueType;
            return super.init(_product);
        }

        /**
         * Sets the new value of "dopplerDefinition" (any previous value will be replaced)
         * 
         * @param dopplerDefinition
         *     New value of the "dopplerDefinition" property.
         */
        public RedshiftFrameType.Builder<_B> withDopplerDefinition(final DopplerDefinitionType dopplerDefinition) {
            this.dopplerDefinition = dopplerDefinition;
            return this;
        }

        /**
         * Sets the new value of "referencePosition" (any previous value will be replaced)
         * 
         * @param referencePosition
         *     New value of the "referencePosition" property.
         */
        public RedshiftFrameType.Builder<_B> withReferencePosition(final JAXBElement<? extends ReferencePositionType> referencePosition) {
            this.referencePosition = referencePosition;
            return this;
        }

        /**
         * Sets the new value of "valueType" (any previous value will be replaced)
         * 
         * @param valueType
         *     New value of the "valueType" property.
         */
        public RedshiftFrameType.Builder<_B> withValueType(final String valueType) {
            this.valueType = valueType;
            return this;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        @Override
        public RedshiftFrameType.Builder<_B> withName(final String name) {
            super.withName(name);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public RedshiftFrameType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public RedshiftFrameType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public RedshiftFrameType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public RedshiftFrameType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public RedshiftFrameType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public RedshiftFrameType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public RedshiftFrameType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public RedshiftFrameType build() {
            if (_storedValue == null) {
                return this.init(new RedshiftFrameType());
            } else {
                return ((RedshiftFrameType) _storedValue);
            }
        }

        public RedshiftFrameType.Builder<_B> copyOf(final RedshiftFrameType _other) {
            _other.copyTo(this);
            return this;
        }

        public RedshiftFrameType.Builder<_B> copyOf(final RedshiftFrameType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends CoordFrameType.Modifier
    {


        public void setDopplerDefinition(final DopplerDefinitionType dopplerDefinition) {
            RedshiftFrameType.this.setDopplerDefinition(dopplerDefinition);
        }

        public void setReferencePosition(final JAXBElement<? extends ReferencePositionType> referencePosition) {
            RedshiftFrameType.this.setReferencePosition(referencePosition);
        }

        public void setValueType(final String valueType) {
            RedshiftFrameType.this.setValueType(valueType);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<RedshiftFrameType, DopplerDefinitionType> DOPPLER_DEFINITION = new SinglePropertyInfo<RedshiftFrameType,DopplerDefinitionType>("dopplerDefinition", RedshiftFrameType.class, DopplerDefinitionType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "DopplerDefinition"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "dopplerDefinitionType"), false) {


            @Override
            public DopplerDefinitionType get(final RedshiftFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.dopplerDefinition);
            }

            @Override
            public void set(final RedshiftFrameType _instance_, final DopplerDefinitionType _value_) {
                if (_instance_!= null) {
                    _instance_.dopplerDefinition = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<RedshiftFrameType, ReferencePositionType> REFERENCE_POSITION = new SinglePropertyInfo<RedshiftFrameType,ReferencePositionType>("referencePosition", RedshiftFrameType.class, ReferencePositionType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "ReferencePosition"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "referencePositionType"), false) {


            @Override
            public ReferencePositionType get(final RedshiftFrameType _instance_) {
                return ((_instance_ == null)?null:((_instance_.referencePosition == null)?null:_instance_.referencePosition.getValue()));
            }

            @Override
            public void set(final RedshiftFrameType _instance_, final ReferencePositionType _value_) {
                if (_instance_!= null) {
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<RedshiftFrameType, String> VALUE_TYPE = new SinglePropertyInfo<RedshiftFrameType,String>("valueType", RedshiftFrameType.class, String.class, false, "VELOCITY", new QName("", "value_type"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "anonymousAttributeType"), true) {


            @Override
            public String get(final RedshiftFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.valueType);
            }

            @Override
            public void set(final RedshiftFrameType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.valueType = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends RedshiftFrameType.Selector<RedshiftFrameType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static RedshiftFrameType.Select _root() {
            return new RedshiftFrameType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends CoordFrameType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, RedshiftFrameType.Selector<TRoot, TParent>> dopplerDefinition = null;
        private com.kscs.util.jaxb.Selector<TRoot, RedshiftFrameType.Selector<TRoot, TParent>> referencePosition = null;
        private com.kscs.util.jaxb.Selector<TRoot, RedshiftFrameType.Selector<TRoot, TParent>> valueType = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.dopplerDefinition!= null) {
                products.put("dopplerDefinition", this.dopplerDefinition.init());
            }
            if (this.referencePosition!= null) {
                products.put("referencePosition", this.referencePosition.init());
            }
            if (this.valueType!= null) {
                products.put("valueType", this.valueType.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, RedshiftFrameType.Selector<TRoot, TParent>> dopplerDefinition() {
            return ((this.dopplerDefinition == null)?this.dopplerDefinition = new com.kscs.util.jaxb.Selector<>(this._root, this, "dopplerDefinition"):this.dopplerDefinition);
        }

        public com.kscs.util.jaxb.Selector<TRoot, RedshiftFrameType.Selector<TRoot, TParent>> referencePosition() {
            return ((this.referencePosition == null)?this.referencePosition = new com.kscs.util.jaxb.Selector<>(this._root, this, "referencePosition"):this.referencePosition);
        }

        public com.kscs.util.jaxb.Selector<TRoot, RedshiftFrameType.Selector<TRoot, TParent>> valueType() {
            return ((this.valueType == null)?this.valueType = new com.kscs.util.jaxb.Selector<>(this._root, this, "valueType"):this.valueType);
        }

    }

}
