
package org.javastro.ivoa.entities.stc.v1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Type for STC Coordinate List
 * 
 * <p>Java class for STCCoordinateList complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="STCCoordinateList">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}stcMetadataType">
 *       <sequence>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}AstroCoordSystem"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}AstroCoords" maxOccurs="unbounded"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "STCCoordinateList", propOrder = {
    "astroCoordSystem",
    "astroCoords"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class STCCoordinateList
    extends StcMetadataType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The coordinate system definition: spatial coordinate frame and reference position; time frame and reference position; the coordinate flavor; the spectral fromae and redshift/Doppler frame; and the planetary ephemeris; an ID is required, since this is how coordinate elements are associated with their coordinate systems
     * 
     */
    @XmlElement(name = "AstroCoordSystem", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected AstroCoordSystemType astroCoordSystem;
    /**
     * The coordinate element consists either of a coordinate file or a sequence of time element, spatial coordinate element, velocity element, and redshift element; the spatial and velocity elements may be scalar or vector; it needs to refer to a coordinate system
     * 
     */
    @XmlElement(name = "AstroCoords", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<AstroCoordsType> astroCoords;

    /**
     * Default no-arg constructor
     * 
     */
    public STCCoordinateList() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public STCCoordinateList(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final AstroCoordSystemType astroCoordSystem, final List<AstroCoordsType> astroCoords) {
        super(id, idref, ucd, type, href, idType, idrefType);
        this.astroCoordSystem = astroCoordSystem;
        this.astroCoords = astroCoords;
    }

    /**
     * The coordinate system definition: spatial coordinate frame and reference position; time frame and reference position; the coordinate flavor; the spectral fromae and redshift/Doppler frame; and the planetary ephemeris; an ID is required, since this is how coordinate elements are associated with their coordinate systems
     * 
     * @return
     *     possible object is
     *     {@link AstroCoordSystemType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordSystemType getAstroCoordSystem() {
        return astroCoordSystem;
    }

    /**
     * Sets the value of the astroCoordSystem property.
     * 
     * @param value
     *     allowed object is
     *     {@link AstroCoordSystemType }
     *     
     * @see #getAstroCoordSystem()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setAstroCoordSystem(AstroCoordSystemType value) {
        this.astroCoordSystem = value;
    }

    /**
     * The coordinate element consists either of a coordinate file or a sequence of time element, spatial coordinate element, velocity element, and redshift element; the spatial and velocity elements may be scalar or vector; it needs to refer to a coordinate system
     * 
     * Gets the value of the astroCoords property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the astroCoords property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAstroCoords().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AstroCoordsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the astroCoords property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<AstroCoordsType> getAstroCoords() {
        if (astroCoords == null) {
            astroCoords = new ArrayList<>();
        }
        return this.astroCoords;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final STCCoordinateList that = ((STCCoordinateList) object);
        {
            AstroCoordSystemType leftAstroCoordSystem;
            leftAstroCoordSystem = this.getAstroCoordSystem();
            AstroCoordSystemType rightAstroCoordSystem;
            rightAstroCoordSystem = that.getAstroCoordSystem();
            if (this.astroCoordSystem!= null) {
                if (that.astroCoordSystem!= null) {
                    if (!leftAstroCoordSystem.equals(rightAstroCoordSystem)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.astroCoordSystem!= null) {
                    return false;
                }
            }
        }
        {
            List<AstroCoordsType> leftAstroCoords;
            leftAstroCoords = (((this.astroCoords!= null)&&(!this.astroCoords.isEmpty()))?this.getAstroCoords():null);
            List<AstroCoordsType> rightAstroCoords;
            rightAstroCoords = (((that.astroCoords!= null)&&(!that.astroCoords.isEmpty()))?that.getAstroCoords():null);
            if ((this.astroCoords!= null)&&(!this.astroCoords.isEmpty())) {
                if ((that.astroCoords!= null)&&(!that.astroCoords.isEmpty())) {
                    if (!leftAstroCoords.equals(rightAstroCoords)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.astroCoords!= null)&&(!that.astroCoords.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            AstroCoordSystemType theAstroCoordSystem;
            theAstroCoordSystem = this.getAstroCoordSystem();
            if (this.astroCoordSystem!= null) {
                currentHashCode += theAstroCoordSystem.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<AstroCoordsType> theAstroCoords;
            theAstroCoords = (((this.astroCoords!= null)&&(!this.astroCoords.isEmpty()))?this.getAstroCoords():null);
            if ((this.astroCoords!= null)&&(!this.astroCoords.isEmpty())) {
                currentHashCode += theAstroCoords.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            AstroCoordSystemType theAstroCoordSystem;
            theAstroCoordSystem = this.getAstroCoordSystem();
            strategy.appendField(locator, this, "astroCoordSystem", buffer, theAstroCoordSystem, (this.astroCoordSystem!= null));
        }
        {
            List<AstroCoordsType> theAstroCoords;
            theAstroCoords = (((this.astroCoords!= null)&&(!this.astroCoords.isEmpty()))?this.getAstroCoords():null);
            strategy.appendField(locator, this, "astroCoords", buffer, theAstroCoords, ((this.astroCoords!= null)&&(!this.astroCoords.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof STCCoordinateList) {
            final STCCoordinateList target = this;
            final STCCoordinateList leftObject = ((STCCoordinateList) left);
            final STCCoordinateList rightObject = ((STCCoordinateList) right);
            {
                Boolean astroCoordSystemShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.astroCoordSystem!= null), (rightObject.astroCoordSystem!= null));
                if (astroCoordSystemShouldBeMergedAndSet == Boolean.TRUE) {
                    AstroCoordSystemType lhsAstroCoordSystem;
                    lhsAstroCoordSystem = leftObject.getAstroCoordSystem();
                    AstroCoordSystemType rhsAstroCoordSystem;
                    rhsAstroCoordSystem = rightObject.getAstroCoordSystem();
                    AstroCoordSystemType mergedAstroCoordSystem = ((AstroCoordSystemType) strategy.merge(LocatorUtils.property(leftLocator, "astroCoordSystem", lhsAstroCoordSystem), LocatorUtils.property(rightLocator, "astroCoordSystem", rhsAstroCoordSystem), lhsAstroCoordSystem, rhsAstroCoordSystem, (leftObject.astroCoordSystem!= null), (rightObject.astroCoordSystem!= null)));
                    target.setAstroCoordSystem(mergedAstroCoordSystem);
                } else {
                    if (astroCoordSystemShouldBeMergedAndSet == Boolean.FALSE) {
                        target.astroCoordSystem = null;
                    }
                }
            }
            {
                Boolean astroCoordsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.astroCoords!= null)&&(!leftObject.astroCoords.isEmpty())), ((rightObject.astroCoords!= null)&&(!rightObject.astroCoords.isEmpty())));
                if (astroCoordsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<AstroCoordsType> lhsAstroCoords;
                    lhsAstroCoords = (((leftObject.astroCoords!= null)&&(!leftObject.astroCoords.isEmpty()))?leftObject.getAstroCoords():null);
                    List<AstroCoordsType> rhsAstroCoords;
                    rhsAstroCoords = (((rightObject.astroCoords!= null)&&(!rightObject.astroCoords.isEmpty()))?rightObject.getAstroCoords():null);
                    List<AstroCoordsType> mergedAstroCoords = ((List<AstroCoordsType> ) strategy.merge(LocatorUtils.property(leftLocator, "astroCoords", lhsAstroCoords), LocatorUtils.property(rightLocator, "astroCoords", rhsAstroCoords), lhsAstroCoords, rhsAstroCoords, ((leftObject.astroCoords!= null)&&(!leftObject.astroCoords.isEmpty())), ((rightObject.astroCoords!= null)&&(!rightObject.astroCoords.isEmpty()))));
                    target.astroCoords = null;
                    if (mergedAstroCoords!= null) {
                        List<AstroCoordsType> uniqueAstroCoordsl = target.getAstroCoords();
                        uniqueAstroCoordsl.addAll(mergedAstroCoords);
                    }
                } else {
                    if (astroCoordsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.astroCoords = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new STCCoordinateList();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCCoordinateList clone() {
        final STCCoordinateList _newObject;
        _newObject = ((STCCoordinateList) super.clone());
        _newObject.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.clone());
        if (this.astroCoords == null) {
            _newObject.astroCoords = null;
        } else {
            _newObject.astroCoords = new ArrayList<>();
            for (AstroCoordsType _item: this.astroCoords) {
                _newObject.astroCoords.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCCoordinateList createCopy() {
        final STCCoordinateList _newObject = ((STCCoordinateList) super.createCopy());
        _newObject.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.createCopy());
        if (this.astroCoords == null) {
            _newObject.astroCoords = null;
        } else {
            _newObject.astroCoords = new ArrayList<>();
            for (AstroCoordsType _item: this.astroCoords) {
                _newObject.astroCoords.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCCoordinateList createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCCoordinateList _newObject = ((STCCoordinateList) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree astroCoordSystemPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoordSystem"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordSystemPropertyTree!= null):((astroCoordSystemPropertyTree == null)||(!astroCoordSystemPropertyTree.isLeaf())))) {
            _newObject.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.createCopy(astroCoordSystemPropertyTree, _propertyTreeUse));
        }
        final PropertyTree astroCoordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordsPropertyTree!= null):((astroCoordsPropertyTree == null)||(!astroCoordsPropertyTree.isLeaf())))) {
            if (this.astroCoords == null) {
                _newObject.astroCoords = null;
            } else {
                _newObject.astroCoords = new ArrayList<>();
                for (AstroCoordsType _item: this.astroCoords) {
                    _newObject.astroCoords.add(((_item == null)?null:_item.createCopy(astroCoordsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCCoordinateList copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCCoordinateList copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCCoordinateList.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new STCCoordinateList.Modifier();
        }
        return ((STCCoordinateList.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final STCCoordinateList.Builder<_B> _other) {
        super.copyTo(_other);
        _other.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.newCopyBuilder(_other));
        if (this.astroCoords == null) {
            _other.astroCoords = null;
        } else {
            _other.astroCoords = new ArrayList<>();
            for (AstroCoordsType _item: this.astroCoords) {
                _other.astroCoords.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >STCCoordinateList.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new STCCoordinateList.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCCoordinateList.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCCoordinateList.Builder<Void> builder() {
        return new STCCoordinateList.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCCoordinateList.Builder<_B> copyOf(final StcBaseType _other) {
        final STCCoordinateList.Builder<_B> _newBuilder = new STCCoordinateList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCCoordinateList.Builder<_B> copyOf(final StcMetadataType _other) {
        final STCCoordinateList.Builder<_B> _newBuilder = new STCCoordinateList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCCoordinateList.Builder<_B> copyOf(final STCCoordinateList _other) {
        final STCCoordinateList.Builder<_B> _newBuilder = new STCCoordinateList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final STCCoordinateList.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree astroCoordSystemPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoordSystem"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordSystemPropertyTree!= null):((astroCoordSystemPropertyTree == null)||(!astroCoordSystemPropertyTree.isLeaf())))) {
            _other.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.newCopyBuilder(_other, astroCoordSystemPropertyTree, _propertyTreeUse));
        }
        final PropertyTree astroCoordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordsPropertyTree!= null):((astroCoordsPropertyTree == null)||(!astroCoordsPropertyTree.isLeaf())))) {
            if (this.astroCoords == null) {
                _other.astroCoords = null;
            } else {
                _other.astroCoords = new ArrayList<>();
                for (AstroCoordsType _item: this.astroCoords) {
                    _other.astroCoords.add(((_item == null)?null:_item.newCopyBuilder(_other, astroCoordsPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >STCCoordinateList.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new STCCoordinateList.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCCoordinateList.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCCoordinateList.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCCoordinateList.Builder<_B> _newBuilder = new STCCoordinateList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCCoordinateList.Builder<_B> copyOf(final StcMetadataType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCCoordinateList.Builder<_B> _newBuilder = new STCCoordinateList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCCoordinateList.Builder<_B> copyOf(final STCCoordinateList _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCCoordinateList.Builder<_B> _newBuilder = new STCCoordinateList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCCoordinateList.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCCoordinateList.Builder<Void> copyExcept(final StcMetadataType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCCoordinateList.Builder<Void> copyExcept(final STCCoordinateList _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCCoordinateList.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCCoordinateList.Builder<Void> copyOnly(final StcMetadataType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCCoordinateList.Builder<Void> copyOnly(final STCCoordinateList _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCCoordinateList visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(STCCoordinateList.PropInfo.ASTRO_COORD_SYSTEM, this))&&(this.astroCoordSystem!= null)) {
            this.astroCoordSystem.visit(_visitor_);
        }
        if (_visitor_.visit(new CollectionProperty<>(STCCoordinateList.PropInfo.ASTRO_COORDS, this))&&(this.astroCoords!= null)) {
            for (AstroCoordsType _item_: this.astroCoords) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends StcMetadataType.Builder<_B>
        implements Buildable
    {

        private AstroCoordSystemType.Builder<STCCoordinateList.Builder<_B>> astroCoordSystem;
        private List<AstroCoordsType.Builder<STCCoordinateList.Builder<_B>>> astroCoords;

        public Builder(final _B _parentBuilder, final STCCoordinateList _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.astroCoordSystem = ((_other.astroCoordSystem == null)?null:_other.astroCoordSystem.newCopyBuilder(this));
                if (_other.astroCoords == null) {
                    this.astroCoords = null;
                } else {
                    this.astroCoords = new ArrayList<>();
                    for (AstroCoordsType _item: _other.astroCoords) {
                        this.astroCoords.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final STCCoordinateList _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree astroCoordSystemPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoordSystem"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordSystemPropertyTree!= null):((astroCoordSystemPropertyTree == null)||(!astroCoordSystemPropertyTree.isLeaf())))) {
                    this.astroCoordSystem = ((_other.astroCoordSystem == null)?null:_other.astroCoordSystem.newCopyBuilder(this, astroCoordSystemPropertyTree, _propertyTreeUse));
                }
                final PropertyTree astroCoordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoords"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordsPropertyTree!= null):((astroCoordsPropertyTree == null)||(!astroCoordsPropertyTree.isLeaf())))) {
                    if (_other.astroCoords == null) {
                        this.astroCoords = null;
                    } else {
                        this.astroCoords = new ArrayList<>();
                        for (AstroCoordsType _item: _other.astroCoords) {
                            this.astroCoords.add(((_item == null)?null:_item.newCopyBuilder(this, astroCoordsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
            }
        }

        protected<_P extends STCCoordinateList >_P init(final _P _product) {
            _product.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.build());
            if (this.astroCoords!= null) {
                final List<AstroCoordsType> astroCoords = new ArrayList<>(this.astroCoords.size());
                for (AstroCoordsType.Builder<STCCoordinateList.Builder<_B>> _item: this.astroCoords) {
                    astroCoords.add(_item.build());
                }
                _product.astroCoords = astroCoords;
            }
            return super.init(_product);
        }

        /**
         * Sets the new value of "astroCoordSystem" (any previous value will be replaced)
         * 
         * @param astroCoordSystem
         *     New value of the "astroCoordSystem" property.
         */
        public STCCoordinateList.Builder<_B> withAstroCoordSystem(final AstroCoordSystemType astroCoordSystem) {
            this.astroCoordSystem = ((astroCoordSystem == null)?null:new AstroCoordSystemType.Builder<>(this, astroCoordSystem, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "astroCoordSystem" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordSystemType.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "astroCoordSystem" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordSystemType.Builder#end()}
         *     to return to the current builder.
         */
        public AstroCoordSystemType.Builder<? extends STCCoordinateList.Builder<_B>> withAstroCoordSystem() {
            if (this.astroCoordSystem!= null) {
                return this.astroCoordSystem;
            }
            return this.astroCoordSystem = new AstroCoordSystemType.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "astroCoords"
         * 
         * @param astroCoords
         *     Items to add to the value of the "astroCoords" property
         */
        public STCCoordinateList.Builder<_B> addAstroCoords(final Iterable<? extends AstroCoordsType> astroCoords) {
            if (astroCoords!= null) {
                if (this.astroCoords == null) {
                    this.astroCoords = new ArrayList<>();
                }
                for (AstroCoordsType _item: astroCoords) {
                    this.astroCoords.add(new AstroCoordsType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "astroCoords" (any previous value will be replaced)
         * 
         * @param astroCoords
         *     New value of the "astroCoords" property.
         */
        public STCCoordinateList.Builder<_B> withAstroCoords(final Iterable<? extends AstroCoordsType> astroCoords) {
            if (this.astroCoords!= null) {
                this.astroCoords.clear();
            }
            return addAstroCoords(astroCoords);
        }

        /**
         * Adds the given items to the value of "astroCoords"
         * 
         * @param astroCoords
         *     Items to add to the value of the "astroCoords" property
         */
        public STCCoordinateList.Builder<_B> addAstroCoords(AstroCoordsType... astroCoords) {
            addAstroCoords(Arrays.asList(astroCoords));
            return this;
        }

        /**
         * Sets the new value of "astroCoords" (any previous value will be replaced)
         * 
         * @param astroCoords
         *     New value of the "astroCoords" property.
         */
        public STCCoordinateList.Builder<_B> withAstroCoords(AstroCoordsType... astroCoords) {
            withAstroCoords(Arrays.asList(astroCoords));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "AstroCoords"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordsType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "AstroCoords" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordsType.Builder#end()} to
         *     return to the current builder.
         */
        public AstroCoordsType.Builder<? extends STCCoordinateList.Builder<_B>> addAstroCoords() {
            if (this.astroCoords == null) {
                this.astroCoords = new ArrayList<>();
            }
            final AstroCoordsType.Builder<STCCoordinateList.Builder<_B>> astroCoords_Builder = new AstroCoordsType.Builder<>(this, null, false);
            this.astroCoords.add(astroCoords_Builder);
            return astroCoords_Builder;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public STCCoordinateList.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public STCCoordinateList.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public STCCoordinateList.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public STCCoordinateList.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public STCCoordinateList.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public STCCoordinateList.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public STCCoordinateList.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public STCCoordinateList build() {
            if (_storedValue == null) {
                return this.init(new STCCoordinateList());
            } else {
                return ((STCCoordinateList) _storedValue);
            }
        }

        public STCCoordinateList.Builder<_B> copyOf(final STCCoordinateList _other) {
            _other.copyTo(this);
            return this;
        }

        public STCCoordinateList.Builder<_B> copyOf(final STCCoordinateList.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends StcMetadataType.Modifier
    {


        public void setAstroCoordSystem(final AstroCoordSystemType astroCoordSystem) {
            STCCoordinateList.this.setAstroCoordSystem(astroCoordSystem);
        }

        public List<AstroCoordsType> getAstroCoords() {
            if (STCCoordinateList.this.astroCoords == null) {
                STCCoordinateList.this.astroCoords = new ArrayList<>();
            }
            return STCCoordinateList.this.astroCoords;
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<STCCoordinateList, AstroCoordSystemType> ASTRO_COORD_SYSTEM = new SinglePropertyInfo<STCCoordinateList,AstroCoordSystemType>("astroCoordSystem", STCCoordinateList.class, AstroCoordSystemType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "AstroCoordSystem"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroCoordSystemType"), false) {


            @Override
            public AstroCoordSystemType get(final STCCoordinateList _instance_) {
                return ((_instance_ == null)?null:_instance_.astroCoordSystem);
            }

            @Override
            public void set(final STCCoordinateList _instance_, final AstroCoordSystemType _value_) {
                if (_instance_!= null) {
                    _instance_.astroCoordSystem = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<STCCoordinateList, AstroCoordsType> ASTRO_COORDS = new CollectionPropertyInfo<STCCoordinateList,AstroCoordsType>("astroCoords", STCCoordinateList.class, AstroCoordsType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "AstroCoords"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroCoordsType"), false) {


            @Override
            public List<AstroCoordsType> get(final STCCoordinateList _instance_) {
                return ((_instance_ == null)?null:_instance_.astroCoords);
            }

            @Override
            public void set(final STCCoordinateList _instance_, final List<AstroCoordsType> _value_) {
                if (_instance_!= null) {
                    _instance_.astroCoords = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends STCCoordinateList.Selector<STCCoordinateList.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static STCCoordinateList.Select _root() {
            return new STCCoordinateList.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends StcMetadataType.Selector<TRoot, TParent>
    {

        private AstroCoordSystemType.Selector<TRoot, STCCoordinateList.Selector<TRoot, TParent>> astroCoordSystem = null;
        private AstroCoordsType.Selector<TRoot, STCCoordinateList.Selector<TRoot, TParent>> astroCoords = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.astroCoordSystem!= null) {
                products.put("astroCoordSystem", this.astroCoordSystem.init());
            }
            if (this.astroCoords!= null) {
                products.put("astroCoords", this.astroCoords.init());
            }
            return products;
        }

        public AstroCoordSystemType.Selector<TRoot, STCCoordinateList.Selector<TRoot, TParent>> astroCoordSystem() {
            return ((this.astroCoordSystem == null)?this.astroCoordSystem = new AstroCoordSystemType.Selector<>(this._root, this, "astroCoordSystem"):this.astroCoordSystem);
        }

        public AstroCoordsType.Selector<TRoot, STCCoordinateList.Selector<TRoot, TParent>> astroCoords() {
            return ((this.astroCoords == null)?this.astroCoords = new AstroCoordsType.Selector<>(this._root, this, "astroCoords"):this.astroCoords);
        }

    }

}
