
package org.javastro.ivoa.entities.stc.v1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.IndirectCollectionProperty;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Type for STC Region list
 * 
 * <p>Java class for STCRegionList complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="STCRegionList">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}stcMetadataType">
 *       <sequence>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}AstroCoordSystem"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}Region" maxOccurs="unbounded"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "STCRegionList", propOrder = {
    "astroCoordSystem",
    "regions"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class STCRegionList
    extends StcMetadataType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The coordinate system definition: spatial coordinate frame and reference position; time frame and reference position; the coordinate flavor; the spectral fromae and redshift/Doppler frame; and the planetary ephemeris; an ID is required, since this is how coordinate elements are associated with their coordinate systems
     * 
     */
    @XmlElement(name = "AstroCoordSystem", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected AstroCoordSystemType astroCoordSystem;
    /**
     * Head element of the Region substitution group; a Region is a Shape or the result of a Region Operation on one or more Regions
     * 
     */
    @XmlElementRef(name = "Region", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<JAXBElement<? extends RegionType>> regions;

    /**
     * Default no-arg constructor
     * 
     */
    public STCRegionList() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public STCRegionList(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final AstroCoordSystemType astroCoordSystem, final List<JAXBElement<? extends RegionType>> regions) {
        super(id, idref, ucd, type, href, idType, idrefType);
        this.astroCoordSystem = astroCoordSystem;
        this.regions = regions;
    }

    /**
     * The coordinate system definition: spatial coordinate frame and reference position; time frame and reference position; the coordinate flavor; the spectral fromae and redshift/Doppler frame; and the planetary ephemeris; an ID is required, since this is how coordinate elements are associated with their coordinate systems
     * 
     * @return
     *     possible object is
     *     {@link AstroCoordSystemType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordSystemType getAstroCoordSystem() {
        return astroCoordSystem;
    }

    /**
     * Sets the value of the astroCoordSystem property.
     * 
     * @param value
     *     allowed object is
     *     {@link AstroCoordSystemType }
     *     
     * @see #getAstroCoordSystem()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setAstroCoordSystem(AstroCoordSystemType value) {
        this.astroCoordSystem = value;
    }

    /**
     * Head element of the Region substitution group; a Region is a Shape or the result of a Region Operation on one or more Regions
     * 
     * Gets the value of the regions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the regions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRegions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JAXBElement }{@code <}{@link AllSkyType }{@code >}
     * {@link JAXBElement }{@code <}{@link BoxType }{@code >}
     * {@link JAXBElement }{@code <}{@link CircleType }{@code >}
     * {@link JAXBElement }{@code <}{@link ConvexHullType }{@code >}
     * {@link JAXBElement }{@code <}{@link ConvexType }{@code >}
     * {@link JAXBElement }{@code <}{@link DiffType }{@code >}
     * {@link JAXBElement }{@code <}{@link EllipseType }{@code >}
     * {@link JAXBElement }{@code <}{@link IntersectionType }{@code >}
     * {@link JAXBElement }{@code <}{@link NegationType }{@code >}
     * {@link JAXBElement }{@code <}{@link PolygonType }{@code >}
     * {@link JAXBElement }{@code <}{@link RegionType }{@code >}
     * {@link JAXBElement }{@code <}{@link SectorType }{@code >}
     * {@link JAXBElement }{@code <}{@link SkyIndexType }{@code >}
     * {@link JAXBElement }{@code <}{@link UnionType }{@code >}
     * </p>
     * 
     * 
     * @return
     *     The value of the regions property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<JAXBElement<? extends RegionType>> getRegions() {
        if (regions == null) {
            regions = new ArrayList<>();
        }
        return this.regions;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final STCRegionList that = ((STCRegionList) object);
        {
            AstroCoordSystemType leftAstroCoordSystem;
            leftAstroCoordSystem = this.getAstroCoordSystem();
            AstroCoordSystemType rightAstroCoordSystem;
            rightAstroCoordSystem = that.getAstroCoordSystem();
            if (this.astroCoordSystem!= null) {
                if (that.astroCoordSystem!= null) {
                    if (!leftAstroCoordSystem.equals(rightAstroCoordSystem)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.astroCoordSystem!= null) {
                    return false;
                }
            }
        }
        {
            List<JAXBElement<? extends RegionType>> leftRegions;
            leftRegions = (((this.regions!= null)&&(!this.regions.isEmpty()))?this.getRegions():null);
            List<JAXBElement<? extends RegionType>> rightRegions;
            rightRegions = (((that.regions!= null)&&(!that.regions.isEmpty()))?that.getRegions():null);
            if ((this.regions!= null)&&(!this.regions.isEmpty())) {
                if ((that.regions!= null)&&(!that.regions.isEmpty())) {
                    final ListIterator<JAXBElement<? extends RegionType>> leftRegionsListIterator = leftRegions.listIterator();
                    final ListIterator<JAXBElement<? extends RegionType>> rightRegionsListIterator = rightRegions.listIterator();
                    while (rightRegionsListIterator.hasNext()&&leftRegionsListIterator.hasNext()) {
                        final JAXBElement<? extends RegionType> rightRegionsListIteratorElement = rightRegionsListIterator.next();
                        final JAXBElement<? extends RegionType> leftRegionsListIteratorElement = leftRegionsListIterator.next();
                        if (rightRegionsListIteratorElement!= null) {
                            if (leftRegionsListIteratorElement!= null) {
                                {
                                    final QName rightRegionsListIteratorElementName = rightRegionsListIteratorElement.getName();
                                    final QName leftRegionsListIteratorElementName = leftRegionsListIteratorElement.getName();
                                    if (rightRegionsListIteratorElementName!= null) {
                                        if (leftRegionsListIteratorElementName!= null) {
                                            if (!rightRegionsListIteratorElementName.equals(leftRegionsListIteratorElementName)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftRegionsListIteratorElementName!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final RegionType rightRegionsListIteratorElementValue = rightRegionsListIteratorElement.getValue();
                                    final RegionType leftRegionsListIteratorElementValue = leftRegionsListIteratorElement.getValue();
                                    if (rightRegionsListIteratorElementValue!= null) {
                                        if (leftRegionsListIteratorElementValue!= null) {
                                            if (!rightRegionsListIteratorElementValue.equals(leftRegionsListIteratorElementValue)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftRegionsListIteratorElementValue!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<? extends RegionType> rightRegionsListIteratorElementDeclaredType = rightRegionsListIteratorElement.getDeclaredType();
                                    final Class<? extends RegionType> leftRegionsListIteratorElementDeclaredType = leftRegionsListIteratorElement.getDeclaredType();
                                    if (rightRegionsListIteratorElementDeclaredType!= null) {
                                        if (leftRegionsListIteratorElementDeclaredType!= null) {
                                            if (!rightRegionsListIteratorElementDeclaredType.equals(leftRegionsListIteratorElementDeclaredType)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftRegionsListIteratorElementDeclaredType!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<?> rightRegionsListIteratorElementScope = rightRegionsListIteratorElement.getScope();
                                    final Class<?> leftRegionsListIteratorElementScope = leftRegionsListIteratorElement.getScope();
                                    if (rightRegionsListIteratorElementScope!= null) {
                                        if (leftRegionsListIteratorElementScope!= null) {
                                            if (!rightRegionsListIteratorElementScope.equals(leftRegionsListIteratorElementScope)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftRegionsListIteratorElementScope!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final boolean rightRegionsListIteratorElementNil = rightRegionsListIteratorElement.isNil();
                                    final boolean leftRegionsListIteratorElementNil = leftRegionsListIteratorElement.isNil();
                                    if (rightRegionsListIteratorElementNil!= leftRegionsListIteratorElementNil) {
                                        return false;
                                    }
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (leftRegionsListIteratorElement!= null) {
                                return false;
                            }
                        }
                    }
                    if (rightRegionsListIterator.hasNext()||leftRegionsListIterator.hasNext()) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.regions!= null)&&(!that.regions.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            AstroCoordSystemType theAstroCoordSystem;
            theAstroCoordSystem = this.getAstroCoordSystem();
            if (this.astroCoordSystem!= null) {
                currentHashCode += theAstroCoordSystem.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<JAXBElement<? extends RegionType>> theRegions;
            theRegions = (((this.regions!= null)&&(!this.regions.isEmpty()))?this.getRegions():null);
            if ((this.regions!= null)&&(!this.regions.isEmpty())) {
                final ListIterator<JAXBElement<? extends RegionType>> theRegionsListIterator = theRegions.listIterator();
                while (theRegionsListIterator.hasNext()) {
                    currentHashCode = (currentHashCode* 31);
                    final JAXBElement<? extends RegionType> theRegionsListIteratorElement = theRegionsListIterator.next();
                    if (theRegionsListIteratorElement!= null) {
                        {
                            currentHashCode = (currentHashCode* 31);
                            final QName theRegionsListIteratorElementName = theRegionsListIteratorElement.getName();
                            if (theRegionsListIteratorElementName!= null) {
                                currentHashCode += theRegionsListIteratorElementName.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final RegionType theRegionsListIteratorElementValue = theRegionsListIteratorElement.getValue();
                            if (theRegionsListIteratorElementValue!= null) {
                                currentHashCode += theRegionsListIteratorElementValue.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<? extends RegionType> theRegionsListIteratorElementDeclaredType = theRegionsListIteratorElement.getDeclaredType();
                            if (theRegionsListIteratorElementDeclaredType!= null) {
                                currentHashCode += theRegionsListIteratorElementDeclaredType.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<?> theRegionsListIteratorElementScope = theRegionsListIteratorElement.getScope();
                            if (theRegionsListIteratorElementScope!= null) {
                                currentHashCode += theRegionsListIteratorElementScope.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final boolean theRegionsListIteratorElementNil = theRegionsListIteratorElement.isNil();
                            currentHashCode += (theRegionsListIteratorElementNil? 1231 : 1237);
                        }
                    }
                }
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            AstroCoordSystemType theAstroCoordSystem;
            theAstroCoordSystem = this.getAstroCoordSystem();
            strategy.appendField(locator, this, "astroCoordSystem", buffer, theAstroCoordSystem, (this.astroCoordSystem!= null));
        }
        {
            List<JAXBElement<? extends RegionType>> theRegions;
            theRegions = (((this.regions!= null)&&(!this.regions.isEmpty()))?this.getRegions():null);
            strategy.appendField(locator, this, "regions", buffer, theRegions, ((this.regions!= null)&&(!this.regions.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof STCRegionList) {
            final STCRegionList target = this;
            final STCRegionList leftObject = ((STCRegionList) left);
            final STCRegionList rightObject = ((STCRegionList) right);
            {
                Boolean astroCoordSystemShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.astroCoordSystem!= null), (rightObject.astroCoordSystem!= null));
                if (astroCoordSystemShouldBeMergedAndSet == Boolean.TRUE) {
                    AstroCoordSystemType lhsAstroCoordSystem;
                    lhsAstroCoordSystem = leftObject.getAstroCoordSystem();
                    AstroCoordSystemType rhsAstroCoordSystem;
                    rhsAstroCoordSystem = rightObject.getAstroCoordSystem();
                    AstroCoordSystemType mergedAstroCoordSystem = ((AstroCoordSystemType) strategy.merge(LocatorUtils.property(leftLocator, "astroCoordSystem", lhsAstroCoordSystem), LocatorUtils.property(rightLocator, "astroCoordSystem", rhsAstroCoordSystem), lhsAstroCoordSystem, rhsAstroCoordSystem, (leftObject.astroCoordSystem!= null), (rightObject.astroCoordSystem!= null)));
                    target.setAstroCoordSystem(mergedAstroCoordSystem);
                } else {
                    if (astroCoordSystemShouldBeMergedAndSet == Boolean.FALSE) {
                        target.astroCoordSystem = null;
                    }
                }
            }
            {
                Boolean regionsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.regions!= null)&&(!leftObject.regions.isEmpty())), ((rightObject.regions!= null)&&(!rightObject.regions.isEmpty())));
                if (regionsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<JAXBElement<? extends RegionType>> lhsRegions;
                    lhsRegions = (((leftObject.regions!= null)&&(!leftObject.regions.isEmpty()))?leftObject.getRegions():null);
                    List<JAXBElement<? extends RegionType>> rhsRegions;
                    rhsRegions = (((rightObject.regions!= null)&&(!rightObject.regions.isEmpty()))?rightObject.getRegions():null);
                    List<JAXBElement<? extends RegionType>> mergedRegions = ((List<JAXBElement<? extends RegionType>> ) strategy.merge(LocatorUtils.property(leftLocator, "regions", lhsRegions), LocatorUtils.property(rightLocator, "regions", rhsRegions), lhsRegions, rhsRegions, ((leftObject.regions!= null)&&(!leftObject.regions.isEmpty())), ((rightObject.regions!= null)&&(!rightObject.regions.isEmpty()))));
                    target.regions = null;
                    if (mergedRegions!= null) {
                        List<JAXBElement<? extends RegionType>> uniqueRegionsl = target.getRegions();
                        uniqueRegionsl.addAll(mergedRegions);
                    }
                } else {
                    if (regionsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.regions = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new STCRegionList();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCRegionList clone() {
        final STCRegionList _newObject;
        _newObject = ((STCRegionList) super.clone());
        _newObject.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.clone());
        _newObject.regions = ((this.regions == null)?null:new ArrayList<>(this.regions));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCRegionList createCopy() {
        final STCRegionList _newObject = ((STCRegionList) super.createCopy());
        _newObject.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.createCopy());
        _newObject.regions = ((this.regions == null)?null:new ArrayList<>(this.regions));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCRegionList createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCRegionList _newObject = ((STCRegionList) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree astroCoordSystemPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoordSystem"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordSystemPropertyTree!= null):((astroCoordSystemPropertyTree == null)||(!astroCoordSystemPropertyTree.isLeaf())))) {
            _newObject.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.createCopy(astroCoordSystemPropertyTree, _propertyTreeUse));
        }
        final PropertyTree regionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("regions"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(regionsPropertyTree!= null):((regionsPropertyTree == null)||(!regionsPropertyTree.isLeaf())))) {
            _newObject.regions = ((this.regions == null)?null:new ArrayList<>(this.regions));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCRegionList copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCRegionList copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCRegionList.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new STCRegionList.Modifier();
        }
        return ((STCRegionList.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final STCRegionList.Builder<_B> _other) {
        super.copyTo(_other);
        _other.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.newCopyBuilder(_other));
        if (this.regions == null) {
            _other.regions = null;
        } else {
            _other.regions = new ArrayList<>();
            for (JAXBElement<? extends RegionType> _item: this.regions) {
                _other.regions.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >STCRegionList.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new STCRegionList.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCRegionList.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCRegionList.Builder<Void> builder() {
        return new STCRegionList.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCRegionList.Builder<_B> copyOf(final StcBaseType _other) {
        final STCRegionList.Builder<_B> _newBuilder = new STCRegionList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCRegionList.Builder<_B> copyOf(final StcMetadataType _other) {
        final STCRegionList.Builder<_B> _newBuilder = new STCRegionList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCRegionList.Builder<_B> copyOf(final STCRegionList _other) {
        final STCRegionList.Builder<_B> _newBuilder = new STCRegionList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final STCRegionList.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree astroCoordSystemPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoordSystem"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordSystemPropertyTree!= null):((astroCoordSystemPropertyTree == null)||(!astroCoordSystemPropertyTree.isLeaf())))) {
            _other.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.newCopyBuilder(_other, astroCoordSystemPropertyTree, _propertyTreeUse));
        }
        final PropertyTree regionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("regions"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(regionsPropertyTree!= null):((regionsPropertyTree == null)||(!regionsPropertyTree.isLeaf())))) {
            if (this.regions == null) {
                _other.regions = null;
            } else {
                _other.regions = new ArrayList<>();
                for (JAXBElement<? extends RegionType> _item: this.regions) {
                    _other.regions.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >STCRegionList.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new STCRegionList.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCRegionList.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCRegionList.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCRegionList.Builder<_B> _newBuilder = new STCRegionList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCRegionList.Builder<_B> copyOf(final StcMetadataType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCRegionList.Builder<_B> _newBuilder = new STCRegionList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >STCRegionList.Builder<_B> copyOf(final STCRegionList _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCRegionList.Builder<_B> _newBuilder = new STCRegionList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCRegionList.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCRegionList.Builder<Void> copyExcept(final StcMetadataType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCRegionList.Builder<Void> copyExcept(final STCRegionList _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCRegionList.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCRegionList.Builder<Void> copyOnly(final StcMetadataType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static STCRegionList.Builder<Void> copyOnly(final STCRegionList _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public STCRegionList visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(STCRegionList.PropInfo.ASTRO_COORD_SYSTEM, this))&&(this.astroCoordSystem!= null)) {
            this.astroCoordSystem.visit(_visitor_);
        }
        if (_visitor_.visit(new IndirectCollectionProperty<>(STCRegionList.PropInfo.REGIONS, this))&&(this.regions!= null)) {
            for (JAXBElement<? extends RegionType> _item_: this.regions) {
                if (_item_!= null) {
                    _item_.getValue().visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends StcMetadataType.Builder<_B>
        implements Buildable
    {

        private AstroCoordSystemType.Builder<STCRegionList.Builder<_B>> astroCoordSystem;
        private List<Buildable> regions;

        public Builder(final _B _parentBuilder, final STCRegionList _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.astroCoordSystem = ((_other.astroCoordSystem == null)?null:_other.astroCoordSystem.newCopyBuilder(this));
                if (_other.regions == null) {
                    this.regions = null;
                } else {
                    this.regions = new ArrayList<>();
                    for (JAXBElement<? extends RegionType> _item: _other.regions) {
                        this.regions.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final STCRegionList _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree astroCoordSystemPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoordSystem"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordSystemPropertyTree!= null):((astroCoordSystemPropertyTree == null)||(!astroCoordSystemPropertyTree.isLeaf())))) {
                    this.astroCoordSystem = ((_other.astroCoordSystem == null)?null:_other.astroCoordSystem.newCopyBuilder(this, astroCoordSystemPropertyTree, _propertyTreeUse));
                }
                final PropertyTree regionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("regions"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(regionsPropertyTree!= null):((regionsPropertyTree == null)||(!regionsPropertyTree.isLeaf())))) {
                    if (_other.regions == null) {
                        this.regions = null;
                    } else {
                        this.regions = new ArrayList<>();
                        for (JAXBElement<? extends RegionType> _item: _other.regions) {
                            this.regions.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
            }
        }

        protected<_P extends STCRegionList >_P init(final _P _product) {
            _product.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.build());
            if (this.regions!= null) {
                final List<JAXBElement<? extends RegionType>> regions = new ArrayList<>(this.regions.size());
                for (Buildable _item: this.regions) {
                    regions.add(((JAXBElement<? extends RegionType> ) _item.build()));
                }
                _product.regions = regions;
            }
            return super.init(_product);
        }

        /**
         * Sets the new value of "astroCoordSystem" (any previous value will be replaced)
         * 
         * @param astroCoordSystem
         *     New value of the "astroCoordSystem" property.
         */
        public STCRegionList.Builder<_B> withAstroCoordSystem(final AstroCoordSystemType astroCoordSystem) {
            this.astroCoordSystem = ((astroCoordSystem == null)?null:new AstroCoordSystemType.Builder<>(this, astroCoordSystem, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "astroCoordSystem" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordSystemType.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "astroCoordSystem" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordSystemType.Builder#end()}
         *     to return to the current builder.
         */
        public AstroCoordSystemType.Builder<? extends STCRegionList.Builder<_B>> withAstroCoordSystem() {
            if (this.astroCoordSystem!= null) {
                return this.astroCoordSystem;
            }
            return this.astroCoordSystem = new AstroCoordSystemType.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "regions"
         * 
         * @param regions
         *     Items to add to the value of the "regions" property
         */
        public STCRegionList.Builder<_B> addRegions(final Iterable<? extends JAXBElement<? extends RegionType>> regions) {
            if (regions!= null) {
                if (this.regions == null) {
                    this.regions = new ArrayList<>();
                }
                for (JAXBElement<? extends RegionType> _item: regions) {
                    this.regions.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "regions" (any previous value will be replaced)
         * 
         * @param regions
         *     New value of the "regions" property.
         */
        public STCRegionList.Builder<_B> withRegions(final Iterable<? extends JAXBElement<? extends RegionType>> regions) {
            if (this.regions!= null) {
                this.regions.clear();
            }
            return addRegions(regions);
        }

        /**
         * Adds the given items to the value of "regions"
         * 
         * @param regions
         *     Items to add to the value of the "regions" property
         */
        public STCRegionList.Builder<_B> addRegions(JAXBElement<? extends RegionType> ... regions) {
            addRegions(Arrays.asList(regions));
            return this;
        }

        /**
         * Sets the new value of "regions" (any previous value will be replaced)
         * 
         * @param regions
         *     New value of the "regions" property.
         */
        public STCRegionList.Builder<_B> withRegions(JAXBElement<? extends RegionType> ... regions) {
            withRegions(Arrays.asList(regions));
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public STCRegionList.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public STCRegionList.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public STCRegionList.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public STCRegionList.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public STCRegionList.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public STCRegionList.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public STCRegionList.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public STCRegionList build() {
            if (_storedValue == null) {
                return this.init(new STCRegionList());
            } else {
                return ((STCRegionList) _storedValue);
            }
        }

        public STCRegionList.Builder<_B> copyOf(final STCRegionList _other) {
            _other.copyTo(this);
            return this;
        }

        public STCRegionList.Builder<_B> copyOf(final STCRegionList.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends StcMetadataType.Modifier
    {


        public void setAstroCoordSystem(final AstroCoordSystemType astroCoordSystem) {
            STCRegionList.this.setAstroCoordSystem(astroCoordSystem);
        }

        public List<JAXBElement<? extends RegionType>> getRegions() {
            if (STCRegionList.this.regions == null) {
                STCRegionList.this.regions = new ArrayList<>();
            }
            return STCRegionList.this.regions;
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<STCRegionList, AstroCoordSystemType> ASTRO_COORD_SYSTEM = new SinglePropertyInfo<STCRegionList,AstroCoordSystemType>("astroCoordSystem", STCRegionList.class, AstroCoordSystemType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "AstroCoordSystem"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroCoordSystemType"), false) {


            @Override
            public AstroCoordSystemType get(final STCRegionList _instance_) {
                return ((_instance_ == null)?null:_instance_.astroCoordSystem);
            }

            @Override
            public void set(final STCRegionList _instance_, final AstroCoordSystemType _value_) {
                if (_instance_!= null) {
                    _instance_.astroCoordSystem = _value_;
                }
            }

        }
        ;
        public static final transient IndirectCollectionPropertyInfo<STCRegionList, RegionType> REGIONS = new IndirectCollectionPropertyInfo<STCRegionList,RegionType>("regions", STCRegionList.class, RegionType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Region"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "regionType"), false) {


            @Override
            public List<JAXBElement<? extends RegionType>> get(final STCRegionList _instance_) {
                return ((_instance_ == null)?null:_instance_.regions);
            }

            @Override
            public void set(final STCRegionList _instance_, final List<JAXBElement<? extends RegionType>> _value_) {
                if (_instance_!= null) {
                    _instance_.regions = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends STCRegionList.Selector<STCRegionList.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static STCRegionList.Select _root() {
            return new STCRegionList.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends StcMetadataType.Selector<TRoot, TParent>
    {

        private AstroCoordSystemType.Selector<TRoot, STCRegionList.Selector<TRoot, TParent>> astroCoordSystem = null;
        private com.kscs.util.jaxb.Selector<TRoot, STCRegionList.Selector<TRoot, TParent>> regions = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.astroCoordSystem!= null) {
                products.put("astroCoordSystem", this.astroCoordSystem.init());
            }
            if (this.regions!= null) {
                products.put("regions", this.regions.init());
            }
            return products;
        }

        public AstroCoordSystemType.Selector<TRoot, STCRegionList.Selector<TRoot, TParent>> astroCoordSystem() {
            return ((this.astroCoordSystem == null)?this.astroCoordSystem = new AstroCoordSystemType.Selector<>(this._root, this, "astroCoordSystem"):this.astroCoordSystem);
        }

        public com.kscs.util.jaxb.Selector<TRoot, STCRegionList.Selector<TRoot, TParent>> regions() {
            return ((this.regions == null)?this.regions = new com.kscs.util.jaxb.Selector<>(this._root, this, "regions"):this.regions);
        }

    }

}
