
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A custom space reference frame type defined through pole and X-axis directions
 * 
 * <p>Java class for sphericalRefFrameType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="sphericalRefFrameType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}coordRefFrameType">
 *       <sequence>
 *         <element name="Frame" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="Pole_Zaxis" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}astroCoordsType"/>
 *         <element name="Xaxis" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}astroCoordsType"/>
 *       </sequence>
 *       <attribute name="id" type="{http://www.w3.org/2001/XMLSchema}ID" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "sphericalRefFrameType", propOrder = {
    "frame",
    "poleZaxis",
    "xaxis"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class SphericalRefFrameType
    extends CoordRefFrameType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(name = "Frame", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String frame;
    @XmlElement(name = "Pole_Zaxis", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected AstroCoordsType poleZaxis;
    @XmlElement(name = "Xaxis", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected AstroCoordsType xaxis;
    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String id;

    /**
     * Default no-arg constructor
     * 
     */
    public SphericalRefFrameType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SphericalRefFrameType(final String name, final Object refFrameId, final String frame, final AstroCoordsType poleZaxis, final AstroCoordsType xaxis, final String id) {
        super(name, refFrameId);
        this.frame = frame;
        this.poleZaxis = poleZaxis;
        this.xaxis = xaxis;
        this.id = id;
    }

    /**
     * Gets the value of the frame property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getFrame() {
        return frame;
    }

    /**
     * Sets the value of the frame property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setFrame(String value) {
        this.frame = value;
    }

    /**
     * Gets the value of the poleZaxis property.
     * 
     * @return
     *     possible object is
     *     {@link AstroCoordsType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordsType getPoleZaxis() {
        return poleZaxis;
    }

    /**
     * Sets the value of the poleZaxis property.
     * 
     * @param value
     *     allowed object is
     *     {@link AstroCoordsType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setPoleZaxis(AstroCoordsType value) {
        this.poleZaxis = value;
    }

    /**
     * Gets the value of the xaxis property.
     * 
     * @return
     *     possible object is
     *     {@link AstroCoordsType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordsType getXaxis() {
        return xaxis;
    }

    /**
     * Sets the value of the xaxis property.
     * 
     * @param value
     *     allowed object is
     *     {@link AstroCoordsType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setXaxis(AstroCoordsType value) {
        this.xaxis = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setId(String value) {
        this.id = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final SphericalRefFrameType that = ((SphericalRefFrameType) object);
        {
            String leftFrame;
            leftFrame = this.getFrame();
            String rightFrame;
            rightFrame = that.getFrame();
            if (this.frame!= null) {
                if (that.frame!= null) {
                    if (!leftFrame.equals(rightFrame)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.frame!= null) {
                    return false;
                }
            }
        }
        {
            AstroCoordsType leftPoleZaxis;
            leftPoleZaxis = this.getPoleZaxis();
            AstroCoordsType rightPoleZaxis;
            rightPoleZaxis = that.getPoleZaxis();
            if (this.poleZaxis!= null) {
                if (that.poleZaxis!= null) {
                    if (!leftPoleZaxis.equals(rightPoleZaxis)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.poleZaxis!= null) {
                    return false;
                }
            }
        }
        {
            AstroCoordsType leftXaxis;
            leftXaxis = this.getXaxis();
            AstroCoordsType rightXaxis;
            rightXaxis = that.getXaxis();
            if (this.xaxis!= null) {
                if (that.xaxis!= null) {
                    if (!leftXaxis.equals(rightXaxis)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.xaxis!= null) {
                    return false;
                }
            }
        }
        {
            String leftId;
            leftId = this.getId();
            String rightId;
            rightId = that.getId();
            if (this.id!= null) {
                if (that.id!= null) {
                    if (!leftId.equals(rightId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.id!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            String theFrame;
            theFrame = this.getFrame();
            if (this.frame!= null) {
                currentHashCode += theFrame.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            AstroCoordsType thePoleZaxis;
            thePoleZaxis = this.getPoleZaxis();
            if (this.poleZaxis!= null) {
                currentHashCode += thePoleZaxis.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            AstroCoordsType theXaxis;
            theXaxis = this.getXaxis();
            if (this.xaxis!= null) {
                currentHashCode += theXaxis.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theId;
            theId = this.getId();
            if (this.id!= null) {
                currentHashCode += theId.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            String theFrame;
            theFrame = this.getFrame();
            strategy.appendField(locator, this, "frame", buffer, theFrame, (this.frame!= null));
        }
        {
            AstroCoordsType thePoleZaxis;
            thePoleZaxis = this.getPoleZaxis();
            strategy.appendField(locator, this, "poleZaxis", buffer, thePoleZaxis, (this.poleZaxis!= null));
        }
        {
            AstroCoordsType theXaxis;
            theXaxis = this.getXaxis();
            strategy.appendField(locator, this, "xaxis", buffer, theXaxis, (this.xaxis!= null));
        }
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId, (this.id!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof SphericalRefFrameType) {
            final SphericalRefFrameType target = this;
            final SphericalRefFrameType leftObject = ((SphericalRefFrameType) left);
            final SphericalRefFrameType rightObject = ((SphericalRefFrameType) right);
            {
                Boolean frameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.frame!= null), (rightObject.frame!= null));
                if (frameShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsFrame;
                    lhsFrame = leftObject.getFrame();
                    String rhsFrame;
                    rhsFrame = rightObject.getFrame();
                    String mergedFrame = ((String) strategy.merge(LocatorUtils.property(leftLocator, "frame", lhsFrame), LocatorUtils.property(rightLocator, "frame", rhsFrame), lhsFrame, rhsFrame, (leftObject.frame!= null), (rightObject.frame!= null)));
                    target.setFrame(mergedFrame);
                } else {
                    if (frameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.frame = null;
                    }
                }
            }
            {
                Boolean poleZaxisShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.poleZaxis!= null), (rightObject.poleZaxis!= null));
                if (poleZaxisShouldBeMergedAndSet == Boolean.TRUE) {
                    AstroCoordsType lhsPoleZaxis;
                    lhsPoleZaxis = leftObject.getPoleZaxis();
                    AstroCoordsType rhsPoleZaxis;
                    rhsPoleZaxis = rightObject.getPoleZaxis();
                    AstroCoordsType mergedPoleZaxis = ((AstroCoordsType) strategy.merge(LocatorUtils.property(leftLocator, "poleZaxis", lhsPoleZaxis), LocatorUtils.property(rightLocator, "poleZaxis", rhsPoleZaxis), lhsPoleZaxis, rhsPoleZaxis, (leftObject.poleZaxis!= null), (rightObject.poleZaxis!= null)));
                    target.setPoleZaxis(mergedPoleZaxis);
                } else {
                    if (poleZaxisShouldBeMergedAndSet == Boolean.FALSE) {
                        target.poleZaxis = null;
                    }
                }
            }
            {
                Boolean xaxisShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.xaxis!= null), (rightObject.xaxis!= null));
                if (xaxisShouldBeMergedAndSet == Boolean.TRUE) {
                    AstroCoordsType lhsXaxis;
                    lhsXaxis = leftObject.getXaxis();
                    AstroCoordsType rhsXaxis;
                    rhsXaxis = rightObject.getXaxis();
                    AstroCoordsType mergedXaxis = ((AstroCoordsType) strategy.merge(LocatorUtils.property(leftLocator, "xaxis", lhsXaxis), LocatorUtils.property(rightLocator, "xaxis", rhsXaxis), lhsXaxis, rhsXaxis, (leftObject.xaxis!= null), (rightObject.xaxis!= null)));
                    target.setXaxis(mergedXaxis);
                } else {
                    if (xaxisShouldBeMergedAndSet == Boolean.FALSE) {
                        target.xaxis = null;
                    }
                }
            }
            {
                Boolean idShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.id!= null), (rightObject.id!= null));
                if (idShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsId;
                    lhsId = leftObject.getId();
                    String rhsId;
                    rhsId = rightObject.getId();
                    String mergedId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "id", lhsId), LocatorUtils.property(rightLocator, "id", rhsId), lhsId, rhsId, (leftObject.id!= null), (rightObject.id!= null)));
                    target.setId(mergedId);
                } else {
                    if (idShouldBeMergedAndSet == Boolean.FALSE) {
                        target.id = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new SphericalRefFrameType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SphericalRefFrameType clone() {
        final SphericalRefFrameType _newObject;
        _newObject = ((SphericalRefFrameType) super.clone());
        _newObject.poleZaxis = ((this.poleZaxis == null)?null:this.poleZaxis.clone());
        _newObject.xaxis = ((this.xaxis == null)?null:this.xaxis.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SphericalRefFrameType createCopy() {
        final SphericalRefFrameType _newObject = ((SphericalRefFrameType) super.createCopy());
        _newObject.frame = this.frame;
        _newObject.poleZaxis = ((this.poleZaxis == null)?null:this.poleZaxis.createCopy());
        _newObject.xaxis = ((this.xaxis == null)?null:this.xaxis.createCopy());
        _newObject.id = this.id;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SphericalRefFrameType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SphericalRefFrameType _newObject = ((SphericalRefFrameType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree framePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("frame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(framePropertyTree!= null):((framePropertyTree == null)||(!framePropertyTree.isLeaf())))) {
            _newObject.frame = this.frame;
        }
        final PropertyTree poleZaxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("poleZaxis"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(poleZaxisPropertyTree!= null):((poleZaxisPropertyTree == null)||(!poleZaxisPropertyTree.isLeaf())))) {
            _newObject.poleZaxis = ((this.poleZaxis == null)?null:this.poleZaxis.createCopy(poleZaxisPropertyTree, _propertyTreeUse));
        }
        final PropertyTree xaxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("xaxis"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(xaxisPropertyTree!= null):((xaxisPropertyTree == null)||(!xaxisPropertyTree.isLeaf())))) {
            _newObject.xaxis = ((this.xaxis == null)?null:this.xaxis.createCopy(xaxisPropertyTree, _propertyTreeUse));
        }
        final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
            _newObject.id = this.id;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SphericalRefFrameType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SphericalRefFrameType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SphericalRefFrameType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SphericalRefFrameType.Modifier();
        }
        return ((SphericalRefFrameType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final SphericalRefFrameType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.frame = this.frame;
        _other.poleZaxis = ((this.poleZaxis == null)?null:this.poleZaxis.newCopyBuilder(_other));
        _other.xaxis = ((this.xaxis == null)?null:this.xaxis.newCopyBuilder(_other));
        _other.id = this.id;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >SphericalRefFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SphericalRefFrameType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SphericalRefFrameType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static SphericalRefFrameType.Builder<Void> builder() {
        return new SphericalRefFrameType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >SphericalRefFrameType.Builder<_B> copyOf(final CoordRefFrameType _other) {
        final SphericalRefFrameType.Builder<_B> _newBuilder = new SphericalRefFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >SphericalRefFrameType.Builder<_B> copyOf(final SphericalRefFrameType _other) {
        final SphericalRefFrameType.Builder<_B> _newBuilder = new SphericalRefFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final SphericalRefFrameType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree framePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("frame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(framePropertyTree!= null):((framePropertyTree == null)||(!framePropertyTree.isLeaf())))) {
            _other.frame = this.frame;
        }
        final PropertyTree poleZaxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("poleZaxis"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(poleZaxisPropertyTree!= null):((poleZaxisPropertyTree == null)||(!poleZaxisPropertyTree.isLeaf())))) {
            _other.poleZaxis = ((this.poleZaxis == null)?null:this.poleZaxis.newCopyBuilder(_other, poleZaxisPropertyTree, _propertyTreeUse));
        }
        final PropertyTree xaxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("xaxis"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(xaxisPropertyTree!= null):((xaxisPropertyTree == null)||(!xaxisPropertyTree.isLeaf())))) {
            _other.xaxis = ((this.xaxis == null)?null:this.xaxis.newCopyBuilder(_other, xaxisPropertyTree, _propertyTreeUse));
        }
        final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
            _other.id = this.id;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >SphericalRefFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SphericalRefFrameType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SphericalRefFrameType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >SphericalRefFrameType.Builder<_B> copyOf(final CoordRefFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SphericalRefFrameType.Builder<_B> _newBuilder = new SphericalRefFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >SphericalRefFrameType.Builder<_B> copyOf(final SphericalRefFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SphericalRefFrameType.Builder<_B> _newBuilder = new SphericalRefFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static SphericalRefFrameType.Builder<Void> copyExcept(final CoordRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static SphericalRefFrameType.Builder<Void> copyExcept(final SphericalRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static SphericalRefFrameType.Builder<Void> copyOnly(final CoordRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static SphericalRefFrameType.Builder<Void> copyOnly(final SphericalRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SphericalRefFrameType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(SphericalRefFrameType.PropInfo.FRAME, this));
        if (_visitor_.visit(new SingleProperty<>(SphericalRefFrameType.PropInfo.POLE_ZAXIS, this))&&(this.poleZaxis!= null)) {
            this.poleZaxis.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(SphericalRefFrameType.PropInfo.XAXIS, this))&&(this.xaxis!= null)) {
            this.xaxis.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(SphericalRefFrameType.PropInfo.ID, this));
        return this;
    }

    public static class Builder<_B >
        extends CoordRefFrameType.Builder<_B>
        implements Buildable
    {

        private String frame;
        private AstroCoordsType.Builder<SphericalRefFrameType.Builder<_B>> poleZaxis;
        private AstroCoordsType.Builder<SphericalRefFrameType.Builder<_B>> xaxis;
        private String id;

        public Builder(final _B _parentBuilder, final SphericalRefFrameType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.frame = _other.frame;
                this.poleZaxis = ((_other.poleZaxis == null)?null:_other.poleZaxis.newCopyBuilder(this));
                this.xaxis = ((_other.xaxis == null)?null:_other.xaxis.newCopyBuilder(this));
                this.id = _other.id;
            }
        }

        public Builder(final _B _parentBuilder, final SphericalRefFrameType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree framePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("frame"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(framePropertyTree!= null):((framePropertyTree == null)||(!framePropertyTree.isLeaf())))) {
                    this.frame = _other.frame;
                }
                final PropertyTree poleZaxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("poleZaxis"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(poleZaxisPropertyTree!= null):((poleZaxisPropertyTree == null)||(!poleZaxisPropertyTree.isLeaf())))) {
                    this.poleZaxis = ((_other.poleZaxis == null)?null:_other.poleZaxis.newCopyBuilder(this, poleZaxisPropertyTree, _propertyTreeUse));
                }
                final PropertyTree xaxisPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("xaxis"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(xaxisPropertyTree!= null):((xaxisPropertyTree == null)||(!xaxisPropertyTree.isLeaf())))) {
                    this.xaxis = ((_other.xaxis == null)?null:_other.xaxis.newCopyBuilder(this, xaxisPropertyTree, _propertyTreeUse));
                }
                final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
                    this.id = _other.id;
                }
            }
        }

        protected<_P extends SphericalRefFrameType >_P init(final _P _product) {
            _product.frame = this.frame;
            _product.poleZaxis = ((this.poleZaxis == null)?null:this.poleZaxis.build());
            _product.xaxis = ((this.xaxis == null)?null:this.xaxis.build());
            _product.id = this.id;
            return super.init(_product);
        }

        /**
         * Sets the new value of "frame" (any previous value will be replaced)
         * 
         * @param frame
         *     New value of the "frame" property.
         */
        public SphericalRefFrameType.Builder<_B> withFrame(final String frame) {
            this.frame = frame;
            return this;
        }

        /**
         * Sets the new value of "poleZaxis" (any previous value will be replaced)
         * 
         * @param poleZaxis
         *     New value of the "poleZaxis" property.
         */
        public SphericalRefFrameType.Builder<_B> withPoleZaxis(final AstroCoordsType poleZaxis) {
            this.poleZaxis = ((poleZaxis == null)?null:new AstroCoordsType.Builder<>(this, poleZaxis, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "poleZaxis" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordsType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "poleZaxis" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordsType.Builder#end()} to
         *     return to the current builder.
         */
        public AstroCoordsType.Builder<? extends SphericalRefFrameType.Builder<_B>> withPoleZaxis() {
            if (this.poleZaxis!= null) {
                return this.poleZaxis;
            }
            return this.poleZaxis = new AstroCoordsType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "xaxis" (any previous value will be replaced)
         * 
         * @param xaxis
         *     New value of the "xaxis" property.
         */
        public SphericalRefFrameType.Builder<_B> withXaxis(final AstroCoordsType xaxis) {
            this.xaxis = ((xaxis == null)?null:new AstroCoordsType.Builder<>(this, xaxis, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "xaxis"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordsType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "xaxis" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordsType.Builder#end()} to
         *     return to the current builder.
         */
        public AstroCoordsType.Builder<? extends SphericalRefFrameType.Builder<_B>> withXaxis() {
            if (this.xaxis!= null) {
                return this.xaxis;
            }
            return this.xaxis = new AstroCoordsType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        public SphericalRefFrameType.Builder<_B> withId(final String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        @Override
        public SphericalRefFrameType.Builder<_B> withName(final String name) {
            super.withName(name);
            return this;
        }

        /**
         * Sets the new value of "refFrameId" (any previous value will be replaced)
         * 
         * @param refFrameId
         *     New value of the "refFrameId" property.
         */
        @Override
        public SphericalRefFrameType.Builder<_B> withRefFrameId(final Object refFrameId) {
            super.withRefFrameId(refFrameId);
            return this;
        }

        @Override
        public SphericalRefFrameType build() {
            if (_storedValue == null) {
                return this.init(new SphericalRefFrameType());
            } else {
                return ((SphericalRefFrameType) _storedValue);
            }
        }

        public SphericalRefFrameType.Builder<_B> copyOf(final SphericalRefFrameType _other) {
            _other.copyTo(this);
            return this;
        }

        public SphericalRefFrameType.Builder<_B> copyOf(final SphericalRefFrameType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends CoordRefFrameType.Modifier
    {


        public void setFrame(final String frame) {
            SphericalRefFrameType.this.setFrame(frame);
        }

        public void setPoleZaxis(final AstroCoordsType poleZaxis) {
            SphericalRefFrameType.this.setPoleZaxis(poleZaxis);
        }

        public void setXaxis(final AstroCoordsType xaxis) {
            SphericalRefFrameType.this.setXaxis(xaxis);
        }

        public void setId(final String id) {
            SphericalRefFrameType.this.setId(id);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<SphericalRefFrameType, String> FRAME = new SinglePropertyInfo<SphericalRefFrameType,String>("frame", SphericalRefFrameType.class, String.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Frame"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final SphericalRefFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.frame);
            }

            @Override
            public void set(final SphericalRefFrameType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.frame = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SphericalRefFrameType, AstroCoordsType> POLE_ZAXIS = new SinglePropertyInfo<SphericalRefFrameType,AstroCoordsType>("poleZaxis", SphericalRefFrameType.class, AstroCoordsType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Pole_Zaxis"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroCoordsType"), false) {


            @Override
            public AstroCoordsType get(final SphericalRefFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.poleZaxis);
            }

            @Override
            public void set(final SphericalRefFrameType _instance_, final AstroCoordsType _value_) {
                if (_instance_!= null) {
                    _instance_.poleZaxis = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SphericalRefFrameType, AstroCoordsType> XAXIS = new SinglePropertyInfo<SphericalRefFrameType,AstroCoordsType>("xaxis", SphericalRefFrameType.class, AstroCoordsType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Xaxis"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroCoordsType"), false) {


            @Override
            public AstroCoordsType get(final SphericalRefFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.xaxis);
            }

            @Override
            public void set(final SphericalRefFrameType _instance_, final AstroCoordsType _value_) {
                if (_instance_!= null) {
                    _instance_.xaxis = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SphericalRefFrameType, String> ID = new SinglePropertyInfo<SphericalRefFrameType,String>("id", SphericalRefFrameType.class, String.class, false, null, new QName("", "id"), new QName("http://www.w3.org/2001/XMLSchema", "ID"), true) {


            @Override
            public String get(final SphericalRefFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.id);
            }

            @Override
            public void set(final SphericalRefFrameType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.id = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends SphericalRefFrameType.Selector<SphericalRefFrameType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SphericalRefFrameType.Select _root() {
            return new SphericalRefFrameType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends CoordRefFrameType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, SphericalRefFrameType.Selector<TRoot, TParent>> frame = null;
        private AstroCoordsType.Selector<TRoot, SphericalRefFrameType.Selector<TRoot, TParent>> poleZaxis = null;
        private AstroCoordsType.Selector<TRoot, SphericalRefFrameType.Selector<TRoot, TParent>> xaxis = null;
        private com.kscs.util.jaxb.Selector<TRoot, SphericalRefFrameType.Selector<TRoot, TParent>> id = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.frame!= null) {
                products.put("frame", this.frame.init());
            }
            if (this.poleZaxis!= null) {
                products.put("poleZaxis", this.poleZaxis.init());
            }
            if (this.xaxis!= null) {
                products.put("xaxis", this.xaxis.init());
            }
            if (this.id!= null) {
                products.put("id", this.id.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, SphericalRefFrameType.Selector<TRoot, TParent>> frame() {
            return ((this.frame == null)?this.frame = new com.kscs.util.jaxb.Selector<>(this._root, this, "frame"):this.frame);
        }

        public AstroCoordsType.Selector<TRoot, SphericalRefFrameType.Selector<TRoot, TParent>> poleZaxis() {
            return ((this.poleZaxis == null)?this.poleZaxis = new AstroCoordsType.Selector<>(this._root, this, "poleZaxis"):this.poleZaxis);
        }

        public AstroCoordsType.Selector<TRoot, SphericalRefFrameType.Selector<TRoot, TParent>> xaxis() {
            return ((this.xaxis == null)?this.xaxis = new AstroCoordsType.Selector<>(this._root, this, "xaxis"):this.xaxis);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SphericalRefFrameType.Selector<TRoot, TParent>> id() {
            return ((this.id == null)?this.id = new com.kscs.util.jaxb.Selector<>(this._root, this, "id"):this.id);
        }

    }

}
