
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * The time reference frame consists of a timescale, a reference position, and optionally a reference direction (needed when transformations have been applied)
 * 
 * <p>Java class for timeFrameType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="timeFrameType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}coordFrameType">
 *       <sequence>
 *         <element name="TimeScale" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}timeScaleType"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}ReferencePosition"/>
 *         <element name="TimeRefDirection" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}astroCoordsType" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "timeFrameType", propOrder = {
    "timeScale",
    "referencePosition",
    "timeRefDirection"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class TimeFrameType
    extends CoordFrameType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The time reference frame consists of a time scale, a time format, and a reference time, if needed
     * 
     */
    @XmlElement(name = "TimeScale", required = true, defaultValue = "TT", nillable = true)
    @XmlSchemaType(name = "string")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected TimeScaleType timeScale = TimeScaleType.TT;
    /**
     * Origin of the coordinate reference frame: either a "known place" such as geocenter or barycenter, or a position defined in a known coordinate system
     * 
     */
    @XmlElementRef(name = "ReferencePosition", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected JAXBElement<? extends ReferencePositionType> referencePosition;
    /**
     * Some time transformations (e.g., change of RefPos) depend on an assumed directonal position of the source
     * 
     */
    @XmlElement(name = "TimeRefDirection")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected AstroCoordsType timeRefDirection;

    /**
     * Default no-arg constructor
     * 
     */
    public TimeFrameType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public TimeFrameType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final String name, final TimeScaleType timeScale, final JAXBElement<? extends ReferencePositionType> referencePosition, final AstroCoordsType timeRefDirection) {
        super(id, idref, ucd, type, href, idType, idrefType, name);
        this.timeScale = timeScale;
        this.referencePosition = referencePosition;
        this.timeRefDirection = timeRefDirection;
    }

    /**
     * The time reference frame consists of a time scale, a time format, and a reference time, if needed
     * 
     * @return
     *     possible object is
     *     {@link TimeScaleType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeScaleType getTimeScale() {
        return timeScale;
    }

    /**
     * Sets the value of the timeScale property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeScaleType }
     *     
     * @see #getTimeScale()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setTimeScale(TimeScaleType value) {
        this.timeScale = value;
    }

    /**
     * Origin of the coordinate reference frame: either a "known place" such as geocenter or barycenter, or a position defined in a known coordinate system
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link CustomRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ReferencePositionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public JAXBElement<? extends ReferencePositionType> getReferencePosition() {
        return referencePosition;
    }

    /**
     * Sets the value of the referencePosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link CustomRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ReferencePositionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     
     * @see #getReferencePosition()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setReferencePosition(JAXBElement<? extends ReferencePositionType> value) {
        this.referencePosition = value;
    }

    /**
     * Some time transformations (e.g., change of RefPos) depend on an assumed directonal position of the source
     * 
     * @return
     *     possible object is
     *     {@link AstroCoordsType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordsType getTimeRefDirection() {
        return timeRefDirection;
    }

    /**
     * Sets the value of the timeRefDirection property.
     * 
     * @param value
     *     allowed object is
     *     {@link AstroCoordsType }
     *     
     * @see #getTimeRefDirection()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setTimeRefDirection(AstroCoordsType value) {
        this.timeRefDirection = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final TimeFrameType that = ((TimeFrameType) object);
        {
            TimeScaleType leftTimeScale;
            leftTimeScale = this.getTimeScale();
            TimeScaleType rightTimeScale;
            rightTimeScale = that.getTimeScale();
            if (this.timeScale!= null) {
                if (that.timeScale!= null) {
                    if (!leftTimeScale.equals(rightTimeScale)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.timeScale!= null) {
                    return false;
                }
            }
        }
        {
            JAXBElement<? extends ReferencePositionType> leftReferencePosition;
            leftReferencePosition = this.getReferencePosition();
            JAXBElement<? extends ReferencePositionType> rightReferencePosition;
            rightReferencePosition = that.getReferencePosition();
            if (this.referencePosition!= null) {
                if (that.referencePosition!= null) {
                    {
                        final QName leftReferencePositionName = leftReferencePosition.getName();
                        final QName rightReferencePositionName = rightReferencePosition.getName();
                        if (leftReferencePositionName!= null) {
                            if (rightReferencePositionName!= null) {
                                if (!leftReferencePositionName.equals(rightReferencePositionName)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionName!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final ReferencePositionType leftReferencePositionValue = leftReferencePosition.getValue();
                        final ReferencePositionType rightReferencePositionValue = rightReferencePosition.getValue();
                        if (leftReferencePositionValue!= null) {
                            if (rightReferencePositionValue!= null) {
                                if (!leftReferencePositionValue.equals(rightReferencePositionValue)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionValue!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<? extends ReferencePositionType> leftReferencePositionDeclaredType = leftReferencePosition.getDeclaredType();
                        final Class<? extends ReferencePositionType> rightReferencePositionDeclaredType = rightReferencePosition.getDeclaredType();
                        if (leftReferencePositionDeclaredType!= null) {
                            if (rightReferencePositionDeclaredType!= null) {
                                if (!leftReferencePositionDeclaredType.equals(rightReferencePositionDeclaredType)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionDeclaredType!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<?> leftReferencePositionScope = leftReferencePosition.getScope();
                        final Class<?> rightReferencePositionScope = rightReferencePosition.getScope();
                        if (leftReferencePositionScope!= null) {
                            if (rightReferencePositionScope!= null) {
                                if (!leftReferencePositionScope.equals(rightReferencePositionScope)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionScope!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final boolean leftReferencePositionNil = leftReferencePosition.isNil();
                        final boolean rightReferencePositionNil = rightReferencePosition.isNil();
                        if (leftReferencePositionNil!= rightReferencePositionNil) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
            } else {
                if (that.referencePosition!= null) {
                    return false;
                }
            }
        }
        {
            AstroCoordsType leftTimeRefDirection;
            leftTimeRefDirection = this.getTimeRefDirection();
            AstroCoordsType rightTimeRefDirection;
            rightTimeRefDirection = that.getTimeRefDirection();
            if (this.timeRefDirection!= null) {
                if (that.timeRefDirection!= null) {
                    if (!leftTimeRefDirection.equals(rightTimeRefDirection)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.timeRefDirection!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            TimeScaleType theTimeScale;
            theTimeScale = this.getTimeScale();
            if (this.timeScale!= null) {
                currentHashCode += theTimeScale.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            JAXBElement<? extends ReferencePositionType> theReferencePosition;
            theReferencePosition = this.getReferencePosition();
            if (this.referencePosition!= null) {
                {
                    currentHashCode = (currentHashCode* 31);
                    final QName theReferencePositionName = theReferencePosition.getName();
                    if (theReferencePositionName!= null) {
                        currentHashCode += theReferencePositionName.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final ReferencePositionType theReferencePositionValue = theReferencePosition.getValue();
                    if (theReferencePositionValue!= null) {
                        currentHashCode += theReferencePositionValue.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<? extends ReferencePositionType> theReferencePositionDeclaredType = theReferencePosition.getDeclaredType();
                    if (theReferencePositionDeclaredType!= null) {
                        currentHashCode += theReferencePositionDeclaredType.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<?> theReferencePositionScope = theReferencePosition.getScope();
                    if (theReferencePositionScope!= null) {
                        currentHashCode += theReferencePositionScope.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final boolean theReferencePositionNil = theReferencePosition.isNil();
                    currentHashCode += (theReferencePositionNil? 1231 : 1237);
                }
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            AstroCoordsType theTimeRefDirection;
            theTimeRefDirection = this.getTimeRefDirection();
            if (this.timeRefDirection!= null) {
                currentHashCode += theTimeRefDirection.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            TimeScaleType theTimeScale;
            theTimeScale = this.getTimeScale();
            strategy.appendField(locator, this, "timeScale", buffer, theTimeScale, (this.timeScale!= null));
        }
        {
            JAXBElement<? extends ReferencePositionType> theReferencePosition;
            theReferencePosition = this.getReferencePosition();
            strategy.appendField(locator, this, "referencePosition", buffer, theReferencePosition, (this.referencePosition!= null));
        }
        {
            AstroCoordsType theTimeRefDirection;
            theTimeRefDirection = this.getTimeRefDirection();
            strategy.appendField(locator, this, "timeRefDirection", buffer, theTimeRefDirection, (this.timeRefDirection!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof TimeFrameType) {
            final TimeFrameType target = this;
            final TimeFrameType leftObject = ((TimeFrameType) left);
            final TimeFrameType rightObject = ((TimeFrameType) right);
            {
                Boolean timeScaleShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.timeScale!= null), (rightObject.timeScale!= null));
                if (timeScaleShouldBeMergedAndSet == Boolean.TRUE) {
                    TimeScaleType lhsTimeScale;
                    lhsTimeScale = leftObject.getTimeScale();
                    TimeScaleType rhsTimeScale;
                    rhsTimeScale = rightObject.getTimeScale();
                    TimeScaleType mergedTimeScale = ((TimeScaleType) strategy.merge(LocatorUtils.property(leftLocator, "timeScale", lhsTimeScale), LocatorUtils.property(rightLocator, "timeScale", rhsTimeScale), lhsTimeScale, rhsTimeScale, (leftObject.timeScale!= null), (rightObject.timeScale!= null)));
                    target.setTimeScale(mergedTimeScale);
                } else {
                    if (timeScaleShouldBeMergedAndSet == Boolean.FALSE) {
                        target.timeScale = null;
                    }
                }
            }
            {
                Boolean referencePositionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.referencePosition!= null), (rightObject.referencePosition!= null));
                if (referencePositionShouldBeMergedAndSet == Boolean.TRUE) {
                    JAXBElement<? extends ReferencePositionType> lhsReferencePosition;
                    lhsReferencePosition = leftObject.getReferencePosition();
                    JAXBElement<? extends ReferencePositionType> rhsReferencePosition;
                    rhsReferencePosition = rightObject.getReferencePosition();
                    JAXBElement<? extends ReferencePositionType> mergedReferencePosition = ((JAXBElement<? extends ReferencePositionType> ) strategy.merge(LocatorUtils.property(leftLocator, "referencePosition", lhsReferencePosition), LocatorUtils.property(rightLocator, "referencePosition", rhsReferencePosition), lhsReferencePosition, rhsReferencePosition, (leftObject.referencePosition!= null), (rightObject.referencePosition!= null)));
                    target.setReferencePosition(mergedReferencePosition);
                } else {
                    if (referencePositionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.referencePosition = null;
                    }
                }
            }
            {
                Boolean timeRefDirectionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.timeRefDirection!= null), (rightObject.timeRefDirection!= null));
                if (timeRefDirectionShouldBeMergedAndSet == Boolean.TRUE) {
                    AstroCoordsType lhsTimeRefDirection;
                    lhsTimeRefDirection = leftObject.getTimeRefDirection();
                    AstroCoordsType rhsTimeRefDirection;
                    rhsTimeRefDirection = rightObject.getTimeRefDirection();
                    AstroCoordsType mergedTimeRefDirection = ((AstroCoordsType) strategy.merge(LocatorUtils.property(leftLocator, "timeRefDirection", lhsTimeRefDirection), LocatorUtils.property(rightLocator, "timeRefDirection", rhsTimeRefDirection), lhsTimeRefDirection, rhsTimeRefDirection, (leftObject.timeRefDirection!= null), (rightObject.timeRefDirection!= null)));
                    target.setTimeRefDirection(mergedTimeRefDirection);
                } else {
                    if (timeRefDirectionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.timeRefDirection = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new TimeFrameType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeFrameType clone() {
        final TimeFrameType _newObject;
        _newObject = ((TimeFrameType) super.clone());
        _newObject.timeRefDirection = ((this.timeRefDirection == null)?null:this.timeRefDirection.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeFrameType createCopy() {
        final TimeFrameType _newObject = ((TimeFrameType) super.createCopy());
        _newObject.timeScale = this.timeScale;
        _newObject.referencePosition = this.referencePosition;
        _newObject.timeRefDirection = ((this.timeRefDirection == null)?null:this.timeRefDirection.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeFrameType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final TimeFrameType _newObject = ((TimeFrameType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree timeScalePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeScale"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeScalePropertyTree!= null):((timeScalePropertyTree == null)||(!timeScalePropertyTree.isLeaf())))) {
            _newObject.timeScale = this.timeScale;
        }
        final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
            _newObject.referencePosition = this.referencePosition;
        }
        final PropertyTree timeRefDirectionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeRefDirection"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeRefDirectionPropertyTree!= null):((timeRefDirectionPropertyTree == null)||(!timeRefDirectionPropertyTree.isLeaf())))) {
            _newObject.timeRefDirection = ((this.timeRefDirection == null)?null:this.timeRefDirection.createCopy(timeRefDirectionPropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeFrameType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeFrameType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeFrameType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new TimeFrameType.Modifier();
        }
        return ((TimeFrameType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final TimeFrameType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.timeScale = this.timeScale;
        _other.referencePosition = this.referencePosition;
        _other.timeRefDirection = ((this.timeRefDirection == null)?null:this.timeRefDirection.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >TimeFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new TimeFrameType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeFrameType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TimeFrameType.Builder<Void> builder() {
        return new TimeFrameType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >TimeFrameType.Builder<_B> copyOf(final StcBaseType _other) {
        final TimeFrameType.Builder<_B> _newBuilder = new TimeFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >TimeFrameType.Builder<_B> copyOf(final CoordFrameType _other) {
        final TimeFrameType.Builder<_B> _newBuilder = new TimeFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >TimeFrameType.Builder<_B> copyOf(final TimeFrameType _other) {
        final TimeFrameType.Builder<_B> _newBuilder = new TimeFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final TimeFrameType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree timeScalePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeScale"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeScalePropertyTree!= null):((timeScalePropertyTree == null)||(!timeScalePropertyTree.isLeaf())))) {
            _other.timeScale = this.timeScale;
        }
        final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
            _other.referencePosition = this.referencePosition;
        }
        final PropertyTree timeRefDirectionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeRefDirection"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeRefDirectionPropertyTree!= null):((timeRefDirectionPropertyTree == null)||(!timeRefDirectionPropertyTree.isLeaf())))) {
            _other.timeRefDirection = ((this.timeRefDirection == null)?null:this.timeRefDirection.newCopyBuilder(_other, timeRefDirectionPropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >TimeFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new TimeFrameType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeFrameType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >TimeFrameType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final TimeFrameType.Builder<_B> _newBuilder = new TimeFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >TimeFrameType.Builder<_B> copyOf(final CoordFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final TimeFrameType.Builder<_B> _newBuilder = new TimeFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >TimeFrameType.Builder<_B> copyOf(final TimeFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final TimeFrameType.Builder<_B> _newBuilder = new TimeFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TimeFrameType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TimeFrameType.Builder<Void> copyExcept(final CoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TimeFrameType.Builder<Void> copyExcept(final TimeFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TimeFrameType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TimeFrameType.Builder<Void> copyOnly(final CoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TimeFrameType.Builder<Void> copyOnly(final TimeFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeFrameType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(TimeFrameType.PropInfo.TIME_SCALE, this));
        if (_visitor_.visit(new SingleProperty<>(TimeFrameType.PropInfo.REFERENCE_POSITION, this))&&(this.referencePosition!= null)) {
            this.referencePosition.getValue().visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(TimeFrameType.PropInfo.TIME_REF_DIRECTION, this))&&(this.timeRefDirection!= null)) {
            this.timeRefDirection.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends CoordFrameType.Builder<_B>
        implements Buildable
    {

        private TimeScaleType timeScale;
        private JAXBElement<? extends ReferencePositionType> referencePosition;
        private AstroCoordsType.Builder<TimeFrameType.Builder<_B>> timeRefDirection;

        public Builder(final _B _parentBuilder, final TimeFrameType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.timeScale = _other.timeScale;
                this.referencePosition = _other.referencePosition;
                this.timeRefDirection = ((_other.timeRefDirection == null)?null:_other.timeRefDirection.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final TimeFrameType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree timeScalePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeScale"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeScalePropertyTree!= null):((timeScalePropertyTree == null)||(!timeScalePropertyTree.isLeaf())))) {
                    this.timeScale = _other.timeScale;
                }
                final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
                    this.referencePosition = _other.referencePosition;
                }
                final PropertyTree timeRefDirectionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeRefDirection"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeRefDirectionPropertyTree!= null):((timeRefDirectionPropertyTree == null)||(!timeRefDirectionPropertyTree.isLeaf())))) {
                    this.timeRefDirection = ((_other.timeRefDirection == null)?null:_other.timeRefDirection.newCopyBuilder(this, timeRefDirectionPropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends TimeFrameType >_P init(final _P _product) {
            _product.timeScale = this.timeScale;
            _product.referencePosition = this.referencePosition;
            _product.timeRefDirection = ((this.timeRefDirection == null)?null:this.timeRefDirection.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "timeScale" (any previous value will be replaced)
         * 
         * @param timeScale
         *     New value of the "timeScale" property.
         */
        public TimeFrameType.Builder<_B> withTimeScale(final TimeScaleType timeScale) {
            this.timeScale = timeScale;
            return this;
        }

        /**
         * Sets the new value of "referencePosition" (any previous value will be replaced)
         * 
         * @param referencePosition
         *     New value of the "referencePosition" property.
         */
        public TimeFrameType.Builder<_B> withReferencePosition(final JAXBElement<? extends ReferencePositionType> referencePosition) {
            this.referencePosition = referencePosition;
            return this;
        }

        /**
         * Sets the new value of "timeRefDirection" (any previous value will be replaced)
         * 
         * @param timeRefDirection
         *     New value of the "timeRefDirection" property.
         */
        public TimeFrameType.Builder<_B> withTimeRefDirection(final AstroCoordsType timeRefDirection) {
            this.timeRefDirection = ((timeRefDirection == null)?null:new AstroCoordsType.Builder<>(this, timeRefDirection, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "timeRefDirection" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordsType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "timeRefDirection" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordsType.Builder#end()} to
         *     return to the current builder.
         */
        public AstroCoordsType.Builder<? extends TimeFrameType.Builder<_B>> withTimeRefDirection() {
            if (this.timeRefDirection!= null) {
                return this.timeRefDirection;
            }
            return this.timeRefDirection = new AstroCoordsType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        @Override
        public TimeFrameType.Builder<_B> withName(final String name) {
            super.withName(name);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public TimeFrameType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public TimeFrameType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public TimeFrameType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public TimeFrameType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public TimeFrameType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public TimeFrameType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public TimeFrameType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public TimeFrameType build() {
            if (_storedValue == null) {
                return this.init(new TimeFrameType());
            } else {
                return ((TimeFrameType) _storedValue);
            }
        }

        public TimeFrameType.Builder<_B> copyOf(final TimeFrameType _other) {
            _other.copyTo(this);
            return this;
        }

        public TimeFrameType.Builder<_B> copyOf(final TimeFrameType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends CoordFrameType.Modifier
    {


        public void setTimeScale(final TimeScaleType timeScale) {
            TimeFrameType.this.setTimeScale(timeScale);
        }

        public void setReferencePosition(final JAXBElement<? extends ReferencePositionType> referencePosition) {
            TimeFrameType.this.setReferencePosition(referencePosition);
        }

        public void setTimeRefDirection(final AstroCoordsType timeRefDirection) {
            TimeFrameType.this.setTimeRefDirection(timeRefDirection);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<TimeFrameType, TimeScaleType> TIME_SCALE = new SinglePropertyInfo<TimeFrameType,TimeScaleType>("timeScale", TimeFrameType.class, TimeScaleType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "TimeScale"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "timeScaleType"), false) {


            @Override
            public TimeScaleType get(final TimeFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.timeScale);
            }

            @Override
            public void set(final TimeFrameType _instance_, final TimeScaleType _value_) {
                if (_instance_!= null) {
                    _instance_.timeScale = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<TimeFrameType, ReferencePositionType> REFERENCE_POSITION = new SinglePropertyInfo<TimeFrameType,ReferencePositionType>("referencePosition", TimeFrameType.class, ReferencePositionType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "ReferencePosition"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "referencePositionType"), false) {


            @Override
            public ReferencePositionType get(final TimeFrameType _instance_) {
                return ((_instance_ == null)?null:((_instance_.referencePosition == null)?null:_instance_.referencePosition.getValue()));
            }

            @Override
            public void set(final TimeFrameType _instance_, final ReferencePositionType _value_) {
                if (_instance_!= null) {
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<TimeFrameType, AstroCoordsType> TIME_REF_DIRECTION = new SinglePropertyInfo<TimeFrameType,AstroCoordsType>("timeRefDirection", TimeFrameType.class, AstroCoordsType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "TimeRefDirection"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroCoordsType"), false) {


            @Override
            public AstroCoordsType get(final TimeFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.timeRefDirection);
            }

            @Override
            public void set(final TimeFrameType _instance_, final AstroCoordsType _value_) {
                if (_instance_!= null) {
                    _instance_.timeRefDirection = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends TimeFrameType.Selector<TimeFrameType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static TimeFrameType.Select _root() {
            return new TimeFrameType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends CoordFrameType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, TimeFrameType.Selector<TRoot, TParent>> timeScale = null;
        private com.kscs.util.jaxb.Selector<TRoot, TimeFrameType.Selector<TRoot, TParent>> referencePosition = null;
        private AstroCoordsType.Selector<TRoot, TimeFrameType.Selector<TRoot, TParent>> timeRefDirection = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.timeScale!= null) {
                products.put("timeScale", this.timeScale.init());
            }
            if (this.referencePosition!= null) {
                products.put("referencePosition", this.referencePosition.init());
            }
            if (this.timeRefDirection!= null) {
                products.put("timeRefDirection", this.timeRefDirection.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, TimeFrameType.Selector<TRoot, TParent>> timeScale() {
            return ((this.timeScale == null)?this.timeScale = new com.kscs.util.jaxb.Selector<>(this._root, this, "timeScale"):this.timeScale);
        }

        public com.kscs.util.jaxb.Selector<TRoot, TimeFrameType.Selector<TRoot, TParent>> referencePosition() {
            return ((this.referencePosition == null)?this.referencePosition = new com.kscs.util.jaxb.Selector<>(this._root, this, "referencePosition"):this.referencePosition);
        }

        public AstroCoordsType.Selector<TRoot, TimeFrameType.Selector<TRoot, TParent>> timeRefDirection() {
            return ((this.timeRefDirection == null)?this.timeRefDirection = new AstroCoordsType.Selector<>(this._root, this, "timeRefDirection"):this.timeRefDirection);
        }

    }

}
