
package org.javastro.ivoa.entities.stc.v1;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * The actual time scale used: TT, TAI, UTC, TDB, etc.
 * 
 * <p>Java class for timeScaleType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="timeScaleType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="TT"/>
 *     <enumeration value="TDT"/>
 *     <enumeration value="ET"/>
 *     <enumeration value="TDB"/>
 *     <enumeration value="TEB"/>
 *     <enumeration value="TCG"/>
 *     <enumeration value="TCB"/>
 *     <enumeration value="TAI"/>
 *     <enumeration value="IAT"/>
 *     <enumeration value="UTC"/>
 *     <enumeration value="GPS"/>
 *     <enumeration value="LST"/>
 *     <enumeration value="GMST"/>
 *     <enumeration value="LOCAL"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "timeScaleType")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public enum TimeScaleType implements EnumValue<String>
{


    /**
     * Terrestrial Time; the basis for ephemerides
     * 
     */
    TT,

    /**
     * Obsolete synonym for TT
     * 
     */
    TDT,

    /**
     * Ephemeris Time; predecessor of, and continuous with, TT
     * 
     */
    ET,

    /**
     * Barycentric Dynamic Time:the independent variable in planetay ephemerides; time at the solar system barycenter synchronous with TT on an annual basis; sometimes called TEB
     * 
     */
    TDB,

    /**
     * Barycentric Ephemeris Time: time at the solar system barycenter synchronous with TT on an annual basis; a deprecated synonym of TDB.
     * 
     */
    TEB,

    /**
     * Terrestrial Coordinate Time
     * 
     */
    TCG,

    /**
     * Barycentric Coordinate Time; runs slower than TDB but is consistent with physical constants
     * 
     */
    TCB,

    /**
     * International Atomic Time; runs 32.184 s behind TT
     * 
     */
    TAI,

    /**
     * Synonym for TAI
     * 
     */
    IAT,

    /**
     * Coordinated Universal Time; currently (2006) runs 33 leapseconds behind TAI
     * 
     */
    UTC,

    /**
     * Global Positioning System's time scale; runs 19 s behind TAI, 51.184 s behind TT.
     * 
     */
    GPS,

    /**
     * Local Siderial Time; only for ground-based observations; note that the second is shorter
     * 
     */
    LST,

    /**
     * Greenwich Mean Siderial Time; only for ground-based observations; note that the second is shorter
     * 
     */
    GMST,

    /**
     * Only to be used for simulations in conjunction with a relocatable spatial frame
     * 
     */
    LOCAL;

    public String value() {
        return name();
    }

    public static TimeScaleType fromValue(String v) {
        return valueOf(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
