
package org.javastro.ivoa.entities.uws;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.javastro.ivoa.jaxb.adapters.ZonedDateTimeXmlAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;
import org.w3c.dom.Element;


/**
 * The complete representation of the state of a job
 * 
 * <p>Java class for JobSummary complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="JobSummary">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="jobId" type="{http://www.ivoa.net/xml/UWS/v1.0}JobIdentifier"/>
 *         <element name="runId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="ownerId" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="phase" type="{http://www.ivoa.net/xml/UWS/v1.0}ExecutionPhase"/>
 *         <element name="quote" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         <element name="creationTime" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         <element name="startTime" type="{http://www.w3.org/2001/XMLSchema}dateTime"/>
 *         <element name="endTime" type="{http://www.w3.org/2001/XMLSchema}dateTime"/>
 *         <element name="executionDuration" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *         <element name="destruction" type="{http://www.w3.org/2001/XMLSchema}dateTime"/>
 *         <element ref="{http://www.ivoa.net/xml/UWS/v1.0}parameters" minOccurs="0"/>
 *         <element ref="{http://www.ivoa.net/xml/UWS/v1.0}results"/>
 *         <element name="errorSummary" type="{http://www.ivoa.net/xml/UWS/v1.0}ErrorSummary" minOccurs="0"/>
 *         <element name="jobInfo" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <sequence>
 *                   <any processContents='lax' maxOccurs="unbounded" minOccurs="0"/>
 *                 </sequence>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </sequence>
 *       <attribute name="version" type="{http://www.ivoa.net/xml/UWS/v1.0}UWSVersion" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "JobSummary", propOrder = {
    "jobId",
    "runId",
    "ownerId",
    "phase",
    "quote",
    "creationTime",
    "startTime",
    "endTime",
    "executionDuration",
    "destruction",
    "parameters",
    "results",
    "errorSummary",
    "jobInfo"
})
@XmlRootElement(name = "job")
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Job implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String jobId;
    /**
     * this is a client supplied identifier - the UWS system
     *                   does nothing other than to return it as part of the
     *                   description of the job
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String runId;
    /**
     * the owner (creator) of the job - this should be
     *                   expressed as a string that can be parsed in accordance
     *                   with IVOA security standards. If there was no
     *                   authenticated job creator then this should be set to
     *                   NULL.
     * 
     */
    @XmlElement(required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String ownerId;
    /**
     * the execution phase - returned at
     *                   /{jobs}/{job-id}/phase
     * 
     */
    @XmlElement(required = true)
    @XmlSchemaType(name = "string")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ExecutionPhase phase;
    /**
     * A Quote predicts when the job is likely to complete -
     *                   returned at /{jobs}/{job-id}/quote "don't know" is
     *                   encoded by setting to the XML null value
     *                   xsi:nil="true"
     * 
     */
    @XmlElement(type = String.class, nillable = true)
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ZonedDateTime quote;
    /**
     * Note that the version 1.1 of the specification requires that this element be present.
     *                 It is optional only in versions 1.x of the schema for backwards compatibility.
     *                 2.0+ versions of the schema will make this formally mandatory in an XML sense.
     * 
     */
    @XmlElement(type = String.class)
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ZonedDateTime creationTime;
    /**
     * The instant at which the job started execution.
     * 
     */
    @XmlElement(required = true, type = String.class, nillable = true)
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ZonedDateTime startTime;
    /**
     * The instant at which the job finished execution
     * 
     */
    @XmlElement(required = true, type = String.class, nillable = true)
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ZonedDateTime endTime;
    /**
     * The duration (in seconds) for which the job should be
     *                   allowed to run - a value of 0 is intended to mean
     *                   unlimited - returned at
     *                   /{jobs}/{job-id}/executionduration
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected int executionDuration;
    /**
     * The time at which the whole job + records + results
     *                   will be destroyed. returned at
     *                   /{jobs}/{job-id}/destruction
     * 
     */
    @XmlElement(required = true, type = String.class, nillable = true)
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ZonedDateTime destruction;
    /**
     * The parameters to the job (where appropriate) can also
     *                   be retrieved at /{jobs}/{job-id}/parameters
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Parameters parameters;
    /**
     * The results for the job - can also be retrieved at
     *                   /{jobs}/{job-id}/results
     * 
     */
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Results results;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ErrorSummary errorSummary;
    /**
     * This is arbitrary information that can be added to the
     *                   job description by the UWS implementation.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Job.JobInfo jobInfo;
    /**
     * note that this attribute is actually required by the 1.1 specification - however remains optional in the schema
     *            for backwards compatibility. It will be formally required in the next major revision.
     * 
     */
    @XmlAttribute(name = "version")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String version;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient Job.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Job() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Job(final String jobId, final String runId, final String ownerId, final ExecutionPhase phase, final ZonedDateTime quote, final ZonedDateTime creationTime, final ZonedDateTime startTime, final ZonedDateTime endTime, final int executionDuration, final ZonedDateTime destruction, final Parameters parameters, final Results results, final ErrorSummary errorSummary, final Job.JobInfo jobInfo, final String version) {
        this.jobId = jobId;
        this.runId = runId;
        this.ownerId = ownerId;
        this.phase = phase;
        this.quote = quote;
        this.creationTime = creationTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.executionDuration = executionDuration;
        this.destruction = destruction;
        this.parameters = parameters;
        this.results = results;
        this.errorSummary = errorSummary;
        this.jobInfo = jobInfo;
        this.version = version;
    }

    /**
     * Gets the value of the jobId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getJobId() {
        return jobId;
    }

    /**
     * Sets the value of the jobId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setJobId(String value) {
        this.jobId = value;
    }

    /**
     * this is a client supplied identifier - the UWS system
     *                   does nothing other than to return it as part of the
     *                   description of the job
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getRunId() {
        return runId;
    }

    /**
     * Sets the value of the runId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getRunId()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setRunId(String value) {
        this.runId = value;
    }

    /**
     * the owner (creator) of the job - this should be
     *                   expressed as a string that can be parsed in accordance
     *                   with IVOA security standards. If there was no
     *                   authenticated job creator then this should be set to
     *                   NULL.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getOwnerId() {
        return ownerId;
    }

    /**
     * Sets the value of the ownerId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getOwnerId()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setOwnerId(String value) {
        this.ownerId = value;
    }

    /**
     * the execution phase - returned at
     *                   /{jobs}/{job-id}/phase
     * 
     * @return
     *     possible object is
     *     {@link ExecutionPhase }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ExecutionPhase getPhase() {
        return phase;
    }

    /**
     * Sets the value of the phase property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExecutionPhase }
     *     
     * @see #getPhase()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setPhase(ExecutionPhase value) {
        this.phase = value;
    }

    /**
     * A Quote predicts when the job is likely to complete -
     *                   returned at /{jobs}/{job-id}/quote "don't know" is
     *                   encoded by setting to the XML null value
     *                   xsi:nil="true"
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ZonedDateTime getQuote() {
        return quote;
    }

    /**
     * Sets the value of the quote property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getQuote()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setQuote(ZonedDateTime value) {
        this.quote = value;
    }

    /**
     * Note that the version 1.1 of the specification requires that this element be present.
     *                 It is optional only in versions 1.x of the schema for backwards compatibility.
     *                 2.0+ versions of the schema will make this formally mandatory in an XML sense.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ZonedDateTime getCreationTime() {
        return creationTime;
    }

    /**
     * Sets the value of the creationTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreationTime()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setCreationTime(ZonedDateTime value) {
        this.creationTime = value;
    }

    /**
     * The instant at which the job started execution.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ZonedDateTime getStartTime() {
        return startTime;
    }

    /**
     * Sets the value of the startTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getStartTime()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setStartTime(ZonedDateTime value) {
        this.startTime = value;
    }

    /**
     * The instant at which the job finished execution
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ZonedDateTime getEndTime() {
        return endTime;
    }

    /**
     * Sets the value of the endTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getEndTime()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setEndTime(ZonedDateTime value) {
        this.endTime = value;
    }

    /**
     * The duration (in seconds) for which the job should be
     *                   allowed to run - a value of 0 is intended to mean
     *                   unlimited - returned at
     *                   /{jobs}/{job-id}/executionduration
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int getExecutionDuration() {
        return executionDuration;
    }

    /**
     * Sets the value of the executionDuration property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setExecutionDuration(int value) {
        this.executionDuration = value;
    }

    /**
     * The time at which the whole job + records + results
     *                   will be destroyed. returned at
     *                   /{jobs}/{job-id}/destruction
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ZonedDateTime getDestruction() {
        return destruction;
    }

    /**
     * Sets the value of the destruction property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDestruction()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setDestruction(ZonedDateTime value) {
        this.destruction = value;
    }

    /**
     * The parameters to the job (where appropriate) can also
     *                   be retrieved at /{jobs}/{job-id}/parameters
     * 
     * @return
     *     possible object is
     *     {@link Parameters }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Parameters getParameters() {
        return parameters;
    }

    /**
     * Sets the value of the parameters property.
     * 
     * @param value
     *     allowed object is
     *     {@link Parameters }
     *     
     * @see #getParameters()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setParameters(Parameters value) {
        this.parameters = value;
    }

    /**
     * The results for the job - can also be retrieved at
     *                   /{jobs}/{job-id}/results
     * 
     * @return
     *     possible object is
     *     {@link Results }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Results getResults() {
        return results;
    }

    /**
     * Sets the value of the results property.
     * 
     * @param value
     *     allowed object is
     *     {@link Results }
     *     
     * @see #getResults()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setResults(Results value) {
        this.results = value;
    }

    /**
     * Gets the value of the errorSummary property.
     * 
     * @return
     *     possible object is
     *     {@link ErrorSummary }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ErrorSummary getErrorSummary() {
        return errorSummary;
    }

    /**
     * Sets the value of the errorSummary property.
     * 
     * @param value
     *     allowed object is
     *     {@link ErrorSummary }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setErrorSummary(ErrorSummary value) {
        this.errorSummary = value;
    }

    /**
     * This is arbitrary information that can be added to the
     *                   job description by the UWS implementation.
     * 
     * @return
     *     possible object is
     *     {@link Job.JobInfo }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Job.JobInfo getJobInfo() {
        return jobInfo;
    }

    /**
     * Sets the value of the jobInfo property.
     * 
     * @param value
     *     allowed object is
     *     {@link Job.JobInfo }
     *     
     * @see #getJobInfo()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setJobInfo(Job.JobInfo value) {
        this.jobInfo = value;
    }

    /**
     * note that this attribute is actually required by the 1.1 specification - however remains optional in the schema
     *            for backwards compatibility. It will be formally required in the next major revision.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getVersion()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setVersion(String value) {
        this.version = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Job that = ((Job) object);
        {
            String leftJobId;
            leftJobId = this.getJobId();
            String rightJobId;
            rightJobId = that.getJobId();
            if (this.jobId!= null) {
                if (that.jobId!= null) {
                    if (!leftJobId.equals(rightJobId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.jobId!= null) {
                    return false;
                }
            }
        }
        {
            String leftRunId;
            leftRunId = this.getRunId();
            String rightRunId;
            rightRunId = that.getRunId();
            if (this.runId!= null) {
                if (that.runId!= null) {
                    if (!leftRunId.equals(rightRunId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.runId!= null) {
                    return false;
                }
            }
        }
        {
            String leftOwnerId;
            leftOwnerId = this.getOwnerId();
            String rightOwnerId;
            rightOwnerId = that.getOwnerId();
            if (this.ownerId!= null) {
                if (that.ownerId!= null) {
                    if (!leftOwnerId.equals(rightOwnerId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.ownerId!= null) {
                    return false;
                }
            }
        }
        {
            ExecutionPhase leftPhase;
            leftPhase = this.getPhase();
            ExecutionPhase rightPhase;
            rightPhase = that.getPhase();
            if (this.phase!= null) {
                if (that.phase!= null) {
                    if (!leftPhase.equals(rightPhase)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.phase!= null) {
                    return false;
                }
            }
        }
        {
            ZonedDateTime leftQuote;
            leftQuote = this.getQuote();
            ZonedDateTime rightQuote;
            rightQuote = that.getQuote();
            if (this.quote!= null) {
                if (that.quote!= null) {
                    if (!leftQuote.equals(rightQuote)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.quote!= null) {
                    return false;
                }
            }
        }
        {
            ZonedDateTime leftCreationTime;
            leftCreationTime = this.getCreationTime();
            ZonedDateTime rightCreationTime;
            rightCreationTime = that.getCreationTime();
            if (this.creationTime!= null) {
                if (that.creationTime!= null) {
                    if (!leftCreationTime.equals(rightCreationTime)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.creationTime!= null) {
                    return false;
                }
            }
        }
        {
            ZonedDateTime leftStartTime;
            leftStartTime = this.getStartTime();
            ZonedDateTime rightStartTime;
            rightStartTime = that.getStartTime();
            if (this.startTime!= null) {
                if (that.startTime!= null) {
                    if (!leftStartTime.equals(rightStartTime)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.startTime!= null) {
                    return false;
                }
            }
        }
        {
            ZonedDateTime leftEndTime;
            leftEndTime = this.getEndTime();
            ZonedDateTime rightEndTime;
            rightEndTime = that.getEndTime();
            if (this.endTime!= null) {
                if (that.endTime!= null) {
                    if (!leftEndTime.equals(rightEndTime)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.endTime!= null) {
                    return false;
                }
            }
        }
        {
            int leftExecutionDuration;
            leftExecutionDuration = this.getExecutionDuration();
            int rightExecutionDuration;
            rightExecutionDuration = that.getExecutionDuration();
            if (leftExecutionDuration!= rightExecutionDuration) {
                return false;
            }
        }
        {
            ZonedDateTime leftDestruction;
            leftDestruction = this.getDestruction();
            ZonedDateTime rightDestruction;
            rightDestruction = that.getDestruction();
            if (this.destruction!= null) {
                if (that.destruction!= null) {
                    if (!leftDestruction.equals(rightDestruction)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.destruction!= null) {
                    return false;
                }
            }
        }
        {
            Parameters leftParameters;
            leftParameters = this.getParameters();
            Parameters rightParameters;
            rightParameters = that.getParameters();
            if (this.parameters!= null) {
                if (that.parameters!= null) {
                    if (!leftParameters.equals(rightParameters)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.parameters!= null) {
                    return false;
                }
            }
        }
        {
            Results leftResults;
            leftResults = this.getResults();
            Results rightResults;
            rightResults = that.getResults();
            if (this.results!= null) {
                if (that.results!= null) {
                    if (!leftResults.equals(rightResults)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.results!= null) {
                    return false;
                }
            }
        }
        {
            ErrorSummary leftErrorSummary;
            leftErrorSummary = this.getErrorSummary();
            ErrorSummary rightErrorSummary;
            rightErrorSummary = that.getErrorSummary();
            if (this.errorSummary!= null) {
                if (that.errorSummary!= null) {
                    if (!leftErrorSummary.equals(rightErrorSummary)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.errorSummary!= null) {
                    return false;
                }
            }
        }
        {
            Job.JobInfo leftJobInfo;
            leftJobInfo = this.getJobInfo();
            Job.JobInfo rightJobInfo;
            rightJobInfo = that.getJobInfo();
            if (this.jobInfo!= null) {
                if (that.jobInfo!= null) {
                    if (!leftJobInfo.equals(rightJobInfo)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.jobInfo!= null) {
                    return false;
                }
            }
        }
        {
            String leftVersion;
            leftVersion = this.getVersion();
            String rightVersion;
            rightVersion = that.getVersion();
            if (this.version!= null) {
                if (that.version!= null) {
                    if (!leftVersion.equals(rightVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.version!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theJobId;
            theJobId = this.getJobId();
            if (this.jobId!= null) {
                currentHashCode += theJobId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theRunId;
            theRunId = this.getRunId();
            if (this.runId!= null) {
                currentHashCode += theRunId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theOwnerId;
            theOwnerId = this.getOwnerId();
            if (this.ownerId!= null) {
                currentHashCode += theOwnerId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ExecutionPhase thePhase;
            thePhase = this.getPhase();
            if (this.phase!= null) {
                currentHashCode += thePhase.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theQuote;
            theQuote = this.getQuote();
            if (this.quote!= null) {
                currentHashCode += theQuote.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theCreationTime;
            theCreationTime = this.getCreationTime();
            if (this.creationTime!= null) {
                currentHashCode += theCreationTime.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theStartTime;
            theStartTime = this.getStartTime();
            if (this.startTime!= null) {
                currentHashCode += theStartTime.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theEndTime;
            theEndTime = this.getEndTime();
            if (this.endTime!= null) {
                currentHashCode += theEndTime.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            int theExecutionDuration;
            theExecutionDuration = this.getExecutionDuration();
            currentHashCode += theExecutionDuration;
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theDestruction;
            theDestruction = this.getDestruction();
            if (this.destruction!= null) {
                currentHashCode += theDestruction.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Parameters theParameters;
            theParameters = this.getParameters();
            if (this.parameters!= null) {
                currentHashCode += theParameters.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Results theResults;
            theResults = this.getResults();
            if (this.results!= null) {
                currentHashCode += theResults.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ErrorSummary theErrorSummary;
            theErrorSummary = this.getErrorSummary();
            if (this.errorSummary!= null) {
                currentHashCode += theErrorSummary.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Job.JobInfo theJobInfo;
            theJobInfo = this.getJobInfo();
            if (this.jobInfo!= null) {
                currentHashCode += theJobInfo.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theVersion;
            theVersion = this.getVersion();
            if (this.version!= null) {
                currentHashCode += theVersion.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theJobId;
            theJobId = this.getJobId();
            strategy.appendField(locator, this, "jobId", buffer, theJobId, (this.jobId!= null));
        }
        {
            String theRunId;
            theRunId = this.getRunId();
            strategy.appendField(locator, this, "runId", buffer, theRunId, (this.runId!= null));
        }
        {
            String theOwnerId;
            theOwnerId = this.getOwnerId();
            strategy.appendField(locator, this, "ownerId", buffer, theOwnerId, (this.ownerId!= null));
        }
        {
            ExecutionPhase thePhase;
            thePhase = this.getPhase();
            strategy.appendField(locator, this, "phase", buffer, thePhase, (this.phase!= null));
        }
        {
            ZonedDateTime theQuote;
            theQuote = this.getQuote();
            strategy.appendField(locator, this, "quote", buffer, theQuote, (this.quote!= null));
        }
        {
            ZonedDateTime theCreationTime;
            theCreationTime = this.getCreationTime();
            strategy.appendField(locator, this, "creationTime", buffer, theCreationTime, (this.creationTime!= null));
        }
        {
            ZonedDateTime theStartTime;
            theStartTime = this.getStartTime();
            strategy.appendField(locator, this, "startTime", buffer, theStartTime, (this.startTime!= null));
        }
        {
            ZonedDateTime theEndTime;
            theEndTime = this.getEndTime();
            strategy.appendField(locator, this, "endTime", buffer, theEndTime, (this.endTime!= null));
        }
        {
            int theExecutionDuration;
            theExecutionDuration = this.getExecutionDuration();
            strategy.appendField(locator, this, "executionDuration", buffer, theExecutionDuration, true);
        }
        {
            ZonedDateTime theDestruction;
            theDestruction = this.getDestruction();
            strategy.appendField(locator, this, "destruction", buffer, theDestruction, (this.destruction!= null));
        }
        {
            Parameters theParameters;
            theParameters = this.getParameters();
            strategy.appendField(locator, this, "parameters", buffer, theParameters, (this.parameters!= null));
        }
        {
            Results theResults;
            theResults = this.getResults();
            strategy.appendField(locator, this, "results", buffer, theResults, (this.results!= null));
        }
        {
            ErrorSummary theErrorSummary;
            theErrorSummary = this.getErrorSummary();
            strategy.appendField(locator, this, "errorSummary", buffer, theErrorSummary, (this.errorSummary!= null));
        }
        {
            Job.JobInfo theJobInfo;
            theJobInfo = this.getJobInfo();
            strategy.appendField(locator, this, "jobInfo", buffer, theJobInfo, (this.jobInfo!= null));
        }
        {
            String theVersion;
            theVersion = this.getVersion();
            strategy.appendField(locator, this, "version", buffer, theVersion, (this.version!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Job) {
            final Job target = this;
            final Job leftObject = ((Job) left);
            final Job rightObject = ((Job) right);
            {
                Boolean jobIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.jobId!= null), (rightObject.jobId!= null));
                if (jobIdShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsJobId;
                    lhsJobId = leftObject.getJobId();
                    String rhsJobId;
                    rhsJobId = rightObject.getJobId();
                    String mergedJobId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "jobId", lhsJobId), LocatorUtils.property(rightLocator, "jobId", rhsJobId), lhsJobId, rhsJobId, (leftObject.jobId!= null), (rightObject.jobId!= null)));
                    target.setJobId(mergedJobId);
                } else {
                    if (jobIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.jobId = null;
                    }
                }
            }
            {
                Boolean runIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.runId!= null), (rightObject.runId!= null));
                if (runIdShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsRunId;
                    lhsRunId = leftObject.getRunId();
                    String rhsRunId;
                    rhsRunId = rightObject.getRunId();
                    String mergedRunId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "runId", lhsRunId), LocatorUtils.property(rightLocator, "runId", rhsRunId), lhsRunId, rhsRunId, (leftObject.runId!= null), (rightObject.runId!= null)));
                    target.setRunId(mergedRunId);
                } else {
                    if (runIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.runId = null;
                    }
                }
            }
            {
                Boolean ownerIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.ownerId!= null), (rightObject.ownerId!= null));
                if (ownerIdShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsOwnerId;
                    lhsOwnerId = leftObject.getOwnerId();
                    String rhsOwnerId;
                    rhsOwnerId = rightObject.getOwnerId();
                    String mergedOwnerId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "ownerId", lhsOwnerId), LocatorUtils.property(rightLocator, "ownerId", rhsOwnerId), lhsOwnerId, rhsOwnerId, (leftObject.ownerId!= null), (rightObject.ownerId!= null)));
                    target.setOwnerId(mergedOwnerId);
                } else {
                    if (ownerIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.ownerId = null;
                    }
                }
            }
            {
                Boolean phaseShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.phase!= null), (rightObject.phase!= null));
                if (phaseShouldBeMergedAndSet == Boolean.TRUE) {
                    ExecutionPhase lhsPhase;
                    lhsPhase = leftObject.getPhase();
                    ExecutionPhase rhsPhase;
                    rhsPhase = rightObject.getPhase();
                    ExecutionPhase mergedPhase = ((ExecutionPhase) strategy.merge(LocatorUtils.property(leftLocator, "phase", lhsPhase), LocatorUtils.property(rightLocator, "phase", rhsPhase), lhsPhase, rhsPhase, (leftObject.phase!= null), (rightObject.phase!= null)));
                    target.setPhase(mergedPhase);
                } else {
                    if (phaseShouldBeMergedAndSet == Boolean.FALSE) {
                        target.phase = null;
                    }
                }
            }
            {
                Boolean quoteShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.quote!= null), (rightObject.quote!= null));
                if (quoteShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsQuote;
                    lhsQuote = leftObject.getQuote();
                    ZonedDateTime rhsQuote;
                    rhsQuote = rightObject.getQuote();
                    ZonedDateTime mergedQuote = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "quote", lhsQuote), LocatorUtils.property(rightLocator, "quote", rhsQuote), lhsQuote, rhsQuote, (leftObject.quote!= null), (rightObject.quote!= null)));
                    target.setQuote(mergedQuote);
                } else {
                    if (quoteShouldBeMergedAndSet == Boolean.FALSE) {
                        target.quote = null;
                    }
                }
            }
            {
                Boolean creationTimeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.creationTime!= null), (rightObject.creationTime!= null));
                if (creationTimeShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsCreationTime;
                    lhsCreationTime = leftObject.getCreationTime();
                    ZonedDateTime rhsCreationTime;
                    rhsCreationTime = rightObject.getCreationTime();
                    ZonedDateTime mergedCreationTime = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "creationTime", lhsCreationTime), LocatorUtils.property(rightLocator, "creationTime", rhsCreationTime), lhsCreationTime, rhsCreationTime, (leftObject.creationTime!= null), (rightObject.creationTime!= null)));
                    target.setCreationTime(mergedCreationTime);
                } else {
                    if (creationTimeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.creationTime = null;
                    }
                }
            }
            {
                Boolean startTimeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.startTime!= null), (rightObject.startTime!= null));
                if (startTimeShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsStartTime;
                    lhsStartTime = leftObject.getStartTime();
                    ZonedDateTime rhsStartTime;
                    rhsStartTime = rightObject.getStartTime();
                    ZonedDateTime mergedStartTime = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "startTime", lhsStartTime), LocatorUtils.property(rightLocator, "startTime", rhsStartTime), lhsStartTime, rhsStartTime, (leftObject.startTime!= null), (rightObject.startTime!= null)));
                    target.setStartTime(mergedStartTime);
                } else {
                    if (startTimeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.startTime = null;
                    }
                }
            }
            {
                Boolean endTimeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.endTime!= null), (rightObject.endTime!= null));
                if (endTimeShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsEndTime;
                    lhsEndTime = leftObject.getEndTime();
                    ZonedDateTime rhsEndTime;
                    rhsEndTime = rightObject.getEndTime();
                    ZonedDateTime mergedEndTime = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "endTime", lhsEndTime), LocatorUtils.property(rightLocator, "endTime", rhsEndTime), lhsEndTime, rhsEndTime, (leftObject.endTime!= null), (rightObject.endTime!= null)));
                    target.setEndTime(mergedEndTime);
                } else {
                    if (endTimeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.endTime = null;
                    }
                }
            }
            {
                Boolean executionDurationShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (executionDurationShouldBeMergedAndSet == Boolean.TRUE) {
                    int lhsExecutionDuration;
                    lhsExecutionDuration = leftObject.getExecutionDuration();
                    int rhsExecutionDuration;
                    rhsExecutionDuration = rightObject.getExecutionDuration();
                    int mergedExecutionDuration = ((int) strategy.merge(LocatorUtils.property(leftLocator, "executionDuration", lhsExecutionDuration), LocatorUtils.property(rightLocator, "executionDuration", rhsExecutionDuration), lhsExecutionDuration, rhsExecutionDuration, true, true));
                    target.setExecutionDuration(mergedExecutionDuration);
                } else {
                    if (executionDurationShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean destructionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.destruction!= null), (rightObject.destruction!= null));
                if (destructionShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsDestruction;
                    lhsDestruction = leftObject.getDestruction();
                    ZonedDateTime rhsDestruction;
                    rhsDestruction = rightObject.getDestruction();
                    ZonedDateTime mergedDestruction = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "destruction", lhsDestruction), LocatorUtils.property(rightLocator, "destruction", rhsDestruction), lhsDestruction, rhsDestruction, (leftObject.destruction!= null), (rightObject.destruction!= null)));
                    target.setDestruction(mergedDestruction);
                } else {
                    if (destructionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.destruction = null;
                    }
                }
            }
            {
                Boolean parametersShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.parameters!= null), (rightObject.parameters!= null));
                if (parametersShouldBeMergedAndSet == Boolean.TRUE) {
                    Parameters lhsParameters;
                    lhsParameters = leftObject.getParameters();
                    Parameters rhsParameters;
                    rhsParameters = rightObject.getParameters();
                    Parameters mergedParameters = ((Parameters) strategy.merge(LocatorUtils.property(leftLocator, "parameters", lhsParameters), LocatorUtils.property(rightLocator, "parameters", rhsParameters), lhsParameters, rhsParameters, (leftObject.parameters!= null), (rightObject.parameters!= null)));
                    target.setParameters(mergedParameters);
                } else {
                    if (parametersShouldBeMergedAndSet == Boolean.FALSE) {
                        target.parameters = null;
                    }
                }
            }
            {
                Boolean resultsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.results!= null), (rightObject.results!= null));
                if (resultsShouldBeMergedAndSet == Boolean.TRUE) {
                    Results lhsResults;
                    lhsResults = leftObject.getResults();
                    Results rhsResults;
                    rhsResults = rightObject.getResults();
                    Results mergedResults = ((Results) strategy.merge(LocatorUtils.property(leftLocator, "results", lhsResults), LocatorUtils.property(rightLocator, "results", rhsResults), lhsResults, rhsResults, (leftObject.results!= null), (rightObject.results!= null)));
                    target.setResults(mergedResults);
                } else {
                    if (resultsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.results = null;
                    }
                }
            }
            {
                Boolean errorSummaryShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.errorSummary!= null), (rightObject.errorSummary!= null));
                if (errorSummaryShouldBeMergedAndSet == Boolean.TRUE) {
                    ErrorSummary lhsErrorSummary;
                    lhsErrorSummary = leftObject.getErrorSummary();
                    ErrorSummary rhsErrorSummary;
                    rhsErrorSummary = rightObject.getErrorSummary();
                    ErrorSummary mergedErrorSummary = ((ErrorSummary) strategy.merge(LocatorUtils.property(leftLocator, "errorSummary", lhsErrorSummary), LocatorUtils.property(rightLocator, "errorSummary", rhsErrorSummary), lhsErrorSummary, rhsErrorSummary, (leftObject.errorSummary!= null), (rightObject.errorSummary!= null)));
                    target.setErrorSummary(mergedErrorSummary);
                } else {
                    if (errorSummaryShouldBeMergedAndSet == Boolean.FALSE) {
                        target.errorSummary = null;
                    }
                }
            }
            {
                Boolean jobInfoShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.jobInfo!= null), (rightObject.jobInfo!= null));
                if (jobInfoShouldBeMergedAndSet == Boolean.TRUE) {
                    Job.JobInfo lhsJobInfo;
                    lhsJobInfo = leftObject.getJobInfo();
                    Job.JobInfo rhsJobInfo;
                    rhsJobInfo = rightObject.getJobInfo();
                    Job.JobInfo mergedJobInfo = ((Job.JobInfo) strategy.merge(LocatorUtils.property(leftLocator, "jobInfo", lhsJobInfo), LocatorUtils.property(rightLocator, "jobInfo", rhsJobInfo), lhsJobInfo, rhsJobInfo, (leftObject.jobInfo!= null), (rightObject.jobInfo!= null)));
                    target.setJobInfo(mergedJobInfo);
                } else {
                    if (jobInfoShouldBeMergedAndSet == Boolean.FALSE) {
                        target.jobInfo = null;
                    }
                }
            }
            {
                Boolean versionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.version!= null), (rightObject.version!= null));
                if (versionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsVersion;
                    lhsVersion = leftObject.getVersion();
                    String rhsVersion;
                    rhsVersion = rightObject.getVersion();
                    String mergedVersion = ((String) strategy.merge(LocatorUtils.property(leftLocator, "version", lhsVersion), LocatorUtils.property(rightLocator, "version", rhsVersion), lhsVersion, rhsVersion, (leftObject.version!= null), (rightObject.version!= null)));
                    target.setVersion(mergedVersion);
                } else {
                    if (versionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.version = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Job();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Job clone() {
        final Job _newObject;
        try {
            _newObject = ((Job) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.parameters = ((this.parameters == null)?null:this.parameters.clone());
        _newObject.results = ((this.results == null)?null:this.results.clone());
        _newObject.errorSummary = ((this.errorSummary == null)?null:this.errorSummary.clone());
        _newObject.jobInfo = ((this.jobInfo == null)?null:this.jobInfo.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Job createCopy() {
        final Job _newObject;
        try {
            _newObject = ((Job) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.jobId = this.jobId;
        _newObject.runId = this.runId;
        _newObject.ownerId = this.ownerId;
        _newObject.phase = this.phase;
        _newObject.quote = this.quote;
        _newObject.creationTime = this.creationTime;
        _newObject.startTime = this.startTime;
        _newObject.endTime = this.endTime;
        _newObject.executionDuration = this.executionDuration;
        _newObject.destruction = this.destruction;
        _newObject.parameters = ((this.parameters == null)?null:this.parameters.createCopy());
        _newObject.results = ((this.results == null)?null:this.results.createCopy());
        _newObject.errorSummary = ((this.errorSummary == null)?null:this.errorSummary.createCopy());
        _newObject.jobInfo = ((this.jobInfo == null)?null:this.jobInfo.createCopy());
        _newObject.version = this.version;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Job createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Job _newObject;
        try {
            _newObject = ((Job) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree jobIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("jobId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(jobIdPropertyTree!= null):((jobIdPropertyTree == null)||(!jobIdPropertyTree.isLeaf())))) {
            _newObject.jobId = this.jobId;
        }
        final PropertyTree runIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("runId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(runIdPropertyTree!= null):((runIdPropertyTree == null)||(!runIdPropertyTree.isLeaf())))) {
            _newObject.runId = this.runId;
        }
        final PropertyTree ownerIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ownerId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ownerIdPropertyTree!= null):((ownerIdPropertyTree == null)||(!ownerIdPropertyTree.isLeaf())))) {
            _newObject.ownerId = this.ownerId;
        }
        final PropertyTree phasePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("phase"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(phasePropertyTree!= null):((phasePropertyTree == null)||(!phasePropertyTree.isLeaf())))) {
            _newObject.phase = this.phase;
        }
        final PropertyTree quotePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("quote"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(quotePropertyTree!= null):((quotePropertyTree == null)||(!quotePropertyTree.isLeaf())))) {
            _newObject.quote = this.quote;
        }
        final PropertyTree creationTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("creationTime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(creationTimePropertyTree!= null):((creationTimePropertyTree == null)||(!creationTimePropertyTree.isLeaf())))) {
            _newObject.creationTime = this.creationTime;
        }
        final PropertyTree startTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("startTime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(startTimePropertyTree!= null):((startTimePropertyTree == null)||(!startTimePropertyTree.isLeaf())))) {
            _newObject.startTime = this.startTime;
        }
        final PropertyTree endTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("endTime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(endTimePropertyTree!= null):((endTimePropertyTree == null)||(!endTimePropertyTree.isLeaf())))) {
            _newObject.endTime = this.endTime;
        }
        final PropertyTree executionDurationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("executionDuration"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(executionDurationPropertyTree!= null):((executionDurationPropertyTree == null)||(!executionDurationPropertyTree.isLeaf())))) {
            _newObject.executionDuration = this.executionDuration;
        }
        final PropertyTree destructionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("destruction"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(destructionPropertyTree!= null):((destructionPropertyTree == null)||(!destructionPropertyTree.isLeaf())))) {
            _newObject.destruction = this.destruction;
        }
        final PropertyTree parametersPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("parameters"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(parametersPropertyTree!= null):((parametersPropertyTree == null)||(!parametersPropertyTree.isLeaf())))) {
            _newObject.parameters = ((this.parameters == null)?null:this.parameters.createCopy(parametersPropertyTree, _propertyTreeUse));
        }
        final PropertyTree resultsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("results"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(resultsPropertyTree!= null):((resultsPropertyTree == null)||(!resultsPropertyTree.isLeaf())))) {
            _newObject.results = ((this.results == null)?null:this.results.createCopy(resultsPropertyTree, _propertyTreeUse));
        }
        final PropertyTree errorSummaryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("errorSummary"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(errorSummaryPropertyTree!= null):((errorSummaryPropertyTree == null)||(!errorSummaryPropertyTree.isLeaf())))) {
            _newObject.errorSummary = ((this.errorSummary == null)?null:this.errorSummary.createCopy(errorSummaryPropertyTree, _propertyTreeUse));
        }
        final PropertyTree jobInfoPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("jobInfo"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(jobInfoPropertyTree!= null):((jobInfoPropertyTree == null)||(!jobInfoPropertyTree.isLeaf())))) {
            _newObject.jobInfo = ((this.jobInfo == null)?null:this.jobInfo.createCopy(jobInfoPropertyTree, _propertyTreeUse));
        }
        final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
            _newObject.version = this.version;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Job copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Job copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Job.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Job.Modifier();
        }
        return ((Job.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Job.Builder<_B> _other) {
        _other.jobId = this.jobId;
        _other.runId = this.runId;
        _other.ownerId = this.ownerId;
        _other.phase = this.phase;
        _other.quote = this.quote;
        _other.creationTime = this.creationTime;
        _other.startTime = this.startTime;
        _other.endTime = this.endTime;
        _other.executionDuration = this.executionDuration;
        _other.destruction = this.destruction;
        _other.parameters = ((this.parameters == null)?null:this.parameters.newCopyBuilder(_other));
        _other.results = ((this.results == null)?null:this.results.newCopyBuilder(_other));
        _other.errorSummary = ((this.errorSummary == null)?null:this.errorSummary.newCopyBuilder(_other));
        _other.jobInfo = ((this.jobInfo == null)?null:this.jobInfo.newCopyBuilder(_other));
        _other.version = this.version;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Job.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Job.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Job.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Job.Builder<Void> builder() {
        return new Job.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Job.Builder<_B> copyOf(final Job _other) {
        final Job.Builder<_B> _newBuilder = new Job.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Job.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree jobIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("jobId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(jobIdPropertyTree!= null):((jobIdPropertyTree == null)||(!jobIdPropertyTree.isLeaf())))) {
            _other.jobId = this.jobId;
        }
        final PropertyTree runIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("runId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(runIdPropertyTree!= null):((runIdPropertyTree == null)||(!runIdPropertyTree.isLeaf())))) {
            _other.runId = this.runId;
        }
        final PropertyTree ownerIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ownerId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ownerIdPropertyTree!= null):((ownerIdPropertyTree == null)||(!ownerIdPropertyTree.isLeaf())))) {
            _other.ownerId = this.ownerId;
        }
        final PropertyTree phasePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("phase"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(phasePropertyTree!= null):((phasePropertyTree == null)||(!phasePropertyTree.isLeaf())))) {
            _other.phase = this.phase;
        }
        final PropertyTree quotePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("quote"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(quotePropertyTree!= null):((quotePropertyTree == null)||(!quotePropertyTree.isLeaf())))) {
            _other.quote = this.quote;
        }
        final PropertyTree creationTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("creationTime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(creationTimePropertyTree!= null):((creationTimePropertyTree == null)||(!creationTimePropertyTree.isLeaf())))) {
            _other.creationTime = this.creationTime;
        }
        final PropertyTree startTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("startTime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(startTimePropertyTree!= null):((startTimePropertyTree == null)||(!startTimePropertyTree.isLeaf())))) {
            _other.startTime = this.startTime;
        }
        final PropertyTree endTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("endTime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(endTimePropertyTree!= null):((endTimePropertyTree == null)||(!endTimePropertyTree.isLeaf())))) {
            _other.endTime = this.endTime;
        }
        final PropertyTree executionDurationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("executionDuration"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(executionDurationPropertyTree!= null):((executionDurationPropertyTree == null)||(!executionDurationPropertyTree.isLeaf())))) {
            _other.executionDuration = this.executionDuration;
        }
        final PropertyTree destructionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("destruction"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(destructionPropertyTree!= null):((destructionPropertyTree == null)||(!destructionPropertyTree.isLeaf())))) {
            _other.destruction = this.destruction;
        }
        final PropertyTree parametersPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("parameters"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(parametersPropertyTree!= null):((parametersPropertyTree == null)||(!parametersPropertyTree.isLeaf())))) {
            _other.parameters = ((this.parameters == null)?null:this.parameters.newCopyBuilder(_other, parametersPropertyTree, _propertyTreeUse));
        }
        final PropertyTree resultsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("results"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(resultsPropertyTree!= null):((resultsPropertyTree == null)||(!resultsPropertyTree.isLeaf())))) {
            _other.results = ((this.results == null)?null:this.results.newCopyBuilder(_other, resultsPropertyTree, _propertyTreeUse));
        }
        final PropertyTree errorSummaryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("errorSummary"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(errorSummaryPropertyTree!= null):((errorSummaryPropertyTree == null)||(!errorSummaryPropertyTree.isLeaf())))) {
            _other.errorSummary = ((this.errorSummary == null)?null:this.errorSummary.newCopyBuilder(_other, errorSummaryPropertyTree, _propertyTreeUse));
        }
        final PropertyTree jobInfoPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("jobInfo"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(jobInfoPropertyTree!= null):((jobInfoPropertyTree == null)||(!jobInfoPropertyTree.isLeaf())))) {
            _other.jobInfo = ((this.jobInfo == null)?null:this.jobInfo.newCopyBuilder(_other, jobInfoPropertyTree, _propertyTreeUse));
        }
        final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
            _other.version = this.version;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Job.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Job.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Job.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Job.Builder<_B> copyOf(final Job _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Job.Builder<_B> _newBuilder = new Job.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Job.Builder<Void> copyExcept(final Job _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Job.Builder<Void> copyOnly(final Job _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Job visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.JOB_ID, this));
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.RUN_ID, this));
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.OWNER_ID, this));
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.PHASE, this));
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.QUOTE, this));
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.CREATION_TIME, this));
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.START_TIME, this));
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.END_TIME, this));
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.EXECUTION_DURATION, this));
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.DESTRUCTION, this));
        if (_visitor_.visit(new SingleProperty<>(Job.PropInfo.PARAMETERS, this))&&(this.parameters!= null)) {
            this.parameters.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(Job.PropInfo.RESULTS, this))&&(this.results!= null)) {
            this.results.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(Job.PropInfo.ERROR_SUMMARY, this))&&(this.errorSummary!= null)) {
            this.errorSummary.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(Job.PropInfo.JOB_INFO, this))&&(this.jobInfo!= null)) {
            this.jobInfo.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(Job.PropInfo.VERSION, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Job _storedValue;
        private String jobId;
        private String runId;
        private String ownerId;
        private ExecutionPhase phase;
        private ZonedDateTime quote;
        private ZonedDateTime creationTime;
        private ZonedDateTime startTime;
        private ZonedDateTime endTime;
        private int executionDuration;
        private ZonedDateTime destruction;
        private Parameters.Builder<Job.Builder<_B>> parameters;
        private Results.Builder<Job.Builder<_B>> results;
        private ErrorSummary.Builder<Job.Builder<_B>> errorSummary;
        private Job.JobInfo.Builder<Job.Builder<_B>> jobInfo;
        private String version;

        public Builder(final _B _parentBuilder, final Job _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.jobId = _other.jobId;
                    this.runId = _other.runId;
                    this.ownerId = _other.ownerId;
                    this.phase = _other.phase;
                    this.quote = _other.quote;
                    this.creationTime = _other.creationTime;
                    this.startTime = _other.startTime;
                    this.endTime = _other.endTime;
                    this.executionDuration = _other.executionDuration;
                    this.destruction = _other.destruction;
                    this.parameters = ((_other.parameters == null)?null:_other.parameters.newCopyBuilder(this));
                    this.results = ((_other.results == null)?null:_other.results.newCopyBuilder(this));
                    this.errorSummary = ((_other.errorSummary == null)?null:_other.errorSummary.newCopyBuilder(this));
                    this.jobInfo = ((_other.jobInfo == null)?null:_other.jobInfo.newCopyBuilder(this));
                    this.version = _other.version;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Job _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree jobIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("jobId"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(jobIdPropertyTree!= null):((jobIdPropertyTree == null)||(!jobIdPropertyTree.isLeaf())))) {
                        this.jobId = _other.jobId;
                    }
                    final PropertyTree runIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("runId"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(runIdPropertyTree!= null):((runIdPropertyTree == null)||(!runIdPropertyTree.isLeaf())))) {
                        this.runId = _other.runId;
                    }
                    final PropertyTree ownerIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ownerId"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ownerIdPropertyTree!= null):((ownerIdPropertyTree == null)||(!ownerIdPropertyTree.isLeaf())))) {
                        this.ownerId = _other.ownerId;
                    }
                    final PropertyTree phasePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("phase"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(phasePropertyTree!= null):((phasePropertyTree == null)||(!phasePropertyTree.isLeaf())))) {
                        this.phase = _other.phase;
                    }
                    final PropertyTree quotePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("quote"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(quotePropertyTree!= null):((quotePropertyTree == null)||(!quotePropertyTree.isLeaf())))) {
                        this.quote = _other.quote;
                    }
                    final PropertyTree creationTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("creationTime"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(creationTimePropertyTree!= null):((creationTimePropertyTree == null)||(!creationTimePropertyTree.isLeaf())))) {
                        this.creationTime = _other.creationTime;
                    }
                    final PropertyTree startTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("startTime"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(startTimePropertyTree!= null):((startTimePropertyTree == null)||(!startTimePropertyTree.isLeaf())))) {
                        this.startTime = _other.startTime;
                    }
                    final PropertyTree endTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("endTime"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(endTimePropertyTree!= null):((endTimePropertyTree == null)||(!endTimePropertyTree.isLeaf())))) {
                        this.endTime = _other.endTime;
                    }
                    final PropertyTree executionDurationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("executionDuration"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(executionDurationPropertyTree!= null):((executionDurationPropertyTree == null)||(!executionDurationPropertyTree.isLeaf())))) {
                        this.executionDuration = _other.executionDuration;
                    }
                    final PropertyTree destructionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("destruction"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(destructionPropertyTree!= null):((destructionPropertyTree == null)||(!destructionPropertyTree.isLeaf())))) {
                        this.destruction = _other.destruction;
                    }
                    final PropertyTree parametersPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("parameters"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(parametersPropertyTree!= null):((parametersPropertyTree == null)||(!parametersPropertyTree.isLeaf())))) {
                        this.parameters = ((_other.parameters == null)?null:_other.parameters.newCopyBuilder(this, parametersPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree resultsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("results"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(resultsPropertyTree!= null):((resultsPropertyTree == null)||(!resultsPropertyTree.isLeaf())))) {
                        this.results = ((_other.results == null)?null:_other.results.newCopyBuilder(this, resultsPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree errorSummaryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("errorSummary"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(errorSummaryPropertyTree!= null):((errorSummaryPropertyTree == null)||(!errorSummaryPropertyTree.isLeaf())))) {
                        this.errorSummary = ((_other.errorSummary == null)?null:_other.errorSummary.newCopyBuilder(this, errorSummaryPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree jobInfoPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("jobInfo"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(jobInfoPropertyTree!= null):((jobInfoPropertyTree == null)||(!jobInfoPropertyTree.isLeaf())))) {
                        this.jobInfo = ((_other.jobInfo == null)?null:_other.jobInfo.newCopyBuilder(this, jobInfoPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
                        this.version = _other.version;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Job >_P init(final _P _product) {
            _product.jobId = this.jobId;
            _product.runId = this.runId;
            _product.ownerId = this.ownerId;
            _product.phase = this.phase;
            _product.quote = this.quote;
            _product.creationTime = this.creationTime;
            _product.startTime = this.startTime;
            _product.endTime = this.endTime;
            _product.executionDuration = this.executionDuration;
            _product.destruction = this.destruction;
            _product.parameters = ((this.parameters == null)?null:this.parameters.build());
            _product.results = ((this.results == null)?null:this.results.build());
            _product.errorSummary = ((this.errorSummary == null)?null:this.errorSummary.build());
            _product.jobInfo = ((this.jobInfo == null)?null:this.jobInfo.build());
            _product.version = this.version;
            return _product;
        }

        /**
         * Sets the new value of "jobId" (any previous value will be replaced)
         * 
         * @param jobId
         *     New value of the "jobId" property.
         */
        public Job.Builder<_B> withJobId(final String jobId) {
            this.jobId = jobId;
            return this;
        }

        /**
         * Sets the new value of "runId" (any previous value will be replaced)
         * 
         * @param runId
         *     New value of the "runId" property.
         */
        public Job.Builder<_B> withRunId(final String runId) {
            this.runId = runId;
            return this;
        }

        /**
         * Sets the new value of "ownerId" (any previous value will be replaced)
         * 
         * @param ownerId
         *     New value of the "ownerId" property.
         */
        public Job.Builder<_B> withOwnerId(final String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Sets the new value of "phase" (any previous value will be replaced)
         * 
         * @param phase
         *     New value of the "phase" property.
         */
        public Job.Builder<_B> withPhase(final ExecutionPhase phase) {
            this.phase = phase;
            return this;
        }

        /**
         * Sets the new value of "quote" (any previous value will be replaced)
         * 
         * @param quote
         *     New value of the "quote" property.
         */
        public Job.Builder<_B> withQuote(final ZonedDateTime quote) {
            this.quote = quote;
            return this;
        }

        /**
         * Sets the new value of "creationTime" (any previous value will be replaced)
         * 
         * @param creationTime
         *     New value of the "creationTime" property.
         */
        public Job.Builder<_B> withCreationTime(final ZonedDateTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        /**
         * Sets the new value of "startTime" (any previous value will be replaced)
         * 
         * @param startTime
         *     New value of the "startTime" property.
         */
        public Job.Builder<_B> withStartTime(final ZonedDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        /**
         * Sets the new value of "endTime" (any previous value will be replaced)
         * 
         * @param endTime
         *     New value of the "endTime" property.
         */
        public Job.Builder<_B> withEndTime(final ZonedDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        /**
         * Sets the new value of "executionDuration" (any previous value will be replaced)
         * 
         * @param executionDuration
         *     New value of the "executionDuration" property.
         */
        public Job.Builder<_B> withExecutionDuration(final int executionDuration) {
            this.executionDuration = executionDuration;
            return this;
        }

        /**
         * Sets the new value of "destruction" (any previous value will be replaced)
         * 
         * @param destruction
         *     New value of the "destruction" property.
         */
        public Job.Builder<_B> withDestruction(final ZonedDateTime destruction) {
            this.destruction = destruction;
            return this;
        }

        /**
         * Sets the new value of "parameters" (any previous value will be replaced)
         * 
         * @param parameters
         *     New value of the "parameters" property.
         */
        public Job.Builder<_B> withParameters(final Parameters parameters) {
            this.parameters = ((parameters == null)?null:new Parameters.Builder<>(this, parameters, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "parameters" property.
         * Use {@link org.javastro.ivoa.entities.uws.Parameters.Builder#end()} to return to
         * the current builder.
         * 
         * @return
         *     A new builder to build the value of the "parameters" property.
         *     Use {@link org.javastro.ivoa.entities.uws.Parameters.Builder#end()} to return to
         *     the current builder.
         */
        public Parameters.Builder<? extends Job.Builder<_B>> withParameters() {
            if (this.parameters!= null) {
                return this.parameters;
            }
            return this.parameters = new Parameters.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "results" (any previous value will be replaced)
         * 
         * @param results
         *     New value of the "results" property.
         */
        public Job.Builder<_B> withResults(final Results results) {
            this.results = ((results == null)?null:new Results.Builder<>(this, results, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "results" property.
         * Use {@link org.javastro.ivoa.entities.uws.Results.Builder#end()} to return to
         * the current builder.
         * 
         * @return
         *     A new builder to build the value of the "results" property.
         *     Use {@link org.javastro.ivoa.entities.uws.Results.Builder#end()} to return to
         *     the current builder.
         */
        public Results.Builder<? extends Job.Builder<_B>> withResults() {
            if (this.results!= null) {
                return this.results;
            }
            return this.results = new Results.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "errorSummary" (any previous value will be replaced)
         * 
         * @param errorSummary
         *     New value of the "errorSummary" property.
         */
        public Job.Builder<_B> withErrorSummary(final ErrorSummary errorSummary) {
            this.errorSummary = ((errorSummary == null)?null:new ErrorSummary.Builder<>(this, errorSummary, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "errorSummary" property.
         * Use {@link org.javastro.ivoa.entities.uws.ErrorSummary.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "errorSummary" property.
         *     Use {@link org.javastro.ivoa.entities.uws.ErrorSummary.Builder#end()} to return
         *     to the current builder.
         */
        public ErrorSummary.Builder<? extends Job.Builder<_B>> withErrorSummary() {
            if (this.errorSummary!= null) {
                return this.errorSummary;
            }
            return this.errorSummary = new ErrorSummary.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "jobInfo" (any previous value will be replaced)
         * 
         * @param jobInfo
         *     New value of the "jobInfo" property.
         */
        public Job.Builder<_B> withJobInfo(final Job.JobInfo jobInfo) {
            this.jobInfo = ((jobInfo == null)?null:new Job.JobInfo.Builder<>(this, jobInfo, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "jobInfo" property.
         * Use {@link org.javastro.ivoa.entities.uws.Job.JobInfo.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "jobInfo" property.
         *     Use {@link org.javastro.ivoa.entities.uws.Job.JobInfo.Builder#end()} to return
         *     to the current builder.
         */
        public Job.JobInfo.Builder<? extends Job.Builder<_B>> withJobInfo() {
            if (this.jobInfo!= null) {
                return this.jobInfo;
            }
            return this.jobInfo = new Job.JobInfo.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        public Job.Builder<_B> withVersion(final String version) {
            this.version = version;
            return this;
        }

        @Override
        public Job build() {
            if (_storedValue == null) {
                return this.init(new Job());
            } else {
                return ((Job) _storedValue);
            }
        }

        public Job.Builder<_B> copyOf(final Job _other) {
            _other.copyTo(this);
            return this;
        }

        public Job.Builder<_B> copyOf(final Job.Builder _other) {
            return copyOf(_other.build());
        }

    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <sequence>
     *         <any processContents='lax' maxOccurs="unbounded" minOccurs="0"/>
     *       </sequence>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "anies"
    })
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static class JobInfo implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
    {

        @XmlAnyElement
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        protected List<Element> anies;
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        protected transient Job.JobInfo.Modifier __cachedModifier__;

        /**
         * Default no-arg constructor
         * 
         */
        public JobInfo() {
            super();
        }

        /**
         * Fully-initialising value constructor
         * 
         */
        public JobInfo(final List<Element> anies) {
            this.anies = anies;
        }

        /**
         * Gets the value of the anies property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the anies property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getAnies().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link Element }
         * </p>
         * 
         * 
         * @return
         *     The value of the anies property.
         */
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public List<Element> getAnies() {
            if (anies == null) {
                anies = new ArrayList<>();
            }
            return this.anies;
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public boolean equals(Object object) {
            if ((object == null)||(this.getClass()!= object.getClass())) {
                return false;
            }
            if (this == object) {
                return true;
            }
            final Job.JobInfo that = ((Job.JobInfo) object);
            {
                List<Element> leftAnies;
                leftAnies = (((this.anies!= null)&&(!this.anies.isEmpty()))?this.getAnies():null);
                List<Element> rightAnies;
                rightAnies = (((that.anies!= null)&&(!that.anies.isEmpty()))?that.getAnies():null);
                if ((this.anies!= null)&&(!this.anies.isEmpty())) {
                    if ((that.anies!= null)&&(!that.anies.isEmpty())) {
                        if (!leftAnies.equals(rightAnies)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } else {
                    if ((that.anies!= null)&&(!that.anies.isEmpty())) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public int hashCode() {
            int currentHashCode = 1;
            {
                currentHashCode = (currentHashCode* 31);
                List<Element> theAnies;
                theAnies = (((this.anies!= null)&&(!this.anies.isEmpty()))?this.getAnies():null);
                if ((this.anies!= null)&&(!this.anies.isEmpty())) {
                    currentHashCode += theAnies.hashCode();
                }
            }
            return currentHashCode;
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public String toString() {
            final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
            final StringBuilder buffer = new StringBuilder();
            append(null, buffer, strategy);
            return buffer.toString();
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
            strategy.appendStart(locator, this, buffer);
            appendFields(locator, buffer, strategy);
            strategy.appendEnd(locator, this, buffer);
            return buffer;
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
            {
                List<Element> theAnies;
                theAnies = (((this.anies!= null)&&(!this.anies.isEmpty()))?this.getAnies():null);
                strategy.appendField(locator, this, "anies", buffer, theAnies, ((this.anies!= null)&&(!this.anies.isEmpty())));
            }
            return buffer;
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public void mergeFrom(Object left, Object right) {
            final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
            mergeFrom(null, null, left, right, strategy);
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
            if (right instanceof Job.JobInfo) {
                final Job.JobInfo target = this;
                final Job.JobInfo leftObject = ((Job.JobInfo) left);
                final Job.JobInfo rightObject = ((Job.JobInfo) right);
                {
                    Boolean aniesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.anies!= null)&&(!leftObject.anies.isEmpty())), ((rightObject.anies!= null)&&(!rightObject.anies.isEmpty())));
                    if (aniesShouldBeMergedAndSet == Boolean.TRUE) {
                        List<Element> lhsAnies;
                        lhsAnies = (((leftObject.anies!= null)&&(!leftObject.anies.isEmpty()))?leftObject.getAnies():null);
                        List<Element> rhsAnies;
                        rhsAnies = (((rightObject.anies!= null)&&(!rightObject.anies.isEmpty()))?rightObject.getAnies():null);
                        List<Element> mergedAnies = ((List<Element> ) strategy.merge(LocatorUtils.property(leftLocator, "anies", lhsAnies), LocatorUtils.property(rightLocator, "anies", rhsAnies), lhsAnies, rhsAnies, ((leftObject.anies!= null)&&(!leftObject.anies.isEmpty())), ((rightObject.anies!= null)&&(!rightObject.anies.isEmpty()))));
                        target.anies = null;
                        if (mergedAnies!= null) {
                            List<Element> uniqueAniesl = target.getAnies();
                            uniqueAniesl.addAll(mergedAnies);
                        }
                    } else {
                        if (aniesShouldBeMergedAndSet == Boolean.FALSE) {
                            target.anies = null;
                        }
                    }
                }
            }
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public Object createNewInstance() {
            return new Job.JobInfo();
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public Job.JobInfo clone() {
            final Job.JobInfo _newObject;
            try {
                _newObject = ((Job.JobInfo) super.clone());
            } catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            _newObject.anies = ((this.anies == null)?null:new ArrayList<>(this.anies));
            return _newObject;
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public Job.JobInfo createCopy() {
            final Job.JobInfo _newObject;
            try {
                _newObject = ((Job.JobInfo) super.clone());
            } catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            _newObject.anies = ((this.anies == null)?null:new ArrayList<>(this.anies));
            return _newObject;
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public Job.JobInfo createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            final Job.JobInfo _newObject;
            try {
                _newObject = ((Job.JobInfo) super.clone());
            } catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            final PropertyTree aniesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("anies"));
            if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(aniesPropertyTree!= null):((aniesPropertyTree == null)||(!aniesPropertyTree.isLeaf())))) {
                _newObject.anies = ((this.anies == null)?null:new ArrayList<>(this.anies));
            }
            return _newObject;
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public Job.JobInfo copyExcept(final PropertyTree _propertyTree) {
            return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
        }

        @Override
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public Job.JobInfo copyOnly(final PropertyTree _propertyTree) {
            return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public Job.JobInfo.Modifier modifier() {
            if (null == this.__cachedModifier__) {
                this.__cachedModifier__ = new Job.JobInfo.Modifier();
            }
            return ((Job.JobInfo.Modifier) this.__cachedModifier__);
        }

        /**
         * Copies all state of this object to a builder. This method is used by the copyOf
         * method and should not be called directly by client code.
         * 
         * @param _other
         *     A builder instance to which the state of this object will be copied.
         */
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public<_B >void copyTo(final Job.JobInfo.Builder<_B> _other) {
            if (this.anies == null) {
                _other.anies = null;
            } else {
                _other.anies = new ArrayList<>();
                for (Element _item: this.anies) {
                    _other.anies.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public<_B >Job.JobInfo.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
            return new Job.JobInfo.Builder<_B>(_parentBuilder, this, true);
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public Job.JobInfo.Builder<Void> newCopyBuilder() {
            return newCopyBuilder(null);
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public static Job.JobInfo.Builder<Void> builder() {
            return new Job.JobInfo.Builder<>(null, null, false);
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public static<_B >Job.JobInfo.Builder<_B> copyOf(final Job.JobInfo _other) {
            final Job.JobInfo.Builder<_B> _newBuilder = new Job.JobInfo.Builder<>(null, null, false);
            _other.copyTo(_newBuilder);
            return _newBuilder;
        }

        /**
         * Copies all state of this object to a builder. This method is used by the copyOf
         * method and should not be called directly by client code.
         * 
         * @param _other
         *     A builder instance to which the state of this object will be copied.
         */
        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public<_B >void copyTo(final Job.JobInfo.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            final PropertyTree aniesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("anies"));
            if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(aniesPropertyTree!= null):((aniesPropertyTree == null)||(!aniesPropertyTree.isLeaf())))) {
                if (this.anies == null) {
                    _other.anies = null;
                } else {
                    _other.anies = new ArrayList<>();
                    for (Element _item: this.anies) {
                        _other.anies.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
            }
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public<_B >Job.JobInfo.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            return new Job.JobInfo.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public Job.JobInfo.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public static<_B >Job.JobInfo.Builder<_B> copyOf(final Job.JobInfo _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            final Job.JobInfo.Builder<_B> _newBuilder = new Job.JobInfo.Builder<>(null, null, false);
            _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
            return _newBuilder;
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public static Job.JobInfo.Builder<Void> copyExcept(final Job.JobInfo _other, final PropertyTree _propertyTree) {
            return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public static Job.JobInfo.Builder<Void> copyOnly(final Job.JobInfo _other, final PropertyTree _propertyTree) {
            return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
        }

        @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
        public Job.JobInfo visit(final PropertyVisitor _visitor_) {
            _visitor_.visit(this);
            _visitor_.visit(new CollectionProperty<>(Job.JobInfo.PropInfo.ANIES, this));
            return this;
        }

        public static class Builder<_B >implements Buildable
        {

            protected final _B _parentBuilder;
            protected final Job.JobInfo _storedValue;
            private List<Buildable> anies;

            public Builder(final _B _parentBuilder, final Job.JobInfo _other, final boolean _copy) {
                this._parentBuilder = _parentBuilder;
                if (_other!= null) {
                    if (_copy) {
                        _storedValue = null;
                        if (_other.anies == null) {
                            this.anies = null;
                        } else {
                            this.anies = new ArrayList<>();
                            for (Element _item: _other.anies) {
                                this.anies.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    } else {
                        _storedValue = _other;
                    }
                } else {
                    _storedValue = null;
                }
            }

            public Builder(final _B _parentBuilder, final Job.JobInfo _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
                this._parentBuilder = _parentBuilder;
                if (_other!= null) {
                    if (_copy) {
                        _storedValue = null;
                        final PropertyTree aniesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("anies"));
                        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(aniesPropertyTree!= null):((aniesPropertyTree == null)||(!aniesPropertyTree.isLeaf())))) {
                            if (_other.anies == null) {
                                this.anies = null;
                            } else {
                                this.anies = new ArrayList<>();
                                for (Element _item: _other.anies) {
                                    this.anies.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                                }
                            }
                        }
                    } else {
                        _storedValue = _other;
                    }
                } else {
                    _storedValue = null;
                }
            }

            public _B end() {
                return this._parentBuilder;
            }

            protected<_P extends Job.JobInfo >_P init(final _P _product) {
                if (this.anies!= null) {
                    final List<Element> anies = new ArrayList<>(this.anies.size());
                    for (Buildable _item: this.anies) {
                        anies.add(((Element) _item.build()));
                    }
                    _product.anies = anies;
                }
                return _product;
            }

            /**
             * Adds the given items to the value of "anies"
             * 
             * @param anies
             *     Items to add to the value of the "anies" property
             */
            public Job.JobInfo.Builder<_B> addAnies(final Iterable<? extends Element> anies) {
                if (anies!= null) {
                    if (this.anies == null) {
                        this.anies = new ArrayList<>();
                    }
                    for (Element _item: anies) {
                        this.anies.add(new Buildable.PrimitiveBuildable(_item));
                    }
                }
                return this;
            }

            /**
             * Sets the new value of "anies" (any previous value will be replaced)
             * 
             * @param anies
             *     New value of the "anies" property.
             */
            public Job.JobInfo.Builder<_B> withAnies(final Iterable<? extends Element> anies) {
                if (this.anies!= null) {
                    this.anies.clear();
                }
                return addAnies(anies);
            }

            /**
             * Adds the given items to the value of "anies"
             * 
             * @param anies
             *     Items to add to the value of the "anies" property
             */
            public Job.JobInfo.Builder<_B> addAnies(Element... anies) {
                addAnies(Arrays.asList(anies));
                return this;
            }

            /**
             * Sets the new value of "anies" (any previous value will be replaced)
             * 
             * @param anies
             *     New value of the "anies" property.
             */
            public Job.JobInfo.Builder<_B> withAnies(Element... anies) {
                withAnies(Arrays.asList(anies));
                return this;
            }

            @Override
            public Job.JobInfo build() {
                if (_storedValue == null) {
                    return this.init(new Job.JobInfo());
                } else {
                    return ((Job.JobInfo) _storedValue);
                }
            }

            public Job.JobInfo.Builder<_B> copyOf(final Job.JobInfo _other) {
                _other.copyTo(this);
                return this;
            }

            public Job.JobInfo.Builder<_B> copyOf(final Job.JobInfo.Builder _other) {
                return copyOf(_other.build());
            }

        }

        public class Modifier {


            public List<Element> getAnies() {
                if (Job.JobInfo.this.anies == null) {
                    Job.JobInfo.this.anies = new ArrayList<>();
                }
                return Job.JobInfo.this.anies;
            }

        }

        public static class PropInfo {

            public static final transient CollectionPropertyInfo<Job.JobInfo, Element> ANIES = new CollectionPropertyInfo<JobInfo,Element>("anies", Job.JobInfo.class, Element.class, true, null, new QName("", "*"), new QName("", "*"), false) {


                @Override
                public List<Element> get(final Job.JobInfo _instance_) {
                    return ((_instance_ == null)?null:_instance_.anies);
                }

                @Override
                public void set(final Job.JobInfo _instance_, final List<Element> _value_) {
                    if (_instance_!= null) {
                        _instance_.anies = _value_;
                    }
                }

            }
            ;

        }

        public static class Select
            extends Job.JobInfo.Selector<Job.JobInfo.Select, Void>
        {


            Select() {
                super(null, null, null);
            }

            public static Job.JobInfo.Select _root() {
                return new Job.JobInfo.Select();
            }

        }

        public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
            extends com.kscs.util.jaxb.Selector<TRoot, TParent>
        {

            private com.kscs.util.jaxb.Selector<TRoot, Job.JobInfo.Selector<TRoot, TParent>> anies = null;

            public Selector(final TRoot root, final TParent parent, final String propertyName) {
                super(root, parent, propertyName);
            }

            @Override
            public Map<String, PropertyTree> buildChildren() {
                final Map<String, PropertyTree> products = new HashMap<>();
                products.putAll(super.buildChildren());
                if (this.anies!= null) {
                    products.put("anies", this.anies.init());
                }
                return products;
            }

            public com.kscs.util.jaxb.Selector<TRoot, Job.JobInfo.Selector<TRoot, TParent>> anies() {
                return ((this.anies == null)?this.anies = new com.kscs.util.jaxb.Selector<>(this._root, this, "anies"):this.anies);
            }

        }

    }

    public class Modifier {


        public void setJobId(final String jobId) {
            Job.this.setJobId(jobId);
        }

        public void setRunId(final String runId) {
            Job.this.setRunId(runId);
        }

        public void setOwnerId(final String ownerId) {
            Job.this.setOwnerId(ownerId);
        }

        public void setPhase(final ExecutionPhase phase) {
            Job.this.setPhase(phase);
        }

        public void setQuote(final ZonedDateTime quote) {
            Job.this.setQuote(quote);
        }

        public void setCreationTime(final ZonedDateTime creationTime) {
            Job.this.setCreationTime(creationTime);
        }

        public void setStartTime(final ZonedDateTime startTime) {
            Job.this.setStartTime(startTime);
        }

        public void setEndTime(final ZonedDateTime endTime) {
            Job.this.setEndTime(endTime);
        }

        public void setExecutionDuration(final int executionDuration) {
            Job.this.setExecutionDuration(executionDuration);
        }

        public void setDestruction(final ZonedDateTime destruction) {
            Job.this.setDestruction(destruction);
        }

        public void setParameters(final Parameters parameters) {
            Job.this.setParameters(parameters);
        }

        public void setResults(final Results results) {
            Job.this.setResults(results);
        }

        public void setErrorSummary(final ErrorSummary errorSummary) {
            Job.this.setErrorSummary(errorSummary);
        }

        public void setJobInfo(final Job.JobInfo jobInfo) {
            Job.this.setJobInfo(jobInfo);
        }

        public void setVersion(final String version) {
            Job.this.setVersion(version);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Job, String> JOB_ID = new SinglePropertyInfo<Job,String>("jobId", Job.class, String.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "jobId"), new QName("http://www.ivoa.net/xml/UWS/v1.0", "JobIdentifier"), false) {


            @Override
            public String get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.jobId);
            }

            @Override
            public void set(final Job _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.jobId = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, String> RUN_ID = new SinglePropertyInfo<Job,String>("runId", Job.class, String.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "runId"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.runId);
            }

            @Override
            public void set(final Job _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.runId = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, String> OWNER_ID = new SinglePropertyInfo<Job,String>("ownerId", Job.class, String.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "ownerId"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.ownerId);
            }

            @Override
            public void set(final Job _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.ownerId = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, ExecutionPhase> PHASE = new SinglePropertyInfo<Job,ExecutionPhase>("phase", Job.class, ExecutionPhase.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "phase"), new QName("http://www.ivoa.net/xml/UWS/v1.0", "ExecutionPhase"), false) {


            @Override
            public ExecutionPhase get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.phase);
            }

            @Override
            public void set(final Job _instance_, final ExecutionPhase _value_) {
                if (_instance_!= null) {
                    _instance_.phase = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, ZonedDateTime> QUOTE = new SinglePropertyInfo<Job,ZonedDateTime>("quote", Job.class, ZonedDateTime.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "quote"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), false) {


            @Override
            public ZonedDateTime get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.quote);
            }

            @Override
            public void set(final Job _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.quote = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, ZonedDateTime> CREATION_TIME = new SinglePropertyInfo<Job,ZonedDateTime>("creationTime", Job.class, ZonedDateTime.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "creationTime"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), false) {


            @Override
            public ZonedDateTime get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.creationTime);
            }

            @Override
            public void set(final Job _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.creationTime = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, ZonedDateTime> START_TIME = new SinglePropertyInfo<Job,ZonedDateTime>("startTime", Job.class, ZonedDateTime.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "startTime"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), false) {


            @Override
            public ZonedDateTime get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.startTime);
            }

            @Override
            public void set(final Job _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.startTime = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, ZonedDateTime> END_TIME = new SinglePropertyInfo<Job,ZonedDateTime>("endTime", Job.class, ZonedDateTime.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "endTime"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), false) {


            @Override
            public ZonedDateTime get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.endTime);
            }

            @Override
            public void set(final Job _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.endTime = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, Integer> EXECUTION_DURATION = new SinglePropertyInfo<Job,Integer>("executionDuration", Job.class, Integer.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "executionDuration"), new QName("http://www.w3.org/2001/XMLSchema", "int"), false) {


            @Override
            public Integer get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.executionDuration);
            }

            @Override
            public void set(final Job _instance_, final Integer _value_) {
                if (_instance_!= null) {
                    _instance_.executionDuration = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, ZonedDateTime> DESTRUCTION = new SinglePropertyInfo<Job,ZonedDateTime>("destruction", Job.class, ZonedDateTime.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "destruction"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), false) {


            @Override
            public ZonedDateTime get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.destruction);
            }

            @Override
            public void set(final Job _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.destruction = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, Parameters> PARAMETERS = new SinglePropertyInfo<Job,Parameters>("parameters", Job.class, Parameters.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "parameters"), new QName("http://www.ivoa.net/xml/UWS/v1.0", "anononymousElementType"), false) {


            @Override
            public Parameters get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.parameters);
            }

            @Override
            public void set(final Job _instance_, final Parameters _value_) {
                if (_instance_!= null) {
                    _instance_.parameters = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, Results> RESULTS = new SinglePropertyInfo<Job,Results>("results", Job.class, Results.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "results"), new QName("http://www.ivoa.net/xml/UWS/v1.0", "anononymousElementType"), false) {


            @Override
            public Results get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.results);
            }

            @Override
            public void set(final Job _instance_, final Results _value_) {
                if (_instance_!= null) {
                    _instance_.results = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, ErrorSummary> ERROR_SUMMARY = new SinglePropertyInfo<Job,ErrorSummary>("errorSummary", Job.class, ErrorSummary.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "errorSummary"), new QName("http://www.ivoa.net/xml/UWS/v1.0", "ErrorSummary"), false) {


            @Override
            public ErrorSummary get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.errorSummary);
            }

            @Override
            public void set(final Job _instance_, final ErrorSummary _value_) {
                if (_instance_!= null) {
                    _instance_.errorSummary = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, Job.JobInfo> JOB_INFO = new SinglePropertyInfo<Job,JobInfo>("jobInfo", Job.class, Job.JobInfo.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "jobInfo"), new QName("http://www.ivoa.net/xml/UWS/v1.0", "anononymousElementType"), false) {


            @Override
            public Job.JobInfo get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.jobInfo);
            }

            @Override
            public void set(final Job _instance_, final Job.JobInfo _value_) {
                if (_instance_!= null) {
                    _instance_.jobInfo = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Job, String> VERSION = new SinglePropertyInfo<Job,String>("version", Job.class, String.class, false, null, new QName("", "version"), new QName("http://www.ivoa.net/xml/UWS/v1.0", "UWSVersion"), true) {


            @Override
            public String get(final Job _instance_) {
                return ((_instance_ == null)?null:_instance_.version);
            }

            @Override
            public void set(final Job _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.version = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Job.Selector<Job.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Job.Select _root() {
            return new Job.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> jobId = null;
        private com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> runId = null;
        private com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> ownerId = null;
        private com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> phase = null;
        private com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> quote = null;
        private com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> creationTime = null;
        private com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> startTime = null;
        private com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> endTime = null;
        private com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> destruction = null;
        private Parameters.Selector<TRoot, Job.Selector<TRoot, TParent>> parameters = null;
        private Results.Selector<TRoot, Job.Selector<TRoot, TParent>> results = null;
        private ErrorSummary.Selector<TRoot, Job.Selector<TRoot, TParent>> errorSummary = null;
        private Job.JobInfo.Selector<TRoot, Job.Selector<TRoot, TParent>> jobInfo = null;
        private com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> version = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.jobId!= null) {
                products.put("jobId", this.jobId.init());
            }
            if (this.runId!= null) {
                products.put("runId", this.runId.init());
            }
            if (this.ownerId!= null) {
                products.put("ownerId", this.ownerId.init());
            }
            if (this.phase!= null) {
                products.put("phase", this.phase.init());
            }
            if (this.quote!= null) {
                products.put("quote", this.quote.init());
            }
            if (this.creationTime!= null) {
                products.put("creationTime", this.creationTime.init());
            }
            if (this.startTime!= null) {
                products.put("startTime", this.startTime.init());
            }
            if (this.endTime!= null) {
                products.put("endTime", this.endTime.init());
            }
            if (this.destruction!= null) {
                products.put("destruction", this.destruction.init());
            }
            if (this.parameters!= null) {
                products.put("parameters", this.parameters.init());
            }
            if (this.results!= null) {
                products.put("results", this.results.init());
            }
            if (this.errorSummary!= null) {
                products.put("errorSummary", this.errorSummary.init());
            }
            if (this.jobInfo!= null) {
                products.put("jobInfo", this.jobInfo.init());
            }
            if (this.version!= null) {
                products.put("version", this.version.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> jobId() {
            return ((this.jobId == null)?this.jobId = new com.kscs.util.jaxb.Selector<>(this._root, this, "jobId"):this.jobId);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> runId() {
            return ((this.runId == null)?this.runId = new com.kscs.util.jaxb.Selector<>(this._root, this, "runId"):this.runId);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> ownerId() {
            return ((this.ownerId == null)?this.ownerId = new com.kscs.util.jaxb.Selector<>(this._root, this, "ownerId"):this.ownerId);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> phase() {
            return ((this.phase == null)?this.phase = new com.kscs.util.jaxb.Selector<>(this._root, this, "phase"):this.phase);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> quote() {
            return ((this.quote == null)?this.quote = new com.kscs.util.jaxb.Selector<>(this._root, this, "quote"):this.quote);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> creationTime() {
            return ((this.creationTime == null)?this.creationTime = new com.kscs.util.jaxb.Selector<>(this._root, this, "creationTime"):this.creationTime);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> startTime() {
            return ((this.startTime == null)?this.startTime = new com.kscs.util.jaxb.Selector<>(this._root, this, "startTime"):this.startTime);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> endTime() {
            return ((this.endTime == null)?this.endTime = new com.kscs.util.jaxb.Selector<>(this._root, this, "endTime"):this.endTime);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> destruction() {
            return ((this.destruction == null)?this.destruction = new com.kscs.util.jaxb.Selector<>(this._root, this, "destruction"):this.destruction);
        }

        public Parameters.Selector<TRoot, Job.Selector<TRoot, TParent>> parameters() {
            return ((this.parameters == null)?this.parameters = new Parameters.Selector<>(this._root, this, "parameters"):this.parameters);
        }

        public Results.Selector<TRoot, Job.Selector<TRoot, TParent>> results() {
            return ((this.results == null)?this.results = new Results.Selector<>(this._root, this, "results"):this.results);
        }

        public ErrorSummary.Selector<TRoot, Job.Selector<TRoot, TParent>> errorSummary() {
            return ((this.errorSummary == null)?this.errorSummary = new ErrorSummary.Selector<>(this._root, this, "errorSummary"):this.errorSummary);
        }

        public Job.JobInfo.Selector<TRoot, Job.Selector<TRoot, TParent>> jobInfo() {
            return ((this.jobInfo == null)?this.jobInfo = new Job.JobInfo.Selector<>(this._root, this, "jobInfo"):this.jobInfo);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Job.Selector<TRoot, TParent>> version() {
            return ((this.version == null)?this.version = new com.kscs.util.jaxb.Selector<>(this._root, this, "version"):this.version);
        }

    }

}
