
package org.javastro.ivoa.entities.uws;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.javastro.ivoa.jaxb.adapters.ZonedDateTimeXmlAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Java class for ShortJobDescription complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ShortJobDescription">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="phase" type="{http://www.ivoa.net/xml/UWS/v1.0}ExecutionPhase"/>
 *         <element name="runId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="ownerId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="creationTime" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *       </sequence>
 *       <attGroup ref="{http://www.ivoa.net/xml/UWS/v1.0}reference"/>
 *       <attribute name="id" use="required" type="{http://www.ivoa.net/xml/UWS/v1.0}JobIdentifier" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ShortJobDescription", propOrder = {
    "phase",
    "runId",
    "ownerId",
    "creationTime"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class ShortJobDescription implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * the execution phase - returned at
     *                      /{jobs}/{job-id}/phase
     * 
     */
    @XmlElement(required = true)
    @XmlSchemaType(name = "string")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ExecutionPhase phase;
    /**
     * this is a client supplied identifier - the UWS system
     *                   does nothing other than to return it as part of the
     *                   description of the job
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String runId;
    /**
     * the owner (creator) of the job - this should be
     *                   expressed as a string that can be parsed in accordance
     *                   with IVOA security standards. If there was no
     *                   authenticated job creator then this should be set to
     *                   NULL.
     * 
     */
    @XmlElement(nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String ownerId;
    /**
     * The instant at which the job was created.
     * 
     */
    @XmlElement(type = String.class)
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ZonedDateTime creationTime;
    @XmlAttribute(name = "id", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String id;
    @XmlAttribute(name = "type", namespace = "http://www.w3.org/1999/xlink")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String type;
    @XmlAttribute(name = "href", namespace = "http://www.w3.org/1999/xlink")
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String href;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient ShortJobDescription.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public ShortJobDescription() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public ShortJobDescription(final ExecutionPhase phase, final String runId, final String ownerId, final ZonedDateTime creationTime, final String id, final String type, final String href) {
        this.phase = phase;
        this.runId = runId;
        this.ownerId = ownerId;
        this.creationTime = creationTime;
        this.id = id;
        this.type = type;
        this.href = href;
    }

    /**
     * the execution phase - returned at
     *                      /{jobs}/{job-id}/phase
     * 
     * @return
     *     possible object is
     *     {@link ExecutionPhase }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ExecutionPhase getPhase() {
        return phase;
    }

    /**
     * Sets the value of the phase property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExecutionPhase }
     *     
     * @see #getPhase()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setPhase(ExecutionPhase value) {
        this.phase = value;
    }

    /**
     * this is a client supplied identifier - the UWS system
     *                   does nothing other than to return it as part of the
     *                   description of the job
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getRunId() {
        return runId;
    }

    /**
     * Sets the value of the runId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getRunId()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setRunId(String value) {
        this.runId = value;
    }

    /**
     * the owner (creator) of the job - this should be
     *                   expressed as a string that can be parsed in accordance
     *                   with IVOA security standards. If there was no
     *                   authenticated job creator then this should be set to
     *                   NULL.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getOwnerId() {
        return ownerId;
    }

    /**
     * Sets the value of the ownerId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getOwnerId()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setOwnerId(String value) {
        this.ownerId = value;
    }

    /**
     * The instant at which the job was created.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ZonedDateTime getCreationTime() {
        return creationTime;
    }

    /**
     * Sets the value of the creationTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreationTime()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setCreationTime(ZonedDateTime value) {
        this.creationTime = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getType() {
        if (type == null) {
            return "simple";
        } else {
            return type;
        }
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets the value of the href property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getHref() {
        return href;
    }

    /**
     * Sets the value of the href property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setHref(String value) {
        this.href = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ShortJobDescription that = ((ShortJobDescription) object);
        {
            ExecutionPhase leftPhase;
            leftPhase = this.getPhase();
            ExecutionPhase rightPhase;
            rightPhase = that.getPhase();
            if (this.phase!= null) {
                if (that.phase!= null) {
                    if (!leftPhase.equals(rightPhase)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.phase!= null) {
                    return false;
                }
            }
        }
        {
            String leftRunId;
            leftRunId = this.getRunId();
            String rightRunId;
            rightRunId = that.getRunId();
            if (this.runId!= null) {
                if (that.runId!= null) {
                    if (!leftRunId.equals(rightRunId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.runId!= null) {
                    return false;
                }
            }
        }
        {
            String leftOwnerId;
            leftOwnerId = this.getOwnerId();
            String rightOwnerId;
            rightOwnerId = that.getOwnerId();
            if (this.ownerId!= null) {
                if (that.ownerId!= null) {
                    if (!leftOwnerId.equals(rightOwnerId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.ownerId!= null) {
                    return false;
                }
            }
        }
        {
            ZonedDateTime leftCreationTime;
            leftCreationTime = this.getCreationTime();
            ZonedDateTime rightCreationTime;
            rightCreationTime = that.getCreationTime();
            if (this.creationTime!= null) {
                if (that.creationTime!= null) {
                    if (!leftCreationTime.equals(rightCreationTime)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.creationTime!= null) {
                    return false;
                }
            }
        }
        {
            String leftId;
            leftId = this.getId();
            String rightId;
            rightId = that.getId();
            if (this.id!= null) {
                if (that.id!= null) {
                    if (!leftId.equals(rightId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.id!= null) {
                    return false;
                }
            }
        }
        {
            String leftType;
            leftType = this.getType();
            String rightType;
            rightType = that.getType();
            if (this.type!= null) {
                if (that.type!= null) {
                    if (!leftType.equals(rightType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.type!= null) {
                    return false;
                }
            }
        }
        {
            String leftHref;
            leftHref = this.getHref();
            String rightHref;
            rightHref = that.getHref();
            if (this.href!= null) {
                if (that.href!= null) {
                    if (!leftHref.equals(rightHref)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.href!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            ExecutionPhase thePhase;
            thePhase = this.getPhase();
            if (this.phase!= null) {
                currentHashCode += thePhase.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theRunId;
            theRunId = this.getRunId();
            if (this.runId!= null) {
                currentHashCode += theRunId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theOwnerId;
            theOwnerId = this.getOwnerId();
            if (this.ownerId!= null) {
                currentHashCode += theOwnerId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theCreationTime;
            theCreationTime = this.getCreationTime();
            if (this.creationTime!= null) {
                currentHashCode += theCreationTime.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theId;
            theId = this.getId();
            if (this.id!= null) {
                currentHashCode += theId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theType;
            theType = this.getType();
            if (this.type!= null) {
                currentHashCode += theType.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theHref;
            theHref = this.getHref();
            if (this.href!= null) {
                currentHashCode += theHref.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            ExecutionPhase thePhase;
            thePhase = this.getPhase();
            strategy.appendField(locator, this, "phase", buffer, thePhase, (this.phase!= null));
        }
        {
            String theRunId;
            theRunId = this.getRunId();
            strategy.appendField(locator, this, "runId", buffer, theRunId, (this.runId!= null));
        }
        {
            String theOwnerId;
            theOwnerId = this.getOwnerId();
            strategy.appendField(locator, this, "ownerId", buffer, theOwnerId, (this.ownerId!= null));
        }
        {
            ZonedDateTime theCreationTime;
            theCreationTime = this.getCreationTime();
            strategy.appendField(locator, this, "creationTime", buffer, theCreationTime, (this.creationTime!= null));
        }
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId, (this.id!= null));
        }
        {
            String theType;
            theType = this.getType();
            strategy.appendField(locator, this, "type", buffer, theType, (this.type!= null));
        }
        {
            String theHref;
            theHref = this.getHref();
            strategy.appendField(locator, this, "href", buffer, theHref, (this.href!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof ShortJobDescription) {
            final ShortJobDescription target = this;
            final ShortJobDescription leftObject = ((ShortJobDescription) left);
            final ShortJobDescription rightObject = ((ShortJobDescription) right);
            {
                Boolean phaseShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.phase!= null), (rightObject.phase!= null));
                if (phaseShouldBeMergedAndSet == Boolean.TRUE) {
                    ExecutionPhase lhsPhase;
                    lhsPhase = leftObject.getPhase();
                    ExecutionPhase rhsPhase;
                    rhsPhase = rightObject.getPhase();
                    ExecutionPhase mergedPhase = ((ExecutionPhase) strategy.merge(LocatorUtils.property(leftLocator, "phase", lhsPhase), LocatorUtils.property(rightLocator, "phase", rhsPhase), lhsPhase, rhsPhase, (leftObject.phase!= null), (rightObject.phase!= null)));
                    target.setPhase(mergedPhase);
                } else {
                    if (phaseShouldBeMergedAndSet == Boolean.FALSE) {
                        target.phase = null;
                    }
                }
            }
            {
                Boolean runIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.runId!= null), (rightObject.runId!= null));
                if (runIdShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsRunId;
                    lhsRunId = leftObject.getRunId();
                    String rhsRunId;
                    rhsRunId = rightObject.getRunId();
                    String mergedRunId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "runId", lhsRunId), LocatorUtils.property(rightLocator, "runId", rhsRunId), lhsRunId, rhsRunId, (leftObject.runId!= null), (rightObject.runId!= null)));
                    target.setRunId(mergedRunId);
                } else {
                    if (runIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.runId = null;
                    }
                }
            }
            {
                Boolean ownerIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.ownerId!= null), (rightObject.ownerId!= null));
                if (ownerIdShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsOwnerId;
                    lhsOwnerId = leftObject.getOwnerId();
                    String rhsOwnerId;
                    rhsOwnerId = rightObject.getOwnerId();
                    String mergedOwnerId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "ownerId", lhsOwnerId), LocatorUtils.property(rightLocator, "ownerId", rhsOwnerId), lhsOwnerId, rhsOwnerId, (leftObject.ownerId!= null), (rightObject.ownerId!= null)));
                    target.setOwnerId(mergedOwnerId);
                } else {
                    if (ownerIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.ownerId = null;
                    }
                }
            }
            {
                Boolean creationTimeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.creationTime!= null), (rightObject.creationTime!= null));
                if (creationTimeShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsCreationTime;
                    lhsCreationTime = leftObject.getCreationTime();
                    ZonedDateTime rhsCreationTime;
                    rhsCreationTime = rightObject.getCreationTime();
                    ZonedDateTime mergedCreationTime = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "creationTime", lhsCreationTime), LocatorUtils.property(rightLocator, "creationTime", rhsCreationTime), lhsCreationTime, rhsCreationTime, (leftObject.creationTime!= null), (rightObject.creationTime!= null)));
                    target.setCreationTime(mergedCreationTime);
                } else {
                    if (creationTimeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.creationTime = null;
                    }
                }
            }
            {
                Boolean idShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.id!= null), (rightObject.id!= null));
                if (idShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsId;
                    lhsId = leftObject.getId();
                    String rhsId;
                    rhsId = rightObject.getId();
                    String mergedId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "id", lhsId), LocatorUtils.property(rightLocator, "id", rhsId), lhsId, rhsId, (leftObject.id!= null), (rightObject.id!= null)));
                    target.setId(mergedId);
                } else {
                    if (idShouldBeMergedAndSet == Boolean.FALSE) {
                        target.id = null;
                    }
                }
            }
            {
                Boolean typeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.type!= null), (rightObject.type!= null));
                if (typeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsType;
                    lhsType = leftObject.getType();
                    String rhsType;
                    rhsType = rightObject.getType();
                    String mergedType = ((String) strategy.merge(LocatorUtils.property(leftLocator, "type", lhsType), LocatorUtils.property(rightLocator, "type", rhsType), lhsType, rhsType, (leftObject.type!= null), (rightObject.type!= null)));
                    target.setType(mergedType);
                } else {
                    if (typeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.type = null;
                    }
                }
            }
            {
                Boolean hrefShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.href!= null), (rightObject.href!= null));
                if (hrefShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsHref;
                    lhsHref = leftObject.getHref();
                    String rhsHref;
                    rhsHref = rightObject.getHref();
                    String mergedHref = ((String) strategy.merge(LocatorUtils.property(leftLocator, "href", lhsHref), LocatorUtils.property(rightLocator, "href", rhsHref), lhsHref, rhsHref, (leftObject.href!= null), (rightObject.href!= null)));
                    target.setHref(mergedHref);
                } else {
                    if (hrefShouldBeMergedAndSet == Boolean.FALSE) {
                        target.href = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new ShortJobDescription();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ShortJobDescription clone() {
        final ShortJobDescription _newObject;
        try {
            _newObject = ((ShortJobDescription) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ShortJobDescription createCopy() {
        final ShortJobDescription _newObject;
        try {
            _newObject = ((ShortJobDescription) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.phase = this.phase;
        _newObject.runId = this.runId;
        _newObject.ownerId = this.ownerId;
        _newObject.creationTime = this.creationTime;
        _newObject.id = this.id;
        _newObject.type = this.type;
        _newObject.href = this.href;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ShortJobDescription createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ShortJobDescription _newObject;
        try {
            _newObject = ((ShortJobDescription) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree phasePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("phase"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(phasePropertyTree!= null):((phasePropertyTree == null)||(!phasePropertyTree.isLeaf())))) {
            _newObject.phase = this.phase;
        }
        final PropertyTree runIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("runId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(runIdPropertyTree!= null):((runIdPropertyTree == null)||(!runIdPropertyTree.isLeaf())))) {
            _newObject.runId = this.runId;
        }
        final PropertyTree ownerIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ownerId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ownerIdPropertyTree!= null):((ownerIdPropertyTree == null)||(!ownerIdPropertyTree.isLeaf())))) {
            _newObject.ownerId = this.ownerId;
        }
        final PropertyTree creationTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("creationTime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(creationTimePropertyTree!= null):((creationTimePropertyTree == null)||(!creationTimePropertyTree.isLeaf())))) {
            _newObject.creationTime = this.creationTime;
        }
        final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
            _newObject.id = this.id;
        }
        final PropertyTree typePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("type"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(typePropertyTree!= null):((typePropertyTree == null)||(!typePropertyTree.isLeaf())))) {
            _newObject.type = this.type;
        }
        final PropertyTree hrefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("href"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(hrefPropertyTree!= null):((hrefPropertyTree == null)||(!hrefPropertyTree.isLeaf())))) {
            _newObject.href = this.href;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ShortJobDescription copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ShortJobDescription copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ShortJobDescription.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new ShortJobDescription.Modifier();
        }
        return ((ShortJobDescription.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final ShortJobDescription.Builder<_B> _other) {
        _other.phase = this.phase;
        _other.runId = this.runId;
        _other.ownerId = this.ownerId;
        _other.creationTime = this.creationTime;
        _other.id = this.id;
        _other.type = this.type;
        _other.href = this.href;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >ShortJobDescription.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new ShortJobDescription.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ShortJobDescription.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ShortJobDescription.Builder<Void> builder() {
        return new ShortJobDescription.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ShortJobDescription.Builder<_B> copyOf(final ShortJobDescription _other) {
        final ShortJobDescription.Builder<_B> _newBuilder = new ShortJobDescription.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final ShortJobDescription.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree phasePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("phase"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(phasePropertyTree!= null):((phasePropertyTree == null)||(!phasePropertyTree.isLeaf())))) {
            _other.phase = this.phase;
        }
        final PropertyTree runIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("runId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(runIdPropertyTree!= null):((runIdPropertyTree == null)||(!runIdPropertyTree.isLeaf())))) {
            _other.runId = this.runId;
        }
        final PropertyTree ownerIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ownerId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ownerIdPropertyTree!= null):((ownerIdPropertyTree == null)||(!ownerIdPropertyTree.isLeaf())))) {
            _other.ownerId = this.ownerId;
        }
        final PropertyTree creationTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("creationTime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(creationTimePropertyTree!= null):((creationTimePropertyTree == null)||(!creationTimePropertyTree.isLeaf())))) {
            _other.creationTime = this.creationTime;
        }
        final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
            _other.id = this.id;
        }
        final PropertyTree typePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("type"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(typePropertyTree!= null):((typePropertyTree == null)||(!typePropertyTree.isLeaf())))) {
            _other.type = this.type;
        }
        final PropertyTree hrefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("href"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(hrefPropertyTree!= null):((hrefPropertyTree == null)||(!hrefPropertyTree.isLeaf())))) {
            _other.href = this.href;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >ShortJobDescription.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new ShortJobDescription.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ShortJobDescription.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ShortJobDescription.Builder<_B> copyOf(final ShortJobDescription _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ShortJobDescription.Builder<_B> _newBuilder = new ShortJobDescription.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ShortJobDescription.Builder<Void> copyExcept(final ShortJobDescription _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ShortJobDescription.Builder<Void> copyOnly(final ShortJobDescription _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ShortJobDescription visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(ShortJobDescription.PropInfo.PHASE, this));
        _visitor_.visit(new SingleProperty<>(ShortJobDescription.PropInfo.RUN_ID, this));
        _visitor_.visit(new SingleProperty<>(ShortJobDescription.PropInfo.OWNER_ID, this));
        _visitor_.visit(new SingleProperty<>(ShortJobDescription.PropInfo.CREATION_TIME, this));
        _visitor_.visit(new SingleProperty<>(ShortJobDescription.PropInfo.ID, this));
        _visitor_.visit(new SingleProperty<>(ShortJobDescription.PropInfo.TYPE, this));
        _visitor_.visit(new SingleProperty<>(ShortJobDescription.PropInfo.HREF, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final ShortJobDescription _storedValue;
        private ExecutionPhase phase;
        private String runId;
        private String ownerId;
        private ZonedDateTime creationTime;
        private String id;
        private String type = "simple";
        private String href;

        public Builder(final _B _parentBuilder, final ShortJobDescription _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.phase = _other.phase;
                    this.runId = _other.runId;
                    this.ownerId = _other.ownerId;
                    this.creationTime = _other.creationTime;
                    this.id = _other.id;
                    this.type = _other.type;
                    this.href = _other.href;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final ShortJobDescription _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree phasePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("phase"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(phasePropertyTree!= null):((phasePropertyTree == null)||(!phasePropertyTree.isLeaf())))) {
                        this.phase = _other.phase;
                    }
                    final PropertyTree runIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("runId"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(runIdPropertyTree!= null):((runIdPropertyTree == null)||(!runIdPropertyTree.isLeaf())))) {
                        this.runId = _other.runId;
                    }
                    final PropertyTree ownerIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ownerId"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ownerIdPropertyTree!= null):((ownerIdPropertyTree == null)||(!ownerIdPropertyTree.isLeaf())))) {
                        this.ownerId = _other.ownerId;
                    }
                    final PropertyTree creationTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("creationTime"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(creationTimePropertyTree!= null):((creationTimePropertyTree == null)||(!creationTimePropertyTree.isLeaf())))) {
                        this.creationTime = _other.creationTime;
                    }
                    final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
                        this.id = _other.id;
                    }
                    final PropertyTree typePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("type"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(typePropertyTree!= null):((typePropertyTree == null)||(!typePropertyTree.isLeaf())))) {
                        this.type = _other.type;
                    }
                    final PropertyTree hrefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("href"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(hrefPropertyTree!= null):((hrefPropertyTree == null)||(!hrefPropertyTree.isLeaf())))) {
                        this.href = _other.href;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends ShortJobDescription >_P init(final _P _product) {
            _product.phase = this.phase;
            _product.runId = this.runId;
            _product.ownerId = this.ownerId;
            _product.creationTime = this.creationTime;
            _product.id = this.id;
            _product.type = this.type;
            _product.href = this.href;
            return _product;
        }

        /**
         * Sets the new value of "phase" (any previous value will be replaced)
         * 
         * @param phase
         *     New value of the "phase" property.
         */
        public ShortJobDescription.Builder<_B> withPhase(final ExecutionPhase phase) {
            this.phase = phase;
            return this;
        }

        /**
         * Sets the new value of "runId" (any previous value will be replaced)
         * 
         * @param runId
         *     New value of the "runId" property.
         */
        public ShortJobDescription.Builder<_B> withRunId(final String runId) {
            this.runId = runId;
            return this;
        }

        /**
         * Sets the new value of "ownerId" (any previous value will be replaced)
         * 
         * @param ownerId
         *     New value of the "ownerId" property.
         */
        public ShortJobDescription.Builder<_B> withOwnerId(final String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Sets the new value of "creationTime" (any previous value will be replaced)
         * 
         * @param creationTime
         *     New value of the "creationTime" property.
         */
        public ShortJobDescription.Builder<_B> withCreationTime(final ZonedDateTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        public ShortJobDescription.Builder<_B> withId(final String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        public ShortJobDescription.Builder<_B> withType(final String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        public ShortJobDescription.Builder<_B> withHref(final String href) {
            this.href = href;
            return this;
        }

        @Override
        public ShortJobDescription build() {
            if (_storedValue == null) {
                return this.init(new ShortJobDescription());
            } else {
                return ((ShortJobDescription) _storedValue);
            }
        }

        public ShortJobDescription.Builder<_B> copyOf(final ShortJobDescription _other) {
            _other.copyTo(this);
            return this;
        }

        public ShortJobDescription.Builder<_B> copyOf(final ShortJobDescription.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setPhase(final ExecutionPhase phase) {
            ShortJobDescription.this.setPhase(phase);
        }

        public void setRunId(final String runId) {
            ShortJobDescription.this.setRunId(runId);
        }

        public void setOwnerId(final String ownerId) {
            ShortJobDescription.this.setOwnerId(ownerId);
        }

        public void setCreationTime(final ZonedDateTime creationTime) {
            ShortJobDescription.this.setCreationTime(creationTime);
        }

        public void setId(final String id) {
            ShortJobDescription.this.setId(id);
        }

        public void setType(final String type) {
            ShortJobDescription.this.setType(type);
        }

        public void setHref(final String href) {
            ShortJobDescription.this.setHref(href);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<ShortJobDescription, ExecutionPhase> PHASE = new SinglePropertyInfo<ShortJobDescription,ExecutionPhase>("phase", ShortJobDescription.class, ExecutionPhase.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "phase"), new QName("http://www.ivoa.net/xml/UWS/v1.0", "ExecutionPhase"), false) {


            @Override
            public ExecutionPhase get(final ShortJobDescription _instance_) {
                return ((_instance_ == null)?null:_instance_.phase);
            }

            @Override
            public void set(final ShortJobDescription _instance_, final ExecutionPhase _value_) {
                if (_instance_!= null) {
                    _instance_.phase = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ShortJobDescription, String> RUN_ID = new SinglePropertyInfo<ShortJobDescription,String>("runId", ShortJobDescription.class, String.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "runId"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final ShortJobDescription _instance_) {
                return ((_instance_ == null)?null:_instance_.runId);
            }

            @Override
            public void set(final ShortJobDescription _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.runId = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ShortJobDescription, String> OWNER_ID = new SinglePropertyInfo<ShortJobDescription,String>("ownerId", ShortJobDescription.class, String.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "ownerId"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final ShortJobDescription _instance_) {
                return ((_instance_ == null)?null:_instance_.ownerId);
            }

            @Override
            public void set(final ShortJobDescription _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.ownerId = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ShortJobDescription, ZonedDateTime> CREATION_TIME = new SinglePropertyInfo<ShortJobDescription,ZonedDateTime>("creationTime", ShortJobDescription.class, ZonedDateTime.class, false, null, new QName("http://www.ivoa.net/xml/UWS/v1.0", "creationTime"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), false) {


            @Override
            public ZonedDateTime get(final ShortJobDescription _instance_) {
                return ((_instance_ == null)?null:_instance_.creationTime);
            }

            @Override
            public void set(final ShortJobDescription _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.creationTime = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ShortJobDescription, String> ID = new SinglePropertyInfo<ShortJobDescription,String>("id", ShortJobDescription.class, String.class, false, null, new QName("", "id"), new QName("http://www.ivoa.net/xml/UWS/v1.0", "JobIdentifier"), true) {


            @Override
            public String get(final ShortJobDescription _instance_) {
                return ((_instance_ == null)?null:_instance_.id);
            }

            @Override
            public void set(final ShortJobDescription _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.id = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ShortJobDescription, String> TYPE = new SinglePropertyInfo<ShortJobDescription,String>("type", ShortJobDescription.class, String.class, false, "simple", new QName("http://www.w3.org/1999/xlink", "type"), new QName("http://www.w3.org/1999/xlink", "anonymousAttributeType"), true) {


            @Override
            public String get(final ShortJobDescription _instance_) {
                return ((_instance_ == null)?null:_instance_.type);
            }

            @Override
            public void set(final ShortJobDescription _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.type = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ShortJobDescription, String> HREF = new SinglePropertyInfo<ShortJobDescription,String>("href", ShortJobDescription.class, String.class, false, null, new QName("http://www.w3.org/1999/xlink", "href"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), true) {


            @Override
            public String get(final ShortJobDescription _instance_) {
                return ((_instance_ == null)?null:_instance_.href);
            }

            @Override
            public void set(final ShortJobDescription _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.href = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends ShortJobDescription.Selector<ShortJobDescription.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static ShortJobDescription.Select _root() {
            return new ShortJobDescription.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> phase = null;
        private com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> runId = null;
        private com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> ownerId = null;
        private com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> creationTime = null;
        private com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> id = null;
        private com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> type = null;
        private com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> href = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.phase!= null) {
                products.put("phase", this.phase.init());
            }
            if (this.runId!= null) {
                products.put("runId", this.runId.init());
            }
            if (this.ownerId!= null) {
                products.put("ownerId", this.ownerId.init());
            }
            if (this.creationTime!= null) {
                products.put("creationTime", this.creationTime.init());
            }
            if (this.id!= null) {
                products.put("id", this.id.init());
            }
            if (this.type!= null) {
                products.put("type", this.type.init());
            }
            if (this.href!= null) {
                products.put("href", this.href.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> phase() {
            return ((this.phase == null)?this.phase = new com.kscs.util.jaxb.Selector<>(this._root, this, "phase"):this.phase);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> runId() {
            return ((this.runId == null)?this.runId = new com.kscs.util.jaxb.Selector<>(this._root, this, "runId"):this.runId);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> ownerId() {
            return ((this.ownerId == null)?this.ownerId = new com.kscs.util.jaxb.Selector<>(this._root, this, "ownerId"):this.ownerId);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> creationTime() {
            return ((this.creationTime == null)?this.creationTime = new com.kscs.util.jaxb.Selector<>(this._root, this, "creationTime"):this.creationTime);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> id() {
            return ((this.id == null)?this.id = new com.kscs.util.jaxb.Selector<>(this._root, this, "id"):this.id);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> type() {
            return ((this.type == null)?this.type = new com.kscs.util.jaxb.Selector<>(this._root, this, "type"):this.type);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ShortJobDescription.Selector<TRoot, TParent>> href() {
            return ((this.href == null)?this.href = new com.kscs.util.jaxb.Selector<>(this._root, this, "href"):this.href);
        }

    }

}
