
package org.javastro.ivoa.entities.vodml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A "proxy" for an external model that is being used by the current model. 
 *         Defines the url where the VO-DML representation of that model can be retrieved, and
 *         replicates its name that MUST be used when making references to
 *         elements in that model using a VODMLREF element.
 * 
 * <p>Java class for ModelImport complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ModelImport">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="name" type="{http://www.ivoa.net/xml/VODML/v1}ModelName"/>
 *         <element name="identifier" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="version" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="url" type="{http://www.w3.org/2001/XMLSchema}anyURI"/>
 *         <element name="documentationURL" type="{http://www.w3.org/2001/XMLSchema}anyURI"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ModelImport", propOrder = {
    "name",
    "identifier",
    "version",
    "url",
    "documentationURL"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class ModelImport implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Name by which imported model is used in the current model and its documentation.
     *                     This name MUST be the same as the 'name' of the model definition in that remote document.
     *                     For all utypes pointing to elements in the imported model MUST use this name as prefix.
     * 
     */
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String name;
    /**
     * A string holding the identifier by which the imported model is registered in an 
     *                         IVOA compatible registry. Must be the same value as the 'identifier' of the imported model.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String identifier;
    /**
     * Version of the imported model.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String version;
    /**
     * URL from which the VO-DML model document can be downloaded.
     *             Note, could likely be done through a registry once ivoId is known.
     *             TBD SHOULD this be a generic URI, or can we insits on URL?
     * 
     */
    @XmlElement(required = true)
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String url;
    /**
     * URL where a documentation HTML file for the remote model can be downloaded.
     *             This SHOULD be a document that contains anchors for each element thta has as name attribute the vodml-id of that element.
     *             I.e. it is assumed that the
     *             vodml-id-s of the imported types can be added onto this documentationURL
     *             (should end with a #?) so that a direct link to the documentation for a referenced data model element can be found.
     * 
     */
    @XmlElement(required = true)
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String documentationURL;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient ModelImport.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public ModelImport() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public ModelImport(final String name, final String identifier, final String version, final String url, final String documentationURL) {
        this.name = name;
        this.identifier = identifier;
        this.version = version;
        this.url = url;
        this.documentationURL = documentationURL;
    }

    /**
     * Name by which imported model is used in the current model and its documentation.
     *                     This name MUST be the same as the 'name' of the model definition in that remote document.
     *                     For all utypes pointing to elements in the imported model MUST use this name as prefix.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setName(String value) {
        this.name = value;
    }

    /**
     * A string holding the identifier by which the imported model is registered in an 
     *                         IVOA compatible registry. Must be the same value as the 'identifier' of the imported model.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getIdentifier() {
        return identifier;
    }

    /**
     * Sets the value of the identifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getIdentifier()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setIdentifier(String value) {
        this.identifier = value;
    }

    /**
     * Version of the imported model.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getVersion()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setVersion(String value) {
        this.version = value;
    }

    /**
     * URL from which the VO-DML model document can be downloaded.
     *             Note, could likely be done through a registry once ivoId is known.
     *             TBD SHOULD this be a generic URI, or can we insits on URL?
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getUrl() {
        return url;
    }

    /**
     * Sets the value of the url property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUrl()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setUrl(String value) {
        this.url = value;
    }

    /**
     * URL where a documentation HTML file for the remote model can be downloaded.
     *             This SHOULD be a document that contains anchors for each element thta has as name attribute the vodml-id of that element.
     *             I.e. it is assumed that the
     *             vodml-id-s of the imported types can be added onto this documentationURL
     *             (should end with a #?) so that a direct link to the documentation for a referenced data model element can be found.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getDocumentationURL() {
        return documentationURL;
    }

    /**
     * Sets the value of the documentationURL property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDocumentationURL()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setDocumentationURL(String value) {
        this.documentationURL = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ModelImport that = ((ModelImport) object);
        {
            String leftName;
            leftName = this.getName();
            String rightName;
            rightName = that.getName();
            if (this.name!= null) {
                if (that.name!= null) {
                    if (!leftName.equals(rightName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.name!= null) {
                    return false;
                }
            }
        }
        {
            String leftIdentifier;
            leftIdentifier = this.getIdentifier();
            String rightIdentifier;
            rightIdentifier = that.getIdentifier();
            if (this.identifier!= null) {
                if (that.identifier!= null) {
                    if (!leftIdentifier.equals(rightIdentifier)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.identifier!= null) {
                    return false;
                }
            }
        }
        {
            String leftVersion;
            leftVersion = this.getVersion();
            String rightVersion;
            rightVersion = that.getVersion();
            if (this.version!= null) {
                if (that.version!= null) {
                    if (!leftVersion.equals(rightVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.version!= null) {
                    return false;
                }
            }
        }
        {
            String leftUrl;
            leftUrl = this.getUrl();
            String rightUrl;
            rightUrl = that.getUrl();
            if (this.url!= null) {
                if (that.url!= null) {
                    if (!leftUrl.equals(rightUrl)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.url!= null) {
                    return false;
                }
            }
        }
        {
            String leftDocumentationURL;
            leftDocumentationURL = this.getDocumentationURL();
            String rightDocumentationURL;
            rightDocumentationURL = that.getDocumentationURL();
            if (this.documentationURL!= null) {
                if (that.documentationURL!= null) {
                    if (!leftDocumentationURL.equals(rightDocumentationURL)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.documentationURL!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theName;
            theName = this.getName();
            if (this.name!= null) {
                currentHashCode += theName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theIdentifier;
            theIdentifier = this.getIdentifier();
            if (this.identifier!= null) {
                currentHashCode += theIdentifier.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theVersion;
            theVersion = this.getVersion();
            if (this.version!= null) {
                currentHashCode += theVersion.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theUrl;
            theUrl = this.getUrl();
            if (this.url!= null) {
                currentHashCode += theUrl.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDocumentationURL;
            theDocumentationURL = this.getDocumentationURL();
            if (this.documentationURL!= null) {
                currentHashCode += theDocumentationURL.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theName;
            theName = this.getName();
            strategy.appendField(locator, this, "name", buffer, theName, (this.name!= null));
        }
        {
            String theIdentifier;
            theIdentifier = this.getIdentifier();
            strategy.appendField(locator, this, "identifier", buffer, theIdentifier, (this.identifier!= null));
        }
        {
            String theVersion;
            theVersion = this.getVersion();
            strategy.appendField(locator, this, "version", buffer, theVersion, (this.version!= null));
        }
        {
            String theUrl;
            theUrl = this.getUrl();
            strategy.appendField(locator, this, "url", buffer, theUrl, (this.url!= null));
        }
        {
            String theDocumentationURL;
            theDocumentationURL = this.getDocumentationURL();
            strategy.appendField(locator, this, "documentationURL", buffer, theDocumentationURL, (this.documentationURL!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof ModelImport) {
            final ModelImport target = this;
            final ModelImport leftObject = ((ModelImport) left);
            final ModelImport rightObject = ((ModelImport) right);
            {
                Boolean nameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.name!= null), (rightObject.name!= null));
                if (nameShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsName;
                    lhsName = leftObject.getName();
                    String rhsName;
                    rhsName = rightObject.getName();
                    String mergedName = ((String) strategy.merge(LocatorUtils.property(leftLocator, "name", lhsName), LocatorUtils.property(rightLocator, "name", rhsName), lhsName, rhsName, (leftObject.name!= null), (rightObject.name!= null)));
                    target.setName(mergedName);
                } else {
                    if (nameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.name = null;
                    }
                }
            }
            {
                Boolean identifierShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.identifier!= null), (rightObject.identifier!= null));
                if (identifierShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsIdentifier;
                    lhsIdentifier = leftObject.getIdentifier();
                    String rhsIdentifier;
                    rhsIdentifier = rightObject.getIdentifier();
                    String mergedIdentifier = ((String) strategy.merge(LocatorUtils.property(leftLocator, "identifier", lhsIdentifier), LocatorUtils.property(rightLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, (leftObject.identifier!= null), (rightObject.identifier!= null)));
                    target.setIdentifier(mergedIdentifier);
                } else {
                    if (identifierShouldBeMergedAndSet == Boolean.FALSE) {
                        target.identifier = null;
                    }
                }
            }
            {
                Boolean versionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.version!= null), (rightObject.version!= null));
                if (versionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsVersion;
                    lhsVersion = leftObject.getVersion();
                    String rhsVersion;
                    rhsVersion = rightObject.getVersion();
                    String mergedVersion = ((String) strategy.merge(LocatorUtils.property(leftLocator, "version", lhsVersion), LocatorUtils.property(rightLocator, "version", rhsVersion), lhsVersion, rhsVersion, (leftObject.version!= null), (rightObject.version!= null)));
                    target.setVersion(mergedVersion);
                } else {
                    if (versionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.version = null;
                    }
                }
            }
            {
                Boolean urlShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.url!= null), (rightObject.url!= null));
                if (urlShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsUrl;
                    lhsUrl = leftObject.getUrl();
                    String rhsUrl;
                    rhsUrl = rightObject.getUrl();
                    String mergedUrl = ((String) strategy.merge(LocatorUtils.property(leftLocator, "url", lhsUrl), LocatorUtils.property(rightLocator, "url", rhsUrl), lhsUrl, rhsUrl, (leftObject.url!= null), (rightObject.url!= null)));
                    target.setUrl(mergedUrl);
                } else {
                    if (urlShouldBeMergedAndSet == Boolean.FALSE) {
                        target.url = null;
                    }
                }
            }
            {
                Boolean documentationURLShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.documentationURL!= null), (rightObject.documentationURL!= null));
                if (documentationURLShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsDocumentationURL;
                    lhsDocumentationURL = leftObject.getDocumentationURL();
                    String rhsDocumentationURL;
                    rhsDocumentationURL = rightObject.getDocumentationURL();
                    String mergedDocumentationURL = ((String) strategy.merge(LocatorUtils.property(leftLocator, "documentationURL", lhsDocumentationURL), LocatorUtils.property(rightLocator, "documentationURL", rhsDocumentationURL), lhsDocumentationURL, rhsDocumentationURL, (leftObject.documentationURL!= null), (rightObject.documentationURL!= null)));
                    target.setDocumentationURL(mergedDocumentationURL);
                } else {
                    if (documentationURLShouldBeMergedAndSet == Boolean.FALSE) {
                        target.documentationURL = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new ModelImport();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ModelImport clone() {
        final ModelImport _newObject;
        try {
            _newObject = ((ModelImport) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ModelImport createCopy() {
        final ModelImport _newObject;
        try {
            _newObject = ((ModelImport) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.name = this.name;
        _newObject.identifier = this.identifier;
        _newObject.version = this.version;
        _newObject.url = this.url;
        _newObject.documentationURL = this.documentationURL;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ModelImport createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ModelImport _newObject;
        try {
            _newObject = ((ModelImport) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _newObject.name = this.name;
        }
        final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
            _newObject.identifier = this.identifier;
        }
        final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
            _newObject.version = this.version;
        }
        final PropertyTree urlPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("url"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(urlPropertyTree!= null):((urlPropertyTree == null)||(!urlPropertyTree.isLeaf())))) {
            _newObject.url = this.url;
        }
        final PropertyTree documentationURLPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("documentationURL"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(documentationURLPropertyTree!= null):((documentationURLPropertyTree == null)||(!documentationURLPropertyTree.isLeaf())))) {
            _newObject.documentationURL = this.documentationURL;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ModelImport copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ModelImport copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ModelImport.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new ModelImport.Modifier();
        }
        return ((ModelImport.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final ModelImport.Builder<_B> _other) {
        _other.name = this.name;
        _other.identifier = this.identifier;
        _other.version = this.version;
        _other.url = this.url;
        _other.documentationURL = this.documentationURL;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >ModelImport.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new ModelImport.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ModelImport.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ModelImport.Builder<Void> builder() {
        return new ModelImport.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ModelImport.Builder<_B> copyOf(final ModelImport _other) {
        final ModelImport.Builder<_B> _newBuilder = new ModelImport.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final ModelImport.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _other.name = this.name;
        }
        final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
            _other.identifier = this.identifier;
        }
        final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
            _other.version = this.version;
        }
        final PropertyTree urlPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("url"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(urlPropertyTree!= null):((urlPropertyTree == null)||(!urlPropertyTree.isLeaf())))) {
            _other.url = this.url;
        }
        final PropertyTree documentationURLPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("documentationURL"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(documentationURLPropertyTree!= null):((documentationURLPropertyTree == null)||(!documentationURLPropertyTree.isLeaf())))) {
            _other.documentationURL = this.documentationURL;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >ModelImport.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new ModelImport.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ModelImport.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ModelImport.Builder<_B> copyOf(final ModelImport _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ModelImport.Builder<_B> _newBuilder = new ModelImport.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ModelImport.Builder<Void> copyExcept(final ModelImport _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ModelImport.Builder<Void> copyOnly(final ModelImport _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ModelImport visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(ModelImport.PropInfo.NAME, this));
        _visitor_.visit(new SingleProperty<>(ModelImport.PropInfo.IDENTIFIER, this));
        _visitor_.visit(new SingleProperty<>(ModelImport.PropInfo.VERSION, this));
        _visitor_.visit(new SingleProperty<>(ModelImport.PropInfo.URL, this));
        _visitor_.visit(new SingleProperty<>(ModelImport.PropInfo.DOCUMENTATION_URL, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final ModelImport _storedValue;
        private String name;
        private String identifier;
        private String version;
        private String url;
        private String documentationURL;

        public Builder(final _B _parentBuilder, final ModelImport _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.name = _other.name;
                    this.identifier = _other.identifier;
                    this.version = _other.version;
                    this.url = _other.url;
                    this.documentationURL = _other.documentationURL;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final ModelImport _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
                        this.name = _other.name;
                    }
                    final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
                        this.identifier = _other.identifier;
                    }
                    final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
                        this.version = _other.version;
                    }
                    final PropertyTree urlPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("url"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(urlPropertyTree!= null):((urlPropertyTree == null)||(!urlPropertyTree.isLeaf())))) {
                        this.url = _other.url;
                    }
                    final PropertyTree documentationURLPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("documentationURL"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(documentationURLPropertyTree!= null):((documentationURLPropertyTree == null)||(!documentationURLPropertyTree.isLeaf())))) {
                        this.documentationURL = _other.documentationURL;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends ModelImport >_P init(final _P _product) {
            _product.name = this.name;
            _product.identifier = this.identifier;
            _product.version = this.version;
            _product.url = this.url;
            _product.documentationURL = this.documentationURL;
            return _product;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        public ModelImport.Builder<_B> withName(final String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        public ModelImport.Builder<_B> withIdentifier(final String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        public ModelImport.Builder<_B> withVersion(final String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the new value of "url" (any previous value will be replaced)
         * 
         * @param url
         *     New value of the "url" property.
         */
        public ModelImport.Builder<_B> withUrl(final String url) {
            this.url = url;
            return this;
        }

        /**
         * Sets the new value of "documentationURL" (any previous value will be replaced)
         * 
         * @param documentationURL
         *     New value of the "documentationURL" property.
         */
        public ModelImport.Builder<_B> withDocumentationURL(final String documentationURL) {
            this.documentationURL = documentationURL;
            return this;
        }

        @Override
        public ModelImport build() {
            if (_storedValue == null) {
                return this.init(new ModelImport());
            } else {
                return ((ModelImport) _storedValue);
            }
        }

        public ModelImport.Builder<_B> copyOf(final ModelImport _other) {
            _other.copyTo(this);
            return this;
        }

        public ModelImport.Builder<_B> copyOf(final ModelImport.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setName(final String name) {
            ModelImport.this.setName(name);
        }

        public void setIdentifier(final String identifier) {
            ModelImport.this.setIdentifier(identifier);
        }

        public void setVersion(final String version) {
            ModelImport.this.setVersion(version);
        }

        public void setUrl(final String url) {
            ModelImport.this.setUrl(url);
        }

        public void setDocumentationURL(final String documentationURL) {
            ModelImport.this.setDocumentationURL(documentationURL);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<ModelImport, String> NAME = new SinglePropertyInfo<ModelImport,String>("name", ModelImport.class, String.class, false, null, new QName("", "name"), new QName("http://www.ivoa.net/xml/VODML/v1", "ModelName"), false) {


            @Override
            public String get(final ModelImport _instance_) {
                return ((_instance_ == null)?null:_instance_.name);
            }

            @Override
            public void set(final ModelImport _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.name = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ModelImport, String> IDENTIFIER = new SinglePropertyInfo<ModelImport,String>("identifier", ModelImport.class, String.class, false, null, new QName("", "identifier"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final ModelImport _instance_) {
                return ((_instance_ == null)?null:_instance_.identifier);
            }

            @Override
            public void set(final ModelImport _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.identifier = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ModelImport, String> VERSION = new SinglePropertyInfo<ModelImport,String>("version", ModelImport.class, String.class, false, null, new QName("", "version"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final ModelImport _instance_) {
                return ((_instance_ == null)?null:_instance_.version);
            }

            @Override
            public void set(final ModelImport _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.version = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ModelImport, String> URL = new SinglePropertyInfo<ModelImport,String>("url", ModelImport.class, String.class, false, null, new QName("", "url"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), false) {


            @Override
            public String get(final ModelImport _instance_) {
                return ((_instance_ == null)?null:_instance_.url);
            }

            @Override
            public void set(final ModelImport _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.url = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ModelImport, String> DOCUMENTATION_URL = new SinglePropertyInfo<ModelImport,String>("documentationURL", ModelImport.class, String.class, false, null, new QName("", "documentationURL"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), false) {


            @Override
            public String get(final ModelImport _instance_) {
                return ((_instance_ == null)?null:_instance_.documentationURL);
            }

            @Override
            public void set(final ModelImport _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.documentationURL = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends ModelImport.Selector<ModelImport.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static ModelImport.Select _root() {
            return new ModelImport.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, ModelImport.Selector<TRoot, TParent>> name = null;
        private com.kscs.util.jaxb.Selector<TRoot, ModelImport.Selector<TRoot, TParent>> identifier = null;
        private com.kscs.util.jaxb.Selector<TRoot, ModelImport.Selector<TRoot, TParent>> version = null;
        private com.kscs.util.jaxb.Selector<TRoot, ModelImport.Selector<TRoot, TParent>> url = null;
        private com.kscs.util.jaxb.Selector<TRoot, ModelImport.Selector<TRoot, TParent>> documentationURL = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.name!= null) {
                products.put("name", this.name.init());
            }
            if (this.identifier!= null) {
                products.put("identifier", this.identifier.init());
            }
            if (this.version!= null) {
                products.put("version", this.version.init());
            }
            if (this.url!= null) {
                products.put("url", this.url.init());
            }
            if (this.documentationURL!= null) {
                products.put("documentationURL", this.documentationURL.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, ModelImport.Selector<TRoot, TParent>> name() {
            return ((this.name == null)?this.name = new com.kscs.util.jaxb.Selector<>(this._root, this, "name"):this.name);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ModelImport.Selector<TRoot, TParent>> identifier() {
            return ((this.identifier == null)?this.identifier = new com.kscs.util.jaxb.Selector<>(this._root, this, "identifier"):this.identifier);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ModelImport.Selector<TRoot, TParent>> version() {
            return ((this.version == null)?this.version = new com.kscs.util.jaxb.Selector<>(this._root, this, "version"):this.version);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ModelImport.Selector<TRoot, TParent>> url() {
            return ((this.url == null)?this.url = new com.kscs.util.jaxb.Selector<>(this._root, this, "url"):this.url);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ModelImport.Selector<TRoot, TParent>> documentationURL() {
            return ((this.documentationURL == null)?this.documentationURL = new com.kscs.util.jaxb.Selector<>(this._root, this, "documentationURL"):this.documentationURL);
        }

    }

}
