
package org.javastro.ivoa.entities.vodml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A special type of constraint that represents the common pattern where a subtype.
 *       would like to restrict certain aspects of a definition of a  roles defined on a super type.
 *       The constraint explicitly defines the datatype of the identified role. This new datatype MUST
 *       be a subtype of the declared datatype of the role that is being constrained. Similarly
 *       a new, more restrictive semantic concept  may be defined.
 * 
 * <p>Java class for SubsettedRole complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SubsettedRole">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VODML/v1}Constraint">
 *       <sequence>
 *         <element name="role" type="{http://www.ivoa.net/xml/VODML/v1}ElementRef"/>
 *         <element name="datatype" type="{http://www.ivoa.net/xml/VODML/v1}ElementRef" minOccurs="0"/>
 *         <element name="semanticconcept" type="{http://www.ivoa.net/xml/VODML/v1}SemanticConcept" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SubsettedRole", propOrder = {
    "role",
    "datatype",
    "semanticconcept"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class SubsettedRole
    extends Constraint
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * VODMLREF identifying the constrained Role.
     *             This role MUST be available to the type containing this constraint.
     * 
     */
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ElementRef role;
    /**
     * Pointer to datatype that the constrained Role must take.
     *             This datatype MUST be a sub-type of the declared datatype of the constrained Role.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ElementRef datatype;
    /**
     * Maybe the super type has not defined a semantic concept for the Role, but 
     * 						the subtype needs that. This attribute allows this assignment. But alse when 
     * 						the Role on the super-type already has a semanticconcept with a topConcept 
     * 						defined on it, the subtype may restrict the values to a narrower concept than 
     * 						that assigned to it on the super-type.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected SemanticConcept semanticconcept;

    /**
     * Default no-arg constructor
     * 
     */
    public SubsettedRole() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SubsettedRole(final String description, final ElementRef role, final ElementRef datatype, final SemanticConcept semanticconcept) {
        super(description);
        this.role = role;
        this.datatype = datatype;
        this.semanticconcept = semanticconcept;
    }

    /**
     * VODMLREF identifying the constrained Role.
     *             This role MUST be available to the type containing this constraint.
     * 
     * @return
     *     possible object is
     *     {@link ElementRef }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ElementRef getRole() {
        return role;
    }

    /**
     * Sets the value of the role property.
     * 
     * @param value
     *     allowed object is
     *     {@link ElementRef }
     *     
     * @see #getRole()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setRole(ElementRef value) {
        this.role = value;
    }

    /**
     * Pointer to datatype that the constrained Role must take.
     *             This datatype MUST be a sub-type of the declared datatype of the constrained Role.
     * 
     * @return
     *     possible object is
     *     {@link ElementRef }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ElementRef getDatatype() {
        return datatype;
    }

    /**
     * Sets the value of the datatype property.
     * 
     * @param value
     *     allowed object is
     *     {@link ElementRef }
     *     
     * @see #getDatatype()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setDatatype(ElementRef value) {
        this.datatype = value;
    }

    /**
     * Maybe the super type has not defined a semantic concept for the Role, but 
     * 						the subtype needs that. This attribute allows this assignment. But alse when 
     * 						the Role on the super-type already has a semanticconcept with a topConcept 
     * 						defined on it, the subtype may restrict the values to a narrower concept than 
     * 						that assigned to it on the super-type.
     * 
     * @return
     *     possible object is
     *     {@link SemanticConcept }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SemanticConcept getSemanticconcept() {
        return semanticconcept;
    }

    /**
     * Sets the value of the semanticconcept property.
     * 
     * @param value
     *     allowed object is
     *     {@link SemanticConcept }
     *     
     * @see #getSemanticconcept()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setSemanticconcept(SemanticConcept value) {
        this.semanticconcept = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final SubsettedRole that = ((SubsettedRole) object);
        {
            ElementRef leftRole;
            leftRole = this.getRole();
            ElementRef rightRole;
            rightRole = that.getRole();
            if (this.role!= null) {
                if (that.role!= null) {
                    if (!leftRole.equals(rightRole)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.role!= null) {
                    return false;
                }
            }
        }
        {
            ElementRef leftDatatype;
            leftDatatype = this.getDatatype();
            ElementRef rightDatatype;
            rightDatatype = that.getDatatype();
            if (this.datatype!= null) {
                if (that.datatype!= null) {
                    if (!leftDatatype.equals(rightDatatype)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.datatype!= null) {
                    return false;
                }
            }
        }
        {
            SemanticConcept leftSemanticconcept;
            leftSemanticconcept = this.getSemanticconcept();
            SemanticConcept rightSemanticconcept;
            rightSemanticconcept = that.getSemanticconcept();
            if (this.semanticconcept!= null) {
                if (that.semanticconcept!= null) {
                    if (!leftSemanticconcept.equals(rightSemanticconcept)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.semanticconcept!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            ElementRef theRole;
            theRole = this.getRole();
            if (this.role!= null) {
                currentHashCode += theRole.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ElementRef theDatatype;
            theDatatype = this.getDatatype();
            if (this.datatype!= null) {
                currentHashCode += theDatatype.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            SemanticConcept theSemanticconcept;
            theSemanticconcept = this.getSemanticconcept();
            if (this.semanticconcept!= null) {
                currentHashCode += theSemanticconcept.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            ElementRef theRole;
            theRole = this.getRole();
            strategy.appendField(locator, this, "role", buffer, theRole, (this.role!= null));
        }
        {
            ElementRef theDatatype;
            theDatatype = this.getDatatype();
            strategy.appendField(locator, this, "datatype", buffer, theDatatype, (this.datatype!= null));
        }
        {
            SemanticConcept theSemanticconcept;
            theSemanticconcept = this.getSemanticconcept();
            strategy.appendField(locator, this, "semanticconcept", buffer, theSemanticconcept, (this.semanticconcept!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof SubsettedRole) {
            final SubsettedRole target = this;
            final SubsettedRole leftObject = ((SubsettedRole) left);
            final SubsettedRole rightObject = ((SubsettedRole) right);
            {
                Boolean roleShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.role!= null), (rightObject.role!= null));
                if (roleShouldBeMergedAndSet == Boolean.TRUE) {
                    ElementRef lhsRole;
                    lhsRole = leftObject.getRole();
                    ElementRef rhsRole;
                    rhsRole = rightObject.getRole();
                    ElementRef mergedRole = ((ElementRef) strategy.merge(LocatorUtils.property(leftLocator, "role", lhsRole), LocatorUtils.property(rightLocator, "role", rhsRole), lhsRole, rhsRole, (leftObject.role!= null), (rightObject.role!= null)));
                    target.setRole(mergedRole);
                } else {
                    if (roleShouldBeMergedAndSet == Boolean.FALSE) {
                        target.role = null;
                    }
                }
            }
            {
                Boolean datatypeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.datatype!= null), (rightObject.datatype!= null));
                if (datatypeShouldBeMergedAndSet == Boolean.TRUE) {
                    ElementRef lhsDatatype;
                    lhsDatatype = leftObject.getDatatype();
                    ElementRef rhsDatatype;
                    rhsDatatype = rightObject.getDatatype();
                    ElementRef mergedDatatype = ((ElementRef) strategy.merge(LocatorUtils.property(leftLocator, "datatype", lhsDatatype), LocatorUtils.property(rightLocator, "datatype", rhsDatatype), lhsDatatype, rhsDatatype, (leftObject.datatype!= null), (rightObject.datatype!= null)));
                    target.setDatatype(mergedDatatype);
                } else {
                    if (datatypeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.datatype = null;
                    }
                }
            }
            {
                Boolean semanticconceptShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.semanticconcept!= null), (rightObject.semanticconcept!= null));
                if (semanticconceptShouldBeMergedAndSet == Boolean.TRUE) {
                    SemanticConcept lhsSemanticconcept;
                    lhsSemanticconcept = leftObject.getSemanticconcept();
                    SemanticConcept rhsSemanticconcept;
                    rhsSemanticconcept = rightObject.getSemanticconcept();
                    SemanticConcept mergedSemanticconcept = ((SemanticConcept) strategy.merge(LocatorUtils.property(leftLocator, "semanticconcept", lhsSemanticconcept), LocatorUtils.property(rightLocator, "semanticconcept", rhsSemanticconcept), lhsSemanticconcept, rhsSemanticconcept, (leftObject.semanticconcept!= null), (rightObject.semanticconcept!= null)));
                    target.setSemanticconcept(mergedSemanticconcept);
                } else {
                    if (semanticconceptShouldBeMergedAndSet == Boolean.FALSE) {
                        target.semanticconcept = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new SubsettedRole();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SubsettedRole clone() {
        final SubsettedRole _newObject;
        _newObject = ((SubsettedRole) super.clone());
        _newObject.role = ((this.role == null)?null:this.role.clone());
        _newObject.datatype = ((this.datatype == null)?null:this.datatype.clone());
        _newObject.semanticconcept = ((this.semanticconcept == null)?null:this.semanticconcept.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SubsettedRole createCopy() {
        final SubsettedRole _newObject = ((SubsettedRole) super.createCopy());
        _newObject.role = ((this.role == null)?null:this.role.createCopy());
        _newObject.datatype = ((this.datatype == null)?null:this.datatype.createCopy());
        _newObject.semanticconcept = ((this.semanticconcept == null)?null:this.semanticconcept.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SubsettedRole createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SubsettedRole _newObject = ((SubsettedRole) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree rolePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("role"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(rolePropertyTree!= null):((rolePropertyTree == null)||(!rolePropertyTree.isLeaf())))) {
            _newObject.role = ((this.role == null)?null:this.role.createCopy(rolePropertyTree, _propertyTreeUse));
        }
        final PropertyTree datatypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("datatype"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(datatypePropertyTree!= null):((datatypePropertyTree == null)||(!datatypePropertyTree.isLeaf())))) {
            _newObject.datatype = ((this.datatype == null)?null:this.datatype.createCopy(datatypePropertyTree, _propertyTreeUse));
        }
        final PropertyTree semanticconceptPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("semanticconcept"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(semanticconceptPropertyTree!= null):((semanticconceptPropertyTree == null)||(!semanticconceptPropertyTree.isLeaf())))) {
            _newObject.semanticconcept = ((this.semanticconcept == null)?null:this.semanticconcept.createCopy(semanticconceptPropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SubsettedRole copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SubsettedRole copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SubsettedRole.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SubsettedRole.Modifier();
        }
        return ((SubsettedRole.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final SubsettedRole.Builder<_B> _other) {
        super.copyTo(_other);
        _other.role = ((this.role == null)?null:this.role.newCopyBuilder(_other));
        _other.datatype = ((this.datatype == null)?null:this.datatype.newCopyBuilder(_other));
        _other.semanticconcept = ((this.semanticconcept == null)?null:this.semanticconcept.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >SubsettedRole.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SubsettedRole.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SubsettedRole.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static SubsettedRole.Builder<Void> builder() {
        return new SubsettedRole.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >SubsettedRole.Builder<_B> copyOf(final Constraint _other) {
        final SubsettedRole.Builder<_B> _newBuilder = new SubsettedRole.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >SubsettedRole.Builder<_B> copyOf(final SubsettedRole _other) {
        final SubsettedRole.Builder<_B> _newBuilder = new SubsettedRole.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final SubsettedRole.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree rolePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("role"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(rolePropertyTree!= null):((rolePropertyTree == null)||(!rolePropertyTree.isLeaf())))) {
            _other.role = ((this.role == null)?null:this.role.newCopyBuilder(_other, rolePropertyTree, _propertyTreeUse));
        }
        final PropertyTree datatypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("datatype"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(datatypePropertyTree!= null):((datatypePropertyTree == null)||(!datatypePropertyTree.isLeaf())))) {
            _other.datatype = ((this.datatype == null)?null:this.datatype.newCopyBuilder(_other, datatypePropertyTree, _propertyTreeUse));
        }
        final PropertyTree semanticconceptPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("semanticconcept"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(semanticconceptPropertyTree!= null):((semanticconceptPropertyTree == null)||(!semanticconceptPropertyTree.isLeaf())))) {
            _other.semanticconcept = ((this.semanticconcept == null)?null:this.semanticconcept.newCopyBuilder(_other, semanticconceptPropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >SubsettedRole.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SubsettedRole.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SubsettedRole.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >SubsettedRole.Builder<_B> copyOf(final Constraint _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SubsettedRole.Builder<_B> _newBuilder = new SubsettedRole.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >SubsettedRole.Builder<_B> copyOf(final SubsettedRole _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SubsettedRole.Builder<_B> _newBuilder = new SubsettedRole.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static SubsettedRole.Builder<Void> copyExcept(final Constraint _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static SubsettedRole.Builder<Void> copyExcept(final SubsettedRole _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static SubsettedRole.Builder<Void> copyOnly(final Constraint _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static SubsettedRole.Builder<Void> copyOnly(final SubsettedRole _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SubsettedRole visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(SubsettedRole.PropInfo.ROLE, this))&&(this.role!= null)) {
            this.role.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(SubsettedRole.PropInfo.DATATYPE, this))&&(this.datatype!= null)) {
            this.datatype.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(SubsettedRole.PropInfo.SEMANTICCONCEPT, this))&&(this.semanticconcept!= null)) {
            this.semanticconcept.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends Constraint.Builder<_B>
        implements Buildable
    {

        private ElementRef.Builder<SubsettedRole.Builder<_B>> role;
        private ElementRef.Builder<SubsettedRole.Builder<_B>> datatype;
        private SemanticConcept.Builder<SubsettedRole.Builder<_B>> semanticconcept;

        public Builder(final _B _parentBuilder, final SubsettedRole _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.role = ((_other.role == null)?null:_other.role.newCopyBuilder(this));
                this.datatype = ((_other.datatype == null)?null:_other.datatype.newCopyBuilder(this));
                this.semanticconcept = ((_other.semanticconcept == null)?null:_other.semanticconcept.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final SubsettedRole _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree rolePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("role"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(rolePropertyTree!= null):((rolePropertyTree == null)||(!rolePropertyTree.isLeaf())))) {
                    this.role = ((_other.role == null)?null:_other.role.newCopyBuilder(this, rolePropertyTree, _propertyTreeUse));
                }
                final PropertyTree datatypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("datatype"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(datatypePropertyTree!= null):((datatypePropertyTree == null)||(!datatypePropertyTree.isLeaf())))) {
                    this.datatype = ((_other.datatype == null)?null:_other.datatype.newCopyBuilder(this, datatypePropertyTree, _propertyTreeUse));
                }
                final PropertyTree semanticconceptPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("semanticconcept"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(semanticconceptPropertyTree!= null):((semanticconceptPropertyTree == null)||(!semanticconceptPropertyTree.isLeaf())))) {
                    this.semanticconcept = ((_other.semanticconcept == null)?null:_other.semanticconcept.newCopyBuilder(this, semanticconceptPropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends SubsettedRole >_P init(final _P _product) {
            _product.role = ((this.role == null)?null:this.role.build());
            _product.datatype = ((this.datatype == null)?null:this.datatype.build());
            _product.semanticconcept = ((this.semanticconcept == null)?null:this.semanticconcept.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "role" (any previous value will be replaced)
         * 
         * @param role
         *     New value of the "role" property.
         */
        public SubsettedRole.Builder<_B> withRole(final ElementRef role) {
            this.role = ((role == null)?null:new ElementRef.Builder<>(this, role, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "role"
         * property.
         * Use {@link org.javastro.ivoa.entities.vodml.ElementRef.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "role" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.ElementRef.Builder#end()} to return
         *     to the current builder.
         */
        public ElementRef.Builder<? extends SubsettedRole.Builder<_B>> withRole() {
            if (this.role!= null) {
                return this.role;
            }
            return this.role = new ElementRef.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "datatype" (any previous value will be replaced)
         * 
         * @param datatype
         *     New value of the "datatype" property.
         */
        public SubsettedRole.Builder<_B> withDatatype(final ElementRef datatype) {
            this.datatype = ((datatype == null)?null:new ElementRef.Builder<>(this, datatype, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "datatype" property.
         * Use {@link org.javastro.ivoa.entities.vodml.ElementRef.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "datatype" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.ElementRef.Builder#end()} to return
         *     to the current builder.
         */
        public ElementRef.Builder<? extends SubsettedRole.Builder<_B>> withDatatype() {
            if (this.datatype!= null) {
                return this.datatype;
            }
            return this.datatype = new ElementRef.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "semanticconcept" (any previous value will be replaced)
         * 
         * @param semanticconcept
         *     New value of the "semanticconcept" property.
         */
        public SubsettedRole.Builder<_B> withSemanticconcept(final SemanticConcept semanticconcept) {
            this.semanticconcept = ((semanticconcept == null)?null:new SemanticConcept.Builder<>(this, semanticconcept, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "semanticconcept" property.
         * Use {@link org.javastro.ivoa.entities.vodml.SemanticConcept.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "semanticconcept" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.SemanticConcept.Builder#end()} to
         *     return to the current builder.
         */
        public SemanticConcept.Builder<? extends SubsettedRole.Builder<_B>> withSemanticconcept() {
            if (this.semanticconcept!= null) {
                return this.semanticconcept;
            }
            return this.semanticconcept = new SemanticConcept.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        @Override
        public SubsettedRole.Builder<_B> withDescription(final String description) {
            super.withDescription(description);
            return this;
        }

        @Override
        public SubsettedRole build() {
            if (_storedValue == null) {
                return this.init(new SubsettedRole());
            } else {
                return ((SubsettedRole) _storedValue);
            }
        }

        public SubsettedRole.Builder<_B> copyOf(final SubsettedRole _other) {
            _other.copyTo(this);
            return this;
        }

        public SubsettedRole.Builder<_B> copyOf(final SubsettedRole.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Constraint.Modifier
    {


        public void setRole(final ElementRef role) {
            SubsettedRole.this.setRole(role);
        }

        public void setDatatype(final ElementRef datatype) {
            SubsettedRole.this.setDatatype(datatype);
        }

        public void setSemanticconcept(final SemanticConcept semanticconcept) {
            SubsettedRole.this.setSemanticconcept(semanticconcept);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<SubsettedRole, ElementRef> ROLE = new SinglePropertyInfo<SubsettedRole,ElementRef>("role", SubsettedRole.class, ElementRef.class, false, null, new QName("", "role"), new QName("http://www.ivoa.net/xml/VODML/v1", "ElementRef"), false) {


            @Override
            public ElementRef get(final SubsettedRole _instance_) {
                return ((_instance_ == null)?null:_instance_.role);
            }

            @Override
            public void set(final SubsettedRole _instance_, final ElementRef _value_) {
                if (_instance_!= null) {
                    _instance_.role = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SubsettedRole, ElementRef> DATATYPE = new SinglePropertyInfo<SubsettedRole,ElementRef>("datatype", SubsettedRole.class, ElementRef.class, false, null, new QName("", "datatype"), new QName("http://www.ivoa.net/xml/VODML/v1", "ElementRef"), false) {


            @Override
            public ElementRef get(final SubsettedRole _instance_) {
                return ((_instance_ == null)?null:_instance_.datatype);
            }

            @Override
            public void set(final SubsettedRole _instance_, final ElementRef _value_) {
                if (_instance_!= null) {
                    _instance_.datatype = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SubsettedRole, SemanticConcept> SEMANTICCONCEPT = new SinglePropertyInfo<SubsettedRole,SemanticConcept>("semanticconcept", SubsettedRole.class, SemanticConcept.class, false, null, new QName("", "semanticconcept"), new QName("http://www.ivoa.net/xml/VODML/v1", "SemanticConcept"), false) {


            @Override
            public SemanticConcept get(final SubsettedRole _instance_) {
                return ((_instance_ == null)?null:_instance_.semanticconcept);
            }

            @Override
            public void set(final SubsettedRole _instance_, final SemanticConcept _value_) {
                if (_instance_!= null) {
                    _instance_.semanticconcept = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends SubsettedRole.Selector<SubsettedRole.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SubsettedRole.Select _root() {
            return new SubsettedRole.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Constraint.Selector<TRoot, TParent>
    {

        private ElementRef.Selector<TRoot, SubsettedRole.Selector<TRoot, TParent>> role = null;
        private ElementRef.Selector<TRoot, SubsettedRole.Selector<TRoot, TParent>> datatype = null;
        private SemanticConcept.Selector<TRoot, SubsettedRole.Selector<TRoot, TParent>> semanticconcept = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.role!= null) {
                products.put("role", this.role.init());
            }
            if (this.datatype!= null) {
                products.put("datatype", this.datatype.init());
            }
            if (this.semanticconcept!= null) {
                products.put("semanticconcept", this.semanticconcept.init());
            }
            return products;
        }

        public ElementRef.Selector<TRoot, SubsettedRole.Selector<TRoot, TParent>> role() {
            return ((this.role == null)?this.role = new ElementRef.Selector<>(this._root, this, "role"):this.role);
        }

        public ElementRef.Selector<TRoot, SubsettedRole.Selector<TRoot, TParent>> datatype() {
            return ((this.datatype == null)?this.datatype = new ElementRef.Selector<>(this._root, this, "datatype"):this.datatype);
        }

        public SemanticConcept.Selector<TRoot, SubsettedRole.Selector<TRoot, TParent>> semanticconcept() {
            return ((this.semanticconcept == null)?this.semanticconcept = new SemanticConcept.Selector<>(this._root, this, "semanticconcept"):this.semanticconcept);
        }

    }

}
