
package org.javastro.ivoa.entities.vosi.availability;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.javastro.ivoa.jaxb.adapters.ZonedDateTimeXmlAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Java class for Availability complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Availability">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="available" type="{http://www.w3.org/2001/XMLSchema}boolean"/>
 *         <element name="upSince" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         <element name="downAt" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         <element name="backAt" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         <element name="note" type="{http://www.w3.org/2001/XMLSchema}string" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Availability", propOrder = {
    "available",
    "upSince",
    "downAt",
    "backAt",
    "notes"
})
@XmlRootElement(name = "availability")
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Availability implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Indicates whether the service is currently available.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected boolean available;
    /**
     * The instant at which the service last became available.
     * 
     */
    @XmlElement(type = String.class)
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ZonedDateTime upSince;
    /**
     * The instant at which the service is next scheduled to become
     *             unavailable.
     * 
     */
    @XmlElement(type = String.class)
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ZonedDateTime downAt;
    /**
     * The instant at which the service is scheduled to become available 
     *             again after a period of unavailability.
     * 
     */
    @XmlElement(type = String.class)
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ZonedDateTime backAt;
    /**
     * A textual note concerning availability.
     * 
     */
    @XmlElement(name = "note")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<String> notes;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient Availability.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Availability() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Availability(final boolean available, final ZonedDateTime upSince, final ZonedDateTime downAt, final ZonedDateTime backAt, final List<String> notes) {
        this.available = available;
        this.upSince = upSince;
        this.downAt = downAt;
        this.backAt = backAt;
        this.notes = notes;
    }

    /**
     * Indicates whether the service is currently available.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean isAvailable() {
        return available;
    }

    /**
     * Sets the value of the available property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setAvailable(boolean value) {
        this.available = value;
    }

    /**
     * The instant at which the service last became available.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ZonedDateTime getUpSince() {
        return upSince;
    }

    /**
     * Sets the value of the upSince property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUpSince()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setUpSince(ZonedDateTime value) {
        this.upSince = value;
    }

    /**
     * The instant at which the service is next scheduled to become
     *             unavailable.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ZonedDateTime getDownAt() {
        return downAt;
    }

    /**
     * Sets the value of the downAt property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDownAt()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setDownAt(ZonedDateTime value) {
        this.downAt = value;
    }

    /**
     * The instant at which the service is scheduled to become available 
     *             again after a period of unavailability.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ZonedDateTime getBackAt() {
        return backAt;
    }

    /**
     * Sets the value of the backAt property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getBackAt()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setBackAt(ZonedDateTime value) {
        this.backAt = value;
    }

    /**
     * A textual note concerning availability.
     * 
     * Gets the value of the notes property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the notes property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNotes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the notes property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<String> getNotes() {
        if (notes == null) {
            notes = new ArrayList<>();
        }
        return this.notes;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Availability that = ((Availability) object);
        {
            boolean leftAvailable;
            leftAvailable = this.isAvailable();
            boolean rightAvailable;
            rightAvailable = that.isAvailable();
            if (leftAvailable!= rightAvailable) {
                return false;
            }
        }
        {
            ZonedDateTime leftUpSince;
            leftUpSince = this.getUpSince();
            ZonedDateTime rightUpSince;
            rightUpSince = that.getUpSince();
            if (this.upSince!= null) {
                if (that.upSince!= null) {
                    if (!leftUpSince.equals(rightUpSince)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.upSince!= null) {
                    return false;
                }
            }
        }
        {
            ZonedDateTime leftDownAt;
            leftDownAt = this.getDownAt();
            ZonedDateTime rightDownAt;
            rightDownAt = that.getDownAt();
            if (this.downAt!= null) {
                if (that.downAt!= null) {
                    if (!leftDownAt.equals(rightDownAt)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.downAt!= null) {
                    return false;
                }
            }
        }
        {
            ZonedDateTime leftBackAt;
            leftBackAt = this.getBackAt();
            ZonedDateTime rightBackAt;
            rightBackAt = that.getBackAt();
            if (this.backAt!= null) {
                if (that.backAt!= null) {
                    if (!leftBackAt.equals(rightBackAt)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.backAt!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftNotes;
            leftNotes = (((this.notes!= null)&&(!this.notes.isEmpty()))?this.getNotes():null);
            List<String> rightNotes;
            rightNotes = (((that.notes!= null)&&(!that.notes.isEmpty()))?that.getNotes():null);
            if ((this.notes!= null)&&(!this.notes.isEmpty())) {
                if ((that.notes!= null)&&(!that.notes.isEmpty())) {
                    if (!leftNotes.equals(rightNotes)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.notes!= null)&&(!that.notes.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            boolean theAvailable;
            theAvailable = this.isAvailable();
            currentHashCode += (theAvailable? 1231 : 1237);
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theUpSince;
            theUpSince = this.getUpSince();
            if (this.upSince!= null) {
                currentHashCode += theUpSince.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theDownAt;
            theDownAt = this.getDownAt();
            if (this.downAt!= null) {
                currentHashCode += theDownAt.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theBackAt;
            theBackAt = this.getBackAt();
            if (this.backAt!= null) {
                currentHashCode += theBackAt.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theNotes;
            theNotes = (((this.notes!= null)&&(!this.notes.isEmpty()))?this.getNotes():null);
            if ((this.notes!= null)&&(!this.notes.isEmpty())) {
                currentHashCode += theNotes.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            boolean theAvailable;
            theAvailable = this.isAvailable();
            strategy.appendField(locator, this, "available", buffer, theAvailable, true);
        }
        {
            ZonedDateTime theUpSince;
            theUpSince = this.getUpSince();
            strategy.appendField(locator, this, "upSince", buffer, theUpSince, (this.upSince!= null));
        }
        {
            ZonedDateTime theDownAt;
            theDownAt = this.getDownAt();
            strategy.appendField(locator, this, "downAt", buffer, theDownAt, (this.downAt!= null));
        }
        {
            ZonedDateTime theBackAt;
            theBackAt = this.getBackAt();
            strategy.appendField(locator, this, "backAt", buffer, theBackAt, (this.backAt!= null));
        }
        {
            List<String> theNotes;
            theNotes = (((this.notes!= null)&&(!this.notes.isEmpty()))?this.getNotes():null);
            strategy.appendField(locator, this, "notes", buffer, theNotes, ((this.notes!= null)&&(!this.notes.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Availability) {
            final Availability target = this;
            final Availability leftObject = ((Availability) left);
            final Availability rightObject = ((Availability) right);
            {
                Boolean availableShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (availableShouldBeMergedAndSet == Boolean.TRUE) {
                    boolean lhsAvailable;
                    lhsAvailable = leftObject.isAvailable();
                    boolean rhsAvailable;
                    rhsAvailable = rightObject.isAvailable();
                    boolean mergedAvailable = ((boolean) strategy.merge(LocatorUtils.property(leftLocator, "available", lhsAvailable), LocatorUtils.property(rightLocator, "available", rhsAvailable), lhsAvailable, rhsAvailable, true, true));
                    target.setAvailable(mergedAvailable);
                } else {
                    if (availableShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean upSinceShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.upSince!= null), (rightObject.upSince!= null));
                if (upSinceShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsUpSince;
                    lhsUpSince = leftObject.getUpSince();
                    ZonedDateTime rhsUpSince;
                    rhsUpSince = rightObject.getUpSince();
                    ZonedDateTime mergedUpSince = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "upSince", lhsUpSince), LocatorUtils.property(rightLocator, "upSince", rhsUpSince), lhsUpSince, rhsUpSince, (leftObject.upSince!= null), (rightObject.upSince!= null)));
                    target.setUpSince(mergedUpSince);
                } else {
                    if (upSinceShouldBeMergedAndSet == Boolean.FALSE) {
                        target.upSince = null;
                    }
                }
            }
            {
                Boolean downAtShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.downAt!= null), (rightObject.downAt!= null));
                if (downAtShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsDownAt;
                    lhsDownAt = leftObject.getDownAt();
                    ZonedDateTime rhsDownAt;
                    rhsDownAt = rightObject.getDownAt();
                    ZonedDateTime mergedDownAt = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "downAt", lhsDownAt), LocatorUtils.property(rightLocator, "downAt", rhsDownAt), lhsDownAt, rhsDownAt, (leftObject.downAt!= null), (rightObject.downAt!= null)));
                    target.setDownAt(mergedDownAt);
                } else {
                    if (downAtShouldBeMergedAndSet == Boolean.FALSE) {
                        target.downAt = null;
                    }
                }
            }
            {
                Boolean backAtShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.backAt!= null), (rightObject.backAt!= null));
                if (backAtShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsBackAt;
                    lhsBackAt = leftObject.getBackAt();
                    ZonedDateTime rhsBackAt;
                    rhsBackAt = rightObject.getBackAt();
                    ZonedDateTime mergedBackAt = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "backAt", lhsBackAt), LocatorUtils.property(rightLocator, "backAt", rhsBackAt), lhsBackAt, rhsBackAt, (leftObject.backAt!= null), (rightObject.backAt!= null)));
                    target.setBackAt(mergedBackAt);
                } else {
                    if (backAtShouldBeMergedAndSet == Boolean.FALSE) {
                        target.backAt = null;
                    }
                }
            }
            {
                Boolean notesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.notes!= null)&&(!leftObject.notes.isEmpty())), ((rightObject.notes!= null)&&(!rightObject.notes.isEmpty())));
                if (notesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsNotes;
                    lhsNotes = (((leftObject.notes!= null)&&(!leftObject.notes.isEmpty()))?leftObject.getNotes():null);
                    List<String> rhsNotes;
                    rhsNotes = (((rightObject.notes!= null)&&(!rightObject.notes.isEmpty()))?rightObject.getNotes():null);
                    List<String> mergedNotes = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "notes", lhsNotes), LocatorUtils.property(rightLocator, "notes", rhsNotes), lhsNotes, rhsNotes, ((leftObject.notes!= null)&&(!leftObject.notes.isEmpty())), ((rightObject.notes!= null)&&(!rightObject.notes.isEmpty()))));
                    target.notes = null;
                    if (mergedNotes!= null) {
                        List<String> uniqueNotesl = target.getNotes();
                        uniqueNotesl.addAll(mergedNotes);
                    }
                } else {
                    if (notesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.notes = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Availability();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Availability clone() {
        final Availability _newObject;
        try {
            _newObject = ((Availability) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.notes = ((this.notes == null)?null:new ArrayList<>(this.notes));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Availability createCopy() {
        final Availability _newObject;
        try {
            _newObject = ((Availability) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.available = this.available;
        _newObject.upSince = this.upSince;
        _newObject.downAt = this.downAt;
        _newObject.backAt = this.backAt;
        _newObject.notes = ((this.notes == null)?null:new ArrayList<>(this.notes));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Availability createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Availability _newObject;
        try {
            _newObject = ((Availability) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree availablePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("available"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(availablePropertyTree!= null):((availablePropertyTree == null)||(!availablePropertyTree.isLeaf())))) {
            _newObject.available = this.available;
        }
        final PropertyTree upSincePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("upSince"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(upSincePropertyTree!= null):((upSincePropertyTree == null)||(!upSincePropertyTree.isLeaf())))) {
            _newObject.upSince = this.upSince;
        }
        final PropertyTree downAtPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("downAt"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(downAtPropertyTree!= null):((downAtPropertyTree == null)||(!downAtPropertyTree.isLeaf())))) {
            _newObject.downAt = this.downAt;
        }
        final PropertyTree backAtPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("backAt"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(backAtPropertyTree!= null):((backAtPropertyTree == null)||(!backAtPropertyTree.isLeaf())))) {
            _newObject.backAt = this.backAt;
        }
        final PropertyTree notesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("notes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(notesPropertyTree!= null):((notesPropertyTree == null)||(!notesPropertyTree.isLeaf())))) {
            _newObject.notes = ((this.notes == null)?null:new ArrayList<>(this.notes));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Availability copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Availability copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Availability.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Availability.Modifier();
        }
        return ((Availability.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Availability.Builder<_B> _other) {
        _other.available = this.available;
        _other.upSince = this.upSince;
        _other.downAt = this.downAt;
        _other.backAt = this.backAt;
        if (this.notes == null) {
            _other.notes = null;
        } else {
            _other.notes = new ArrayList<>();
            for (String _item: this.notes) {
                _other.notes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Availability.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Availability.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Availability.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Availability.Builder<Void> builder() {
        return new Availability.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Availability.Builder<_B> copyOf(final Availability _other) {
        final Availability.Builder<_B> _newBuilder = new Availability.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Availability.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree availablePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("available"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(availablePropertyTree!= null):((availablePropertyTree == null)||(!availablePropertyTree.isLeaf())))) {
            _other.available = this.available;
        }
        final PropertyTree upSincePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("upSince"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(upSincePropertyTree!= null):((upSincePropertyTree == null)||(!upSincePropertyTree.isLeaf())))) {
            _other.upSince = this.upSince;
        }
        final PropertyTree downAtPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("downAt"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(downAtPropertyTree!= null):((downAtPropertyTree == null)||(!downAtPropertyTree.isLeaf())))) {
            _other.downAt = this.downAt;
        }
        final PropertyTree backAtPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("backAt"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(backAtPropertyTree!= null):((backAtPropertyTree == null)||(!backAtPropertyTree.isLeaf())))) {
            _other.backAt = this.backAt;
        }
        final PropertyTree notesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("notes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(notesPropertyTree!= null):((notesPropertyTree == null)||(!notesPropertyTree.isLeaf())))) {
            if (this.notes == null) {
                _other.notes = null;
            } else {
                _other.notes = new ArrayList<>();
                for (String _item: this.notes) {
                    _other.notes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Availability.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Availability.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Availability.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Availability.Builder<_B> copyOf(final Availability _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Availability.Builder<_B> _newBuilder = new Availability.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Availability.Builder<Void> copyExcept(final Availability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Availability.Builder<Void> copyOnly(final Availability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Availability visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(Availability.PropInfo.AVAILABLE, this));
        _visitor_.visit(new SingleProperty<>(Availability.PropInfo.UP_SINCE, this));
        _visitor_.visit(new SingleProperty<>(Availability.PropInfo.DOWN_AT, this));
        _visitor_.visit(new SingleProperty<>(Availability.PropInfo.BACK_AT, this));
        _visitor_.visit(new CollectionProperty<>(Availability.PropInfo.NOTES, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Availability _storedValue;
        private boolean available;
        private ZonedDateTime upSince;
        private ZonedDateTime downAt;
        private ZonedDateTime backAt;
        private List<Buildable> notes;

        public Builder(final _B _parentBuilder, final Availability _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.available = _other.available;
                    this.upSince = _other.upSince;
                    this.downAt = _other.downAt;
                    this.backAt = _other.backAt;
                    if (_other.notes == null) {
                        this.notes = null;
                    } else {
                        this.notes = new ArrayList<>();
                        for (String _item: _other.notes) {
                            this.notes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Availability _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree availablePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("available"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(availablePropertyTree!= null):((availablePropertyTree == null)||(!availablePropertyTree.isLeaf())))) {
                        this.available = _other.available;
                    }
                    final PropertyTree upSincePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("upSince"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(upSincePropertyTree!= null):((upSincePropertyTree == null)||(!upSincePropertyTree.isLeaf())))) {
                        this.upSince = _other.upSince;
                    }
                    final PropertyTree downAtPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("downAt"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(downAtPropertyTree!= null):((downAtPropertyTree == null)||(!downAtPropertyTree.isLeaf())))) {
                        this.downAt = _other.downAt;
                    }
                    final PropertyTree backAtPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("backAt"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(backAtPropertyTree!= null):((backAtPropertyTree == null)||(!backAtPropertyTree.isLeaf())))) {
                        this.backAt = _other.backAt;
                    }
                    final PropertyTree notesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("notes"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(notesPropertyTree!= null):((notesPropertyTree == null)||(!notesPropertyTree.isLeaf())))) {
                        if (_other.notes == null) {
                            this.notes = null;
                        } else {
                            this.notes = new ArrayList<>();
                            for (String _item: _other.notes) {
                                this.notes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Availability >_P init(final _P _product) {
            _product.available = this.available;
            _product.upSince = this.upSince;
            _product.downAt = this.downAt;
            _product.backAt = this.backAt;
            if (this.notes!= null) {
                final List<String> notes = new ArrayList<>(this.notes.size());
                for (Buildable _item: this.notes) {
                    notes.add(((String) _item.build()));
                }
                _product.notes = notes;
            }
            return _product;
        }

        /**
         * Sets the new value of "available" (any previous value will be replaced)
         * 
         * @param available
         *     New value of the "available" property.
         */
        public Availability.Builder<_B> withAvailable(final boolean available) {
            this.available = available;
            return this;
        }

        /**
         * Sets the new value of "upSince" (any previous value will be replaced)
         * 
         * @param upSince
         *     New value of the "upSince" property.
         */
        public Availability.Builder<_B> withUpSince(final ZonedDateTime upSince) {
            this.upSince = upSince;
            return this;
        }

        /**
         * Sets the new value of "downAt" (any previous value will be replaced)
         * 
         * @param downAt
         *     New value of the "downAt" property.
         */
        public Availability.Builder<_B> withDownAt(final ZonedDateTime downAt) {
            this.downAt = downAt;
            return this;
        }

        /**
         * Sets the new value of "backAt" (any previous value will be replaced)
         * 
         * @param backAt
         *     New value of the "backAt" property.
         */
        public Availability.Builder<_B> withBackAt(final ZonedDateTime backAt) {
            this.backAt = backAt;
            return this;
        }

        /**
         * Adds the given items to the value of "notes"
         * 
         * @param notes
         *     Items to add to the value of the "notes" property
         */
        public Availability.Builder<_B> addNotes(final Iterable<? extends String> notes) {
            if (notes!= null) {
                if (this.notes == null) {
                    this.notes = new ArrayList<>();
                }
                for (String _item: notes) {
                    this.notes.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "notes" (any previous value will be replaced)
         * 
         * @param notes
         *     New value of the "notes" property.
         */
        public Availability.Builder<_B> withNotes(final Iterable<? extends String> notes) {
            if (this.notes!= null) {
                this.notes.clear();
            }
            return addNotes(notes);
        }

        /**
         * Adds the given items to the value of "notes"
         * 
         * @param notes
         *     Items to add to the value of the "notes" property
         */
        public Availability.Builder<_B> addNotes(String... notes) {
            addNotes(Arrays.asList(notes));
            return this;
        }

        /**
         * Sets the new value of "notes" (any previous value will be replaced)
         * 
         * @param notes
         *     New value of the "notes" property.
         */
        public Availability.Builder<_B> withNotes(String... notes) {
            withNotes(Arrays.asList(notes));
            return this;
        }

        @Override
        public Availability build() {
            if (_storedValue == null) {
                return this.init(new Availability());
            } else {
                return ((Availability) _storedValue);
            }
        }

        public Availability.Builder<_B> copyOf(final Availability _other) {
            _other.copyTo(this);
            return this;
        }

        public Availability.Builder<_B> copyOf(final Availability.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setAvailable(final boolean available) {
            Availability.this.setAvailable(available);
        }

        public void setUpSince(final ZonedDateTime upSince) {
            Availability.this.setUpSince(upSince);
        }

        public void setDownAt(final ZonedDateTime downAt) {
            Availability.this.setDownAt(downAt);
        }

        public void setBackAt(final ZonedDateTime backAt) {
            Availability.this.setBackAt(backAt);
        }

        public List<String> getNotes() {
            if (Availability.this.notes == null) {
                Availability.this.notes = new ArrayList<>();
            }
            return Availability.this.notes;
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Availability, Boolean> AVAILABLE = new SinglePropertyInfo<Availability,Boolean>("available", Availability.class, Boolean.class, false, null, new QName("http://www.ivoa.net/xml/VOSIAvailability/v1.0", "available"), new QName("http://www.w3.org/2001/XMLSchema", "boolean"), false) {


            @Override
            public Boolean get(final Availability _instance_) {
                return ((_instance_ == null)?null:_instance_.available);
            }

            @Override
            public void set(final Availability _instance_, final Boolean _value_) {
                if (_instance_!= null) {
                    _instance_.available = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Availability, ZonedDateTime> UP_SINCE = new SinglePropertyInfo<Availability,ZonedDateTime>("upSince", Availability.class, ZonedDateTime.class, false, null, new QName("http://www.ivoa.net/xml/VOSIAvailability/v1.0", "upSince"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), false) {


            @Override
            public ZonedDateTime get(final Availability _instance_) {
                return ((_instance_ == null)?null:_instance_.upSince);
            }

            @Override
            public void set(final Availability _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.upSince = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Availability, ZonedDateTime> DOWN_AT = new SinglePropertyInfo<Availability,ZonedDateTime>("downAt", Availability.class, ZonedDateTime.class, false, null, new QName("http://www.ivoa.net/xml/VOSIAvailability/v1.0", "downAt"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), false) {


            @Override
            public ZonedDateTime get(final Availability _instance_) {
                return ((_instance_ == null)?null:_instance_.downAt);
            }

            @Override
            public void set(final Availability _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.downAt = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Availability, ZonedDateTime> BACK_AT = new SinglePropertyInfo<Availability,ZonedDateTime>("backAt", Availability.class, ZonedDateTime.class, false, null, new QName("http://www.ivoa.net/xml/VOSIAvailability/v1.0", "backAt"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), false) {


            @Override
            public ZonedDateTime get(final Availability _instance_) {
                return ((_instance_ == null)?null:_instance_.backAt);
            }

            @Override
            public void set(final Availability _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.backAt = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Availability, String> NOTES = new CollectionPropertyInfo<Availability,String>("notes", Availability.class, String.class, true, null, new QName("http://www.ivoa.net/xml/VOSIAvailability/v1.0", "note"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public List<String> get(final Availability _instance_) {
                return ((_instance_ == null)?null:_instance_.notes);
            }

            @Override
            public void set(final Availability _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.notes = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Availability.Selector<Availability.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Availability.Select _root() {
            return new Availability.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, Availability.Selector<TRoot, TParent>> upSince = null;
        private com.kscs.util.jaxb.Selector<TRoot, Availability.Selector<TRoot, TParent>> downAt = null;
        private com.kscs.util.jaxb.Selector<TRoot, Availability.Selector<TRoot, TParent>> backAt = null;
        private com.kscs.util.jaxb.Selector<TRoot, Availability.Selector<TRoot, TParent>> notes = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.upSince!= null) {
                products.put("upSince", this.upSince.init());
            }
            if (this.downAt!= null) {
                products.put("downAt", this.downAt.init());
            }
            if (this.backAt!= null) {
                products.put("backAt", this.backAt.init());
            }
            if (this.notes!= null) {
                products.put("notes", this.notes.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Availability.Selector<TRoot, TParent>> upSince() {
            return ((this.upSince == null)?this.upSince = new com.kscs.util.jaxb.Selector<>(this._root, this, "upSince"):this.upSince);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Availability.Selector<TRoot, TParent>> downAt() {
            return ((this.downAt == null)?this.downAt = new com.kscs.util.jaxb.Selector<>(this._root, this, "downAt"):this.downAt);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Availability.Selector<TRoot, TParent>> backAt() {
            return ((this.backAt == null)?this.backAt = new com.kscs.util.jaxb.Selector<>(this._root, this, "backAt"):this.backAt);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Availability.Selector<TRoot, TParent>> notes() {
            return ((this.notes == null)?this.notes = new com.kscs.util.jaxb.Selector<>(this._root, this, "notes"):this.notes);
        }

    }

}
