/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.resource.dataservice;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.javastro.ivoa.entities.resource.AccessURL;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.ResourceName;
import org.javastro.ivoa.entities.resource.Rights;
import org.javastro.ivoa.entities.resource.Validation;
import org.javastro.ivoa.entities.resource.dataservice.Coverage;
import org.javastro.ivoa.entities.resource.dataservice.Format;
import org.javastro.ivoa.entities.resource.dataservice.Tableset;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DataCollection", propOrder={"facilities", "instruments", "rights", "formats", "coverage", "tableset", "accessURL"})
public class DataCollection
extends Resource
implements Cloneable,
Copyable,
PartialCopyable,
MergeFrom,
ToString {
    @XmlElement(name="facility")
    protected List<ResourceName> facilities;
    @XmlElement(name="instrument")
    protected List<ResourceName> instruments;
    protected List<Rights> rights;
    @XmlElement(name="format")
    protected List<Format> formats;
    protected Coverage coverage;
    protected Tableset tableset;
    protected AccessURL accessURL;

    public DataCollection() {
    }

    public DataCollection(List<Validation> validationLevels, String title, String shortName, String identifier, List<String> altIdentifiers, Curation curation, Content content, ZonedDateTime created, ZonedDateTime updated, String status, String version, List<ResourceName> facilities, List<ResourceName> instruments, List<Rights> rights, List<Format> formats, Coverage coverage, Tableset tableset, AccessURL accessURL) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version);
        this.facilities = facilities;
        this.instruments = instruments;
        this.rights = rights;
        this.formats = formats;
        this.coverage = coverage;
        this.tableset = tableset;
        this.accessURL = accessURL;
    }

    public List<ResourceName> getFacilities() {
        if (this.facilities == null) {
            this.facilities = new ArrayList<ResourceName>();
        }
        return this.facilities;
    }

    public List<ResourceName> getInstruments() {
        if (this.instruments == null) {
            this.instruments = new ArrayList<ResourceName>();
        }
        return this.instruments;
    }

    public List<Rights> getRights() {
        if (this.rights == null) {
            this.rights = new ArrayList<Rights>();
        }
        return this.rights;
    }

    public List<Format> getFormats() {
        if (this.formats == null) {
            this.formats = new ArrayList<Format>();
        }
        return this.formats;
    }

    public Coverage getCoverage() {
        return this.coverage;
    }

    public void setCoverage(Coverage value) {
        this.coverage = value;
    }

    public Tableset getTableset() {
        return this.tableset;
    }

    public void setTableset(Tableset value) {
        this.tableset = value;
    }

    public AccessURL getAccessURL() {
        return this.accessURL;
    }

    public void setAccessURL(AccessURL value) {
        this.accessURL = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Format> rightFormats;
        List<Rights> rightRights;
        List<ResourceName> rightInstruments;
        List<ResourceName> rightFacilities;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DataCollection that = (DataCollection)object;
        List<ResourceName> leftFacilities = this.facilities != null && !this.facilities.isEmpty() ? this.getFacilities() : null;
        List<ResourceName> list = rightFacilities = that.facilities != null && !that.facilities.isEmpty() ? that.getFacilities() : null;
        if (this.facilities != null && !this.facilities.isEmpty()) {
            if (that.facilities == null || that.facilities.isEmpty()) return false;
            if (!leftFacilities.equals(rightFacilities)) {
                return false;
            }
        } else if (that.facilities != null && !that.facilities.isEmpty()) {
            return false;
        }
        List<ResourceName> leftInstruments = this.instruments != null && !this.instruments.isEmpty() ? this.getInstruments() : null;
        List<ResourceName> list2 = rightInstruments = that.instruments != null && !that.instruments.isEmpty() ? that.getInstruments() : null;
        if (this.instruments != null && !this.instruments.isEmpty()) {
            if (that.instruments == null || that.instruments.isEmpty()) return false;
            if (!leftInstruments.equals(rightInstruments)) {
                return false;
            }
        } else if (that.instruments != null && !that.instruments.isEmpty()) {
            return false;
        }
        List<Rights> leftRights = this.rights != null && !this.rights.isEmpty() ? this.getRights() : null;
        List<Rights> list3 = rightRights = that.rights != null && !that.rights.isEmpty() ? that.getRights() : null;
        if (this.rights != null && !this.rights.isEmpty()) {
            if (that.rights == null || that.rights.isEmpty()) return false;
            if (!leftRights.equals(rightRights)) {
                return false;
            }
        } else if (that.rights != null && !that.rights.isEmpty()) {
            return false;
        }
        List<Format> leftFormats = this.formats != null && !this.formats.isEmpty() ? this.getFormats() : null;
        List<Format> list4 = rightFormats = that.formats != null && !that.formats.isEmpty() ? that.getFormats() : null;
        if (this.formats != null && !this.formats.isEmpty()) {
            if (that.formats == null || that.formats.isEmpty()) return false;
            if (!leftFormats.equals(rightFormats)) {
                return false;
            }
        } else if (that.formats != null && !that.formats.isEmpty()) {
            return false;
        }
        Coverage leftCoverage = this.getCoverage();
        Coverage rightCoverage = that.getCoverage();
        if (this.coverage != null) {
            if (that.coverage == null) return false;
            if (!leftCoverage.equals(rightCoverage)) {
                return false;
            }
        } else if (that.coverage != null) {
            return false;
        }
        Tableset leftTableset = this.getTableset();
        Tableset rightTableset = that.getTableset();
        if (this.tableset != null) {
            if (that.tableset == null) return false;
            if (!leftTableset.equals(rightTableset)) {
                return false;
            }
        } else if (that.tableset != null) {
            return false;
        }
        AccessURL leftAccessURL = this.getAccessURL();
        AccessURL rightAccessURL = that.getAccessURL();
        if (this.accessURL != null) {
            if (that.accessURL == null) return false;
            if (leftAccessURL.equals(rightAccessURL)) return true;
            return false;
        }
        if (that.accessURL == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Format> theFormats;
        List<Rights> theRights;
        List<ResourceName> theInstruments;
        List<ResourceName> theFacilities;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        List<ResourceName> list = theFacilities = this.facilities != null && !this.facilities.isEmpty() ? this.getFacilities() : null;
        if (this.facilities != null && !this.facilities.isEmpty()) {
            currentHashCode += theFacilities.hashCode();
        }
        currentHashCode *= 31;
        List<ResourceName> list2 = theInstruments = this.instruments != null && !this.instruments.isEmpty() ? this.getInstruments() : null;
        if (this.instruments != null && !this.instruments.isEmpty()) {
            currentHashCode += theInstruments.hashCode();
        }
        currentHashCode *= 31;
        List<Rights> list3 = theRights = this.rights != null && !this.rights.isEmpty() ? this.getRights() : null;
        if (this.rights != null && !this.rights.isEmpty()) {
            currentHashCode += theRights.hashCode();
        }
        currentHashCode *= 31;
        List<Format> list4 = theFormats = this.formats != null && !this.formats.isEmpty() ? this.getFormats() : null;
        if (this.formats != null && !this.formats.isEmpty()) {
            currentHashCode += theFormats.hashCode();
        }
        currentHashCode *= 31;
        Coverage theCoverage = this.getCoverage();
        if (this.coverage != null) {
            currentHashCode += theCoverage.hashCode();
        }
        currentHashCode *= 31;
        Tableset theTableset = this.getTableset();
        if (this.tableset != null) {
            currentHashCode += theTableset.hashCode();
        }
        currentHashCode *= 31;
        AccessURL theAccessURL = this.getAccessURL();
        if (this.accessURL != null) {
            currentHashCode += theAccessURL.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<ResourceName> theFacilities = this.facilities != null && !this.facilities.isEmpty() ? this.getFacilities() : null;
        strategy.appendField(locator, (Object)this, "facilities", buffer, theFacilities, this.facilities != null && !this.facilities.isEmpty());
        List<ResourceName> theInstruments = this.instruments != null && !this.instruments.isEmpty() ? this.getInstruments() : null;
        strategy.appendField(locator, (Object)this, "instruments", buffer, theInstruments, this.instruments != null && !this.instruments.isEmpty());
        List<Rights> theRights = this.rights != null && !this.rights.isEmpty() ? this.getRights() : null;
        strategy.appendField(locator, (Object)this, "rights", buffer, theRights, this.rights != null && !this.rights.isEmpty());
        List<Format> theFormats = this.formats != null && !this.formats.isEmpty() ? this.getFormats() : null;
        strategy.appendField(locator, (Object)this, "formats", buffer, theFormats, this.formats != null && !this.formats.isEmpty());
        Coverage theCoverage = this.getCoverage();
        strategy.appendField(locator, (Object)this, "coverage", buffer, (Object)theCoverage, this.coverage != null);
        Tableset theTableset = this.getTableset();
        strategy.appendField(locator, (Object)this, "tableset", buffer, (Object)theTableset, this.tableset != null);
        AccessURL theAccessURL = this.getAccessURL();
        strategy.appendField(locator, (Object)this, "accessURL", buffer, (Object)theAccessURL, this.accessURL != null);
        return buffer;
    }

    @Override
    public void mergeFrom(Object left, Object right) {
        JAXBMergeStrategy strategy = JAXBMergeStrategy.getInstance();
        this.mergeFrom(null, null, left, right, (MergeStrategy)strategy);
    }

    @Override
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof DataCollection) {
            DataCollection target = this;
            DataCollection leftObject = (DataCollection)left;
            DataCollection rightObject = (DataCollection)right;
            Boolean facilitiesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.facilities != null && !leftObject.facilities.isEmpty(), rightObject.facilities != null && !rightObject.facilities.isEmpty());
            if (facilitiesShouldBeMergedAndSet == Boolean.TRUE) {
                List<ResourceName> lhsFacilities = leftObject.facilities != null && !leftObject.facilities.isEmpty() ? leftObject.getFacilities() : null;
                List<ResourceName> rhsFacilities = rightObject.facilities != null && !rightObject.facilities.isEmpty() ? rightObject.getFacilities() : null;
                List mergedFacilities = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"facilities", lhsFacilities), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"facilities", rhsFacilities), lhsFacilities, rhsFacilities, leftObject.facilities != null && !leftObject.facilities.isEmpty(), rightObject.facilities != null && !rightObject.facilities.isEmpty());
                target.facilities = null;
                if (mergedFacilities != null) {
                    List<ResourceName> uniqueFacilitiesl = target.getFacilities();
                    uniqueFacilitiesl.addAll(mergedFacilities);
                }
            } else if (facilitiesShouldBeMergedAndSet == Boolean.FALSE) {
                target.facilities = null;
            }
            Boolean instrumentsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.instruments != null && !leftObject.instruments.isEmpty(), rightObject.instruments != null && !rightObject.instruments.isEmpty());
            if (instrumentsShouldBeMergedAndSet == Boolean.TRUE) {
                List<ResourceName> lhsInstruments = leftObject.instruments != null && !leftObject.instruments.isEmpty() ? leftObject.getInstruments() : null;
                List<ResourceName> rhsInstruments = rightObject.instruments != null && !rightObject.instruments.isEmpty() ? rightObject.getInstruments() : null;
                List mergedInstruments = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"instruments", lhsInstruments), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"instruments", rhsInstruments), lhsInstruments, rhsInstruments, leftObject.instruments != null && !leftObject.instruments.isEmpty(), rightObject.instruments != null && !rightObject.instruments.isEmpty());
                target.instruments = null;
                if (mergedInstruments != null) {
                    List<ResourceName> uniqueInstrumentsl = target.getInstruments();
                    uniqueInstrumentsl.addAll(mergedInstruments);
                }
            } else if (instrumentsShouldBeMergedAndSet == Boolean.FALSE) {
                target.instruments = null;
            }
            Boolean rightsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.rights != null && !leftObject.rights.isEmpty(), rightObject.rights != null && !rightObject.rights.isEmpty());
            if (rightsShouldBeMergedAndSet == Boolean.TRUE) {
                List<Rights> lhsRights = leftObject.rights != null && !leftObject.rights.isEmpty() ? leftObject.getRights() : null;
                List<Rights> rhsRights = rightObject.rights != null && !rightObject.rights.isEmpty() ? rightObject.getRights() : null;
                List mergedRights = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"rights", lhsRights), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"rights", rhsRights), lhsRights, rhsRights, leftObject.rights != null && !leftObject.rights.isEmpty(), rightObject.rights != null && !rightObject.rights.isEmpty());
                target.rights = null;
                if (mergedRights != null) {
                    List<Rights> uniqueRightsl = target.getRights();
                    uniqueRightsl.addAll(mergedRights);
                }
            } else if (rightsShouldBeMergedAndSet == Boolean.FALSE) {
                target.rights = null;
            }
            Boolean formatsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.formats != null && !leftObject.formats.isEmpty(), rightObject.formats != null && !rightObject.formats.isEmpty());
            if (formatsShouldBeMergedAndSet == Boolean.TRUE) {
                List<Format> lhsFormats = leftObject.formats != null && !leftObject.formats.isEmpty() ? leftObject.getFormats() : null;
                List<Format> rhsFormats = rightObject.formats != null && !rightObject.formats.isEmpty() ? rightObject.getFormats() : null;
                List mergedFormats = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"formats", lhsFormats), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"formats", rhsFormats), lhsFormats, rhsFormats, leftObject.formats != null && !leftObject.formats.isEmpty(), rightObject.formats != null && !rightObject.formats.isEmpty());
                target.formats = null;
                if (mergedFormats != null) {
                    List<Format> uniqueFormatsl = target.getFormats();
                    uniqueFormatsl.addAll(mergedFormats);
                }
            } else if (formatsShouldBeMergedAndSet == Boolean.FALSE) {
                target.formats = null;
            }
            Boolean coverageShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.coverage != null, rightObject.coverage != null);
            if (coverageShouldBeMergedAndSet == Boolean.TRUE) {
                Coverage lhsCoverage = leftObject.getCoverage();
                Coverage rhsCoverage = rightObject.getCoverage();
                Coverage mergedCoverage = (Coverage)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"coverage", (Object)lhsCoverage), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"coverage", (Object)rhsCoverage), (Object)lhsCoverage, (Object)rhsCoverage, leftObject.coverage != null, rightObject.coverage != null);
                target.setCoverage(mergedCoverage);
            } else if (coverageShouldBeMergedAndSet == Boolean.FALSE) {
                target.coverage = null;
            }
            Boolean tablesetShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.tableset != null, rightObject.tableset != null);
            if (tablesetShouldBeMergedAndSet == Boolean.TRUE) {
                Tableset lhsTableset = leftObject.getTableset();
                Tableset rhsTableset = rightObject.getTableset();
                Tableset mergedTableset = (Tableset)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"tableset", (Object)lhsTableset), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"tableset", (Object)rhsTableset), (Object)lhsTableset, (Object)rhsTableset, leftObject.tableset != null, rightObject.tableset != null);
                target.setTableset(mergedTableset);
            } else if (tablesetShouldBeMergedAndSet == Boolean.FALSE) {
                target.tableset = null;
            }
            Boolean accessURLShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.accessURL != null, rightObject.accessURL != null);
            if (accessURLShouldBeMergedAndSet == Boolean.TRUE) {
                AccessURL lhsAccessURL = leftObject.getAccessURL();
                AccessURL rhsAccessURL = rightObject.getAccessURL();
                AccessURL mergedAccessURL = (AccessURL)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"accessURL", (Object)lhsAccessURL), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"accessURL", (Object)rhsAccessURL), (Object)lhsAccessURL, (Object)rhsAccessURL, leftObject.accessURL != null, rightObject.accessURL != null);
                target.setAccessURL(mergedAccessURL);
            } else if (accessURLShouldBeMergedAndSet == Boolean.FALSE) {
                target.accessURL = null;
            }
        }
    }

    @Override
    public Object createNewInstance() {
        return new DataCollection();
    }

    @Override
    public DataCollection clone() {
        DataCollection _newObject = (DataCollection)super.clone();
        if (this.facilities == null) {
            _newObject.facilities = null;
        } else {
            _newObject.facilities = new ArrayList<ResourceName>();
            for (ResourceName resourceName : this.facilities) {
                _newObject.facilities.add(resourceName == null ? null : resourceName.clone());
            }
        }
        if (this.instruments == null) {
            _newObject.instruments = null;
        } else {
            _newObject.instruments = new ArrayList<ResourceName>();
            for (ResourceName resourceName : this.instruments) {
                _newObject.instruments.add(resourceName == null ? null : resourceName.clone());
            }
        }
        if (this.rights == null) {
            _newObject.rights = null;
        } else {
            _newObject.rights = new ArrayList<Rights>();
            for (Rights rights : this.rights) {
                _newObject.rights.add(rights == null ? null : rights.clone());
            }
        }
        if (this.formats == null) {
            _newObject.formats = null;
        } else {
            _newObject.formats = new ArrayList<Format>();
            for (Format format : this.formats) {
                _newObject.formats.add(format == null ? null : format.clone());
            }
        }
        _newObject.coverage = this.coverage == null ? null : this.coverage.clone();
        _newObject.tableset = this.tableset == null ? null : this.tableset.clone();
        _newObject.accessURL = this.accessURL == null ? null : this.accessURL.clone();
        return _newObject;
    }

    @Override
    public DataCollection createCopy() {
        DataCollection _newObject = (DataCollection)super.createCopy();
        if (this.facilities == null) {
            _newObject.facilities = null;
        } else {
            _newObject.facilities = new ArrayList<ResourceName>();
            for (ResourceName resourceName : this.facilities) {
                _newObject.facilities.add(resourceName == null ? null : resourceName.createCopy());
            }
        }
        if (this.instruments == null) {
            _newObject.instruments = null;
        } else {
            _newObject.instruments = new ArrayList<ResourceName>();
            for (ResourceName resourceName : this.instruments) {
                _newObject.instruments.add(resourceName == null ? null : resourceName.createCopy());
            }
        }
        if (this.rights == null) {
            _newObject.rights = null;
        } else {
            _newObject.rights = new ArrayList<Rights>();
            for (Rights rights : this.rights) {
                _newObject.rights.add(rights == null ? null : rights.createCopy());
            }
        }
        if (this.formats == null) {
            _newObject.formats = null;
        } else {
            _newObject.formats = new ArrayList<Format>();
            for (Format format : this.formats) {
                _newObject.formats.add(format == null ? null : format.createCopy());
            }
        }
        _newObject.coverage = this.coverage == null ? null : this.coverage.createCopy();
        _newObject.tableset = this.tableset == null ? null : this.tableset.createCopy();
        _newObject.accessURL = this.accessURL == null ? null : this.accessURL.createCopy();
        return _newObject;
    }

    @Override
    public DataCollection createCopy(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree accessURLPropertyTree;
        PropertyTree tablesetPropertyTree;
        PropertyTree propertyTree;
        PropertyTree propertyTree2;
        PropertyTree propertyTree3;
        PropertyTree instrumentsPropertyTree;
        PropertyTree facilitiesPropertyTree;
        DataCollection _newObject = (DataCollection)super.createCopy(_propertyTree, _propertyTreeUse);
        PropertyTree propertyTree4 = facilitiesPropertyTree = _propertyTree == null ? null : _propertyTree.get("facilities");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? facilitiesPropertyTree != null : facilitiesPropertyTree == null || !facilitiesPropertyTree.isLeaf()) {
            if (this.facilities == null) {
                _newObject.facilities = null;
            } else {
                _newObject.facilities = new ArrayList<ResourceName>();
                for (ResourceName resourceName : this.facilities) {
                    _newObject.facilities.add(resourceName == null ? null : resourceName.createCopy(facilitiesPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree5 = instrumentsPropertyTree = _propertyTree == null ? null : _propertyTree.get("instruments");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? instrumentsPropertyTree != null : instrumentsPropertyTree == null || !instrumentsPropertyTree.isLeaf()) {
            if (this.instruments == null) {
                _newObject.instruments = null;
            } else {
                _newObject.instruments = new ArrayList<ResourceName>();
                for (ResourceName resourceName : this.instruments) {
                    _newObject.instruments.add(resourceName == null ? null : resourceName.createCopy(instrumentsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree6 = propertyTree3 = _propertyTree == null ? null : _propertyTree.get("rights");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree3 != null : propertyTree3 == null || !propertyTree3.isLeaf()) {
            if (this.rights == null) {
                _newObject.rights = null;
            } else {
                _newObject.rights = new ArrayList<Rights>();
                for (Rights rights : this.rights) {
                    _newObject.rights.add(rights == null ? null : rights.createCopy(propertyTree3, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree7 = propertyTree2 = _propertyTree == null ? null : _propertyTree.get("formats");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree2 != null : propertyTree2 == null || !propertyTree2.isLeaf()) {
            if (this.formats == null) {
                _newObject.formats = null;
            } else {
                _newObject.formats = new ArrayList<Format>();
                for (Format _item : this.formats) {
                    _newObject.formats.add(_item == null ? null : _item.createCopy(propertyTree2, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree8 = propertyTree = _propertyTree == null ? null : _propertyTree.get("coverage");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
            _newObject.coverage = this.coverage == null ? null : this.coverage.createCopy(propertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree9 = tablesetPropertyTree = _propertyTree == null ? null : _propertyTree.get("tableset");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? tablesetPropertyTree != null : tablesetPropertyTree == null || !tablesetPropertyTree.isLeaf()) {
            _newObject.tableset = this.tableset == null ? null : this.tableset.createCopy(tablesetPropertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree10 = accessURLPropertyTree = _propertyTree == null ? null : _propertyTree.get("accessURL");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? accessURLPropertyTree != null : accessURLPropertyTree == null || !accessURLPropertyTree.isLeaf()) {
            _newObject.accessURL = this.accessURL == null ? null : this.accessURL.createCopy(accessURLPropertyTree, _propertyTreeUse);
        }
        return _newObject;
    }

    @Override
    public DataCollection copyExcept(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    public DataCollection copyOnly(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Modifier();
        }
        return (Modifier)this.__cachedModifier__;
    }

    public <_B> void copyTo(Builder<_B> _other) {
        super.copyTo(_other);
        if (this.facilities == null) {
            _other.facilities = null;
        } else {
            _other.facilities = new ArrayList();
            for (ResourceName resourceName : this.facilities) {
                _other.facilities.add(resourceName == null ? null : resourceName.newCopyBuilder(_other));
            }
        }
        if (this.instruments == null) {
            _other.instruments = null;
        } else {
            _other.instruments = new ArrayList();
            for (ResourceName resourceName : this.instruments) {
                _other.instruments.add(resourceName == null ? null : resourceName.newCopyBuilder(_other));
            }
        }
        if (this.rights == null) {
            _other.rights = null;
        } else {
            _other.rights = new ArrayList();
            for (Rights rights : this.rights) {
                _other.rights.add(rights == null ? null : rights.newCopyBuilder(_other));
            }
        }
        if (this.formats == null) {
            _other.formats = null;
        } else {
            _other.formats = new ArrayList();
            for (Format format : this.formats) {
                _other.formats.add(format == null ? null : format.newCopyBuilder(_other));
            }
        }
        _other.coverage = this.coverage == null ? null : this.coverage.newCopyBuilder(_other);
        _other.tableset = this.tableset == null ? null : this.tableset.newCopyBuilder(_other);
        _other.accessURL = this.accessURL == null ? null : this.accessURL.newCopyBuilder(_other);
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder) {
        return new Builder<_B>(_parentBuilder, this, true);
    }

    public Builder<Void> newCopyBuilder() {
        return this.newCopyBuilder((Object)null);
    }

    public static Builder<Void> builder() {
        return new Builder<Object>(null, null, false);
    }

    public static <_B> Builder<_B> copyOf(Resource _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(DataCollection _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public <_B> void copyTo(Builder<_B> _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree accessURLPropertyTree;
        PropertyTree tablesetPropertyTree;
        PropertyTree propertyTree;
        PropertyTree propertyTree2;
        PropertyTree propertyTree3;
        PropertyTree instrumentsPropertyTree;
        PropertyTree facilitiesPropertyTree;
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        PropertyTree propertyTree4 = facilitiesPropertyTree = _propertyTree == null ? null : _propertyTree.get("facilities");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? facilitiesPropertyTree != null : facilitiesPropertyTree == null || !facilitiesPropertyTree.isLeaf()) {
            if (this.facilities == null) {
                _other.facilities = null;
            } else {
                _other.facilities = new ArrayList();
                for (ResourceName resourceName : this.facilities) {
                    _other.facilities.add(resourceName == null ? null : resourceName.newCopyBuilder(_other, facilitiesPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree5 = instrumentsPropertyTree = _propertyTree == null ? null : _propertyTree.get("instruments");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? instrumentsPropertyTree != null : instrumentsPropertyTree == null || !instrumentsPropertyTree.isLeaf()) {
            if (this.instruments == null) {
                _other.instruments = null;
            } else {
                _other.instruments = new ArrayList();
                for (ResourceName resourceName : this.instruments) {
                    _other.instruments.add(resourceName == null ? null : resourceName.newCopyBuilder(_other, instrumentsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree6 = propertyTree3 = _propertyTree == null ? null : _propertyTree.get("rights");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree3 != null : propertyTree3 == null || !propertyTree3.isLeaf()) {
            if (this.rights == null) {
                _other.rights = null;
            } else {
                _other.rights = new ArrayList();
                for (Rights rights : this.rights) {
                    _other.rights.add(rights == null ? null : rights.newCopyBuilder(_other, propertyTree3, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree7 = propertyTree2 = _propertyTree == null ? null : _propertyTree.get("formats");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree2 != null : propertyTree2 == null || !propertyTree2.isLeaf()) {
            if (this.formats == null) {
                _other.formats = null;
            } else {
                _other.formats = new ArrayList();
                for (Format _item : this.formats) {
                    _other.formats.add(_item == null ? null : _item.newCopyBuilder(_other, propertyTree2, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree8 = propertyTree = _propertyTree == null ? null : _propertyTree.get("coverage");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
            _other.coverage = this.coverage == null ? null : this.coverage.newCopyBuilder(_other, propertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree9 = tablesetPropertyTree = _propertyTree == null ? null : _propertyTree.get("tableset");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? tablesetPropertyTree != null : tablesetPropertyTree == null || !tablesetPropertyTree.isLeaf()) {
            _other.tableset = this.tableset == null ? null : this.tableset.newCopyBuilder(_other, tablesetPropertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree10 = accessURLPropertyTree = _propertyTree == null ? null : _propertyTree.get("accessURL");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? accessURLPropertyTree != null : accessURLPropertyTree == null || !accessURLPropertyTree.isLeaf()) {
            _other.accessURL = this.accessURL == null ? null : this.accessURL.newCopyBuilder(_other, accessURLPropertyTree, _propertyTreeUse);
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return new Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    public Builder<Void> newCopyBuilder(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return this.newCopyBuilder((Object)null, _propertyTree, _propertyTreeUse);
    }

    public static <_B> Builder<_B> copyOf(Resource _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(DataCollection _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static Builder<Void> copyExcept(Resource _other, PropertyTree _propertyTree) {
        return DataCollection.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(DataCollection _other, PropertyTree _propertyTree) {
        return DataCollection.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyOnly(Resource _other, PropertyTree _propertyTree) {
        return DataCollection.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(DataCollection _other, PropertyTree _propertyTree) {
        return DataCollection.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public DataCollection visit(PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty(PropInfo.FACILITIES, (Object)this)) && this.facilities != null) {
            for (ResourceName resourceName : this.facilities) {
                if (resourceName == null) continue;
                resourceName.visit(_visitor_);
            }
        }
        if (_visitor_.visit(new CollectionProperty(PropInfo.INSTRUMENTS, (Object)this)) && this.instruments != null) {
            for (ResourceName resourceName : this.instruments) {
                if (resourceName == null) continue;
                resourceName.visit(_visitor_);
            }
        }
        if (_visitor_.visit(new CollectionProperty(PropInfo.RIGHTS, (Object)this)) && this.rights != null) {
            for (Rights rights : this.rights) {
                if (rights == null) continue;
                rights.visit(_visitor_);
            }
        }
        if (_visitor_.visit(new CollectionProperty(PropInfo.FORMATS, (Object)this)) && this.formats != null) {
            for (Format format : this.formats) {
                if (format == null) continue;
                format.visit(_visitor_);
            }
        }
        if (_visitor_.visit(new SingleProperty(PropInfo.COVERAGE, (Object)this)) && this.coverage != null) {
            this.coverage.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty(PropInfo.TABLESET, (Object)this)) && this.tableset != null) {
            this.tableset.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty(PropInfo.ACCESS_URL, (Object)this)) && this.accessURL != null) {
            this.accessURL.visit(_visitor_);
        }
        return this;
    }

    public class Modifier
    extends Resource.Modifier {
        public Modifier() {
            super(DataCollection.this);
        }

        public List<ResourceName> getFacilities() {
            if (DataCollection.this.facilities == null) {
                DataCollection.this.facilities = new ArrayList<ResourceName>();
            }
            return DataCollection.this.facilities;
        }

        public List<ResourceName> getInstruments() {
            if (DataCollection.this.instruments == null) {
                DataCollection.this.instruments = new ArrayList<ResourceName>();
            }
            return DataCollection.this.instruments;
        }

        public List<Rights> getRights() {
            if (DataCollection.this.rights == null) {
                DataCollection.this.rights = new ArrayList<Rights>();
            }
            return DataCollection.this.rights;
        }

        public List<Format> getFormats() {
            if (DataCollection.this.formats == null) {
                DataCollection.this.formats = new ArrayList<Format>();
            }
            return DataCollection.this.formats;
        }

        public void setCoverage(Coverage coverage) {
            DataCollection.this.setCoverage(coverage);
        }

        public void setTableset(Tableset tableset) {
            DataCollection.this.setTableset(tableset);
        }

        public void setAccessURL(AccessURL accessURL) {
            DataCollection.this.setAccessURL(accessURL);
        }
    }

    public static class Builder<_B>
    extends Resource.Builder<_B>
    implements Buildable {
        private List<ResourceName.Builder<Builder<_B>>> facilities;
        private List<ResourceName.Builder<Builder<_B>>> instruments;
        private List<Rights.Builder<Builder<_B>>> rights;
        private List<Format.Builder<Builder<_B>>> formats;
        private Coverage.Builder<Builder<_B>> coverage;
        private Tableset.Builder<Builder<_B>> tableset;
        private AccessURL.Builder<Builder<_B>> accessURL;

        public Builder(_B _parentBuilder, DataCollection _other, boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other != null) {
                if (_other.facilities == null) {
                    this.facilities = null;
                } else {
                    this.facilities = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                    for (ResourceName resourceName : _other.facilities) {
                        this.facilities.add(resourceName == null ? null : resourceName.newCopyBuilder(this));
                    }
                }
                if (_other.instruments == null) {
                    this.instruments = null;
                } else {
                    this.instruments = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                    for (ResourceName resourceName : _other.instruments) {
                        this.instruments.add(resourceName == null ? null : resourceName.newCopyBuilder(this));
                    }
                }
                if (_other.rights == null) {
                    this.rights = null;
                } else {
                    this.rights = new ArrayList<Rights.Builder<Builder<_B>>>();
                    for (Rights rights : _other.rights) {
                        this.rights.add(rights == null ? null : rights.newCopyBuilder(this));
                    }
                }
                if (_other.formats == null) {
                    this.formats = null;
                } else {
                    this.formats = new ArrayList<Format.Builder<Builder<_B>>>();
                    for (Format format : _other.formats) {
                        this.formats.add(format == null ? null : format.newCopyBuilder(this));
                    }
                }
                this.coverage = _other.coverage == null ? null : _other.coverage.newCopyBuilder(this);
                this.tableset = _other.tableset == null ? null : _other.tableset.newCopyBuilder(this);
                this.accessURL = _other.accessURL == null ? null : _other.accessURL.newCopyBuilder(this);
            }
        }

        public Builder(_B _parentBuilder, DataCollection _other, boolean _copy, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other != null) {
                PropertyTree accessURLPropertyTree;
                PropertyTree tablesetPropertyTree;
                PropertyTree propertyTree;
                PropertyTree propertyTree2;
                PropertyTree propertyTree3;
                PropertyTree instrumentsPropertyTree;
                PropertyTree facilitiesPropertyTree;
                PropertyTree propertyTree4 = facilitiesPropertyTree = _propertyTree == null ? null : _propertyTree.get("facilities");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? facilitiesPropertyTree != null : facilitiesPropertyTree == null || !facilitiesPropertyTree.isLeaf()) {
                    if (_other.facilities == null) {
                        this.facilities = null;
                    } else {
                        this.facilities = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                        for (ResourceName resourceName : _other.facilities) {
                            this.facilities.add(resourceName == null ? null : resourceName.newCopyBuilder(this, facilitiesPropertyTree, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree5 = instrumentsPropertyTree = _propertyTree == null ? null : _propertyTree.get("instruments");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? instrumentsPropertyTree != null : instrumentsPropertyTree == null || !instrumentsPropertyTree.isLeaf()) {
                    if (_other.instruments == null) {
                        this.instruments = null;
                    } else {
                        this.instruments = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                        for (ResourceName resourceName : _other.instruments) {
                            this.instruments.add(resourceName == null ? null : resourceName.newCopyBuilder(this, instrumentsPropertyTree, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree6 = propertyTree3 = _propertyTree == null ? null : _propertyTree.get("rights");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree3 != null : propertyTree3 == null || !propertyTree3.isLeaf()) {
                    if (_other.rights == null) {
                        this.rights = null;
                    } else {
                        this.rights = new ArrayList<Rights.Builder<Builder<_B>>>();
                        for (Rights rights : _other.rights) {
                            this.rights.add(rights == null ? null : rights.newCopyBuilder(this, propertyTree3, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree7 = propertyTree2 = _propertyTree == null ? null : _propertyTree.get("formats");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree2 != null : propertyTree2 == null || !propertyTree2.isLeaf()) {
                    if (_other.formats == null) {
                        this.formats = null;
                    } else {
                        this.formats = new ArrayList<Format.Builder<Builder<_B>>>();
                        for (Format _item : _other.formats) {
                            this.formats.add(_item == null ? null : _item.newCopyBuilder(this, propertyTree2, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree8 = propertyTree = _propertyTree == null ? null : _propertyTree.get("coverage");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
                    this.coverage = _other.coverage == null ? null : _other.coverage.newCopyBuilder(this, propertyTree, _propertyTreeUse);
                }
                PropertyTree propertyTree9 = tablesetPropertyTree = _propertyTree == null ? null : _propertyTree.get("tableset");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? tablesetPropertyTree != null : tablesetPropertyTree == null || !tablesetPropertyTree.isLeaf()) {
                    this.tableset = _other.tableset == null ? null : _other.tableset.newCopyBuilder(this, tablesetPropertyTree, _propertyTreeUse);
                }
                PropertyTree propertyTree10 = accessURLPropertyTree = _propertyTree == null ? null : _propertyTree.get("accessURL");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? accessURLPropertyTree != null : accessURLPropertyTree == null || !accessURLPropertyTree.isLeaf()) {
                    this.accessURL = _other.accessURL == null ? null : _other.accessURL.newCopyBuilder(this, accessURLPropertyTree, _propertyTreeUse);
                }
            }
        }

        @Override
        protected <_P extends DataCollection> _P init(_P _product) {
            if (this.facilities != null) {
                ArrayList<ResourceName> facilities = new ArrayList<ResourceName>(this.facilities.size());
                for (ResourceName.Builder<Builder<_B>> builder : this.facilities) {
                    facilities.add(builder.build());
                }
                _product.facilities = facilities;
            }
            if (this.instruments != null) {
                ArrayList<ResourceName> instruments = new ArrayList<ResourceName>(this.instruments.size());
                for (ResourceName.Builder builder : this.instruments) {
                    instruments.add(builder.build());
                }
                _product.instruments = instruments;
            }
            if (this.rights != null) {
                ArrayList<Rights> rights = new ArrayList<Rights>(this.rights.size());
                for (Rights.Builder builder : this.rights) {
                    rights.add(builder.build());
                }
                _product.rights = rights;
            }
            if (this.formats != null) {
                ArrayList<Format> formats = new ArrayList<Format>(this.formats.size());
                for (Format.Builder builder : this.formats) {
                    formats.add(builder.build());
                }
                _product.formats = formats;
            }
            _product.coverage = this.coverage == null ? null : this.coverage.build();
            _product.tableset = this.tableset == null ? null : this.tableset.build();
            _product.accessURL = this.accessURL == null ? null : this.accessURL.build();
            return super.init(_product);
        }

        public Builder<_B> addFacilities(Iterable<? extends ResourceName> facilities) {
            if (facilities != null) {
                if (this.facilities == null) {
                    this.facilities = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                }
                for (ResourceName resourceName : facilities) {
                    this.facilities.add(new ResourceName.Builder<Builder>(this, resourceName, false));
                }
            }
            return this;
        }

        public Builder<_B> withFacilities(Iterable<? extends ResourceName> facilities) {
            if (this.facilities != null) {
                this.facilities.clear();
            }
            return this.addFacilities(facilities);
        }

        public Builder<_B> addFacilities(ResourceName ... facilities) {
            this.addFacilities(Arrays.asList(facilities));
            return this;
        }

        public Builder<_B> withFacilities(ResourceName ... facilities) {
            this.withFacilities(Arrays.asList(facilities));
            return this;
        }

        public ResourceName.Builder<? extends Builder<_B>> addFacilities() {
            if (this.facilities == null) {
                this.facilities = new ArrayList<ResourceName.Builder<Builder<_B>>>();
            }
            ResourceName.Builder<Builder> facilities_Builder = new ResourceName.Builder<Builder>(this, null, false);
            this.facilities.add(facilities_Builder);
            return facilities_Builder;
        }

        public Builder<_B> addInstruments(Iterable<? extends ResourceName> instruments) {
            if (instruments != null) {
                if (this.instruments == null) {
                    this.instruments = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                }
                for (ResourceName resourceName : instruments) {
                    this.instruments.add(new ResourceName.Builder<Builder>(this, resourceName, false));
                }
            }
            return this;
        }

        public Builder<_B> withInstruments(Iterable<? extends ResourceName> instruments) {
            if (this.instruments != null) {
                this.instruments.clear();
            }
            return this.addInstruments(instruments);
        }

        public Builder<_B> addInstruments(ResourceName ... instruments) {
            this.addInstruments(Arrays.asList(instruments));
            return this;
        }

        public Builder<_B> withInstruments(ResourceName ... instruments) {
            this.withInstruments(Arrays.asList(instruments));
            return this;
        }

        public ResourceName.Builder<? extends Builder<_B>> addInstruments() {
            if (this.instruments == null) {
                this.instruments = new ArrayList<ResourceName.Builder<Builder<_B>>>();
            }
            ResourceName.Builder<Builder> instruments_Builder = new ResourceName.Builder<Builder>(this, null, false);
            this.instruments.add(instruments_Builder);
            return instruments_Builder;
        }

        public Builder<_B> addRights(Iterable<? extends Rights> rights) {
            if (rights != null) {
                if (this.rights == null) {
                    this.rights = new ArrayList<Rights.Builder<Builder<_B>>>();
                }
                for (Rights rights2 : rights) {
                    this.rights.add(new Rights.Builder<Builder>(this, rights2, false));
                }
            }
            return this;
        }

        public Builder<_B> withRights(Iterable<? extends Rights> rights) {
            if (this.rights != null) {
                this.rights.clear();
            }
            return this.addRights(rights);
        }

        public Builder<_B> addRights(Rights ... rights) {
            this.addRights(Arrays.asList(rights));
            return this;
        }

        public Builder<_B> withRights(Rights ... rights) {
            this.withRights(Arrays.asList(rights));
            return this;
        }

        public Rights.Builder<? extends Builder<_B>> addRights() {
            if (this.rights == null) {
                this.rights = new ArrayList<Rights.Builder<Builder<_B>>>();
            }
            Rights.Builder<Builder> rights_Builder = new Rights.Builder<Builder>(this, null, false);
            this.rights.add(rights_Builder);
            return rights_Builder;
        }

        public Builder<_B> addFormats(Iterable<? extends Format> formats) {
            if (formats != null) {
                if (this.formats == null) {
                    this.formats = new ArrayList<Format.Builder<Builder<_B>>>();
                }
                for (Format format : formats) {
                    this.formats.add(new Format.Builder<Builder>(this, format, false));
                }
            }
            return this;
        }

        public Builder<_B> withFormats(Iterable<? extends Format> formats) {
            if (this.formats != null) {
                this.formats.clear();
            }
            return this.addFormats(formats);
        }

        public Builder<_B> addFormats(Format ... formats) {
            this.addFormats(Arrays.asList(formats));
            return this;
        }

        public Builder<_B> withFormats(Format ... formats) {
            this.withFormats(Arrays.asList(formats));
            return this;
        }

        public Format.Builder<? extends Builder<_B>> addFormats() {
            if (this.formats == null) {
                this.formats = new ArrayList<Format.Builder<Builder<_B>>>();
            }
            Format.Builder<Builder> formats_Builder = new Format.Builder<Builder>(this, null, false);
            this.formats.add(formats_Builder);
            return formats_Builder;
        }

        public Builder<_B> withCoverage(Coverage coverage) {
            this.coverage = coverage == null ? null : new Coverage.Builder<Builder>(this, coverage, false);
            return this;
        }

        public Coverage.Builder<? extends Builder<_B>> withCoverage() {
            if (this.coverage != null) {
                return this.coverage;
            }
            this.coverage = new Coverage.Builder<Builder>(this, null, false);
            return this.coverage;
        }

        public Builder<_B> withTableset(Tableset tableset) {
            this.tableset = tableset == null ? null : new Tableset.Builder<Builder>(this, tableset, false);
            return this;
        }

        public Tableset.Builder<? extends Builder<_B>> withTableset() {
            if (this.tableset != null) {
                return this.tableset;
            }
            this.tableset = new Tableset.Builder<Builder>(this, null, false);
            return this.tableset;
        }

        public Builder<_B> withAccessURL(AccessURL accessURL) {
            this.accessURL = accessURL == null ? null : new AccessURL.Builder<Builder>(this, accessURL, false);
            return this;
        }

        public AccessURL.Builder<? extends Builder<_B>> withAccessURL() {
            if (this.accessURL != null) {
                return this.accessURL;
            }
            this.accessURL = new AccessURL.Builder<Builder>(this, null, false);
            return this.accessURL;
        }

        @Override
        public Builder<_B> addValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> addValidationLevels(Validation ... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Validation ... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withTitle(String title) {
            super.withTitle(title);
            return this;
        }

        @Override
        public Builder<_B> withShortName(String shortName) {
            super.withShortName(shortName);
            return this;
        }

        @Override
        public Builder<_B> withIdentifier(String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        @Override
        public Builder<_B> addAltIdentifiers(Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> addAltIdentifiers(String ... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withAltIdentifiers(Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withAltIdentifiers(String ... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withCuration(Curation curation) {
            super.withCuration(curation);
            return this;
        }

        @Override
        public Curation.Builder<? extends Builder<_B>> withCuration() {
            return super.withCuration();
        }

        @Override
        public Builder<_B> withContent(Content content) {
            super.withContent(content);
            return this;
        }

        @Override
        public Content.Builder<? extends Builder<_B>> withContent() {
            return super.withContent();
        }

        @Override
        public Builder<_B> withCreated(ZonedDateTime created) {
            super.withCreated(created);
            return this;
        }

        @Override
        public Builder<_B> withUpdated(ZonedDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        @Override
        public Builder<_B> withStatus(String status) {
            super.withStatus(status);
            return this;
        }

        @Override
        public Builder<_B> withVersion(String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public DataCollection build() {
            if (this._storedValue == null) {
                return this.init(new DataCollection());
            }
            return (DataCollection)this._storedValue;
        }

        public Builder<_B> copyOf(DataCollection _other) {
            _other.copyTo(this);
            return this;
        }

        public Builder<_B> copyOf(Builder _other) {
            return this.copyOf(_other.build());
        }
    }

    public static class PropInfo {
        public static final transient CollectionPropertyInfo<DataCollection, ResourceName> FACILITIES = new CollectionPropertyInfo<DataCollection, ResourceName>("facilities", DataCollection.class, ResourceName.class, true, null, new QName("", "facility"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "ResourceName"), false){

            public List<ResourceName> get(DataCollection _instance_) {
                return _instance_ == null ? null : _instance_.facilities;
            }

            public void set(DataCollection _instance_, List<ResourceName> _value_) {
                if (_instance_ != null) {
                    _instance_.facilities = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<DataCollection, ResourceName> INSTRUMENTS = new CollectionPropertyInfo<DataCollection, ResourceName>("instruments", DataCollection.class, ResourceName.class, true, null, new QName("", "instrument"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "ResourceName"), false){

            public List<ResourceName> get(DataCollection _instance_) {
                return _instance_ == null ? null : _instance_.instruments;
            }

            public void set(DataCollection _instance_, List<ResourceName> _value_) {
                if (_instance_ != null) {
                    _instance_.instruments = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<DataCollection, Rights> RIGHTS = new CollectionPropertyInfo<DataCollection, Rights>("rights", DataCollection.class, Rights.class, true, null, new QName("", "rights"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "Rights"), false){

            public List<Rights> get(DataCollection _instance_) {
                return _instance_ == null ? null : _instance_.rights;
            }

            public void set(DataCollection _instance_, List<Rights> _value_) {
                if (_instance_ != null) {
                    _instance_.rights = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<DataCollection, Format> FORMATS = new CollectionPropertyInfo<DataCollection, Format>("formats", DataCollection.class, Format.class, true, null, new QName("", "format"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "Format"), false){

            public List<Format> get(DataCollection _instance_) {
                return _instance_ == null ? null : _instance_.formats;
            }

            public void set(DataCollection _instance_, List<Format> _value_) {
                if (_instance_ != null) {
                    _instance_.formats = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<DataCollection, Coverage> COVERAGE = new SinglePropertyInfo<DataCollection, Coverage>("coverage", DataCollection.class, Coverage.class, false, null, new QName("", "coverage"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "Coverage"), false){

            public Coverage get(DataCollection _instance_) {
                return _instance_ == null ? null : _instance_.coverage;
            }

            public void set(DataCollection _instance_, Coverage _value_) {
                if (_instance_ != null) {
                    _instance_.coverage = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<DataCollection, Tableset> TABLESET = new SinglePropertyInfo<DataCollection, Tableset>("tableset", DataCollection.class, Tableset.class, false, null, new QName("", "tableset"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "TableSet"), false){

            public Tableset get(DataCollection _instance_) {
                return _instance_ == null ? null : _instance_.tableset;
            }

            public void set(DataCollection _instance_, Tableset _value_) {
                if (_instance_ != null) {
                    _instance_.tableset = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<DataCollection, AccessURL> ACCESS_URL = new SinglePropertyInfo<DataCollection, AccessURL>("accessURL", DataCollection.class, AccessURL.class, false, null, new QName("", "accessURL"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "AccessURL"), false){

            public AccessURL get(DataCollection _instance_) {
                return _instance_ == null ? null : _instance_.accessURL;
            }

            public void set(DataCollection _instance_, AccessURL _value_) {
                if (_instance_ != null) {
                    _instance_.accessURL = _value_;
                }
            }
        };
    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?>, TParent>
    extends Resource.Selector<TRoot, TParent> {
        private ResourceName.Selector<TRoot, Selector<TRoot, TParent>> facilities = null;
        private ResourceName.Selector<TRoot, Selector<TRoot, TParent>> instruments = null;
        private Rights.Selector<TRoot, Selector<TRoot, TParent>> rights = null;
        private Format.Selector<TRoot, Selector<TRoot, TParent>> formats = null;
        private Coverage.Selector<TRoot, Selector<TRoot, TParent>> coverage = null;
        private Tableset.Selector<TRoot, Selector<TRoot, TParent>> tableset = null;
        private AccessURL.Selector<TRoot, Selector<TRoot, TParent>> accessURL = null;

        public Selector(TRoot root, TParent parent, String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            HashMap<String, PropertyTree> products = new HashMap<String, PropertyTree>();
            products.putAll(super.buildChildren());
            if (this.facilities != null) {
                products.put("facilities", this.facilities.init());
            }
            if (this.instruments != null) {
                products.put("instruments", this.instruments.init());
            }
            if (this.rights != null) {
                products.put("rights", this.rights.init());
            }
            if (this.formats != null) {
                products.put("formats", this.formats.init());
            }
            if (this.coverage != null) {
                products.put("coverage", this.coverage.init());
            }
            if (this.tableset != null) {
                products.put("tableset", this.tableset.init());
            }
            if (this.accessURL != null) {
                products.put("accessURL", this.accessURL.init());
            }
            return products;
        }

        public ResourceName.Selector<TRoot, Selector<TRoot, TParent>> facilities() {
            return this.facilities == null ? (this.facilities = new ResourceName.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "facilities")) : this.facilities;
        }

        public ResourceName.Selector<TRoot, Selector<TRoot, TParent>> instruments() {
            return this.instruments == null ? (this.instruments = new ResourceName.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "instruments")) : this.instruments;
        }

        public Rights.Selector<TRoot, Selector<TRoot, TParent>> rights() {
            return this.rights == null ? (this.rights = new Rights.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "rights")) : this.rights;
        }

        public Format.Selector<TRoot, Selector<TRoot, TParent>> formats() {
            return this.formats == null ? (this.formats = new Format.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "formats")) : this.formats;
        }

        public Coverage.Selector<TRoot, Selector<TRoot, TParent>> coverage() {
            return this.coverage == null ? (this.coverage = new Coverage.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "coverage")) : this.coverage;
        }

        public Tableset.Selector<TRoot, Selector<TRoot, TParent>> tableset() {
            return this.tableset == null ? (this.tableset = new Tableset.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "tableset")) : this.tableset;
        }

        public AccessURL.Selector<TRoot, Selector<TRoot, TParent>> accessURL() {
            return this.accessURL == null ? (this.accessURL = new AccessURL.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "accessURL")) : this.accessURL;
        }
    }

    public static class Select
    extends Selector<Select, Void> {
        Select() {
            super(null, null, null);
        }

        public static Select _root() {
            return new Select();
        }
    }
}

