/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.stc.v1;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.javastro.ivoa.entities.stc.v1.CoordRefFrameType;
import org.javastro.ivoa.entities.stc.v1.IcrsType;
import org.javastro.ivoa.entities.stc.v1.SpaceRefFrameType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="geodType")
public class GeodType
extends IcrsType
implements Cloneable,
Copyable,
PartialCopyable,
MergeFrom,
ToString {
    @XmlAttribute(name="radius")
    protected Double radius;
    @XmlAttribute(name="inv_flattening")
    protected Double invFlattening;
    @XmlAttribute(name="unit")
    protected String unit;

    public GeodType() {
    }

    public GeodType(String name, Object refFrameId, Double radius, Double invFlattening, String unit) {
        super(name, refFrameId);
        this.radius = radius;
        this.invFlattening = invFlattening;
        this.unit = unit;
    }

    public double getRadius() {
        if (this.radius == null) {
            return 6378140.0;
        }
        return this.radius;
    }

    public void setRadius(Double value) {
        this.radius = value;
    }

    public double getInvFlattening() {
        if (this.invFlattening == null) {
            return 298.257;
        }
        return this.invFlattening;
    }

    public void setInvFlattening(Double value) {
        this.invFlattening = value;
    }

    public String getUnit() {
        if (this.unit == null) {
            return "m";
        }
        return this.unit;
    }

    public void setUnit(String value) {
        this.unit = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        double rightInvFlattening;
        double rightRadius;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        GeodType that = (GeodType)object;
        double leftRadius = this.radius != null ? this.getRadius() : 6378140.0;
        double d = rightRadius = that.radius != null ? that.getRadius() : 6378140.0;
        if (this.radius != null) {
            if (that.radius == null) return false;
            if (Double.doubleToLongBits(leftRadius) != Double.doubleToLongBits(rightRadius)) {
                return false;
            }
        } else if (that.radius != null) {
            return false;
        }
        double leftInvFlattening = this.invFlattening != null ? this.getInvFlattening() : 298.257;
        double d2 = rightInvFlattening = that.invFlattening != null ? that.getInvFlattening() : 298.257;
        if (this.invFlattening != null) {
            if (that.invFlattening == null) return false;
            if (Double.doubleToLongBits(leftInvFlattening) != Double.doubleToLongBits(rightInvFlattening)) {
                return false;
            }
        } else if (that.invFlattening != null) {
            return false;
        }
        String leftUnit = this.getUnit();
        String rightUnit = that.getUnit();
        if (this.unit != null) {
            if (that.unit == null) return false;
            if (leftUnit.equals(rightUnit)) return true;
            return false;
        }
        if (that.unit == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        double theRadius = this.radius != null ? this.getRadius() : 6378140.0;
        long theRadiusBits = Double.doubleToLongBits(theRadius);
        if (this.radius != null) {
            currentHashCode += (int)(theRadiusBits ^ theRadiusBits >>> 32);
        }
        currentHashCode *= 31;
        double theInvFlattening = this.invFlattening != null ? this.getInvFlattening() : 298.257;
        long theInvFlatteningBits = Double.doubleToLongBits(theInvFlattening);
        if (this.invFlattening != null) {
            currentHashCode += (int)(theInvFlatteningBits ^ theInvFlatteningBits >>> 32);
        }
        currentHashCode *= 31;
        String theUnit = this.getUnit();
        if (this.unit != null) {
            currentHashCode += theUnit.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        double theRadius = this.radius != null ? this.getRadius() : 6378140.0;
        strategy.appendField(locator, (Object)this, "radius", buffer, theRadius, this.radius != null);
        double theInvFlattening = this.invFlattening != null ? this.getInvFlattening() : 298.257;
        strategy.appendField(locator, (Object)this, "invFlattening", buffer, theInvFlattening, this.invFlattening != null);
        String theUnit = this.getUnit();
        strategy.appendField(locator, (Object)this, "unit", buffer, (Object)theUnit, this.unit != null);
        return buffer;
    }

    @Override
    public void mergeFrom(Object left, Object right) {
        JAXBMergeStrategy strategy = JAXBMergeStrategy.getInstance();
        this.mergeFrom(null, null, left, right, (MergeStrategy)strategy);
    }

    @Override
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof GeodType) {
            GeodType target = this;
            GeodType leftObject = (GeodType)left;
            GeodType rightObject = (GeodType)right;
            Boolean radiusShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.radius != null, rightObject.radius != null);
            if (radiusShouldBeMergedAndSet == Boolean.TRUE) {
                double lhsRadius = leftObject.radius != null ? leftObject.getRadius() : 6378140.0;
                double rhsRadius = rightObject.radius != null ? rightObject.getRadius() : 6378140.0;
                double mergedRadius = strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"radius", (double)lhsRadius), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"radius", (double)rhsRadius), lhsRadius, rhsRadius, leftObject.radius != null, rightObject.radius != null);
                target.setRadius(mergedRadius);
            } else if (radiusShouldBeMergedAndSet == Boolean.FALSE) {
                target.radius = null;
            }
            Boolean invFlatteningShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.invFlattening != null, rightObject.invFlattening != null);
            if (invFlatteningShouldBeMergedAndSet == Boolean.TRUE) {
                double lhsInvFlattening = leftObject.invFlattening != null ? leftObject.getInvFlattening() : 298.257;
                double rhsInvFlattening = rightObject.invFlattening != null ? rightObject.getInvFlattening() : 298.257;
                double mergedInvFlattening = strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"invFlattening", (double)lhsInvFlattening), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"invFlattening", (double)rhsInvFlattening), lhsInvFlattening, rhsInvFlattening, leftObject.invFlattening != null, rightObject.invFlattening != null);
                target.setInvFlattening(mergedInvFlattening);
            } else if (invFlatteningShouldBeMergedAndSet == Boolean.FALSE) {
                target.invFlattening = null;
            }
            Boolean unitShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.unit != null, rightObject.unit != null);
            if (unitShouldBeMergedAndSet == Boolean.TRUE) {
                String lhsUnit = leftObject.getUnit();
                String rhsUnit = rightObject.getUnit();
                String mergedUnit = (String)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"unit", (Object)lhsUnit), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"unit", (Object)rhsUnit), (Object)lhsUnit, (Object)rhsUnit, leftObject.unit != null, rightObject.unit != null);
                target.setUnit(mergedUnit);
            } else if (unitShouldBeMergedAndSet == Boolean.FALSE) {
                target.unit = null;
            }
        }
    }

    @Override
    public Object createNewInstance() {
        return new GeodType();
    }

    @Override
    public GeodType clone() {
        GeodType _newObject = (GeodType)super.clone();
        return _newObject;
    }

    @Override
    public GeodType createCopy() {
        GeodType _newObject = (GeodType)super.createCopy();
        _newObject.radius = this.radius;
        _newObject.invFlattening = this.invFlattening;
        _newObject.unit = this.unit;
        return _newObject;
    }

    @Override
    public GeodType createCopy(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree unitPropertyTree;
        PropertyTree invFlatteningPropertyTree;
        PropertyTree radiusPropertyTree;
        GeodType _newObject = (GeodType)super.createCopy(_propertyTree, _propertyTreeUse);
        PropertyTree propertyTree = radiusPropertyTree = _propertyTree == null ? null : _propertyTree.get("radius");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? radiusPropertyTree != null : radiusPropertyTree == null || !radiusPropertyTree.isLeaf()) {
            _newObject.radius = this.radius;
        }
        PropertyTree propertyTree2 = invFlatteningPropertyTree = _propertyTree == null ? null : _propertyTree.get("invFlattening");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? invFlatteningPropertyTree != null : invFlatteningPropertyTree == null || !invFlatteningPropertyTree.isLeaf()) {
            _newObject.invFlattening = this.invFlattening;
        }
        PropertyTree propertyTree3 = unitPropertyTree = _propertyTree == null ? null : _propertyTree.get("unit");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? unitPropertyTree != null : unitPropertyTree == null || !unitPropertyTree.isLeaf()) {
            _newObject.unit = this.unit;
        }
        return _newObject;
    }

    @Override
    public GeodType copyExcept(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    public GeodType copyOnly(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Modifier();
        }
        return (Modifier)this.__cachedModifier__;
    }

    public <_B> void copyTo(Builder<_B> _other) {
        super.copyTo(_other);
        _other.radius = this.radius;
        _other.invFlattening = this.invFlattening;
        _other.unit = this.unit;
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder) {
        return new Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    public Builder<Void> newCopyBuilder() {
        return this.newCopyBuilder((Object)null);
    }

    public static Builder<Void> builder() {
        return new Builder<Object>(null, null, false);
    }

    public static <_B> Builder<_B> copyOf(CoordRefFrameType _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(SpaceRefFrameType _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(IcrsType _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(GeodType _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public <_B> void copyTo(Builder<_B> _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree unitPropertyTree;
        PropertyTree invFlatteningPropertyTree;
        PropertyTree radiusPropertyTree;
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        PropertyTree propertyTree = radiusPropertyTree = _propertyTree == null ? null : _propertyTree.get("radius");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? radiusPropertyTree != null : radiusPropertyTree == null || !radiusPropertyTree.isLeaf()) {
            _other.radius = this.radius;
        }
        PropertyTree propertyTree2 = invFlatteningPropertyTree = _propertyTree == null ? null : _propertyTree.get("invFlattening");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? invFlatteningPropertyTree != null : invFlatteningPropertyTree == null || !invFlatteningPropertyTree.isLeaf()) {
            _other.invFlattening = this.invFlattening;
        }
        PropertyTree propertyTree3 = unitPropertyTree = _propertyTree == null ? null : _propertyTree.get("unit");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? unitPropertyTree != null : unitPropertyTree == null || !unitPropertyTree.isLeaf()) {
            _other.unit = this.unit;
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return new Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    public Builder<Void> newCopyBuilder(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return this.newCopyBuilder((Object)null, _propertyTree, _propertyTreeUse);
    }

    public static <_B> Builder<_B> copyOf(CoordRefFrameType _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(SpaceRefFrameType _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(IcrsType _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(GeodType _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static Builder<Void> copyExcept(CoordRefFrameType _other, PropertyTree _propertyTree) {
        return GeodType.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(SpaceRefFrameType _other, PropertyTree _propertyTree) {
        return GeodType.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(IcrsType _other, PropertyTree _propertyTree) {
        return GeodType.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(GeodType _other, PropertyTree _propertyTree) {
        return GeodType.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyOnly(CoordRefFrameType _other, PropertyTree _propertyTree) {
        return GeodType.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(SpaceRefFrameType _other, PropertyTree _propertyTree) {
        return GeodType.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(IcrsType _other, PropertyTree _propertyTree) {
        return GeodType.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(GeodType _other, PropertyTree _propertyTree) {
        return GeodType.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public GeodType visit(PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty(PropInfo.RADIUS, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.INV_FLATTENING, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.UNIT, (Object)this));
        return this;
    }

    public class Modifier
    extends IcrsType.Modifier {
        public void setRadius(Double radius) {
            GeodType.this.setRadius(radius);
        }

        public void setInvFlattening(Double invFlattening) {
            GeodType.this.setInvFlattening(invFlattening);
        }

        public void setUnit(String unit) {
            GeodType.this.setUnit(unit);
        }
    }

    public static class Builder<_B>
    extends IcrsType.Builder<_B>
    implements Buildable {
        private Double radius = 6378140.0;
        private Double invFlattening = 298.257;
        private String unit = "m";

        public Builder(_B _parentBuilder, GeodType _other, boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other != null) {
                this.radius = _other.radius;
                this.invFlattening = _other.invFlattening;
                this.unit = _other.unit;
            }
        }

        public Builder(_B _parentBuilder, GeodType _other, boolean _copy, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other != null) {
                PropertyTree unitPropertyTree;
                PropertyTree invFlatteningPropertyTree;
                PropertyTree radiusPropertyTree;
                PropertyTree propertyTree = radiusPropertyTree = _propertyTree == null ? null : _propertyTree.get("radius");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? radiusPropertyTree != null : radiusPropertyTree == null || !radiusPropertyTree.isLeaf()) {
                    this.radius = _other.radius;
                }
                PropertyTree propertyTree2 = invFlatteningPropertyTree = _propertyTree == null ? null : _propertyTree.get("invFlattening");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? invFlatteningPropertyTree != null : invFlatteningPropertyTree == null || !invFlatteningPropertyTree.isLeaf()) {
                    this.invFlattening = _other.invFlattening;
                }
                PropertyTree propertyTree3 = unitPropertyTree = _propertyTree == null ? null : _propertyTree.get("unit");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? unitPropertyTree != null : unitPropertyTree == null || !unitPropertyTree.isLeaf()) {
                    this.unit = _other.unit;
                }
            }
        }

        @Override
        protected <_P extends GeodType> _P init(_P _product) {
            _product.radius = this.radius;
            _product.invFlattening = this.invFlattening;
            _product.unit = this.unit;
            return super.init(_product);
        }

        public Builder<_B> withRadius(Double radius) {
            this.radius = radius;
            return this;
        }

        public Builder<_B> withInvFlattening(Double invFlattening) {
            this.invFlattening = invFlattening;
            return this;
        }

        public Builder<_B> withUnit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public Builder<_B> withName(String name) {
            super.withName(name);
            return this;
        }

        @Override
        public Builder<_B> withRefFrameId(Object refFrameId) {
            super.withRefFrameId(refFrameId);
            return this;
        }

        @Override
        public GeodType build() {
            if (this._storedValue == null) {
                return this.init(new GeodType());
            }
            return (GeodType)this._storedValue;
        }

        public Builder<_B> copyOf(GeodType _other) {
            _other.copyTo(this);
            return this;
        }

        public Builder<_B> copyOf(Builder _other) {
            return this.copyOf(_other.build());
        }
    }

    public static class PropInfo {
        public static final transient SinglePropertyInfo<GeodType, Double> RADIUS = new SinglePropertyInfo<GeodType, Double>("radius", GeodType.class, Double.class, false, Double.valueOf(6378140.0), new QName("", "radius"), new QName("http://www.w3.org/2001/XMLSchema", "double"), true){

            public Double get(GeodType _instance_) {
                return _instance_ == null ? null : _instance_.radius;
            }

            public void set(GeodType _instance_, Double _value_) {
                if (_instance_ != null) {
                    _instance_.radius = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<GeodType, Double> INV_FLATTENING = new SinglePropertyInfo<GeodType, Double>("invFlattening", GeodType.class, Double.class, false, Double.valueOf(298.257), new QName("", "inv_flattening"), new QName("http://www.w3.org/2001/XMLSchema", "double"), true){

            public Double get(GeodType _instance_) {
                return _instance_ == null ? null : _instance_.invFlattening;
            }

            public void set(GeodType _instance_, Double _value_) {
                if (_instance_ != null) {
                    _instance_.invFlattening = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<GeodType, String> UNIT = new SinglePropertyInfo<GeodType, String>("unit", GeodType.class, String.class, false, "m", new QName("", "unit"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "posUnitType"), true){

            public String get(GeodType _instance_) {
                return _instance_ == null ? null : _instance_.unit;
            }

            public void set(GeodType _instance_, String _value_) {
                if (_instance_ != null) {
                    _instance_.unit = _value_;
                }
            }
        };
    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?>, TParent>
    extends IcrsType.Selector<TRoot, TParent> {
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> radius = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> invFlattening = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> unit = null;

        public Selector(TRoot root, TParent parent, String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            HashMap<String, PropertyTree> products = new HashMap<String, PropertyTree>();
            products.putAll(super.buildChildren());
            if (this.radius != null) {
                products.put("radius", this.radius.init());
            }
            if (this.invFlattening != null) {
                products.put("invFlattening", this.invFlattening.init());
            }
            if (this.unit != null) {
                products.put("unit", this.unit.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> radius() {
            return this.radius == null ? (this.radius = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "radius")) : this.radius;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> invFlattening() {
            return this.invFlattening == null ? (this.invFlattening = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "invFlattening")) : this.invFlattening;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> unit() {
            return this.unit == null ? (this.unit = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "unit")) : this.unit;
        }
    }

    public static class Select
    extends Selector<Select, Void> {
        Select() {
            super(null, null, null);
        }

        public static Select _root() {
            return new Select();
        }
    }
}

