/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.ValidationException;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.util.ValidationEventCollector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.javastro.ivoa.entities.IvoaJAXBContextFactory;
import org.javastro.ivoa.schema.Namespaces;
import org.javastro.ivoa.schema.SchemaMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class IvoaJAXBUtils {
    public static Transformer identityTransformer;
    private static final Logger logger;
    private static JAXBContext contextFactory;
    private static final SAXParserFactory saxParserFactory;
    private static SchemaFactory sf;
    private static DocumentBuilderFactory dbf;

    private IvoaJAXBUtils() {
    }

    public static Document marshall(JAXBElement<?> element, Transformer stylesheet, Schema schema) throws JAXBException, TransformerException {
        Document doc;
        try {
            doc = dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new JAXBException("problem setting up parser", (Throwable)e);
        }
        Marshaller m = IvoaJAXBContextFactory.newInstance().createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        if (schema != null) {
            m.setSchema(schema);
        }
        ValidationEventCollector handler = new ValidationEventCollector();
        m.setEventHandler((ValidationEventHandler)handler);
        m.marshal(element, (Node)doc);
        if (handler.hasEvents()) {
            logger.error("invalid - " + element);
            for (int i = 0; i < handler.getEvents().length; ++i) {
                ValidationEvent array_element = handler.getEvents()[i];
                logger.error("validation error - " + array_element.toString());
            }
        }
        DOMSource request = new DOMSource(doc);
        DOMResult response = new DOMResult();
        stylesheet.transform(request, response);
        return (Document)response.getNode();
    }

    public static <T> T unmarshall(InputStream inputStream, Class<T> class1) throws JAXBException, IOException, SAXException {
        return IvoaJAXBUtils.unmarshall(new InputStreamReader(inputStream), class1);
    }

    public static <T> T unmarshall(Reader rd, Class<T> clazz) throws JAXBException, IOException, SAXException {
        return IvoaJAXBUtils.unmarshall(rd, clazz, true);
    }

    public static <T> T unmarshall(Node doc, Class<T> clazz, boolean validate) throws JAXBException, IOException, SAXException {
        return IvoaJAXBUtils.unmarshall(new DOMSource(doc), clazz, validate);
    }

    public static <T> T unmarshall(Reader r, Class<T> clazz, boolean validate) throws JAXBException, IOException, SAXException {
        XMLReader saxreader;
        try {
            SAXParser saxParser = saxParserFactory.newSAXParser();
            saxreader = saxParser.getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("problem with configuring XML parser", e);
        }
        saxreader.setEntityResolver(new IVOAEntityResolver());
        SAXSource s = new SAXSource(saxreader, new InputSource(r));
        return IvoaJAXBUtils.unmarshall(s, clazz, validate);
    }

    private static <T> T unmarshall(Source s, Class<T> clazz, boolean validate) throws JAXBException, ValidationException {
        logger.debug("unmarshalling to " + clazz.getSimpleName());
        Unmarshaller um = contextFactory.createUnmarshaller();
        if (validate) {
            logger.debug("finding schema to validate");
            Schema schema = IvoaJAXBUtils.findSchema(clazz);
            um.setSchema(schema);
        } else {
            um.setSchema(null);
        }
        ValidationEventCollector validationEventCollector = new ValidationEventCollector();
        um.setEventHandler((ValidationEventHandler)validationEventCollector);
        JAXBElement el = um.unmarshal(s, clazz);
        Object retval = el.getValue();
        if (validationEventCollector.hasEvents()) {
            StringBuffer errmsg = new StringBuffer();
            for (ValidationEvent err : validationEventCollector.getEvents()) {
                errmsg.append(err.toString());
                errmsg.append("\n");
            }
            logger.error(errmsg.toString());
            throw new ValidationException("xml invalid for " + errmsg.toString());
        }
        return (T)retval;
    }

    public static <T> Schema findSchema(Class<T> clazz) {
        XmlSchema ann = clazz.getPackage().getAnnotation(XmlSchema.class);
        try {
            String namespace = ann.namespace();
            logger.debug("schema for class {} {}", (Object)clazz.getName(), (Object)namespace);
            return IvoaJAXBUtils.findSchema(namespace);
        }
        catch (Throwable e) {
            logger.warn("unable to find schema - validation will not occur", e);
            return null;
        }
    }

    public static Schema findSchema(String namespace) throws IOException, SAXException {
        Schema schema = sf.newSchema(SchemaMap.getRegistrySchemaAsSources());
        return schema;
    }

    public static void printXML(Node doc, Writer sw) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    static {
        logger = LoggerFactory.getLogger(IvoaJAXBUtils.class);
        sf = SchemaFactory.newInstance(Namespaces.XSD.getNamespace());
        saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            sf.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "file,jar:file");
            sf.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "file,jar:file");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e1) {
            logger.error("problem setting up the schema factory to use only local schema", (Throwable)e1);
            e1.printStackTrace();
        }
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        try {
            identityTransformer = xformFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            logger.error("problem setting up default registry stylesheet", (Throwable)e);
        }
        try {
            contextFactory = IvoaJAXBContextFactory.newInstance();
            if (logger.isDebugEnabled()) {
                logger.info(contextFactory.toString());
            }
        }
        catch (JAXBException e) {
            logger.error("problem setting up the JAXB context", (Throwable)e);
        }
        dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
    }

    static class IVOAEntityResolver
    implements EntityResolver {
        IVOAEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            logger.info("entity resolver " + publicId + " " + systemId);
            URL schemaURL = SchemaMap.getSchemaURL((String)systemId);
            if (schemaURL == null) {
                logger.warn("cannot find schema for {}", (Object)systemId);
                schemaURL = new URL(systemId);
            }
            return new InputSource(schemaURL.openStream());
        }
    }
}

