/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.jaxb;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.validation.Schema;
import org.javastro.ivoa.entities.IvoaJAXBUtils;
import org.javastro.ivoa.entities.regtap.RegTAP;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.registry.iface.VOResources;
import org.javastro.ivoa.schema.Namespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static Document marshall(Resource desc) throws JAXBException, TransformerException {
        Schema schema = null;
        return IvoaJAXBUtils.marshall(new JAXBElement(new QName(Namespaces.VR.getNamespace(), "resource"), Resource.class, (Object)desc), IvoaJAXBUtils.identityTransformer, schema);
    }

    public static Document marshall(RegTAP rt) throws JAXBException, TransformerException {
        Schema schema = null;
        return IvoaJAXBUtils.marshall(new JAXBElement(new QName(Namespaces.REGTAP.getNamespace(), "regtap"), RegTAP.class, (Object)rt), IvoaJAXBUtils.identityTransformer, schema);
    }

    public static Document marshall(VOResources desc) throws JAXBException, TransformerException {
        Schema schema = null;
        try {
            schema = IvoaJAXBUtils.findSchema(Namespaces.RI.getNamespace());
        }
        catch (IOException | SAXException e) {
            logger.warn("error finding schema to validate", (Throwable)e);
        }
        return IvoaJAXBUtils.marshall(new JAXBElement(new QName(Namespaces.RI.getNamespace(), "VOResources"), VOResources.class, (Object)desc), IvoaJAXBUtils.identityTransformer, schema);
    }
}

