/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import org.javastro.ivoa.entities.regtap.AltIdentifierPK;
import org.javastro.ivoa.entities.regtap.Resource;

@Entity
@Table(name="alt_identifier")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType
@NamedQueries(value={@NamedQuery(name="AltIdentifier.findAll", query="SELECT s FROM AltIdentifier s"), @NamedQuery(name="AltIdentifier.findByIvoid", query="SELECT s FROM AltIdentifier s WHERE s.altidPK.ivoid = :ivoid"), @NamedQuery(name="AltIdentifier.findByAltId", query="SELECT s FROM AltIdentifier s WHERE s.altidPK.altIdentifier = :altId")})
public class AltIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    @XmlElement
    protected AltIdentifierPK altidPK = new AltIdentifierPK();
    @XmlTransient
    @JoinColumn(name="ivoid", referencedColumnName="ivoid", nullable=false, insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Resource resource;

    AltIdentifier() {
    }

    public AltIdentifier(String id) {
        this.altidPK.setAltIdentifier(id);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setAltId(String id) {
        this.altidPK.setAltIdentifier(id);
    }

    public AltIdentifierPK getAltidPK() {
        return this.altidPK;
    }

    public void setAltidPK(AltIdentifierPK altidPK) {
        this.altidPK = altidPK;
    }

    public void addToResource(Resource resource) {
        this.resource = resource;
        if (resource.getAltIdentifier().indexOf(this) == -1) {
            resource.getAltIdentifier().add(this);
        }
        this.altidPK.setIvoid(resource.getIvoid());
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.altidPK != null ? this.altidPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AltIdentifier)) {
            return false;
        }
        AltIdentifier other = (AltIdentifier)object;
        return (this.altidPK != null || other.altidPK == null) && (this.altidPK == null || this.altidPK.equals(other.altidPK));
    }

    public String toString() {
        return "net.ivoa.regtap.Subject[ subjectPK=" + this.altidPK + " ]";
    }
}

