/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.javastro.ivoa.entities.regtap.CapabilityPK;
import org.javastro.ivoa.entities.regtap.Identifier;
import org.javastro.ivoa.entities.regtap.Interface;
import org.javastro.ivoa.entities.regtap.PKIndex;
import org.javastro.ivoa.entities.regtap.PKIndexUtils;
import org.javastro.ivoa.entities.regtap.Resource;

@Entity
@XmlType
@XmlAccessorType(value=XmlAccessType.FIELD)
@Table(name="capability")
@NamedQueries(value={@NamedQuery(name="Capability.findAll", query="SELECT c FROM Capability c"), @NamedQuery(name="Capability.findByIvoid", query="SELECT c FROM Capability c WHERE c.capabilityPK.ivoid = :ivoid"), @NamedQuery(name="Capability.findByCapIndex", query="SELECT c FROM Capability c WHERE c.capabilityPK.capIndex = :capIndex"), @NamedQuery(name="Capability.findByCapName", query="SELECT c FROM Capability c WHERE c.name = :capName"), @NamedQuery(name="Capability.findByCapType", query="SELECT c FROM Capability c WHERE c.type = :capType"), @NamedQuery(name="Capability.findByCapDescription", query="SELECT c FROM Capability c WHERE c.capDescription = :capDescription"), @NamedQuery(name="Capability.findByStandardId", query="SELECT c FROM Capability c WHERE c.standardId = :standardId")})
public class Capability
implements Serializable,
PKIndex,
Identifier {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    @XmlElement
    protected CapabilityPK capabilityPK;
    @Column(name="cap_name")
    @XmlElement(name="cap_name")
    private String name;
    @Column(name="cap_type")
    @XmlElement(name="cap_type")
    private String type;
    @Column(name="cap_description", length=1024)
    @XmlElement(name="cap_description")
    private String capDescription;
    @Column(name="standard_id")
    @XmlElement(name="standard_id")
    private String standardId;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="capability", targetEntity=Interface.class, fetch=FetchType.EAGER, orphanRemoval=true)
    @XmlElement(name="interface")
    private List<Interface> interfaceList;
    @XmlTransient
    @JoinColumn(name="ivoid", referencedColumnName="ivoid", nullable=false, insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Resource resource;

    public Capability() {
        this.capabilityPK = new CapabilityPK();
    }

    public Capability(CapabilityPK capabilityPK) {
        this.capabilityPK = capabilityPK;
    }

    public Capability(String ivoid, short capIndex) {
        this.capabilityPK = new CapabilityPK(ivoid, capIndex);
    }

    public CapabilityPK getCapabilityPK() {
        return this.capabilityPK;
    }

    public void setCapabilityPK(CapabilityPK capabilityPK) {
        this.capabilityPK = capabilityPK;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCapType() {
        return this.type;
    }

    public void setCapType(String capType) {
        this.type = capType;
    }

    public String getCapDescription() {
        return this.capDescription;
    }

    public void setCapDescription(String capDescription) {
        this.capDescription = capDescription;
    }

    public String getStandardId() {
        return this.standardId;
    }

    public void setStandardId(String standardId) {
        this.standardId = standardId;
    }

    public List<Interface> getInterfaceList() {
        if (this.interfaceList == null) {
            this.interfaceList = new ArrayList<Interface>();
        }
        return this.interfaceList;
    }

    public void setInterfaceList(List<Interface> interfaceList) {
        this.interfaceList = interfaceList;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void addToResource(Resource resource) {
        this.resource = resource;
        PKIndexUtils.addWithIndex(this, resource, resource.getCapabilityList());
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.capabilityPK != null ? this.capabilityPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Capability)) {
            return false;
        }
        Capability other = (Capability)object;
        return (this.capabilityPK != null || other.capabilityPK == null) && (this.capabilityPK == null || this.capabilityPK.equals(other.capabilityPK));
    }

    public String toString() {
        return "net.ivoa.regtap.Capability[ capabilityPK=" + this.capabilityPK + " ]";
    }

    @Override
    public short getIndex() {
        return this.capabilityPK.getCapIndex();
    }

    @Override
    public void setPKIndex(short idx) {
        this.capabilityPK.setCapIndex(idx);
    }

    @Override
    public void setIvoid(String i) {
        this.capabilityPK.setIvoid(i);
    }

    @Override
    public String getIvoid() {
        return this.getCapabilityPK().getIvoid();
    }
}

