/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import org.javastro.ivoa.entities.regtap.Interface;
import org.javastro.ivoa.entities.regtap.IntfParamPK;

@Entity
@Table(name="intf_param")
@XmlType
@XmlAccessorType(value=XmlAccessType.FIELD)
@NamedQueries(value={@NamedQuery(name="IntfParam.findAll", query="SELECT i FROM IntfParam i"), @NamedQuery(name="IntfParam.findByIvoid", query="SELECT i FROM IntfParam i WHERE i.intfParamPK.ivoid = :ivoid"), @NamedQuery(name="IntfParam.findByIntfIndex", query="SELECT i FROM IntfParam i WHERE i.intfParamPK.intfIndex = :intfIndex"), @NamedQuery(name="IntfParam.findByName", query="SELECT i FROM IntfParam i WHERE i.intfParamPK.name = :name"), @NamedQuery(name="IntfParam.findByDatatype", query="SELECT i FROM IntfParam i WHERE i.datatype = :datatype"), @NamedQuery(name="IntfParam.findByDescription", query="SELECT i FROM IntfParam i WHERE i.description = :description"), @NamedQuery(name="IntfParam.findByUcd", query="SELECT i FROM IntfParam i WHERE i.ucd = :ucd"), @NamedQuery(name="IntfParam.findByUnit", query="SELECT i FROM IntfParam i WHERE i.unit = :unit"), @NamedQuery(name="IntfParam.findByUtype", query="SELECT i FROM IntfParam i WHERE i.utype = :utype"), @NamedQuery(name="IntfParam.findByStd", query="SELECT i FROM IntfParam i WHERE i.std = :std"), @NamedQuery(name="IntfParam.findByExtendedSchema", query="SELECT i FROM IntfParam i WHERE i.extendedSchema = :extendedSchema"), @NamedQuery(name="IntfParam.findByExtendedType", query="SELECT i FROM IntfParam i WHERE i.extendedType = :extendedType"), @NamedQuery(name="IntfParam.findByUse", query="SELECT i FROM IntfParam i WHERE i.param_use = :use_param")})
public class IntfParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    @XmlElement
    protected IntfParamPK intfParamPK;
    @Column(name="description", length=1024)
    private String description;
    @Column(name="ucd")
    private String ucd;
    @Column(name="unit")
    private String unit;
    @Column(name="utype")
    private String utype;
    @Basic(optional=false)
    @Column(name="datatype", nullable=false)
    private String datatype;
    @Column(name="extended_schema")
    @XmlElement(name="extended_schema")
    private String extendedSchema;
    @Column(name="extended_type")
    @XmlElement(name="extended_type")
    private String extendedType;
    @Column(name="arraysize")
    @XmlElement(name="arraysize")
    private String arraysize;
    @Column(name="delim")
    @XmlElement(name="delim")
    private String delim;
    @Column(name="param_use")
    @XmlElement(name="use")
    private String param_use;
    @Basic(optional=false)
    @Column(name="std", nullable=false)
    private short std;
    @XmlTransient
    @ManyToOne(optional=false)
    @JoinColumns(value={@JoinColumn(name="ivoid", nullable=false, insertable=false, updatable=false, referencedColumnName="ivoid"), @JoinColumn(name="intf_index", referencedColumnName="intf_index", insertable=false, updatable=false, nullable=false)})
    private Interface iface;

    public IntfParam() {
        this.intfParamPK = new IntfParamPK();
    }

    public IntfParam(String name, String datatype) {
        this.intfParamPK = new IntfParamPK();
        this.intfParamPK.setName(name);
        this.datatype = datatype;
    }

    public IntfParam(IntfParamPK intfParamPK) {
        this.intfParamPK = intfParamPK;
    }

    public IntfParam(IntfParamPK intfParamPK, String datatype, short std) {
        this.intfParamPK = intfParamPK;
        this.datatype = datatype;
        this.std = std;
    }

    public IntfParam(String ivoid, short intfIndex, String name) {
        this.intfParamPK = new IntfParamPK(ivoid, intfIndex, name);
    }

    public IntfParamPK getIntfParamPK() {
        return this.intfParamPK;
    }

    public void setIntfParamPK(IntfParamPK intfParamPK) {
        this.intfParamPK = intfParamPK;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUcd() {
        return this.ucd;
    }

    public void setUcd(String ucd) {
        this.ucd = ucd;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUtype() {
        return this.utype;
    }

    public void setUtype(String utype) {
        this.utype = utype;
    }

    public short getStd() {
        return this.std;
    }

    public void setStd(short std) {
        this.std = std;
    }

    public String getExtendedSchema() {
        return this.extendedSchema;
    }

    public void setExtendedSchema(String extendedSchema) {
        this.extendedSchema = extendedSchema;
    }

    public String getExtendedType() {
        return this.extendedType;
    }

    public void setExtendedType(String extendedType) {
        this.extendedType = extendedType;
    }

    public Interface getIface() {
        return this.iface;
    }

    public void addToInterface(Interface iface) {
        this.iface = iface;
        if (iface.getIntfParamList().indexOf(this) == -1) {
            iface.getIntfParamList().add(this);
        }
        this.intfParamPK.setIvoid(iface.getInterfacePK().getIvoid());
        this.intfParamPK.setIntfIndex(iface.getIndex());
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.intfParamPK != null ? this.intfParamPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntfParam)) {
            return false;
        }
        IntfParam other = (IntfParam)object;
        return (this.intfParamPK != null || other.intfParamPK == null) && (this.intfParamPK == null || this.intfParamPK.equals(other.intfParamPK));
    }

    public String toString() {
        return "net.ivoa.regtap.IntfParam[ intfParamPK=" + this.intfParamPK + " ]";
    }
}

