/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import org.javastro.ivoa.entities.regtap.Resource;

@Embeddable
@XmlType
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Relationship
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Transient
    @XmlAttribute
    private String ivoid;
    @Basic(optional=false)
    @Column(name="relationship_type", nullable=false)
    @XmlElement(name="relationship_type")
    private String relationshipType;
    @Basic(optional=true)
    @Column(name="related_id", nullable=true)
    @XmlElement(name="related_id")
    private String relatedId;
    @Basic(optional=true)
    @Column(name="related_name", nullable=true)
    @XmlElement(name="related_name")
    private String relatedName;
    @XmlTransient
    @Transient
    private Resource resource;

    public Relationship() {
    }

    public Relationship(String relationshipType, String relatedId, String relatedName) {
        this.relationshipType = relationshipType;
        this.relatedId = relatedId;
        this.relatedName = relatedName;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void addToResource(Resource resource) {
        this.resource = resource;
        this.ivoid = resource.getIvoid();
        if (resource.getRelationshipList().indexOf(this) == -1) {
            resource.getRelationshipList().add(this);
        }
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public String getRelatedId() {
        return this.relatedId;
    }

    public void setRelatedId(String relatedId) {
        this.relatedId = relatedId;
    }

    public String getRelatedName() {
        return this.relatedName;
    }

    public void setRelatedName(String relatedName) {
        this.relatedName = relatedName;
    }

    public String getIvoid() {
        return this.ivoid;
    }
}

