/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import org.javastro.ivoa.entities.regtap.ResRolePK;
import org.javastro.ivoa.entities.regtap.Resource;

@Entity
@Table(name="res_role")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@NamedQueries(value={@NamedQuery(name="ResRole.findAll", query="SELECT r FROM ResRole r"), @NamedQuery(name="ResRole.findByIvoid", query="SELECT r FROM ResRole r WHERE r.resRolePK.ivoid = :ivoid"), @NamedQuery(name="ResRole.findByRoleName", query="SELECT r FROM ResRole r WHERE r.roleName = :roleName"), @NamedQuery(name="ResRole.findByRoleIvoid", query="SELECT r FROM ResRole r WHERE r.resRolePK.roleIvoid = :roleIvoid"), @NamedQuery(name="ResRole.findByBaseRole", query="SELECT r FROM ResRole r WHERE r.resRolePK.baseRole = :baseRole"), @NamedQuery(name="ResRole.findByAddress", query="SELECT r FROM ResRole r WHERE r.address = :address"), @NamedQuery(name="ResRole.findByEmail", query="SELECT r FROM ResRole r WHERE r.email = :email"), @NamedQuery(name="ResRole.findByTelephone", query="SELECT r FROM ResRole r WHERE r.telephone = :telephone"), @NamedQuery(name="ResRole.findByLogo", query="SELECT r FROM ResRole r WHERE r.logo = :logo")})
public class ResRole
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    @XmlElement
    protected ResRolePK resRolePK;
    @Basic(optional=false)
    @Column(name="role_name", nullable=false)
    @XmlElement(name="role_name")
    private String roleName;
    @Column(name="street_address")
    private String address;
    @Column(name="email")
    private String email;
    @Column(name="telephone")
    private String telephone;
    @Column(name="logo")
    private String logo;
    @XmlTransient
    @JoinColumn(name="ivoid", referencedColumnName="ivoid", nullable=false, insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Resource resource;

    public ResRole() {
        this.resRolePK = new ResRolePK();
    }

    public ResRole(ResRolePK resRolePK) {
        this.resRolePK = resRolePK;
    }

    public ResRole(ResRolePK resRolePK, String roleName) {
        this.resRolePK = resRolePK;
        this.roleName = roleName;
    }

    public ResRole(String ivoid, String roleIvoid, String baseUtype) {
        this.resRolePK = new ResRolePK(ivoid, roleIvoid, baseUtype);
    }

    public ResRolePK getResRolePK() {
        return this.resRolePK;
    }

    public void setResRolePK(ResRolePK resRolePK) {
        this.resRolePK = resRolePK;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void addToResource(Resource resource) {
        this.resource = resource;
        this.resRolePK.setIvoid(resource.getIvoid());
        if (resource.getResRoleList().indexOf(this) == -1) {
            resource.getResRoleList().add(this);
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.resRolePK != null ? this.resRolePK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResRole)) {
            return false;
        }
        ResRole other = (ResRole)object;
        return (this.resRolePK != null || other.resRolePK == null) && (this.resRolePK == null || this.resRolePK.equals(other.resRolePK));
    }

    public String toString() {
        return "net.ivoa.regtap.ResRole[ resRolePK=" + this.resRolePK + " ]";
    }

    public void setRoleIvoid(String string) {
        this.resRolePK.setRoleIvoid(string);
    }

    public void setRoleBaseRole(String string) {
        this.resRolePK.setBaseRole(string);
    }
}

