/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.List;
import org.javastro.ivoa.entities.regtap.PKIndex;
import org.javastro.ivoa.entities.regtap.PKIndexUtils;
import org.javastro.ivoa.entities.regtap.ResSchemaPK;
import org.javastro.ivoa.entities.regtap.ResTable;
import org.javastro.ivoa.entities.regtap.Resource;

@Entity
@Table(name="res_schema")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@NamedQueries(value={@NamedQuery(name="ResSchema.findAll", query="SELECT r FROM ResSchema r"), @NamedQuery(name="ResSchema.findByIvoid", query="SELECT r FROM ResSchema r WHERE r.resSchemaPK.ivoid = :ivoid"), @NamedQuery(name="ResSchema.findBySchemaIndex", query="SELECT r FROM ResSchema r WHERE r.resSchemaPK.schemaIndex = :schemaIndex"), @NamedQuery(name="ResSchema.findBySchemaName", query="SELECT r FROM ResSchema r WHERE r.name = :schemaName"), @NamedQuery(name="ResSchema.findBySchemaTitle", query="SELECT r FROM ResSchema r WHERE r.title = :schemaTitle"), @NamedQuery(name="ResSchema.findBySchemaDescription", query="SELECT r FROM ResSchema r WHERE r.description = :schemaDescription"), @NamedQuery(name="ResSchema.findBySchemaUtype", query="SELECT r FROM ResSchema r WHERE r.utype = :schemaUtype")})
public class ResSchema
implements Serializable,
PKIndex {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    @XmlElement
    protected ResSchemaPK resSchemaPK;
    @Column(name="schema_name")
    @XmlElement(name="name")
    private String name;
    @Column(name="schema_title")
    @XmlElement(name="title")
    private String title;
    @Column(name="schema_description", length=1024)
    @XmlElement(name="description")
    private String description;
    @Column(name="schema_utype")
    @XmlElement(name="utype")
    private String utype;
    @XmlTransient
    @JoinColumn(name="ivoid", referencedColumnName="ivoid", nullable=false, insertable=false, updatable=false)
    @ManyToOne(optional=false)
    private Resource resource;

    public ResSchema() {
        this.resSchemaPK = new ResSchemaPK();
    }

    public ResSchema(ResSchemaPK resSchemaPK) {
        this.resSchemaPK = resSchemaPK;
    }

    public ResSchema(String ivoid, short schemaIndex) {
        this.resSchemaPK = new ResSchemaPK(ivoid, schemaIndex);
    }

    public ResSchemaPK getResSchemaPK() {
        return this.resSchemaPK;
    }

    public void setResSchemaPK(ResSchemaPK resSchemaPK) {
        this.resSchemaPK = resSchemaPK;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUtype() {
        return this.utype;
    }

    public void setUtype(String utype) {
        this.utype = utype;
    }

    public List<ResTable> getResTableList() {
        return this.resource.getResTableList();
    }

    public Resource getResource() {
        return this.resource;
    }

    public void addToResource(Resource resource) {
        this.resource = resource;
        PKIndexUtils.addWithIndex(this, resource, resource.getResSchemaList());
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.resSchemaPK != null ? this.resSchemaPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResSchema)) {
            return false;
        }
        ResSchema other = (ResSchema)object;
        return (this.resSchemaPK != null || other.resSchemaPK == null) && (this.resSchemaPK == null || this.resSchemaPK.equals(other.resSchemaPK));
    }

    public String toString() {
        return "net.ivoa.regtap.ResSchema[ resSchemaPK=" + this.resSchemaPK + " ]";
    }

    @Override
    public short getIndex() {
        return this.resSchemaPK.getSchemaIndex();
    }

    @Override
    public void setPKIndex(short idx) {
        this.resSchemaPK.setSchemaIndex(idx);
    }

    @Override
    public void setIvoid(String i) {
        this.resSchemaPK.setIvoid(i);
    }
}

