/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.javastro.ivoa.entities.regtap.PKIndex;
import org.javastro.ivoa.entities.regtap.ResSchema;
import org.javastro.ivoa.entities.regtap.ResTablePK;
import org.javastro.ivoa.entities.regtap.Resource;
import org.javastro.ivoa.entities.regtap.TableColumn;

@Entity
@Table(name="res_table")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@NamedQueries(value={@NamedQuery(name="ResTable.findAll", query="SELECT r FROM ResTable r"), @NamedQuery(name="ResTable.findByIvoid", query="SELECT r FROM ResTable r WHERE r.resTablePK.ivoid = :ivoid"), @NamedQuery(name="ResTable.findBySchemaIndex", query="SELECT r FROM ResTable r WHERE r.schemaIndex = :schemaIndex"), @NamedQuery(name="ResTable.findByTableIndex", query="SELECT r FROM ResTable r WHERE r.resTablePK.tableIndex = :tableIndex"), @NamedQuery(name="ResTable.findByTableName", query="SELECT r FROM ResTable r WHERE r.name = :tableName"), @NamedQuery(name="ResTable.findByTableTitle", query="SELECT r FROM ResTable r WHERE r.title = :tableTitle"), @NamedQuery(name="ResTable.findByTableType", query="SELECT r FROM ResTable r WHERE r.type = :tableType"), @NamedQuery(name="ResTable.findByTableUtype", query="SELECT r FROM ResTable r WHERE r.utype = :tableUtype"), @NamedQuery(name="ResTable.findByTableDescription", query="SELECT r FROM ResTable r WHERE r.description = :tableDescription")})
public class ResTable
implements Serializable,
PKIndex {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    @XmlElement
    protected ResTablePK resTablePK;
    @Basic(optional=false)
    @Column(name="schema_index", nullable=true)
    @XmlElement(name="schema_index")
    private Short schemaIndex;
    @Basic(optional=false)
    @Column(name="table_name", nullable=false)
    @XmlElement(name="name")
    private String name;
    @Column(name="table_title")
    @XmlElement(name="title")
    private String title;
    @Column(name="table_description", length=1024)
    @XmlElement(name="description")
    private String description;
    @Column(name="table_utype")
    @XmlElement(name="utype")
    private String utype;
    @Basic(optional=true)
    @Column(name="table_type", nullable=true)
    @XmlElement(name="type")
    private String type;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=TableColumn.class, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="table")
    @XmlElement(name="column")
    private List<TableColumn> tableColumnList;
    @XmlTransient
    @ManyToOne(optional=false)
    @JoinColumns(value={@JoinColumn(name="ivoid", nullable=false, insertable=false, updatable=false, referencedColumnName="ivoid")})
    private Resource resource;

    public ResTable() {
        this.resTablePK = new ResTablePK();
    }

    public ResTable(String name, String type) {
        this.name = name;
        this.type = type;
        this.resTablePK = new ResTablePK();
    }

    public ResTable(ResTablePK resTablePK) {
        this.resTablePK = resTablePK;
    }

    public ResTable(ResTablePK resTablePK, String tableName, String tableType) {
        this.resTablePK = resTablePK;
        this.name = tableName;
        this.type = tableType;
    }

    public ResTable(String ivoid, Short schemaIndex, short tableIndex) {
        this.resTablePK = new ResTablePK(ivoid, tableIndex);
        this.schemaIndex = schemaIndex;
    }

    public ResTablePK getResTablePK() {
        return this.resTablePK;
    }

    public short getSchemaIndex() {
        return this.schemaIndex;
    }

    public void setSchemaIndex(short schemaIndex) {
        this.schemaIndex = schemaIndex;
    }

    public void setResTablePK(ResTablePK resTablePK) {
        this.resTablePK = resTablePK;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUtype() {
        return this.utype;
    }

    public void setUtype(String utype) {
        this.utype = utype;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<TableColumn> getTableColumnList() {
        if (this.tableColumnList == null) {
            this.tableColumnList = new ArrayList<TableColumn>();
        }
        return this.tableColumnList;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void addToSchema(ResSchema schema) {
        this.resource = schema.getResource();
        if (this.resource.getResTableList().indexOf(this) == -1) {
            this.resource.getResTableList().add(this);
        }
        this.resTablePK.setIvoid(schema.getResSchemaPK().getIvoid());
        this.schemaIndex = schema.getIndex();
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.resTablePK != null ? this.resTablePK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResTable)) {
            return false;
        }
        ResTable other = (ResTable)object;
        return (this.resTablePK != null || other.resTablePK == null) && (this.resTablePK == null || this.resTablePK.equals(other.resTablePK));
    }

    public String toString() {
        return "net.ivoa.regtap.ResTable[ resTablePK=" + this.resTablePK + " ]";
    }

    @Override
    public short getIndex() {
        return this.resTablePK.getTableIndex();
    }

    @Override
    public void setPKIndex(short idx) {
        this.resTablePK.setTableIndex(idx);
    }

    @Override
    public void setIvoid(String i) {
        this.resTablePK.setIvoid(i);
    }
}

