/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.javastro.ivoa.entities.regtap.AltIdentifier;
import org.javastro.ivoa.entities.regtap.Capability;
import org.javastro.ivoa.entities.regtap.Date;
import org.javastro.ivoa.entities.regtap.Identifier;
import org.javastro.ivoa.entities.regtap.Relationship;
import org.javastro.ivoa.entities.regtap.ResDetail;
import org.javastro.ivoa.entities.regtap.ResRole;
import org.javastro.ivoa.entities.regtap.ResSchema;
import org.javastro.ivoa.entities.regtap.ResTable;
import org.javastro.ivoa.entities.regtap.Subject;
import org.javastro.ivoa.entities.regtap.Validation;

@Entity
@Table(name="resource")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="resource", propOrder={"ivoid", "altIdentifier", "resType", "created", "updated", "status", "shortName", "resTitle", "contentLevel", "resDescription", "referenceUrl", "creator", "contentType", "sourceFormat", "sourceValue", "version", "regionOfRegard", "waveband", "rights", "rightsURI", "resRoleList", "subjectList", "capabilityList", "validationList", "relationshipList", "dateList", "resSchemaList", "resTableList", "resDetailList"})
@NamedQueries(value={@NamedQuery(name="Resource.findAll", query="SELECT r FROM Resource r"), @NamedQuery(name="Resource.findByIvoid", query="SELECT r FROM Resource r WHERE r.ivoid = :ivoid"), @NamedQuery(name="Resource.findByResType", query="SELECT r FROM Resource r WHERE r.resType = :resType"), @NamedQuery(name="Resource.findByCreated", query="SELECT r FROM Resource r WHERE r.created = :created"), @NamedQuery(name="Resource.findByUpdated", query="SELECT r FROM Resource r WHERE r.updated = :updated"), @NamedQuery(name="Resource.findByStatus", query="SELECT r FROM Resource r WHERE r.status = :status"), @NamedQuery(name="Resource.findByShortName", query="SELECT r FROM Resource r WHERE r.shortName = :shortName"), @NamedQuery(name="Resource.findByResTitle", query="SELECT r FROM Resource r WHERE r.resTitle = :resTitle"), @NamedQuery(name="Resource.findByContentLevel", query="SELECT r FROM Resource r WHERE r.contentLevel = :contentLevel"), @NamedQuery(name="Resource.findByResDescription", query="SELECT r FROM Resource r WHERE r.resDescription = :resDescription"), @NamedQuery(name="Resource.findByReferenceUrl", query="SELECT r FROM Resource r WHERE r.referenceUrl = :referenceUrl"), @NamedQuery(name="Resource.findByContentType", query="SELECT r FROM Resource r WHERE r.contentType = :contentType"), @NamedQuery(name="Resource.findBySourceFormat", query="SELECT r FROM Resource r WHERE r.sourceFormat = :sourceFormat"), @NamedQuery(name="Resource.findBySourceValue", query="SELECT r FROM Resource r WHERE r.sourceValue = :sourceValue"), @NamedQuery(name="Resource.findByVersion", query="SELECT r FROM Resource r WHERE r.version = :version"), @NamedQuery(name="Resource.findByRegionOfRegard", query="SELECT r FROM Resource r WHERE r.regionOfRegard = :regionOfRegard"), @NamedQuery(name="Resource.findByWaveband", query="SELECT r FROM Resource r WHERE r.waveband = :waveband"), @NamedQuery(name="Resource.findByRights", query="SELECT r FROM Resource r WHERE r.rights = :rights")})
public class Resource
implements Identifier,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @Column(name="ivoid", nullable=false)
    private String ivoid;
    @XmlElement(type=AltIdentifier.class, name="alt_identifier")
    @XmlElementWrapper(name="altids")
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="resource", targetEntity=AltIdentifier.class, fetch=FetchType.LAZY, orphanRemoval=true)
    private List<AltIdentifier> altIdentifier;
    @Basic(optional=false)
    @Column(name="res_type", nullable=false)
    @XmlElement(name="res_type")
    private String resType;
    @Basic(optional=false)
    @Column(name="created", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private java.util.Date created;
    @Basic(optional=false)
    @Column(name="updated", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private java.util.Date updated;
    @Basic(optional=false)
    @Column(name="status", nullable=false)
    private String status;
    @Basic(optional=false)
    @Column(name="short_name", nullable=false)
    @XmlElement(name="short_name")
    private String shortName;
    @Basic(optional=false)
    @Column(name="res_title", nullable=false)
    @XmlElement(name="res_title")
    private String resTitle;
    @Column(name="content_level")
    @XmlElement(name="content_level")
    private String contentLevel;
    @Basic(optional=false)
    @Column(name="res_description", length=1024, nullable=false)
    @XmlElement(name="res_description")
    private String resDescription;
    @Basic(optional=false)
    @Column(name="reference_url", nullable=false)
    @XmlElement(name="reference_url")
    private String referenceUrl;
    @Basic(optional=false)
    @Column(name="creator_seq")
    @XmlElement(name="creator_seq")
    private String creator;
    @Column(name="content_type")
    @XmlElement(name="content_type")
    private String contentType;
    @Column(name="source_format")
    @XmlElement(name="source_format")
    private String sourceFormat;
    @Column(name="source_value")
    @XmlElement(name="source_value")
    private String sourceValue;
    @Column(name="res_vesion")
    @XmlElement(name="res_version")
    private String version;
    @Column(name="region_of_regard")
    @XmlElement(name="region_of_regard")
    private double regionOfRegard;
    @Column(name="waveband")
    private String waveband;
    @Column(name="rights")
    private String rights;
    @Column(name="rights_uri")
    @XmlElement(name="rights_uri")
    private String rightsURI;
    @XmlElement(type=Validation.class, name="validation")
    @XmlElementWrapper(name="validationList")
    @ElementCollection
    @CollectionTable(name="validation")
    private List<Validation> validationList;
    @XmlElement(type=Subject.class, name="subject")
    @XmlElementWrapper(name="subjects")
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="resource", targetEntity=Subject.class, fetch=FetchType.LAZY, orphanRemoval=true)
    private List<Subject> subjectList;
    @XmlElement(type=ResDetail.class, name="detail")
    @XmlElementWrapper(name="details")
    @ElementCollection
    @CollectionTable(name="res_detail", joinColumns={@JoinColumn(name="ivoid")})
    private List<ResDetail> resDetailList;
    @XmlElement(type=ResSchema.class, name="schema")
    @XmlElementWrapper(name="schemata")
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="resource", targetEntity=ResSchema.class, fetch=FetchType.EAGER, orphanRemoval=true)
    private List<ResSchema> resSchemaList;
    @XmlElement(type=Date.class, name="date")
    @XmlElementWrapper(name="dates")
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="resource", targetEntity=Date.class, fetch=FetchType.EAGER, orphanRemoval=true)
    private List<Date> dateList;
    @XmlElement(type=Relationship.class, name="relationship")
    @XmlElementWrapper(name="relationships")
    @ElementCollection
    @CollectionTable(name="relationship", joinColumns={@JoinColumn(name="ivoid")})
    private List<Relationship> relationshipList;
    @XmlElement(type=ResRole.class, name="role")
    @XmlElementWrapper(name="roles")
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="resource", targetEntity=ResRole.class, fetch=FetchType.LAZY, orphanRemoval=true)
    private List<ResRole> resRoleList;
    @XmlElement(type=Capability.class, name="capability")
    @XmlElementWrapper(name="capabilities")
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="resource", targetEntity=Capability.class, fetch=FetchType.EAGER, orphanRemoval=true)
    private List<Capability> capabilityList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="resource", targetEntity=ResTable.class, fetch=FetchType.EAGER, orphanRemoval=true)
    @XmlElementWrapper(name="tables")
    @XmlElement(name="table")
    private List<ResTable> resTableList;

    public Resource() {
    }

    public Resource(String ivoid) {
        this.ivoid = ivoid;
    }

    public Resource(String ivoid, String resType, java.util.Date created, java.util.Date updated, String status, String shortName, String resTitle, String resDescription, String referenceUrl) {
        this.ivoid = ivoid;
        this.resType = resType;
        this.created = created;
        this.updated = updated;
        this.status = status;
        this.shortName = shortName;
        this.resTitle = resTitle;
        this.resDescription = resDescription;
        this.referenceUrl = referenceUrl;
    }

    @Override
    public String getIvoid() {
        return this.ivoid;
    }

    public void setIvoid(String ivoid) {
        this.ivoid = ivoid;
    }

    public List<AltIdentifier> getAltIdentifier() {
        if (this.altIdentifier == null) {
            this.altIdentifier = new ArrayList<AltIdentifier>();
        }
        return this.altIdentifier;
    }

    public String getResType() {
        return this.resType;
    }

    public void setResType(String resType) {
        this.resType = resType;
    }

    public java.util.Date getCreated() {
        return this.created;
    }

    public void setCreated(java.util.Date created) {
        this.created = created;
    }

    public java.util.Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(java.util.Date updated) {
        this.updated = updated;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getResTitle() {
        return this.resTitle;
    }

    public void setResTitle(String resTitle) {
        this.resTitle = resTitle;
    }

    public String getContentLevel() {
        return this.contentLevel;
    }

    public void setContentLevel(String contentLevel) {
        this.contentLevel = contentLevel;
    }

    public String getResDescription() {
        return this.resDescription;
    }

    public void setResDescription(String resDescription) {
        this.resDescription = resDescription;
    }

    public String getReferenceUrl() {
        return this.referenceUrl;
    }

    public void setReferenceUrl(String referenceUrl) {
        this.referenceUrl = referenceUrl;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getSourceFormat() {
        return this.sourceFormat;
    }

    public void setSourceFormat(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    public String getSourceValue() {
        return this.sourceValue;
    }

    public void setSourceValue(String sourceValue) {
        this.sourceValue = sourceValue;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public double getRegionOfRegard() {
        return this.regionOfRegard;
    }

    public void setRegionOfRegard(double regionOfRegard) {
        this.regionOfRegard = regionOfRegard;
    }

    public String getWaveband() {
        return this.waveband;
    }

    public void setWaveband(String waveband) {
        this.waveband = waveband;
    }

    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    @XmlTransient
    public List<Validation> getValidationList() {
        if (this.validationList == null) {
            this.validationList = new ArrayList<Validation>();
        }
        return this.validationList;
    }

    @XmlTransient
    public List<Subject> getSubjectList() {
        if (this.subjectList == null) {
            this.subjectList = new ArrayList<Subject>();
        }
        return this.subjectList;
    }

    @XmlTransient
    public List<ResDetail> getResDetailList() {
        if (this.resDetailList == null) {
            this.resDetailList = new ArrayList<ResDetail>();
        }
        return this.resDetailList;
    }

    @XmlTransient
    public List<ResSchema> getResSchemaList() {
        if (this.resSchemaList == null) {
            this.resSchemaList = new ArrayList<ResSchema>();
        }
        return this.resSchemaList;
    }

    @XmlTransient
    public List<Date> getDateList() {
        if (this.dateList == null) {
            this.dateList = new ArrayList<Date>();
        }
        return this.dateList;
    }

    @XmlTransient
    public List<Relationship> getRelationshipList() {
        if (this.relationshipList == null) {
            this.relationshipList = new ArrayList<Relationship>();
        }
        return this.relationshipList;
    }

    @XmlTransient
    public List<ResRole> getResRoleList() {
        if (this.resRoleList == null) {
            this.resRoleList = new ArrayList<ResRole>();
        }
        return this.resRoleList;
    }

    @XmlTransient
    public List<Capability> getCapabilityList() {
        if (this.capabilityList == null) {
            this.capabilityList = new ArrayList<Capability>();
        }
        return this.capabilityList;
    }

    @XmlTransient
    public List<ResTable> getResTableList() {
        if (this.resTableList == null) {
            this.resTableList = new ArrayList<ResTable>();
        }
        return this.resTableList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.ivoid != null ? this.ivoid.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)object;
        return (this.ivoid != null || other.ivoid == null) && (this.ivoid == null || this.ivoid.equals(other.ivoid));
    }

    public String toString() {
        return "net.ivoa.regtap.Resource[ ivoid=" + this.ivoid + " ]";
    }

    public String getRightsURI() {
        return this.rightsURI;
    }

    public void setRightsURI(String rightsURI) {
        this.rightsURI = rightsURI;
    }

    public void setCreator(String c) {
        this.creator = c;
    }
}

