/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import org.javastro.ivoa.entities.regtap.Resource;
import org.javastro.ivoa.entities.regtap.exceptions.IllegalOrphanException;
import org.javastro.ivoa.entities.regtap.exceptions.NonexistentEntityException;
import org.javastro.ivoa.entities.regtap.exceptions.PreexistingEntityException;

@XmlTransient
public class ResourceJpaController {
    private final EntityManagerFactory emf;
    final EntityManager em;

    public ResourceJpaController(EntityManagerFactory emf) {
        this.emf = emf;
        this.em = emf.createEntityManager();
    }

    public void close() {
        this.em.close();
    }

    public void create(Resource resource) throws PreexistingEntityException, Exception {
        try {
            this.em.getTransaction().begin();
            this.em.persist((Object)resource);
            this.em.getTransaction().commit();
        }
        catch (Exception ex) {
            this.em.getTransaction().rollback();
            if (this.findResource(resource.getIvoid()) != null) {
                throw new PreexistingEntityException("Resource " + resource + " already exists.", ex);
            }
            throw ex;
        }
    }

    public void edit(Resource resource) throws IllegalOrphanException, NonexistentEntityException, Exception {
        try {
            this.em.getTransaction().begin();
            resource = (Resource)this.em.merge((Object)resource);
            this.em.getTransaction().commit();
        }
        catch (Exception ex) {
            String id;
            this.em.getTransaction().rollback();
            String msg = ex.getLocalizedMessage();
            if ((msg == null || msg.length() == 0) && this.findResource(id = resource.getIvoid()) == null) {
                throw new NonexistentEntityException("The resource with id " + id + " no longer exists.");
            }
            throw ex;
        }
    }

    public void destroy(String id) throws IllegalOrphanException, NonexistentEntityException {
        Resource resource;
        this.em.getTransaction().begin();
        try {
            resource = (Resource)this.em.getReference(Resource.class, (Object)id);
            resource.getIvoid();
        }
        catch (EntityNotFoundException enfe) {
            throw new NonexistentEntityException("The resource with id " + id + " no longer exists.", enfe);
        }
        this.em.remove((Object)resource);
        this.em.getTransaction().commit();
    }

    public List<Resource> findResourceEntities() {
        return this.findResourceEntities(true, -1, -1);
    }

    public List<Resource> findResourceEntities(int maxResults, int firstResult) {
        return this.findResourceEntities(false, maxResults, firstResult);
    }

    private List<Resource> findResourceEntities(boolean all, int maxResults, int firstResult) {
        CriteriaQuery cq = this.em.getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(Resource.class));
        TypedQuery q = this.em.createQuery(cq);
        if (!all) {
            q.setMaxResults(maxResults);
            q.setFirstResult(firstResult);
        }
        return q.getResultList();
    }

    public Resource findResource(String id) {
        return (Resource)this.em.find(Resource.class, (Object)id);
    }

    public int getResourceCount() {
        CriteriaQuery cq = this.em.getCriteriaBuilder().createQuery();
        Root rt = cq.from(Resource.class);
        cq.select((Selection)this.em.getCriteriaBuilder().count((Expression)rt));
        TypedQuery q = this.em.createQuery(cq);
        return ((Long)q.getSingleResult()).intValue();
    }
}

