/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import org.javastro.ivoa.entities.regtap.ResTable;
import org.javastro.ivoa.entities.regtap.ResTablePK;
import org.javastro.ivoa.entities.regtap.TableColumnPK;

@Entity
@Table(name="table_column")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@NamedQueries(value={@NamedQuery(name="TableColumn.findAll", query="SELECT t FROM TableColumn t"), @NamedQuery(name="TableColumn.findByIvoid", query="SELECT t FROM TableColumn t WHERE t.tableColumnPK.ivoid = :ivoid"), @NamedQuery(name="TableColumn.findByTableIndex", query="SELECT t FROM TableColumn t WHERE t.tableColumnPK.tableIndex = :tableIndex"), @NamedQuery(name="TableColumn.findByName", query="SELECT t FROM TableColumn t WHERE t.name = :name"), @NamedQuery(name="TableColumn.findByDatatype", query="SELECT t FROM TableColumn t WHERE t.datatype = :datatype"), @NamedQuery(name="TableColumn.findByDescription", query="SELECT t FROM TableColumn t WHERE t.description = :description"), @NamedQuery(name="TableColumn.findByUcd", query="SELECT t FROM TableColumn t WHERE t.ucd = :ucd"), @NamedQuery(name="TableColumn.findByUnit", query="SELECT t FROM TableColumn t WHERE t.unit = :unit"), @NamedQuery(name="TableColumn.findByUtype", query="SELECT t FROM TableColumn t WHERE t.utype = :utype"), @NamedQuery(name="TableColumn.findByFlag", query="SELECT t FROM TableColumn t WHERE t.flag = :flag"), @NamedQuery(name="TableColumn.findByStd", query="SELECT t FROM TableColumn t WHERE t.std = :std"), @NamedQuery(name="TableColumn.findByExtendedSchema", query="SELECT t FROM TableColumn t WHERE t.extendedSchema = :extendedSchema"), @NamedQuery(name="TableColumn.findByExtendedType", query="SELECT t FROM TableColumn t WHERE t.extendedType = :extendedType"), @NamedQuery(name="TableColumn.findByArraysize", query="SELECT t FROM TableColumn t WHERE t.arraysize = :arraysize"), @NamedQuery(name="TableColumn.findByDelim", query="SELECT t FROM TableColumn t WHERE t.delim = :delim"), @NamedQuery(name="TableColumn.findByTypeSystem", query="SELECT t FROM TableColumn t WHERE t.typeSystem = :typeSystem")})
public class TableColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    @XmlElement
    protected TableColumnPK tableColumnPK;
    @Basic(optional=false)
    @Column(name="name", nullable=false)
    private String name;
    @Basic(optional=true)
    @Column(name="std", nullable=true)
    @XmlElement(nillable=true)
    private short std;
    @Column(name="flag")
    private String flag;
    @Column(name="description", length=1024)
    private String description;
    @Column(name="unit")
    private String unit;
    @Column(name="ucd")
    private String ucd;
    @Column(name="utype")
    private String utype;
    @Basic(optional=false)
    @Column(name="datatype", nullable=false)
    private String datatype;
    @Column(name="extended_schema")
    @XmlElement(name="extended_schema")
    private String extendedSchema;
    @Column(name="extended_type")
    @XmlElement(name="extended_type")
    private String extendedType;
    @Column(name="arraysize")
    private String arraysize;
    @Column(name="delim")
    private String delim;
    @Column(name="type_system")
    @XmlElement(name="type_system")
    private String typeSystem;
    @XmlTransient
    @ManyToOne(optional=false)
    @JoinColumns(value={@JoinColumn(name="ivoid", nullable=false, insertable=false, updatable=false, referencedColumnName="ivoid"), @JoinColumn(name="table_index", nullable=false, insertable=false, updatable=false, referencedColumnName="table_index")})
    private ResTable table;

    TableColumn() {
        this.tableColumnPK = new TableColumnPK();
    }

    public TableColumn(String name, String type) {
        this.tableColumnPK = new TableColumnPK();
        this.name = name;
        this.datatype = type;
    }

    public TableColumn(TableColumnPK tableColumnPK) {
        this.tableColumnPK = tableColumnPK;
    }

    public TableColumn(TableColumnPK tableColumnPK, String name, String datatype, short std) {
        this.tableColumnPK = tableColumnPK;
        this.datatype = datatype;
        this.std = std;
    }

    public TableColumn(String ivoid, short schemaIndex, short tableIndex, String name) {
        this.tableColumnPK = new TableColumnPK(ivoid, schemaIndex, tableIndex, name);
    }

    public TableColumnPK getTableColumnPK() {
        return this.tableColumnPK;
    }

    public void setTableColumnPK(TableColumnPK tableColumnPK) {
        this.tableColumnPK = tableColumnPK;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUcd() {
        return this.ucd;
    }

    public void setUcd(String ucd) {
        this.ucd = ucd;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUtype() {
        return this.utype;
    }

    public void setUtype(String utype) {
        this.utype = utype;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public short getStd() {
        return this.std;
    }

    public void setStd(short std) {
        this.std = std;
    }

    public String getExtendedSchema() {
        return this.extendedSchema;
    }

    public void setExtendedSchema(String extendedSchema) {
        this.extendedSchema = extendedSchema;
    }

    public String getExtendedType() {
        return this.extendedType;
    }

    public void setExtendedType(String extendedType) {
        this.extendedType = extendedType;
    }

    public String getArraysize() {
        return this.arraysize;
    }

    public void setArraysize(String arraysize) {
        this.arraysize = arraysize;
    }

    public String getDelim() {
        return this.delim;
    }

    public void setDelim(String delim) {
        this.delim = delim;
    }

    public String getTypeSystem() {
        return this.typeSystem;
    }

    public void setTypeSystem(String typeSystem) {
        this.typeSystem = typeSystem;
    }

    public ResTable getTable() {
        return this.table;
    }

    public void addToTable(ResTable table) {
        this.table = table;
        if (table.getTableColumnList().indexOf(this) == -1) {
            table.getTableColumnList().add(this);
        }
        ResTablePK tablePK = table.getResTablePK();
        this.tableColumnPK.setIvoid(tablePK.getIvoid());
        this.tableColumnPK.setTableIndex(tablePK.getTableIndex());
    }

    public String toString() {
        return "net.ivoa.regtap.TableColumn[ tableColumnPK=" + this.tableColumnPK + " ]";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arraysize == null ? 0 : this.arraysize.hashCode());
        result = 31 * result + (this.datatype == null ? 0 : this.datatype.hashCode());
        result = 31 * result + (this.delim == null ? 0 : this.delim.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.extendedSchema == null ? 0 : this.extendedSchema.hashCode());
        result = 31 * result + (this.extendedType == null ? 0 : this.extendedType.hashCode());
        result = 31 * result + (this.flag == null ? 0 : this.flag.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.std;
        result = 31 * result + (this.tableColumnPK == null ? 0 : this.tableColumnPK.hashCode());
        result = 31 * result + (this.typeSystem == null ? 0 : this.typeSystem.hashCode());
        result = 31 * result + (this.ucd == null ? 0 : this.ucd.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.utype == null ? 0 : this.utype.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableColumn)) {
            return false;
        }
        TableColumn other = (TableColumn)obj;
        if (this.arraysize == null ? other.arraysize != null : !this.arraysize.equals(other.arraysize)) {
            return false;
        }
        if (this.datatype == null ? other.datatype != null : !this.datatype.equals(other.datatype)) {
            return false;
        }
        if (this.delim == null ? other.delim != null : !this.delim.equals(other.delim)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.extendedSchema == null ? other.extendedSchema != null : !this.extendedSchema.equals(other.extendedSchema)) {
            return false;
        }
        if (this.extendedType == null ? other.extendedType != null : !this.extendedType.equals(other.extendedType)) {
            return false;
        }
        if (this.flag == null ? other.flag != null : !this.flag.equals(other.flag)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.std != other.std) {
            return false;
        }
        if (this.tableColumnPK == null ? other.tableColumnPK != null : !this.tableColumnPK.equals(other.tableColumnPK)) {
            return false;
        }
        if (this.typeSystem == null ? other.typeSystem != null : !this.typeSystem.equals(other.typeSystem)) {
            return false;
        }
        if (this.ucd == null ? other.ucd != null : !this.ucd.equals(other.ucd)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        return !(this.utype == null ? other.utype != null : !this.utype.equals(other.utype));
    }
}

