/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import org.javastro.ivoa.entities.regtap.Capability;
import org.javastro.ivoa.entities.regtap.Resource;

@Embeddable
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Validation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Transient
    @XmlAttribute
    private String ivoid;
    @Basic(optional=true)
    @Column(name="cap_index", nullable=true)
    @XmlElement(name="cap_index", required=false, nillable=true)
    private Short capIndex;
    @Basic(optional=false)
    @Column(name="validated_by", nullable=false)
    @XmlElement(name="validated_by")
    private String validatedBy;
    @Basic(optional=false)
    @Column(name="level", nullable=false)
    private short level;
    @XmlTransient
    @Transient
    private Resource resource;

    public Validation() {
    }

    public Validation(short capIndex, String validatedBy, short level) {
        this.capIndex = capIndex;
        this.validatedBy = validatedBy;
        this.level = level;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void addToResource(Resource resource) {
        this.resource = resource;
        this.ivoid = resource.getIvoid();
        if (resource.getValidationList().indexOf(this) == -1) {
            resource.getValidationList().add(this);
        }
    }

    public void addToCapability(Capability capability) {
        this.resource = capability.getResource();
        this.ivoid = this.resource.getIvoid();
        this.capIndex = capability.getIndex();
        if (this.resource.getValidationList().indexOf(this) == -1) {
            this.resource.getValidationList().add(this);
        }
    }

    public Short getCapIndex() {
        return this.capIndex;
    }

    public void setCapIndex(Short capIndex) {
        this.capIndex = capIndex;
    }

    public String getValidatedBy() {
        return this.validatedBy;
    }

    public void setValidatedBy(String validatedBy) {
        this.validatedBy = validatedBy;
    }

    public short getLevel() {
        return this.level;
    }

    public void setLevel(short level) {
        this.level = level;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capIndex == null ? 0 : this.capIndex.hashCode());
        result = 31 * result + (this.ivoid == null ? 0 : this.ivoid.hashCode());
        result = 31 * result + this.level;
        result = 31 * result + (this.validatedBy == null ? 0 : this.validatedBy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Validation)) {
            return false;
        }
        Validation other = (Validation)obj;
        if (this.capIndex != other.capIndex) {
            return false;
        }
        if (this.ivoid == null ? other.ivoid != null : !this.ivoid.equals(other.ivoid)) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        return !(this.validatedBy == null ? other.validatedBy != null : !this.validatedBy.equals(other.validatedBy));
    }
}

