/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.regtap.translate;

import jakarta.xml.bind.JAXBException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.javastro.ivoa.entities.IvoaJAXBUtils;
import org.javastro.ivoa.entities.jaxb.Utils;
import org.javastro.ivoa.entities.regtap.RegTAP;
import org.javastro.ivoa.entities.resource.registry.iface.VOResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RegTapTranslator {
    private static final Logger logger = LoggerFactory.getLogger(RegTapTranslator.class);
    private InputStream xslFileStream;
    private TransformerFactory xformFactory = TransformerFactory.newInstance();

    public RegTAP translate(VOResources res) throws JAXBException, IOException, SAXException, ParserConfigurationException, TransformerException {
        this.xslFileStream = RegTapTranslator.class.getResourceAsStream("/convertToRegTap.xsl");
        assert (this.xslFileStream != null) : "could not find the RegistryFixup.xsl";
        StreamSource xsl = new StreamSource(new BufferedReader(new InputStreamReader(this.xslFileStream)));
        Transformer rextapxform = this.xformFactory.newTransformer(xsl);
        Document doc = Utils.marshall(res);
        DOMSource request = new DOMSource(doc);
        DOMResult response = new DOMResult();
        rextapxform.transform(request, response);
        IvoaJAXBUtils.printXML(response.getNode(), new PrintWriter(new File("test.xml")));
        return IvoaJAXBUtils.unmarshall((Document)response.getNode(), RegTAP.class, false);
    }
}

