/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.resource;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.javastro.ivoa.entities.resource.Capability;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.Rights;
import org.javastro.ivoa.entities.resource.Validation;
import org.javastro.ivoa.entities.resource.dataservice.DataResource;
import org.javastro.ivoa.entities.resource.registry.Registry;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Service", propOrder={"rights", "capabilities"})
@XmlSeeAlso(value={DataResource.class, Registry.class})
public class Service
extends Resource
implements Cloneable,
Copyable,
PartialCopyable,
MergeFrom,
ToString {
    protected List<Rights> rights;
    @XmlElement(name="capability")
    protected List<Capability> capabilities;

    public Service() {
    }

    public Service(List<Validation> validationLevels, String title, String shortName, String identifier, List<String> altIdentifiers, Curation curation, Content content, LocalDateTime created, LocalDateTime updated, String status, String version, List<Rights> rights, List<Capability> capabilities) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version);
        this.rights = rights;
        this.capabilities = capabilities;
    }

    public List<Rights> getRights() {
        if (this.rights == null) {
            this.rights = new ArrayList<Rights>();
        }
        return this.rights;
    }

    public List<Capability> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<Capability>();
        }
        return this.capabilities;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Capability> rightCapabilities;
        List<Rights> rightRights;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Service that = (Service)object;
        List<Rights> leftRights = this.rights != null && !this.rights.isEmpty() ? this.getRights() : null;
        List<Rights> list = rightRights = that.rights != null && !that.rights.isEmpty() ? that.getRights() : null;
        if (this.rights != null && !this.rights.isEmpty()) {
            if (that.rights == null || that.rights.isEmpty()) return false;
            if (!leftRights.equals(rightRights)) {
                return false;
            }
        } else if (that.rights != null && !that.rights.isEmpty()) {
            return false;
        }
        List<Capability> leftCapabilities = this.capabilities != null && !this.capabilities.isEmpty() ? this.getCapabilities() : null;
        List<Capability> list2 = rightCapabilities = that.capabilities != null && !that.capabilities.isEmpty() ? that.getCapabilities() : null;
        if (this.capabilities != null && !this.capabilities.isEmpty()) {
            if (that.capabilities == null || that.capabilities.isEmpty()) return false;
            if (leftCapabilities.equals(rightCapabilities)) return true;
            return false;
        }
        if (that.capabilities == null || that.capabilities.isEmpty()) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Capability> theCapabilities;
        List<Rights> theRights;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        List<Rights> list = theRights = this.rights != null && !this.rights.isEmpty() ? this.getRights() : null;
        if (this.rights != null && !this.rights.isEmpty()) {
            currentHashCode += theRights.hashCode();
        }
        currentHashCode *= 31;
        List<Capability> list2 = theCapabilities = this.capabilities != null && !this.capabilities.isEmpty() ? this.getCapabilities() : null;
        if (this.capabilities != null && !this.capabilities.isEmpty()) {
            currentHashCode += theCapabilities.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Rights> theRights = this.rights != null && !this.rights.isEmpty() ? this.getRights() : null;
        strategy.appendField(locator, (Object)this, "rights", buffer, theRights, this.rights != null && !this.rights.isEmpty());
        List<Capability> theCapabilities = this.capabilities != null && !this.capabilities.isEmpty() ? this.getCapabilities() : null;
        strategy.appendField(locator, (Object)this, "capabilities", buffer, theCapabilities, this.capabilities != null && !this.capabilities.isEmpty());
        return buffer;
    }

    @Override
    public void mergeFrom(Object left, Object right) {
        JAXBMergeStrategy strategy = JAXBMergeStrategy.getInstance();
        this.mergeFrom(null, null, left, right, (MergeStrategy)strategy);
    }

    @Override
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Service) {
            Service target = this;
            Service leftObject = (Service)left;
            Service rightObject = (Service)right;
            Boolean rightsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.rights != null && !leftObject.rights.isEmpty(), rightObject.rights != null && !rightObject.rights.isEmpty());
            if (rightsShouldBeMergedAndSet == Boolean.TRUE) {
                List<Rights> lhsRights = leftObject.rights != null && !leftObject.rights.isEmpty() ? leftObject.getRights() : null;
                List<Rights> rhsRights = rightObject.rights != null && !rightObject.rights.isEmpty() ? rightObject.getRights() : null;
                List mergedRights = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"rights", lhsRights), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"rights", rhsRights), lhsRights, rhsRights, leftObject.rights != null && !leftObject.rights.isEmpty(), rightObject.rights != null && !rightObject.rights.isEmpty());
                target.rights = null;
                if (mergedRights != null) {
                    List<Rights> uniqueRightsl = target.getRights();
                    uniqueRightsl.addAll(mergedRights);
                }
            } else if (rightsShouldBeMergedAndSet == Boolean.FALSE) {
                target.rights = null;
            }
            Boolean capabilitiesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.capabilities != null && !leftObject.capabilities.isEmpty(), rightObject.capabilities != null && !rightObject.capabilities.isEmpty());
            if (capabilitiesShouldBeMergedAndSet == Boolean.TRUE) {
                List<Capability> lhsCapabilities = leftObject.capabilities != null && !leftObject.capabilities.isEmpty() ? leftObject.getCapabilities() : null;
                List<Capability> rhsCapabilities = rightObject.capabilities != null && !rightObject.capabilities.isEmpty() ? rightObject.getCapabilities() : null;
                List mergedCapabilities = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"capabilities", lhsCapabilities), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"capabilities", rhsCapabilities), lhsCapabilities, rhsCapabilities, leftObject.capabilities != null && !leftObject.capabilities.isEmpty(), rightObject.capabilities != null && !rightObject.capabilities.isEmpty());
                target.capabilities = null;
                if (mergedCapabilities != null) {
                    List<Capability> uniqueCapabilitiesl = target.getCapabilities();
                    uniqueCapabilitiesl.addAll(mergedCapabilities);
                }
            } else if (capabilitiesShouldBeMergedAndSet == Boolean.FALSE) {
                target.capabilities = null;
            }
        }
    }

    @Override
    public Object createNewInstance() {
        return new Service();
    }

    @Override
    public Service clone() {
        Service _newObject = (Service)super.clone();
        if (this.rights == null) {
            _newObject.rights = null;
        } else {
            _newObject.rights = new ArrayList<Rights>();
            for (Rights rights : this.rights) {
                _newObject.rights.add(rights == null ? null : rights.clone());
            }
        }
        if (this.capabilities == null) {
            _newObject.capabilities = null;
        } else {
            _newObject.capabilities = new ArrayList<Capability>();
            for (Capability capability : this.capabilities) {
                _newObject.capabilities.add(capability == null ? null : capability.clone());
            }
        }
        return _newObject;
    }

    @Override
    public Service createCopy() {
        Service _newObject = (Service)super.createCopy();
        if (this.rights == null) {
            _newObject.rights = null;
        } else {
            _newObject.rights = new ArrayList<Rights>();
            for (Rights rights : this.rights) {
                _newObject.rights.add(rights == null ? null : rights.createCopy());
            }
        }
        if (this.capabilities == null) {
            _newObject.capabilities = null;
        } else {
            _newObject.capabilities = new ArrayList<Capability>();
            for (Capability capability : this.capabilities) {
                _newObject.capabilities.add(capability == null ? null : capability.createCopy());
            }
        }
        return _newObject;
    }

    @Override
    public Service createCopy(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree capabilitiesPropertyTree;
        PropertyTree rightsPropertyTree;
        Service _newObject = (Service)super.createCopy(_propertyTree, _propertyTreeUse);
        PropertyTree propertyTree = rightsPropertyTree = _propertyTree == null ? null : _propertyTree.get("rights");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? rightsPropertyTree != null : rightsPropertyTree == null || !rightsPropertyTree.isLeaf()) {
            if (this.rights == null) {
                _newObject.rights = null;
            } else {
                _newObject.rights = new ArrayList<Rights>();
                for (Rights _item : this.rights) {
                    _newObject.rights.add(_item == null ? null : _item.createCopy(rightsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree2 = capabilitiesPropertyTree = _propertyTree == null ? null : _propertyTree.get("capabilities");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? capabilitiesPropertyTree != null : capabilitiesPropertyTree == null || !capabilitiesPropertyTree.isLeaf()) {
            if (this.capabilities == null) {
                _newObject.capabilities = null;
            } else {
                _newObject.capabilities = new ArrayList<Capability>();
                for (Capability _item : this.capabilities) {
                    _newObject.capabilities.add(_item == null ? null : _item.createCopy(capabilitiesPropertyTree, _propertyTreeUse));
                }
            }
        }
        return _newObject;
    }

    @Override
    public Service copyExcept(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    public Service copyOnly(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Modifier();
        }
        return (Modifier)this.__cachedModifier__;
    }

    public <_B> void copyTo(Builder<_B> _other) {
        super.copyTo(_other);
        if (this.rights == null) {
            _other.rights = null;
        } else {
            _other.rights = new ArrayList();
            for (Rights rights : this.rights) {
                _other.rights.add(rights == null ? null : rights.newCopyBuilder(_other));
            }
        }
        if (this.capabilities == null) {
            _other.capabilities = null;
        } else {
            _other.capabilities = new ArrayList();
            for (Capability capability : this.capabilities) {
                _other.capabilities.add(capability == null ? null : capability.newCopyBuilder(_other));
            }
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder) {
        return new Builder<_B>(_parentBuilder, this, true);
    }

    public Builder<Void> newCopyBuilder() {
        return this.newCopyBuilder((Object)null);
    }

    public static Builder<Void> builder() {
        return new Builder<Object>(null, null, false);
    }

    public static <_B> Builder<_B> copyOf(Resource _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(Service _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public <_B> void copyTo(Builder<_B> _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree capabilitiesPropertyTree;
        PropertyTree rightsPropertyTree;
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        PropertyTree propertyTree = rightsPropertyTree = _propertyTree == null ? null : _propertyTree.get("rights");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? rightsPropertyTree != null : rightsPropertyTree == null || !rightsPropertyTree.isLeaf()) {
            if (this.rights == null) {
                _other.rights = null;
            } else {
                _other.rights = new ArrayList();
                for (Rights _item : this.rights) {
                    _other.rights.add(_item == null ? null : _item.newCopyBuilder(_other, rightsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree2 = capabilitiesPropertyTree = _propertyTree == null ? null : _propertyTree.get("capabilities");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? capabilitiesPropertyTree != null : capabilitiesPropertyTree == null || !capabilitiesPropertyTree.isLeaf()) {
            if (this.capabilities == null) {
                _other.capabilities = null;
            } else {
                _other.capabilities = new ArrayList();
                for (Capability _item : this.capabilities) {
                    _other.capabilities.add(_item == null ? null : _item.newCopyBuilder(_other, capabilitiesPropertyTree, _propertyTreeUse));
                }
            }
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return new Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    public Builder<Void> newCopyBuilder(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return this.newCopyBuilder((Object)null, _propertyTree, _propertyTreeUse);
    }

    public static <_B> Builder<_B> copyOf(Resource _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(Service _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static Builder<Void> copyExcept(Resource _other, PropertyTree _propertyTree) {
        return Service.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(Service _other, PropertyTree _propertyTree) {
        return Service.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyOnly(Resource _other, PropertyTree _propertyTree) {
        return Service.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(Service _other, PropertyTree _propertyTree) {
        return Service.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Service visit(PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty(PropInfo.RIGHTS, (Object)this)) && this.rights != null) {
            for (Rights rights : this.rights) {
                if (rights == null) continue;
                rights.visit(_visitor_);
            }
        }
        if (_visitor_.visit(new CollectionProperty(PropInfo.CAPABILITIES, (Object)this)) && this.capabilities != null) {
            for (Capability capability : this.capabilities) {
                if (capability == null) continue;
                capability.visit(_visitor_);
            }
        }
        return this;
    }

    public class Modifier
    extends Resource.Modifier {
        public Modifier() {
            super(Service.this);
        }

        public List<Rights> getRights() {
            if (Service.this.rights == null) {
                Service.this.rights = new ArrayList<Rights>();
            }
            return Service.this.rights;
        }

        public List<Capability> getCapabilities() {
            if (Service.this.capabilities == null) {
                Service.this.capabilities = new ArrayList<Capability>();
            }
            return Service.this.capabilities;
        }
    }

    public static class Builder<_B>
    extends Resource.Builder<_B>
    implements Buildable {
        private List<Rights.Builder<Builder<_B>>> rights;
        private List<Capability.Builder<Builder<_B>>> capabilities;

        public Builder(_B _parentBuilder, Service _other, boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other != null) {
                if (_other.rights == null) {
                    this.rights = null;
                } else {
                    this.rights = new ArrayList<Rights.Builder<Builder<_B>>>();
                    for (Rights rights : _other.rights) {
                        this.rights.add(rights == null ? null : rights.newCopyBuilder(this));
                    }
                }
                if (_other.capabilities == null) {
                    this.capabilities = null;
                } else {
                    this.capabilities = new ArrayList<Capability.Builder<Builder<_B>>>();
                    for (Capability capability : _other.capabilities) {
                        this.capabilities.add(capability == null ? null : capability.newCopyBuilder(this));
                    }
                }
            }
        }

        public Builder(_B _parentBuilder, Service _other, boolean _copy, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other != null) {
                PropertyTree capabilitiesPropertyTree;
                PropertyTree rightsPropertyTree;
                PropertyTree propertyTree = rightsPropertyTree = _propertyTree == null ? null : _propertyTree.get("rights");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? rightsPropertyTree != null : rightsPropertyTree == null || !rightsPropertyTree.isLeaf()) {
                    if (_other.rights == null) {
                        this.rights = null;
                    } else {
                        this.rights = new ArrayList<Rights.Builder<Builder<_B>>>();
                        for (Rights _item : _other.rights) {
                            this.rights.add(_item == null ? null : _item.newCopyBuilder(this, rightsPropertyTree, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree2 = capabilitiesPropertyTree = _propertyTree == null ? null : _propertyTree.get("capabilities");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? capabilitiesPropertyTree != null : capabilitiesPropertyTree == null || !capabilitiesPropertyTree.isLeaf()) {
                    if (_other.capabilities == null) {
                        this.capabilities = null;
                    } else {
                        this.capabilities = new ArrayList<Capability.Builder<Builder<_B>>>();
                        for (Capability _item : _other.capabilities) {
                            this.capabilities.add(_item == null ? null : _item.newCopyBuilder(this, capabilitiesPropertyTree, _propertyTreeUse));
                        }
                    }
                }
            }
        }

        @Override
        protected <_P extends Service> _P init(_P _product) {
            if (this.rights != null) {
                ArrayList<Rights> rights = new ArrayList<Rights>(this.rights.size());
                for (Rights.Builder builder : this.rights) {
                    rights.add(builder.build());
                }
                _product.rights = rights;
            }
            if (this.capabilities != null) {
                ArrayList<Capability> capabilities = new ArrayList<Capability>(this.capabilities.size());
                for (Capability.Builder builder : this.capabilities) {
                    capabilities.add(builder.build());
                }
                _product.capabilities = capabilities;
            }
            return super.init(_product);
        }

        public Builder<_B> addRights(Iterable<? extends Rights> rights) {
            if (rights != null) {
                if (this.rights == null) {
                    this.rights = new ArrayList<Rights.Builder<Builder<_B>>>();
                }
                for (Rights rights2 : rights) {
                    this.rights.add(new Rights.Builder<Builder>(this, rights2, false));
                }
            }
            return this;
        }

        public Builder<_B> withRights(Iterable<? extends Rights> rights) {
            if (this.rights != null) {
                this.rights.clear();
            }
            return this.addRights(rights);
        }

        public Builder<_B> addRights(Rights ... rights) {
            this.addRights(Arrays.asList(rights));
            return this;
        }

        public Builder<_B> withRights(Rights ... rights) {
            this.withRights(Arrays.asList(rights));
            return this;
        }

        public Rights.Builder<? extends Builder<_B>> addRights() {
            if (this.rights == null) {
                this.rights = new ArrayList<Rights.Builder<Builder<_B>>>();
            }
            Rights.Builder<Builder> rights_Builder = new Rights.Builder<Builder>(this, null, false);
            this.rights.add(rights_Builder);
            return rights_Builder;
        }

        public Builder<_B> addCapabilities(Iterable<? extends Capability> capabilities) {
            if (capabilities != null) {
                if (this.capabilities == null) {
                    this.capabilities = new ArrayList<Capability.Builder<Builder<_B>>>();
                }
                for (Capability capability : capabilities) {
                    this.capabilities.add(new Capability.Builder<Builder>(this, capability, false));
                }
            }
            return this;
        }

        public Builder<_B> withCapabilities(Iterable<? extends Capability> capabilities) {
            if (this.capabilities != null) {
                this.capabilities.clear();
            }
            return this.addCapabilities(capabilities);
        }

        public Builder<_B> addCapabilities(Capability ... capabilities) {
            this.addCapabilities(Arrays.asList(capabilities));
            return this;
        }

        public Builder<_B> withCapabilities(Capability ... capabilities) {
            this.withCapabilities(Arrays.asList(capabilities));
            return this;
        }

        public Capability.Builder<? extends Builder<_B>> addCapabilities() {
            if (this.capabilities == null) {
                this.capabilities = new ArrayList<Capability.Builder<Builder<_B>>>();
            }
            Capability.Builder<Builder> capabilities_Builder = new Capability.Builder<Builder>(this, null, false);
            this.capabilities.add(capabilities_Builder);
            return capabilities_Builder;
        }

        @Override
        public Builder<_B> addValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> addValidationLevels(Validation ... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Validation ... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withTitle(String title) {
            super.withTitle(title);
            return this;
        }

        @Override
        public Builder<_B> withShortName(String shortName) {
            super.withShortName(shortName);
            return this;
        }

        @Override
        public Builder<_B> withIdentifier(String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        @Override
        public Builder<_B> addAltIdentifiers(Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> addAltIdentifiers(String ... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withAltIdentifiers(Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withAltIdentifiers(String ... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withCuration(Curation curation) {
            super.withCuration(curation);
            return this;
        }

        @Override
        public Curation.Builder<? extends Builder<_B>> withCuration() {
            return super.withCuration();
        }

        @Override
        public Builder<_B> withContent(Content content) {
            super.withContent(content);
            return this;
        }

        @Override
        public Content.Builder<? extends Builder<_B>> withContent() {
            return super.withContent();
        }

        @Override
        public Builder<_B> withCreated(LocalDateTime created) {
            super.withCreated(created);
            return this;
        }

        @Override
        public Builder<_B> withUpdated(LocalDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        @Override
        public Builder<_B> withStatus(String status) {
            super.withStatus(status);
            return this;
        }

        @Override
        public Builder<_B> withVersion(String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public Service build() {
            if (this._storedValue == null) {
                return this.init(new Service());
            }
            return (Service)this._storedValue;
        }

        public Builder<_B> copyOf(Service _other) {
            _other.copyTo(this);
            return this;
        }

        public Builder<_B> copyOf(Builder _other) {
            return this.copyOf(_other.build());
        }
    }

    public static class PropInfo {
        public static final transient CollectionPropertyInfo<Service, Rights> RIGHTS = new CollectionPropertyInfo<Service, Rights>("rights", Service.class, Rights.class, true, null, new QName("", "rights"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "Rights"), false){

            public List<Rights> get(Service _instance_) {
                return _instance_ == null ? null : _instance_.rights;
            }

            public void set(Service _instance_, List<Rights> _value_) {
                if (_instance_ != null) {
                    _instance_.rights = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<Service, Capability> CAPABILITIES = new CollectionPropertyInfo<Service, Capability>("capabilities", Service.class, Capability.class, true, null, new QName("", "capability"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "Capability"), false){

            public List<Capability> get(Service _instance_) {
                return _instance_ == null ? null : _instance_.capabilities;
            }

            public void set(Service _instance_, List<Capability> _value_) {
                if (_instance_ != null) {
                    _instance_.capabilities = _value_;
                }
            }
        };
    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?>, TParent>
    extends Resource.Selector<TRoot, TParent> {
        private Rights.Selector<TRoot, Selector<TRoot, TParent>> rights = null;
        private Capability.Selector<TRoot, Selector<TRoot, TParent>> capabilities = null;

        public Selector(TRoot root, TParent parent, String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            HashMap<String, PropertyTree> products = new HashMap<String, PropertyTree>();
            products.putAll(super.buildChildren());
            if (this.rights != null) {
                products.put("rights", this.rights.init());
            }
            if (this.capabilities != null) {
                products.put("capabilities", this.capabilities.init());
            }
            return products;
        }

        public Rights.Selector<TRoot, Selector<TRoot, TParent>> rights() {
            return this.rights == null ? (this.rights = new Rights.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "rights")) : this.rights;
        }

        public Capability.Selector<TRoot, Selector<TRoot, TParent>> capabilities() {
            return this.capabilities == null ? (this.capabilities = new Capability.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "capabilities")) : this.capabilities;
        }
    }

    public static class Select
    extends Selector<Select, Void> {
        Select() {
            super(null, null, null);
        }

        public static Select _root() {
            return new Select();
        }
    }
}

