/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.resource.applications;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.Validation;
import org.javastro.ivoa.entities.resource.applications.Application;
import org.javastro.ivoa.entities.resource.applications.ApplicationCapability;
import org.javastro.ivoa.entities.resource.applications.DataFormat;
import org.javastro.ivoa.entities.resource.applications.ExecutionEnvironment;
import org.javastro.ivoa.entities.resource.applications.NetworkRequirement;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DesktopApplication", propOrder={"binarySize", "memoryRequirement", "network", "dependsOns", "executables"})
public class DesktopApplication
extends Application
implements Cloneable,
Copyable,
PartialCopyable,
MergeFrom,
ToString {
    protected Integer binarySize;
    protected String memoryRequirement;
    @XmlSchemaType(name="string")
    protected NetworkRequirement network;
    @XmlElement(name="dependsOn")
    @XmlSchemaType(name="anyURI")
    protected List<String> dependsOns;
    @XmlElement(name="executable")
    protected List<ExecutionEnvironment> executables;

    public DesktopApplication() {
    }

    public DesktopApplication(List<Validation> validationLevels, String title, String shortName, String identifier, List<String> altIdentifiers, Curation curation, Content content, LocalDateTime created, LocalDateTime updated, String status, String version, String cost, String licence, Boolean openSource, List<DataFormat> dataFormats, List<ApplicationCapability> voStandards, List<String> sourceLanguages, String sourceCodeURL, Integer binarySize, String memoryRequirement, NetworkRequirement network, List<String> dependsOns, List<ExecutionEnvironment> executables) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version, cost, licence, openSource, dataFormats, voStandards, sourceLanguages, sourceCodeURL);
        this.binarySize = binarySize;
        this.memoryRequirement = memoryRequirement;
        this.network = network;
        this.dependsOns = dependsOns;
        this.executables = executables;
    }

    public Integer getBinarySize() {
        return this.binarySize;
    }

    public void setBinarySize(Integer value) {
        this.binarySize = value;
    }

    public String getMemoryRequirement() {
        return this.memoryRequirement;
    }

    public void setMemoryRequirement(String value) {
        this.memoryRequirement = value;
    }

    public NetworkRequirement getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkRequirement value) {
        this.network = value;
    }

    public List<String> getDependsOns() {
        if (this.dependsOns == null) {
            this.dependsOns = new ArrayList<String>();
        }
        return this.dependsOns;
    }

    public List<ExecutionEnvironment> getExecutables() {
        if (this.executables == null) {
            this.executables = new ArrayList<ExecutionEnvironment>();
        }
        return this.executables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<ExecutionEnvironment> rightExecutables;
        List<String> rightDependsOns;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DesktopApplication that = (DesktopApplication)object;
        Integer leftBinarySize = this.getBinarySize();
        Integer rightBinarySize = that.getBinarySize();
        if (this.binarySize != null) {
            if (that.binarySize == null) return false;
            if (!leftBinarySize.equals(rightBinarySize)) {
                return false;
            }
        } else if (that.binarySize != null) {
            return false;
        }
        String leftMemoryRequirement = this.getMemoryRequirement();
        String rightMemoryRequirement = that.getMemoryRequirement();
        if (this.memoryRequirement != null) {
            if (that.memoryRequirement == null) return false;
            if (!leftMemoryRequirement.equals(rightMemoryRequirement)) {
                return false;
            }
        } else if (that.memoryRequirement != null) {
            return false;
        }
        NetworkRequirement leftNetwork = this.getNetwork();
        NetworkRequirement rightNetwork = that.getNetwork();
        if (this.network != null) {
            if (that.network == null) return false;
            if (!leftNetwork.equals((Object)rightNetwork)) {
                return false;
            }
        } else if (that.network != null) {
            return false;
        }
        List<String> leftDependsOns = this.dependsOns != null && !this.dependsOns.isEmpty() ? this.getDependsOns() : null;
        List<String> list = rightDependsOns = that.dependsOns != null && !that.dependsOns.isEmpty() ? that.getDependsOns() : null;
        if (this.dependsOns != null && !this.dependsOns.isEmpty()) {
            if (that.dependsOns == null || that.dependsOns.isEmpty()) return false;
            if (!leftDependsOns.equals(rightDependsOns)) {
                return false;
            }
        } else if (that.dependsOns != null && !that.dependsOns.isEmpty()) {
            return false;
        }
        List<ExecutionEnvironment> leftExecutables = this.executables != null && !this.executables.isEmpty() ? this.getExecutables() : null;
        List<ExecutionEnvironment> list2 = rightExecutables = that.executables != null && !that.executables.isEmpty() ? that.getExecutables() : null;
        if (this.executables != null && !this.executables.isEmpty()) {
            if (that.executables == null || that.executables.isEmpty()) return false;
            if (leftExecutables.equals(rightExecutables)) return true;
            return false;
        }
        if (that.executables == null || that.executables.isEmpty()) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<ExecutionEnvironment> theExecutables;
        List<String> theDependsOns;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        Integer theBinarySize = this.getBinarySize();
        if (this.binarySize != null) {
            currentHashCode += theBinarySize.hashCode();
        }
        currentHashCode *= 31;
        String theMemoryRequirement = this.getMemoryRequirement();
        if (this.memoryRequirement != null) {
            currentHashCode += theMemoryRequirement.hashCode();
        }
        currentHashCode *= 31;
        NetworkRequirement theNetwork = this.getNetwork();
        if (this.network != null) {
            currentHashCode += theNetwork.hashCode();
        }
        currentHashCode *= 31;
        List<String> list = theDependsOns = this.dependsOns != null && !this.dependsOns.isEmpty() ? this.getDependsOns() : null;
        if (this.dependsOns != null && !this.dependsOns.isEmpty()) {
            currentHashCode += theDependsOns.hashCode();
        }
        currentHashCode *= 31;
        List<ExecutionEnvironment> list2 = theExecutables = this.executables != null && !this.executables.isEmpty() ? this.getExecutables() : null;
        if (this.executables != null && !this.executables.isEmpty()) {
            currentHashCode += theExecutables.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Integer theBinarySize = this.getBinarySize();
        strategy.appendField(locator, (Object)this, "binarySize", buffer, (Object)theBinarySize, this.binarySize != null);
        String theMemoryRequirement = this.getMemoryRequirement();
        strategy.appendField(locator, (Object)this, "memoryRequirement", buffer, (Object)theMemoryRequirement, this.memoryRequirement != null);
        NetworkRequirement theNetwork = this.getNetwork();
        strategy.appendField(locator, (Object)this, "network", buffer, (Object)theNetwork, this.network != null);
        List<String> theDependsOns = this.dependsOns != null && !this.dependsOns.isEmpty() ? this.getDependsOns() : null;
        strategy.appendField(locator, (Object)this, "dependsOns", buffer, theDependsOns, this.dependsOns != null && !this.dependsOns.isEmpty());
        List<ExecutionEnvironment> theExecutables = this.executables != null && !this.executables.isEmpty() ? this.getExecutables() : null;
        strategy.appendField(locator, (Object)this, "executables", buffer, theExecutables, this.executables != null && !this.executables.isEmpty());
        return buffer;
    }

    @Override
    public void mergeFrom(Object left, Object right) {
        JAXBMergeStrategy strategy = JAXBMergeStrategy.getInstance();
        this.mergeFrom(null, null, left, right, (MergeStrategy)strategy);
    }

    @Override
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof DesktopApplication) {
            DesktopApplication target = this;
            DesktopApplication leftObject = (DesktopApplication)left;
            DesktopApplication rightObject = (DesktopApplication)right;
            Boolean binarySizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.binarySize != null, rightObject.binarySize != null);
            if (binarySizeShouldBeMergedAndSet == Boolean.TRUE) {
                Integer lhsBinarySize = leftObject.getBinarySize();
                Integer rhsBinarySize = rightObject.getBinarySize();
                Integer mergedBinarySize = (Integer)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"binarySize", (Object)lhsBinarySize), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"binarySize", (Object)rhsBinarySize), (Object)lhsBinarySize, (Object)rhsBinarySize, leftObject.binarySize != null, rightObject.binarySize != null);
                target.setBinarySize(mergedBinarySize);
            } else if (binarySizeShouldBeMergedAndSet == Boolean.FALSE) {
                target.binarySize = null;
            }
            Boolean memoryRequirementShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.memoryRequirement != null, rightObject.memoryRequirement != null);
            if (memoryRequirementShouldBeMergedAndSet == Boolean.TRUE) {
                String lhsMemoryRequirement = leftObject.getMemoryRequirement();
                String rhsMemoryRequirement = rightObject.getMemoryRequirement();
                String mergedMemoryRequirement = (String)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"memoryRequirement", (Object)lhsMemoryRequirement), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"memoryRequirement", (Object)rhsMemoryRequirement), (Object)lhsMemoryRequirement, (Object)rhsMemoryRequirement, leftObject.memoryRequirement != null, rightObject.memoryRequirement != null);
                target.setMemoryRequirement(mergedMemoryRequirement);
            } else if (memoryRequirementShouldBeMergedAndSet == Boolean.FALSE) {
                target.memoryRequirement = null;
            }
            Boolean networkShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.network != null, rightObject.network != null);
            if (networkShouldBeMergedAndSet == Boolean.TRUE) {
                NetworkRequirement lhsNetwork = leftObject.getNetwork();
                NetworkRequirement rhsNetwork = rightObject.getNetwork();
                NetworkRequirement mergedNetwork = (NetworkRequirement)((Object)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"network", (Object)((Object)lhsNetwork)), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"network", (Object)((Object)rhsNetwork)), (Object)lhsNetwork, (Object)rhsNetwork, leftObject.network != null, rightObject.network != null));
                target.setNetwork(mergedNetwork);
            } else if (networkShouldBeMergedAndSet == Boolean.FALSE) {
                target.network = null;
            }
            Boolean dependsOnsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.dependsOns != null && !leftObject.dependsOns.isEmpty(), rightObject.dependsOns != null && !rightObject.dependsOns.isEmpty());
            if (dependsOnsShouldBeMergedAndSet == Boolean.TRUE) {
                List<String> lhsDependsOns = leftObject.dependsOns != null && !leftObject.dependsOns.isEmpty() ? leftObject.getDependsOns() : null;
                List<String> rhsDependsOns = rightObject.dependsOns != null && !rightObject.dependsOns.isEmpty() ? rightObject.getDependsOns() : null;
                List mergedDependsOns = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"dependsOns", lhsDependsOns), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"dependsOns", rhsDependsOns), lhsDependsOns, rhsDependsOns, leftObject.dependsOns != null && !leftObject.dependsOns.isEmpty(), rightObject.dependsOns != null && !rightObject.dependsOns.isEmpty());
                target.dependsOns = null;
                if (mergedDependsOns != null) {
                    List<String> uniqueDependsOnsl = target.getDependsOns();
                    uniqueDependsOnsl.addAll(mergedDependsOns);
                }
            } else if (dependsOnsShouldBeMergedAndSet == Boolean.FALSE) {
                target.dependsOns = null;
            }
            Boolean executablesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.executables != null && !leftObject.executables.isEmpty(), rightObject.executables != null && !rightObject.executables.isEmpty());
            if (executablesShouldBeMergedAndSet == Boolean.TRUE) {
                List<ExecutionEnvironment> lhsExecutables = leftObject.executables != null && !leftObject.executables.isEmpty() ? leftObject.getExecutables() : null;
                List<ExecutionEnvironment> rhsExecutables = rightObject.executables != null && !rightObject.executables.isEmpty() ? rightObject.getExecutables() : null;
                List mergedExecutables = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"executables", lhsExecutables), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"executables", rhsExecutables), lhsExecutables, rhsExecutables, leftObject.executables != null && !leftObject.executables.isEmpty(), rightObject.executables != null && !rightObject.executables.isEmpty());
                target.executables = null;
                if (mergedExecutables != null) {
                    List<ExecutionEnvironment> uniqueExecutablesl = target.getExecutables();
                    uniqueExecutablesl.addAll(mergedExecutables);
                }
            } else if (executablesShouldBeMergedAndSet == Boolean.FALSE) {
                target.executables = null;
            }
        }
    }

    @Override
    public Object createNewInstance() {
        return new DesktopApplication();
    }

    @Override
    public DesktopApplication clone() {
        DesktopApplication _newObject = (DesktopApplication)super.clone();
        ArrayList<String> arrayList = _newObject.dependsOns = this.dependsOns == null ? null : new ArrayList<String>(this.dependsOns);
        if (this.executables == null) {
            _newObject.executables = null;
        } else {
            _newObject.executables = new ArrayList<ExecutionEnvironment>();
            for (ExecutionEnvironment _item : this.executables) {
                _newObject.executables.add(_item == null ? null : _item.clone());
            }
        }
        return _newObject;
    }

    @Override
    public DesktopApplication createCopy() {
        DesktopApplication _newObject = (DesktopApplication)super.createCopy();
        _newObject.binarySize = this.binarySize;
        _newObject.memoryRequirement = this.memoryRequirement;
        _newObject.network = this.network;
        ArrayList<String> arrayList = _newObject.dependsOns = this.dependsOns == null ? null : new ArrayList<String>(this.dependsOns);
        if (this.executables == null) {
            _newObject.executables = null;
        } else {
            _newObject.executables = new ArrayList<ExecutionEnvironment>();
            for (ExecutionEnvironment _item : this.executables) {
                _newObject.executables.add(_item == null ? null : _item.createCopy());
            }
        }
        return _newObject;
    }

    @Override
    public DesktopApplication createCopy(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree executablesPropertyTree;
        PropertyTree dependsOnsPropertyTree;
        PropertyTree networkPropertyTree;
        PropertyTree memoryRequirementPropertyTree;
        PropertyTree binarySizePropertyTree;
        DesktopApplication _newObject = (DesktopApplication)super.createCopy(_propertyTree, _propertyTreeUse);
        PropertyTree propertyTree = binarySizePropertyTree = _propertyTree == null ? null : _propertyTree.get("binarySize");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? binarySizePropertyTree != null : binarySizePropertyTree == null || !binarySizePropertyTree.isLeaf()) {
            _newObject.binarySize = this.binarySize;
        }
        PropertyTree propertyTree2 = memoryRequirementPropertyTree = _propertyTree == null ? null : _propertyTree.get("memoryRequirement");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? memoryRequirementPropertyTree != null : memoryRequirementPropertyTree == null || !memoryRequirementPropertyTree.isLeaf()) {
            _newObject.memoryRequirement = this.memoryRequirement;
        }
        PropertyTree propertyTree3 = networkPropertyTree = _propertyTree == null ? null : _propertyTree.get("network");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? networkPropertyTree != null : networkPropertyTree == null || !networkPropertyTree.isLeaf()) {
            _newObject.network = this.network;
        }
        PropertyTree propertyTree4 = dependsOnsPropertyTree = _propertyTree == null ? null : _propertyTree.get("dependsOns");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? dependsOnsPropertyTree != null : dependsOnsPropertyTree == null || !dependsOnsPropertyTree.isLeaf()) {
            _newObject.dependsOns = this.dependsOns == null ? null : new ArrayList<String>(this.dependsOns);
        }
        PropertyTree propertyTree5 = executablesPropertyTree = _propertyTree == null ? null : _propertyTree.get("executables");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? executablesPropertyTree != null : executablesPropertyTree == null || !executablesPropertyTree.isLeaf()) {
            if (this.executables == null) {
                _newObject.executables = null;
            } else {
                _newObject.executables = new ArrayList<ExecutionEnvironment>();
                for (ExecutionEnvironment _item : this.executables) {
                    _newObject.executables.add(_item == null ? null : _item.createCopy(executablesPropertyTree, _propertyTreeUse));
                }
            }
        }
        return _newObject;
    }

    @Override
    public DesktopApplication copyExcept(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    public DesktopApplication copyOnly(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Modifier();
        }
        return (Modifier)this.__cachedModifier__;
    }

    public <_B> void copyTo(Builder<_B> _other) {
        super.copyTo(_other);
        _other.binarySize = this.binarySize;
        _other.memoryRequirement = this.memoryRequirement;
        _other.network = this.network;
        if (this.dependsOns == null) {
            _other.dependsOns = null;
        } else {
            _other.dependsOns = new ArrayList<Buildable>();
            for (String string : this.dependsOns) {
                _other.dependsOns.add((Buildable)(string == null ? null : new Buildable.PrimitiveBuildable((Object)string)));
            }
        }
        if (this.executables == null) {
            _other.executables = null;
        } else {
            _other.executables = new ArrayList();
            for (ExecutionEnvironment executionEnvironment : this.executables) {
                _other.executables.add(executionEnvironment == null ? null : executionEnvironment.newCopyBuilder(_other));
            }
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder) {
        return new Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    public Builder<Void> newCopyBuilder() {
        return this.newCopyBuilder((Object)null);
    }

    public static Builder<Void> builder() {
        return new Builder<Object>(null, null, false);
    }

    public static <_B> Builder<_B> copyOf(Resource _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(Application _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(DesktopApplication _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public <_B> void copyTo(Builder<_B> _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree executablesPropertyTree;
        PropertyTree dependsOnsPropertyTree;
        PropertyTree networkPropertyTree;
        PropertyTree memoryRequirementPropertyTree;
        PropertyTree binarySizePropertyTree;
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        PropertyTree propertyTree = binarySizePropertyTree = _propertyTree == null ? null : _propertyTree.get("binarySize");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? binarySizePropertyTree != null : binarySizePropertyTree == null || !binarySizePropertyTree.isLeaf()) {
            _other.binarySize = this.binarySize;
        }
        PropertyTree propertyTree2 = memoryRequirementPropertyTree = _propertyTree == null ? null : _propertyTree.get("memoryRequirement");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? memoryRequirementPropertyTree != null : memoryRequirementPropertyTree == null || !memoryRequirementPropertyTree.isLeaf()) {
            _other.memoryRequirement = this.memoryRequirement;
        }
        PropertyTree propertyTree3 = networkPropertyTree = _propertyTree == null ? null : _propertyTree.get("network");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? networkPropertyTree != null : networkPropertyTree == null || !networkPropertyTree.isLeaf()) {
            _other.network = this.network;
        }
        PropertyTree propertyTree4 = dependsOnsPropertyTree = _propertyTree == null ? null : _propertyTree.get("dependsOns");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? dependsOnsPropertyTree != null : dependsOnsPropertyTree == null || !dependsOnsPropertyTree.isLeaf()) {
            if (this.dependsOns == null) {
                _other.dependsOns = null;
            } else {
                _other.dependsOns = new ArrayList<Buildable>();
                for (String _item : this.dependsOns) {
                    _other.dependsOns.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable((Object)_item)));
                }
            }
        }
        PropertyTree propertyTree5 = executablesPropertyTree = _propertyTree == null ? null : _propertyTree.get("executables");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? executablesPropertyTree != null : executablesPropertyTree == null || !executablesPropertyTree.isLeaf()) {
            if (this.executables == null) {
                _other.executables = null;
            } else {
                _other.executables = new ArrayList();
                for (ExecutionEnvironment _item : this.executables) {
                    _other.executables.add(_item == null ? null : _item.newCopyBuilder(_other, executablesPropertyTree, _propertyTreeUse));
                }
            }
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return new Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    public Builder<Void> newCopyBuilder(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return this.newCopyBuilder((Object)null, _propertyTree, _propertyTreeUse);
    }

    public static <_B> Builder<_B> copyOf(Resource _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(Application _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(DesktopApplication _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static Builder<Void> copyExcept(Resource _other, PropertyTree _propertyTree) {
        return DesktopApplication.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(Application _other, PropertyTree _propertyTree) {
        return DesktopApplication.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(DesktopApplication _other, PropertyTree _propertyTree) {
        return DesktopApplication.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyOnly(Resource _other, PropertyTree _propertyTree) {
        return DesktopApplication.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(Application _other, PropertyTree _propertyTree) {
        return DesktopApplication.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(DesktopApplication _other, PropertyTree _propertyTree) {
        return DesktopApplication.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public DesktopApplication visit(PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty(PropInfo.BINARY_SIZE, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.MEMORY_REQUIREMENT, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.NETWORK, (Object)this));
        _visitor_.visit(new CollectionProperty(PropInfo.DEPENDS_ONS, (Object)this));
        if (_visitor_.visit(new CollectionProperty(PropInfo.EXECUTABLES, (Object)this)) && this.executables != null) {
            for (ExecutionEnvironment _item_ : this.executables) {
                if (_item_ == null) continue;
                _item_.visit(_visitor_);
            }
        }
        return this;
    }

    public class Modifier
    extends Application.Modifier {
        public Modifier() {
            super(DesktopApplication.this);
        }

        public void setBinarySize(Integer binarySize) {
            DesktopApplication.this.setBinarySize(binarySize);
        }

        public void setMemoryRequirement(String memoryRequirement) {
            DesktopApplication.this.setMemoryRequirement(memoryRequirement);
        }

        public void setNetwork(NetworkRequirement network) {
            DesktopApplication.this.setNetwork(network);
        }

        public List<String> getDependsOns() {
            if (DesktopApplication.this.dependsOns == null) {
                DesktopApplication.this.dependsOns = new ArrayList<String>();
            }
            return DesktopApplication.this.dependsOns;
        }

        public List<ExecutionEnvironment> getExecutables() {
            if (DesktopApplication.this.executables == null) {
                DesktopApplication.this.executables = new ArrayList<ExecutionEnvironment>();
            }
            return DesktopApplication.this.executables;
        }
    }

    public static class Builder<_B>
    extends Application.Builder<_B>
    implements Buildable {
        private Integer binarySize;
        private String memoryRequirement;
        private NetworkRequirement network;
        private List<Buildable> dependsOns;
        private List<ExecutionEnvironment.Builder<Builder<_B>>> executables;

        public Builder(_B _parentBuilder, DesktopApplication _other, boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other != null) {
                this.binarySize = _other.binarySize;
                this.memoryRequirement = _other.memoryRequirement;
                this.network = _other.network;
                if (_other.dependsOns == null) {
                    this.dependsOns = null;
                } else {
                    this.dependsOns = new ArrayList<Buildable>();
                    for (String string : _other.dependsOns) {
                        this.dependsOns.add((Buildable)(string == null ? null : new Buildable.PrimitiveBuildable((Object)string)));
                    }
                }
                if (_other.executables == null) {
                    this.executables = null;
                } else {
                    this.executables = new ArrayList<ExecutionEnvironment.Builder<Builder<_B>>>();
                    for (ExecutionEnvironment executionEnvironment : _other.executables) {
                        this.executables.add(executionEnvironment == null ? null : executionEnvironment.newCopyBuilder(this));
                    }
                }
            }
        }

        public Builder(_B _parentBuilder, DesktopApplication _other, boolean _copy, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other != null) {
                PropertyTree executablesPropertyTree;
                PropertyTree dependsOnsPropertyTree;
                PropertyTree networkPropertyTree;
                PropertyTree memoryRequirementPropertyTree;
                PropertyTree binarySizePropertyTree;
                PropertyTree propertyTree = binarySizePropertyTree = _propertyTree == null ? null : _propertyTree.get("binarySize");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? binarySizePropertyTree != null : binarySizePropertyTree == null || !binarySizePropertyTree.isLeaf()) {
                    this.binarySize = _other.binarySize;
                }
                PropertyTree propertyTree2 = memoryRequirementPropertyTree = _propertyTree == null ? null : _propertyTree.get("memoryRequirement");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? memoryRequirementPropertyTree != null : memoryRequirementPropertyTree == null || !memoryRequirementPropertyTree.isLeaf()) {
                    this.memoryRequirement = _other.memoryRequirement;
                }
                PropertyTree propertyTree3 = networkPropertyTree = _propertyTree == null ? null : _propertyTree.get("network");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? networkPropertyTree != null : networkPropertyTree == null || !networkPropertyTree.isLeaf()) {
                    this.network = _other.network;
                }
                PropertyTree propertyTree4 = dependsOnsPropertyTree = _propertyTree == null ? null : _propertyTree.get("dependsOns");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? dependsOnsPropertyTree != null : dependsOnsPropertyTree == null || !dependsOnsPropertyTree.isLeaf()) {
                    if (_other.dependsOns == null) {
                        this.dependsOns = null;
                    } else {
                        this.dependsOns = new ArrayList<Buildable>();
                        for (String _item : _other.dependsOns) {
                            this.dependsOns.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable((Object)_item)));
                        }
                    }
                }
                PropertyTree propertyTree5 = executablesPropertyTree = _propertyTree == null ? null : _propertyTree.get("executables");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? executablesPropertyTree != null : executablesPropertyTree == null || !executablesPropertyTree.isLeaf()) {
                    if (_other.executables == null) {
                        this.executables = null;
                    } else {
                        this.executables = new ArrayList<ExecutionEnvironment.Builder<Builder<_B>>>();
                        for (ExecutionEnvironment _item : _other.executables) {
                            this.executables.add(_item == null ? null : _item.newCopyBuilder(this, executablesPropertyTree, _propertyTreeUse));
                        }
                    }
                }
            }
        }

        @Override
        protected <_P extends DesktopApplication> _P init(_P _product) {
            _product.binarySize = this.binarySize;
            _product.memoryRequirement = this.memoryRequirement;
            _product.network = this.network;
            if (this.dependsOns != null) {
                ArrayList<String> dependsOns = new ArrayList<String>(this.dependsOns.size());
                for (Buildable buildable : this.dependsOns) {
                    dependsOns.add((String)buildable.build());
                }
                _product.dependsOns = dependsOns;
            }
            if (this.executables != null) {
                ArrayList<ExecutionEnvironment> executables = new ArrayList<ExecutionEnvironment>(this.executables.size());
                for (ExecutionEnvironment.Builder builder : this.executables) {
                    executables.add(builder.build());
                }
                _product.executables = executables;
            }
            return super.init(_product);
        }

        public Builder<_B> withBinarySize(Integer binarySize) {
            this.binarySize = binarySize;
            return this;
        }

        public Builder<_B> withMemoryRequirement(String memoryRequirement) {
            this.memoryRequirement = memoryRequirement;
            return this;
        }

        public Builder<_B> withNetwork(NetworkRequirement network) {
            this.network = network;
            return this;
        }

        public Builder<_B> addDependsOns(Iterable<? extends String> dependsOns) {
            if (dependsOns != null) {
                if (this.dependsOns == null) {
                    this.dependsOns = new ArrayList<Buildable>();
                }
                for (String string : dependsOns) {
                    this.dependsOns.add((Buildable)new Buildable.PrimitiveBuildable((Object)string));
                }
            }
            return this;
        }

        public Builder<_B> withDependsOns(Iterable<? extends String> dependsOns) {
            if (this.dependsOns != null) {
                this.dependsOns.clear();
            }
            return this.addDependsOns(dependsOns);
        }

        public Builder<_B> addDependsOns(String ... dependsOns) {
            this.addDependsOns(Arrays.asList(dependsOns));
            return this;
        }

        public Builder<_B> withDependsOns(String ... dependsOns) {
            this.withDependsOns(Arrays.asList(dependsOns));
            return this;
        }

        public Builder<_B> addExecutables(Iterable<? extends ExecutionEnvironment> executables) {
            if (executables != null) {
                if (this.executables == null) {
                    this.executables = new ArrayList<ExecutionEnvironment.Builder<Builder<_B>>>();
                }
                for (ExecutionEnvironment executionEnvironment : executables) {
                    this.executables.add(new ExecutionEnvironment.Builder<Builder>(this, executionEnvironment, false));
                }
            }
            return this;
        }

        public Builder<_B> withExecutables(Iterable<? extends ExecutionEnvironment> executables) {
            if (this.executables != null) {
                this.executables.clear();
            }
            return this.addExecutables(executables);
        }

        public Builder<_B> addExecutables(ExecutionEnvironment ... executables) {
            this.addExecutables(Arrays.asList(executables));
            return this;
        }

        public Builder<_B> withExecutables(ExecutionEnvironment ... executables) {
            this.withExecutables(Arrays.asList(executables));
            return this;
        }

        public ExecutionEnvironment.Builder<? extends Builder<_B>> addExecutables() {
            if (this.executables == null) {
                this.executables = new ArrayList<ExecutionEnvironment.Builder<Builder<_B>>>();
            }
            ExecutionEnvironment.Builder<Builder> executables_Builder = new ExecutionEnvironment.Builder<Builder>(this, null, false);
            this.executables.add(executables_Builder);
            return executables_Builder;
        }

        @Override
        public Builder<_B> withCost(String cost) {
            super.withCost(cost);
            return this;
        }

        @Override
        public Builder<_B> withLicence(String licence) {
            super.withLicence(licence);
            return this;
        }

        @Override
        public Builder<_B> withOpenSource(Boolean openSource) {
            super.withOpenSource(openSource);
            return this;
        }

        @Override
        public Builder<_B> addDataFormats(Iterable<? extends DataFormat> dataFormats) {
            super.addDataFormats(dataFormats);
            return this;
        }

        @Override
        public Builder<_B> addDataFormats(DataFormat ... dataFormats) {
            super.addDataFormats(dataFormats);
            return this;
        }

        @Override
        public Builder<_B> withDataFormats(Iterable<? extends DataFormat> dataFormats) {
            super.withDataFormats(dataFormats);
            return this;
        }

        @Override
        public Builder<_B> withDataFormats(DataFormat ... dataFormats) {
            super.withDataFormats(dataFormats);
            return this;
        }

        @Override
        public Builder<_B> addVoStandards(Iterable<? extends ApplicationCapability> voStandards) {
            super.addVoStandards(voStandards);
            return this;
        }

        @Override
        public Builder<_B> addVoStandards(ApplicationCapability ... voStandards) {
            super.addVoStandards(voStandards);
            return this;
        }

        @Override
        public Builder<_B> withVoStandards(Iterable<? extends ApplicationCapability> voStandards) {
            super.withVoStandards(voStandards);
            return this;
        }

        @Override
        public Builder<_B> withVoStandards(ApplicationCapability ... voStandards) {
            super.withVoStandards(voStandards);
            return this;
        }

        @Override
        public Builder<_B> addSourceLanguages(Iterable<? extends String> sourceLanguages) {
            super.addSourceLanguages(sourceLanguages);
            return this;
        }

        @Override
        public Builder<_B> addSourceLanguages(String ... sourceLanguages) {
            super.addSourceLanguages(sourceLanguages);
            return this;
        }

        @Override
        public Builder<_B> withSourceLanguages(Iterable<? extends String> sourceLanguages) {
            super.withSourceLanguages(sourceLanguages);
            return this;
        }

        @Override
        public Builder<_B> withSourceLanguages(String ... sourceLanguages) {
            super.withSourceLanguages(sourceLanguages);
            return this;
        }

        @Override
        public Builder<_B> withSourceCodeURL(String sourceCodeURL) {
            super.withSourceCodeURL(sourceCodeURL);
            return this;
        }

        @Override
        public Builder<_B> addValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels((Iterable)validationLevels);
            return this;
        }

        @Override
        public Builder<_B> addValidationLevels(Validation ... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels((Iterable)validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Validation ... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withTitle(String title) {
            super.withTitle(title);
            return this;
        }

        @Override
        public Builder<_B> withShortName(String shortName) {
            super.withShortName(shortName);
            return this;
        }

        @Override
        public Builder<_B> withIdentifier(String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        @Override
        public Builder<_B> addAltIdentifiers(Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers((Iterable)altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> addAltIdentifiers(String ... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withAltIdentifiers(Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers((Iterable)altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withAltIdentifiers(String ... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withCuration(Curation curation) {
            super.withCuration(curation);
            return this;
        }

        @Override
        public Curation.Builder<? extends Builder<_B>> withCuration() {
            return super.withCuration();
        }

        @Override
        public Builder<_B> withContent(Content content) {
            super.withContent(content);
            return this;
        }

        @Override
        public Content.Builder<? extends Builder<_B>> withContent() {
            return super.withContent();
        }

        @Override
        public Builder<_B> withCreated(LocalDateTime created) {
            super.withCreated(created);
            return this;
        }

        @Override
        public Builder<_B> withUpdated(LocalDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        @Override
        public Builder<_B> withStatus(String status) {
            super.withStatus(status);
            return this;
        }

        @Override
        public Builder<_B> withVersion(String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public DesktopApplication build() {
            if (this._storedValue == null) {
                return this.init(new DesktopApplication());
            }
            return (DesktopApplication)this._storedValue;
        }

        public Builder<_B> copyOf(DesktopApplication _other) {
            _other.copyTo(this);
            return this;
        }

        public Builder<_B> copyOf(Builder _other) {
            return this.copyOf(_other.build());
        }
    }

    public static class PropInfo {
        public static final transient SinglePropertyInfo<DesktopApplication, Integer> BINARY_SIZE = new SinglePropertyInfo<DesktopApplication, Integer>("binarySize", DesktopApplication.class, Integer.class, false, null, new QName("", "binarySize"), new QName("http://www.w3.org/2001/XMLSchema", "int"), false){

            public Integer get(DesktopApplication _instance_) {
                return _instance_ == null ? null : _instance_.binarySize;
            }

            public void set(DesktopApplication _instance_, Integer _value_) {
                if (_instance_ != null) {
                    _instance_.binarySize = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<DesktopApplication, String> MEMORY_REQUIREMENT = new SinglePropertyInfo<DesktopApplication, String>("memoryRequirement", DesktopApplication.class, String.class, false, null, new QName("", "memoryRequirement"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false){

            public String get(DesktopApplication _instance_) {
                return _instance_ == null ? null : _instance_.memoryRequirement;
            }

            public void set(DesktopApplication _instance_, String _value_) {
                if (_instance_ != null) {
                    _instance_.memoryRequirement = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<DesktopApplication, NetworkRequirement> NETWORK = new SinglePropertyInfo<DesktopApplication, NetworkRequirement>("network", DesktopApplication.class, NetworkRequirement.class, false, null, new QName("", "network"), new QName("http://www.ivoa.net/xml/VOApplication/v1.0rc1", "NetworkRequirement"), false){

            public NetworkRequirement get(DesktopApplication _instance_) {
                return _instance_ == null ? null : _instance_.network;
            }

            public void set(DesktopApplication _instance_, NetworkRequirement _value_) {
                if (_instance_ != null) {
                    _instance_.network = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<DesktopApplication, String> DEPENDS_ONS = new CollectionPropertyInfo<DesktopApplication, String>("dependsOns", DesktopApplication.class, String.class, true, null, new QName("", "dependsOn"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "IdentifierURI"), false){

            public List<String> get(DesktopApplication _instance_) {
                return _instance_ == null ? null : _instance_.dependsOns;
            }

            public void set(DesktopApplication _instance_, List<String> _value_) {
                if (_instance_ != null) {
                    _instance_.dependsOns = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<DesktopApplication, ExecutionEnvironment> EXECUTABLES = new CollectionPropertyInfo<DesktopApplication, ExecutionEnvironment>("executables", DesktopApplication.class, ExecutionEnvironment.class, true, null, new QName("", "executable"), new QName("http://www.ivoa.net/xml/VOApplication/v1.0rc1", "ExecutionEnvironment"), false){

            public List<ExecutionEnvironment> get(DesktopApplication _instance_) {
                return _instance_ == null ? null : _instance_.executables;
            }

            public void set(DesktopApplication _instance_, List<ExecutionEnvironment> _value_) {
                if (_instance_ != null) {
                    _instance_.executables = _value_;
                }
            }
        };
    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?>, TParent>
    extends Application.Selector<TRoot, TParent> {
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> binarySize = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> memoryRequirement = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> network = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> dependsOns = null;
        private ExecutionEnvironment.Selector<TRoot, Selector<TRoot, TParent>> executables = null;

        public Selector(TRoot root, TParent parent, String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            HashMap<String, PropertyTree> products = new HashMap<String, PropertyTree>();
            products.putAll(super.buildChildren());
            if (this.binarySize != null) {
                products.put("binarySize", this.binarySize.init());
            }
            if (this.memoryRequirement != null) {
                products.put("memoryRequirement", this.memoryRequirement.init());
            }
            if (this.network != null) {
                products.put("network", this.network.init());
            }
            if (this.dependsOns != null) {
                products.put("dependsOns", this.dependsOns.init());
            }
            if (this.executables != null) {
                products.put("executables", this.executables.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> binarySize() {
            return this.binarySize == null ? (this.binarySize = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "binarySize")) : this.binarySize;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> memoryRequirement() {
            return this.memoryRequirement == null ? (this.memoryRequirement = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "memoryRequirement")) : this.memoryRequirement;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> network() {
            return this.network == null ? (this.network = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "network")) : this.network;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> dependsOns() {
            return this.dependsOns == null ? (this.dependsOns = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "dependsOns")) : this.dependsOns;
        }

        public ExecutionEnvironment.Selector<TRoot, Selector<TRoot, TParent>> executables() {
            return this.executables == null ? (this.executables = new ExecutionEnvironment.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "executables")) : this.executables;
        }
    }

    public static class Select
    extends Selector<Select, Void> {
        Select() {
            super(null, null, null);
        }

        public static Select _root() {
            return new Select();
        }
    }
}

