/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.resource.dataservice;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.javastro.ivoa.entities.resource.dataservice.ServiceReference;
import org.javastro.ivoa.entities.resource.dataservice.SpatialCoverage;
import org.javastro.ivoa.entities.resource.dataservice.Waveband;
import org.javastro.ivoa.entities.stc.v1.AstroSTCDescriptionType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Coverage", propOrder={"stcResourceProfile", "spatial", "temporals", "spectrals", "footprint", "wavebands", "regionOfRegard"})
public class Coverage
implements Cloneable,
Copyable,
PartialCopyable,
MergeFrom,
ToString {
    @XmlElement(name="STCResourceProfile", namespace="http://www.ivoa.net/xml/STC/stc-v1.30.xsd", nillable=true)
    protected AstroSTCDescriptionType stcResourceProfile;
    protected SpatialCoverage spatial;
    @XmlElement(name="temporal")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="token")
    protected List<String> temporals;
    @XmlElement(name="spectral")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="token")
    protected List<String> spectrals;
    protected ServiceReference footprint;
    @XmlElement(name="waveband")
    @XmlSchemaType(name="token")
    protected List<Waveband> wavebands;
    protected Float regionOfRegard;
    protected transient Modifier __cachedModifier__;

    public Coverage() {
    }

    public Coverage(AstroSTCDescriptionType stcResourceProfile, SpatialCoverage spatial, List<String> temporals, List<String> spectrals, ServiceReference footprint, List<Waveband> wavebands, Float regionOfRegard) {
        this.stcResourceProfile = stcResourceProfile;
        this.spatial = spatial;
        this.temporals = temporals;
        this.spectrals = spectrals;
        this.footprint = footprint;
        this.wavebands = wavebands;
        this.regionOfRegard = regionOfRegard;
    }

    public AstroSTCDescriptionType getSTCResourceProfile() {
        return this.stcResourceProfile;
    }

    public void setSTCResourceProfile(AstroSTCDescriptionType value) {
        this.stcResourceProfile = value;
    }

    public SpatialCoverage getSpatial() {
        return this.spatial;
    }

    public void setSpatial(SpatialCoverage value) {
        this.spatial = value;
    }

    public List<String> getTemporals() {
        if (this.temporals == null) {
            this.temporals = new ArrayList<String>();
        }
        return this.temporals;
    }

    public List<String> getSpectrals() {
        if (this.spectrals == null) {
            this.spectrals = new ArrayList<String>();
        }
        return this.spectrals;
    }

    public ServiceReference getFootprint() {
        return this.footprint;
    }

    public void setFootprint(ServiceReference value) {
        this.footprint = value;
    }

    public List<Waveband> getWavebands() {
        if (this.wavebands == null) {
            this.wavebands = new ArrayList<Waveband>();
        }
        return this.wavebands;
    }

    public Float getRegionOfRegard() {
        return this.regionOfRegard;
    }

    public void setRegionOfRegard(Float value) {
        this.regionOfRegard = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<Waveband> rightWavebands;
        List<String> rightSpectrals;
        List<String> rightTemporals;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Coverage that = (Coverage)object;
        AstroSTCDescriptionType leftSTCResourceProfile = this.getSTCResourceProfile();
        AstroSTCDescriptionType rightSTCResourceProfile = that.getSTCResourceProfile();
        if (this.stcResourceProfile != null) {
            if (that.stcResourceProfile == null) return false;
            if (!leftSTCResourceProfile.equals(rightSTCResourceProfile)) {
                return false;
            }
        } else if (that.stcResourceProfile != null) {
            return false;
        }
        SpatialCoverage leftSpatial = this.getSpatial();
        SpatialCoverage rightSpatial = that.getSpatial();
        if (this.spatial != null) {
            if (that.spatial == null) return false;
            if (!leftSpatial.equals(rightSpatial)) {
                return false;
            }
        } else if (that.spatial != null) {
            return false;
        }
        List<String> leftTemporals = this.temporals != null && !this.temporals.isEmpty() ? this.getTemporals() : null;
        List<String> list = rightTemporals = that.temporals != null && !that.temporals.isEmpty() ? that.getTemporals() : null;
        if (this.temporals != null && !this.temporals.isEmpty()) {
            if (that.temporals == null || that.temporals.isEmpty()) return false;
            if (!leftTemporals.equals(rightTemporals)) {
                return false;
            }
        } else if (that.temporals != null && !that.temporals.isEmpty()) {
            return false;
        }
        List<String> leftSpectrals = this.spectrals != null && !this.spectrals.isEmpty() ? this.getSpectrals() : null;
        List<String> list2 = rightSpectrals = that.spectrals != null && !that.spectrals.isEmpty() ? that.getSpectrals() : null;
        if (this.spectrals != null && !this.spectrals.isEmpty()) {
            if (that.spectrals == null || that.spectrals.isEmpty()) return false;
            if (!leftSpectrals.equals(rightSpectrals)) {
                return false;
            }
        } else if (that.spectrals != null && !that.spectrals.isEmpty()) {
            return false;
        }
        ServiceReference leftFootprint = this.getFootprint();
        ServiceReference rightFootprint = that.getFootprint();
        if (this.footprint != null) {
            if (that.footprint == null) return false;
            if (!leftFootprint.equals(rightFootprint)) {
                return false;
            }
        } else if (that.footprint != null) {
            return false;
        }
        List<Waveband> leftWavebands = this.wavebands != null && !this.wavebands.isEmpty() ? this.getWavebands() : null;
        List<Waveband> list3 = rightWavebands = that.wavebands != null && !that.wavebands.isEmpty() ? that.getWavebands() : null;
        if (this.wavebands != null && !this.wavebands.isEmpty()) {
            if (that.wavebands == null || that.wavebands.isEmpty()) return false;
            if (!leftWavebands.equals(rightWavebands)) {
                return false;
            }
        } else if (that.wavebands != null && !that.wavebands.isEmpty()) {
            return false;
        }
        Float leftRegionOfRegard = this.getRegionOfRegard();
        Float rightRegionOfRegard = that.getRegionOfRegard();
        if (this.regionOfRegard != null) {
            if (that.regionOfRegard == null) return false;
            if (leftRegionOfRegard.equals(rightRegionOfRegard)) return true;
            return false;
        }
        if (that.regionOfRegard == null) return true;
        return false;
    }

    public int hashCode() {
        List<Waveband> theWavebands;
        List<String> theSpectrals;
        List<String> theTemporals;
        int currentHashCode = 1;
        currentHashCode *= 31;
        AstroSTCDescriptionType theSTCResourceProfile = this.getSTCResourceProfile();
        if (this.stcResourceProfile != null) {
            currentHashCode += theSTCResourceProfile.hashCode();
        }
        currentHashCode *= 31;
        SpatialCoverage theSpatial = this.getSpatial();
        if (this.spatial != null) {
            currentHashCode += theSpatial.hashCode();
        }
        currentHashCode *= 31;
        List<String> list = theTemporals = this.temporals != null && !this.temporals.isEmpty() ? this.getTemporals() : null;
        if (this.temporals != null && !this.temporals.isEmpty()) {
            currentHashCode += theTemporals.hashCode();
        }
        currentHashCode *= 31;
        List<String> list2 = theSpectrals = this.spectrals != null && !this.spectrals.isEmpty() ? this.getSpectrals() : null;
        if (this.spectrals != null && !this.spectrals.isEmpty()) {
            currentHashCode += theSpectrals.hashCode();
        }
        currentHashCode *= 31;
        ServiceReference theFootprint = this.getFootprint();
        if (this.footprint != null) {
            currentHashCode += theFootprint.hashCode();
        }
        currentHashCode *= 31;
        List<Waveband> list3 = theWavebands = this.wavebands != null && !this.wavebands.isEmpty() ? this.getWavebands() : null;
        if (this.wavebands != null && !this.wavebands.isEmpty()) {
            currentHashCode += theWavebands.hashCode();
        }
        currentHashCode *= 31;
        Float theRegionOfRegard = this.getRegionOfRegard();
        if (this.regionOfRegard != null) {
            currentHashCode += theRegionOfRegard.hashCode();
        }
        return currentHashCode;
    }

    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        AstroSTCDescriptionType theSTCResourceProfile = this.getSTCResourceProfile();
        strategy.appendField(locator, (Object)this, "stcResourceProfile", buffer, (Object)theSTCResourceProfile, this.stcResourceProfile != null);
        SpatialCoverage theSpatial = this.getSpatial();
        strategy.appendField(locator, (Object)this, "spatial", buffer, (Object)theSpatial, this.spatial != null);
        List<String> theTemporals = this.temporals != null && !this.temporals.isEmpty() ? this.getTemporals() : null;
        strategy.appendField(locator, (Object)this, "temporals", buffer, theTemporals, this.temporals != null && !this.temporals.isEmpty());
        List<String> theSpectrals = this.spectrals != null && !this.spectrals.isEmpty() ? this.getSpectrals() : null;
        strategy.appendField(locator, (Object)this, "spectrals", buffer, theSpectrals, this.spectrals != null && !this.spectrals.isEmpty());
        ServiceReference theFootprint = this.getFootprint();
        strategy.appendField(locator, (Object)this, "footprint", buffer, (Object)theFootprint, this.footprint != null);
        List<Waveband> theWavebands = this.wavebands != null && !this.wavebands.isEmpty() ? this.getWavebands() : null;
        strategy.appendField(locator, (Object)this, "wavebands", buffer, theWavebands, this.wavebands != null && !this.wavebands.isEmpty());
        Float theRegionOfRegard = this.getRegionOfRegard();
        strategy.appendField(locator, (Object)this, "regionOfRegard", buffer, (Object)theRegionOfRegard, this.regionOfRegard != null);
        return buffer;
    }

    public void mergeFrom(Object left, Object right) {
        JAXBMergeStrategy strategy = JAXBMergeStrategy.getInstance();
        this.mergeFrom(null, null, left, right, (MergeStrategy)strategy);
    }

    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Coverage) {
            Coverage target = this;
            Coverage leftObject = (Coverage)left;
            Coverage rightObject = (Coverage)right;
            Boolean stcResourceProfileShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.stcResourceProfile != null, rightObject.stcResourceProfile != null);
            if (stcResourceProfileShouldBeMergedAndSet == Boolean.TRUE) {
                AstroSTCDescriptionType lhsSTCResourceProfile = leftObject.getSTCResourceProfile();
                AstroSTCDescriptionType rhsSTCResourceProfile = rightObject.getSTCResourceProfile();
                AstroSTCDescriptionType mergedSTCResourceProfile = (AstroSTCDescriptionType)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"stcResourceProfile", (Object)lhsSTCResourceProfile), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"stcResourceProfile", (Object)rhsSTCResourceProfile), (Object)lhsSTCResourceProfile, (Object)rhsSTCResourceProfile, leftObject.stcResourceProfile != null, rightObject.stcResourceProfile != null);
                target.setSTCResourceProfile(mergedSTCResourceProfile);
            } else if (stcResourceProfileShouldBeMergedAndSet == Boolean.FALSE) {
                target.stcResourceProfile = null;
            }
            Boolean spatialShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.spatial != null, rightObject.spatial != null);
            if (spatialShouldBeMergedAndSet == Boolean.TRUE) {
                SpatialCoverage lhsSpatial = leftObject.getSpatial();
                SpatialCoverage rhsSpatial = rightObject.getSpatial();
                SpatialCoverage mergedSpatial = (SpatialCoverage)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"spatial", (Object)lhsSpatial), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"spatial", (Object)rhsSpatial), (Object)lhsSpatial, (Object)rhsSpatial, leftObject.spatial != null, rightObject.spatial != null);
                target.setSpatial(mergedSpatial);
            } else if (spatialShouldBeMergedAndSet == Boolean.FALSE) {
                target.spatial = null;
            }
            Boolean temporalsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.temporals != null && !leftObject.temporals.isEmpty(), rightObject.temporals != null && !rightObject.temporals.isEmpty());
            if (temporalsShouldBeMergedAndSet == Boolean.TRUE) {
                List<String> lhsTemporals = leftObject.temporals != null && !leftObject.temporals.isEmpty() ? leftObject.getTemporals() : null;
                List<String> rhsTemporals = rightObject.temporals != null && !rightObject.temporals.isEmpty() ? rightObject.getTemporals() : null;
                List mergedTemporals = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"temporals", lhsTemporals), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"temporals", rhsTemporals), lhsTemporals, rhsTemporals, leftObject.temporals != null && !leftObject.temporals.isEmpty(), rightObject.temporals != null && !rightObject.temporals.isEmpty());
                target.temporals = null;
                if (mergedTemporals != null) {
                    List<String> uniqueTemporalsl = target.getTemporals();
                    uniqueTemporalsl.addAll(mergedTemporals);
                }
            } else if (temporalsShouldBeMergedAndSet == Boolean.FALSE) {
                target.temporals = null;
            }
            Boolean spectralsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.spectrals != null && !leftObject.spectrals.isEmpty(), rightObject.spectrals != null && !rightObject.spectrals.isEmpty());
            if (spectralsShouldBeMergedAndSet == Boolean.TRUE) {
                List<String> lhsSpectrals = leftObject.spectrals != null && !leftObject.spectrals.isEmpty() ? leftObject.getSpectrals() : null;
                List<String> rhsSpectrals = rightObject.spectrals != null && !rightObject.spectrals.isEmpty() ? rightObject.getSpectrals() : null;
                List mergedSpectrals = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"spectrals", lhsSpectrals), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"spectrals", rhsSpectrals), lhsSpectrals, rhsSpectrals, leftObject.spectrals != null && !leftObject.spectrals.isEmpty(), rightObject.spectrals != null && !rightObject.spectrals.isEmpty());
                target.spectrals = null;
                if (mergedSpectrals != null) {
                    List<String> uniqueSpectralsl = target.getSpectrals();
                    uniqueSpectralsl.addAll(mergedSpectrals);
                }
            } else if (spectralsShouldBeMergedAndSet == Boolean.FALSE) {
                target.spectrals = null;
            }
            Boolean footprintShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.footprint != null, rightObject.footprint != null);
            if (footprintShouldBeMergedAndSet == Boolean.TRUE) {
                ServiceReference lhsFootprint = leftObject.getFootprint();
                ServiceReference rhsFootprint = rightObject.getFootprint();
                ServiceReference mergedFootprint = (ServiceReference)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"footprint", (Object)lhsFootprint), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"footprint", (Object)rhsFootprint), (Object)lhsFootprint, (Object)rhsFootprint, leftObject.footprint != null, rightObject.footprint != null);
                target.setFootprint(mergedFootprint);
            } else if (footprintShouldBeMergedAndSet == Boolean.FALSE) {
                target.footprint = null;
            }
            Boolean wavebandsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.wavebands != null && !leftObject.wavebands.isEmpty(), rightObject.wavebands != null && !rightObject.wavebands.isEmpty());
            if (wavebandsShouldBeMergedAndSet == Boolean.TRUE) {
                List<Waveband> lhsWavebands = leftObject.wavebands != null && !leftObject.wavebands.isEmpty() ? leftObject.getWavebands() : null;
                List<Waveband> rhsWavebands = rightObject.wavebands != null && !rightObject.wavebands.isEmpty() ? rightObject.getWavebands() : null;
                List mergedWavebands = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"wavebands", lhsWavebands), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"wavebands", rhsWavebands), lhsWavebands, rhsWavebands, leftObject.wavebands != null && !leftObject.wavebands.isEmpty(), rightObject.wavebands != null && !rightObject.wavebands.isEmpty());
                target.wavebands = null;
                if (mergedWavebands != null) {
                    List<Waveband> uniqueWavebandsl = target.getWavebands();
                    uniqueWavebandsl.addAll(mergedWavebands);
                }
            } else if (wavebandsShouldBeMergedAndSet == Boolean.FALSE) {
                target.wavebands = null;
            }
            Boolean regionOfRegardShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.regionOfRegard != null, rightObject.regionOfRegard != null);
            if (regionOfRegardShouldBeMergedAndSet == Boolean.TRUE) {
                Float lhsRegionOfRegard = leftObject.getRegionOfRegard();
                Float rhsRegionOfRegard = rightObject.getRegionOfRegard();
                Float mergedRegionOfRegard = (Float)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"regionOfRegard", (Object)lhsRegionOfRegard), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"regionOfRegard", (Object)rhsRegionOfRegard), (Object)lhsRegionOfRegard, (Object)rhsRegionOfRegard, leftObject.regionOfRegard != null, rightObject.regionOfRegard != null);
                target.setRegionOfRegard(mergedRegionOfRegard);
            } else if (regionOfRegardShouldBeMergedAndSet == Boolean.FALSE) {
                target.regionOfRegard = null;
            }
        }
    }

    public Object createNewInstance() {
        return new Coverage();
    }

    public Coverage clone() {
        Coverage _newObject;
        try {
            _newObject = (Coverage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.stcResourceProfile = this.stcResourceProfile == null ? null : this.stcResourceProfile.clone();
        _newObject.spatial = this.spatial == null ? null : this.spatial.clone();
        _newObject.temporals = this.temporals == null ? null : new ArrayList<String>(this.temporals);
        _newObject.spectrals = this.spectrals == null ? null : new ArrayList<String>(this.spectrals);
        _newObject.footprint = this.footprint == null ? null : this.footprint.clone();
        _newObject.wavebands = this.wavebands == null ? null : new ArrayList<Waveband>(this.wavebands);
        return _newObject;
    }

    public Coverage createCopy() {
        Coverage _newObject;
        try {
            _newObject = (Coverage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.stcResourceProfile = this.stcResourceProfile == null ? null : this.stcResourceProfile.createCopy();
        _newObject.spatial = this.spatial == null ? null : this.spatial.createCopy();
        _newObject.temporals = this.temporals == null ? null : new ArrayList<String>(this.temporals);
        _newObject.spectrals = this.spectrals == null ? null : new ArrayList<String>(this.spectrals);
        _newObject.footprint = this.footprint == null ? null : this.footprint.createCopy();
        _newObject.wavebands = this.wavebands == null ? null : new ArrayList<Waveband>(this.wavebands);
        _newObject.regionOfRegard = this.regionOfRegard;
        return _newObject;
    }

    public Coverage createCopy(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree regionOfRegardPropertyTree;
        PropertyTree wavebandsPropertyTree;
        PropertyTree footprintPropertyTree;
        PropertyTree spectralsPropertyTree;
        PropertyTree temporalsPropertyTree;
        PropertyTree spatialPropertyTree;
        PropertyTree stcResourceProfilePropertyTree;
        Coverage _newObject;
        try {
            _newObject = (Coverage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        PropertyTree propertyTree = stcResourceProfilePropertyTree = _propertyTree == null ? null : _propertyTree.get("stcResourceProfile");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? stcResourceProfilePropertyTree != null : stcResourceProfilePropertyTree == null || !stcResourceProfilePropertyTree.isLeaf()) {
            _newObject.stcResourceProfile = this.stcResourceProfile == null ? null : this.stcResourceProfile.createCopy(stcResourceProfilePropertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree2 = spatialPropertyTree = _propertyTree == null ? null : _propertyTree.get("spatial");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? spatialPropertyTree != null : spatialPropertyTree == null || !spatialPropertyTree.isLeaf()) {
            _newObject.spatial = this.spatial == null ? null : this.spatial.createCopy(spatialPropertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree3 = temporalsPropertyTree = _propertyTree == null ? null : _propertyTree.get("temporals");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? temporalsPropertyTree != null : temporalsPropertyTree == null || !temporalsPropertyTree.isLeaf()) {
            _newObject.temporals = this.temporals == null ? null : new ArrayList<String>(this.temporals);
        }
        PropertyTree propertyTree4 = spectralsPropertyTree = _propertyTree == null ? null : _propertyTree.get("spectrals");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? spectralsPropertyTree != null : spectralsPropertyTree == null || !spectralsPropertyTree.isLeaf()) {
            _newObject.spectrals = this.spectrals == null ? null : new ArrayList<String>(this.spectrals);
        }
        PropertyTree propertyTree5 = footprintPropertyTree = _propertyTree == null ? null : _propertyTree.get("footprint");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? footprintPropertyTree != null : footprintPropertyTree == null || !footprintPropertyTree.isLeaf()) {
            _newObject.footprint = this.footprint == null ? null : this.footprint.createCopy(footprintPropertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree6 = wavebandsPropertyTree = _propertyTree == null ? null : _propertyTree.get("wavebands");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? wavebandsPropertyTree != null : wavebandsPropertyTree == null || !wavebandsPropertyTree.isLeaf()) {
            _newObject.wavebands = this.wavebands == null ? null : new ArrayList<Waveband>(this.wavebands);
        }
        PropertyTree propertyTree7 = regionOfRegardPropertyTree = _propertyTree == null ? null : _propertyTree.get("regionOfRegard");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? regionOfRegardPropertyTree != null : regionOfRegardPropertyTree == null || !regionOfRegardPropertyTree.isLeaf()) {
            _newObject.regionOfRegard = this.regionOfRegard;
        }
        return _newObject;
    }

    public Coverage copyExcept(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public Coverage copyOnly(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    public Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Modifier();
        }
        return this.__cachedModifier__;
    }

    public <_B> void copyTo(Builder<_B> _other) {
        _other.stcResourceProfile = this.stcResourceProfile == null ? null : this.stcResourceProfile.newCopyBuilder(_other);
        SpatialCoverage.Builder<Builder<Builder<_B>>> builder = _other.spatial = this.spatial == null ? null : this.spatial.newCopyBuilder(_other);
        if (this.temporals == null) {
            _other.temporals = null;
        } else {
            _other.temporals = new ArrayList<Buildable>();
            for (String string : this.temporals) {
                _other.temporals.add((Buildable)(string == null ? null : new Buildable.PrimitiveBuildable((Object)string)));
            }
        }
        if (this.spectrals == null) {
            _other.spectrals = null;
        } else {
            _other.spectrals = new ArrayList<Buildable>();
            for (String string : this.spectrals) {
                _other.spectrals.add((Buildable)(string == null ? null : new Buildable.PrimitiveBuildable((Object)string)));
            }
        }
        ServiceReference.Builder<Builder<Builder<_B>>> builder2 = _other.footprint = this.footprint == null ? null : this.footprint.newCopyBuilder(_other);
        if (this.wavebands == null) {
            _other.wavebands = null;
        } else {
            _other.wavebands = new ArrayList<Buildable>();
            for (Waveband waveband : this.wavebands) {
                _other.wavebands.add((Buildable)(waveband == null ? null : new Buildable.PrimitiveBuildable((Object)waveband)));
            }
        }
        _other.regionOfRegard = this.regionOfRegard;
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder) {
        return new Builder<_B>(_parentBuilder, this, true);
    }

    public Builder<Void> newCopyBuilder() {
        return this.newCopyBuilder(null);
    }

    public static Builder<Void> builder() {
        return new Builder<Object>(null, null, false);
    }

    public static <_B> Builder<_B> copyOf(Coverage _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public <_B> void copyTo(Builder<_B> _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree regionOfRegardPropertyTree;
        PropertyTree wavebandsPropertyTree;
        PropertyTree propertyTree;
        PropertyTree spectralsPropertyTree;
        PropertyTree temporalsPropertyTree;
        PropertyTree spatialPropertyTree;
        PropertyTree stcResourceProfilePropertyTree;
        PropertyTree propertyTree2 = stcResourceProfilePropertyTree = _propertyTree == null ? null : _propertyTree.get("stcResourceProfile");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? stcResourceProfilePropertyTree != null : stcResourceProfilePropertyTree == null || !stcResourceProfilePropertyTree.isLeaf()) {
            _other.stcResourceProfile = this.stcResourceProfile == null ? null : this.stcResourceProfile.newCopyBuilder(_other, stcResourceProfilePropertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree3 = spatialPropertyTree = _propertyTree == null ? null : _propertyTree.get("spatial");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? spatialPropertyTree != null : spatialPropertyTree == null || !spatialPropertyTree.isLeaf()) {
            _other.spatial = this.spatial == null ? null : this.spatial.newCopyBuilder(_other, spatialPropertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree4 = temporalsPropertyTree = _propertyTree == null ? null : _propertyTree.get("temporals");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? temporalsPropertyTree != null : temporalsPropertyTree == null || !temporalsPropertyTree.isLeaf()) {
            if (this.temporals == null) {
                _other.temporals = null;
            } else {
                _other.temporals = new ArrayList<Buildable>();
                for (String string : this.temporals) {
                    _other.temporals.add((Buildable)(string == null ? null : new Buildable.PrimitiveBuildable((Object)string)));
                }
            }
        }
        PropertyTree propertyTree5 = spectralsPropertyTree = _propertyTree == null ? null : _propertyTree.get("spectrals");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? spectralsPropertyTree != null : spectralsPropertyTree == null || !spectralsPropertyTree.isLeaf()) {
            if (this.spectrals == null) {
                _other.spectrals = null;
            } else {
                _other.spectrals = new ArrayList<Buildable>();
                for (String _item : this.spectrals) {
                    _other.spectrals.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable((Object)_item)));
                }
            }
        }
        PropertyTree propertyTree6 = propertyTree = _propertyTree == null ? null : _propertyTree.get("footprint");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
            _other.footprint = this.footprint == null ? null : this.footprint.newCopyBuilder(_other, propertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree7 = wavebandsPropertyTree = _propertyTree == null ? null : _propertyTree.get("wavebands");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? wavebandsPropertyTree != null : wavebandsPropertyTree == null || !wavebandsPropertyTree.isLeaf()) {
            if (this.wavebands == null) {
                _other.wavebands = null;
            } else {
                _other.wavebands = new ArrayList<Buildable>();
                for (Waveband _item : this.wavebands) {
                    _other.wavebands.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable((Object)_item)));
                }
            }
        }
        PropertyTree propertyTree8 = regionOfRegardPropertyTree = _propertyTree == null ? null : _propertyTree.get("regionOfRegard");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? regionOfRegardPropertyTree != null : regionOfRegardPropertyTree == null || !regionOfRegardPropertyTree.isLeaf()) {
            _other.regionOfRegard = this.regionOfRegard;
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return new Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    public Builder<Void> newCopyBuilder(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return this.newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    public static <_B> Builder<_B> copyOf(Coverage _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static Builder<Void> copyExcept(Coverage _other, PropertyTree _propertyTree) {
        return Coverage.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyOnly(Coverage _other, PropertyTree _propertyTree) {
        return Coverage.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public Coverage visit(PropertyVisitor _visitor_) {
        _visitor_.visit((Object)this);
        if (_visitor_.visit(new SingleProperty(PropInfo.STC_RESOURCE_PROFILE, (Object)this)) && this.stcResourceProfile != null) {
            this.stcResourceProfile.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty(PropInfo.SPATIAL, (Object)this)) && this.spatial != null) {
            this.spatial.visit(_visitor_);
        }
        _visitor_.visit(new CollectionProperty(PropInfo.TEMPORALS, (Object)this));
        _visitor_.visit(new CollectionProperty(PropInfo.SPECTRALS, (Object)this));
        if (_visitor_.visit(new SingleProperty(PropInfo.FOOTPRINT, (Object)this)) && this.footprint != null) {
            this.footprint.visit(_visitor_);
        }
        _visitor_.visit(new CollectionProperty(PropInfo.WAVEBANDS, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.REGION_OF_REGARD, (Object)this));
        return this;
    }

    public class Modifier {
        public void setSTCResourceProfile(AstroSTCDescriptionType stcResourceProfile) {
            Coverage.this.setSTCResourceProfile(stcResourceProfile);
        }

        public void setSpatial(SpatialCoverage spatial) {
            Coverage.this.setSpatial(spatial);
        }

        public List<String> getTemporals() {
            if (Coverage.this.temporals == null) {
                Coverage.this.temporals = new ArrayList<String>();
            }
            return Coverage.this.temporals;
        }

        public List<String> getSpectrals() {
            if (Coverage.this.spectrals == null) {
                Coverage.this.spectrals = new ArrayList<String>();
            }
            return Coverage.this.spectrals;
        }

        public void setFootprint(ServiceReference footprint) {
            Coverage.this.setFootprint(footprint);
        }

        public List<Waveband> getWavebands() {
            if (Coverage.this.wavebands == null) {
                Coverage.this.wavebands = new ArrayList<Waveband>();
            }
            return Coverage.this.wavebands;
        }

        public void setRegionOfRegard(Float regionOfRegard) {
            Coverage.this.setRegionOfRegard(regionOfRegard);
        }
    }

    public static class Builder<_B>
    implements Buildable {
        protected final _B _parentBuilder;
        protected final Coverage _storedValue;
        private AstroSTCDescriptionType.Builder<Builder<_B>> stcResourceProfile;
        private SpatialCoverage.Builder<Builder<_B>> spatial;
        private List<Buildable> temporals;
        private List<Buildable> spectrals;
        private ServiceReference.Builder<Builder<_B>> footprint;
        private List<Buildable> wavebands;
        private Float regionOfRegard;

        public Builder(_B _parentBuilder, Coverage _other, boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other != null) {
                if (_copy) {
                    this._storedValue = null;
                    this.stcResourceProfile = _other.stcResourceProfile == null ? null : _other.stcResourceProfile.newCopyBuilder(this);
                    SpatialCoverage.Builder<Builder> builder = this.spatial = _other.spatial == null ? null : _other.spatial.newCopyBuilder(this);
                    if (_other.temporals == null) {
                        this.temporals = null;
                    } else {
                        this.temporals = new ArrayList<Buildable>();
                        for (String string : _other.temporals) {
                            this.temporals.add((Buildable)(string == null ? null : new Buildable.PrimitiveBuildable((Object)string)));
                        }
                    }
                    if (_other.spectrals == null) {
                        this.spectrals = null;
                    } else {
                        this.spectrals = new ArrayList<Buildable>();
                        for (String string : _other.spectrals) {
                            this.spectrals.add((Buildable)(string == null ? null : new Buildable.PrimitiveBuildable((Object)string)));
                        }
                    }
                    ServiceReference.Builder<Builder> builder2 = this.footprint = _other.footprint == null ? null : _other.footprint.newCopyBuilder(this);
                    if (_other.wavebands == null) {
                        this.wavebands = null;
                    } else {
                        this.wavebands = new ArrayList<Buildable>();
                        for (Waveband waveband : _other.wavebands) {
                            this.wavebands.add((Buildable)(waveband == null ? null : new Buildable.PrimitiveBuildable((Object)waveband)));
                        }
                    }
                    this.regionOfRegard = _other.regionOfRegard;
                } else {
                    this._storedValue = _other;
                }
            } else {
                this._storedValue = null;
            }
        }

        public Builder(_B _parentBuilder, Coverage _other, boolean _copy, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other != null) {
                if (_copy) {
                    PropertyTree regionOfRegardPropertyTree;
                    PropertyTree wavebandsPropertyTree;
                    PropertyTree propertyTree;
                    PropertyTree spectralsPropertyTree;
                    PropertyTree temporalsPropertyTree;
                    PropertyTree spatialPropertyTree;
                    PropertyTree stcResourceProfilePropertyTree;
                    this._storedValue = null;
                    PropertyTree propertyTree2 = stcResourceProfilePropertyTree = _propertyTree == null ? null : _propertyTree.get("stcResourceProfile");
                    if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? stcResourceProfilePropertyTree != null : stcResourceProfilePropertyTree == null || !stcResourceProfilePropertyTree.isLeaf()) {
                        this.stcResourceProfile = _other.stcResourceProfile == null ? null : _other.stcResourceProfile.newCopyBuilder(this, stcResourceProfilePropertyTree, _propertyTreeUse);
                    }
                    PropertyTree propertyTree3 = spatialPropertyTree = _propertyTree == null ? null : _propertyTree.get("spatial");
                    if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? spatialPropertyTree != null : spatialPropertyTree == null || !spatialPropertyTree.isLeaf()) {
                        this.spatial = _other.spatial == null ? null : _other.spatial.newCopyBuilder(this, spatialPropertyTree, _propertyTreeUse);
                    }
                    PropertyTree propertyTree4 = temporalsPropertyTree = _propertyTree == null ? null : _propertyTree.get("temporals");
                    if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? temporalsPropertyTree != null : temporalsPropertyTree == null || !temporalsPropertyTree.isLeaf()) {
                        if (_other.temporals == null) {
                            this.temporals = null;
                        } else {
                            this.temporals = new ArrayList<Buildable>();
                            for (String string : _other.temporals) {
                                this.temporals.add((Buildable)(string == null ? null : new Buildable.PrimitiveBuildable((Object)string)));
                            }
                        }
                    }
                    PropertyTree propertyTree5 = spectralsPropertyTree = _propertyTree == null ? null : _propertyTree.get("spectrals");
                    if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? spectralsPropertyTree != null : spectralsPropertyTree == null || !spectralsPropertyTree.isLeaf()) {
                        if (_other.spectrals == null) {
                            this.spectrals = null;
                        } else {
                            this.spectrals = new ArrayList<Buildable>();
                            for (String _item : _other.spectrals) {
                                this.spectrals.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable((Object)_item)));
                            }
                        }
                    }
                    PropertyTree propertyTree6 = propertyTree = _propertyTree == null ? null : _propertyTree.get("footprint");
                    if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
                        this.footprint = _other.footprint == null ? null : _other.footprint.newCopyBuilder(this, propertyTree, _propertyTreeUse);
                    }
                    PropertyTree propertyTree7 = wavebandsPropertyTree = _propertyTree == null ? null : _propertyTree.get("wavebands");
                    if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? wavebandsPropertyTree != null : wavebandsPropertyTree == null || !wavebandsPropertyTree.isLeaf()) {
                        if (_other.wavebands == null) {
                            this.wavebands = null;
                        } else {
                            this.wavebands = new ArrayList<Buildable>();
                            for (Waveband _item : _other.wavebands) {
                                this.wavebands.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable((Object)_item)));
                            }
                        }
                    }
                    PropertyTree propertyTree8 = regionOfRegardPropertyTree = _propertyTree == null ? null : _propertyTree.get("regionOfRegard");
                    if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? regionOfRegardPropertyTree != null : regionOfRegardPropertyTree == null || !regionOfRegardPropertyTree.isLeaf()) {
                        this.regionOfRegard = _other.regionOfRegard;
                    }
                } else {
                    this._storedValue = _other;
                }
            } else {
                this._storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected <_P extends Coverage> _P init(_P _product) {
            _product.stcResourceProfile = this.stcResourceProfile == null ? null : this.stcResourceProfile.build();
            SpatialCoverage spatialCoverage = _product.spatial = this.spatial == null ? null : this.spatial.build();
            if (this.temporals != null) {
                ArrayList<String> temporals = new ArrayList<String>(this.temporals.size());
                for (Buildable _item : this.temporals) {
                    temporals.add((String)_item.build());
                }
                _product.temporals = temporals;
            }
            if (this.spectrals != null) {
                ArrayList<String> spectrals = new ArrayList<String>(this.spectrals.size());
                for (Buildable _item : this.spectrals) {
                    spectrals.add((String)_item.build());
                }
                _product.spectrals = spectrals;
            }
            ServiceReference serviceReference = _product.footprint = this.footprint == null ? null : this.footprint.build();
            if (this.wavebands != null) {
                ArrayList<Waveband> wavebands = new ArrayList<Waveband>(this.wavebands.size());
                for (Buildable _item : this.wavebands) {
                    wavebands.add((Waveband)((Object)_item.build()));
                }
                _product.wavebands = wavebands;
            }
            _product.regionOfRegard = this.regionOfRegard;
            return _product;
        }

        public Builder<_B> withSTCResourceProfile(AstroSTCDescriptionType stcResourceProfile) {
            this.stcResourceProfile = stcResourceProfile == null ? null : new AstroSTCDescriptionType.Builder<Builder>(this, stcResourceProfile, false);
            return this;
        }

        public AstroSTCDescriptionType.Builder<? extends Builder<_B>> withSTCResourceProfile() {
            if (this.stcResourceProfile != null) {
                return this.stcResourceProfile;
            }
            this.stcResourceProfile = new AstroSTCDescriptionType.Builder<Builder>(this, null, false);
            return this.stcResourceProfile;
        }

        public Builder<_B> withSpatial(SpatialCoverage spatial) {
            this.spatial = spatial == null ? null : new SpatialCoverage.Builder<Builder>(this, spatial, false);
            return this;
        }

        public SpatialCoverage.Builder<? extends Builder<_B>> withSpatial() {
            if (this.spatial != null) {
                return this.spatial;
            }
            this.spatial = new SpatialCoverage.Builder<Builder>(this, null, false);
            return this.spatial;
        }

        public Builder<_B> addTemporals(Iterable<? extends String> temporals) {
            if (temporals != null) {
                if (this.temporals == null) {
                    this.temporals = new ArrayList<Buildable>();
                }
                for (String string : temporals) {
                    this.temporals.add((Buildable)new Buildable.PrimitiveBuildable((Object)string));
                }
            }
            return this;
        }

        public Builder<_B> withTemporals(Iterable<? extends String> temporals) {
            if (this.temporals != null) {
                this.temporals.clear();
            }
            return this.addTemporals(temporals);
        }

        public Builder<_B> addTemporals(String ... temporals) {
            this.addTemporals(Arrays.asList(temporals));
            return this;
        }

        public Builder<_B> withTemporals(String ... temporals) {
            this.withTemporals(Arrays.asList(temporals));
            return this;
        }

        public Builder<_B> addSpectrals(Iterable<? extends String> spectrals) {
            if (spectrals != null) {
                if (this.spectrals == null) {
                    this.spectrals = new ArrayList<Buildable>();
                }
                for (String string : spectrals) {
                    this.spectrals.add((Buildable)new Buildable.PrimitiveBuildable((Object)string));
                }
            }
            return this;
        }

        public Builder<_B> withSpectrals(Iterable<? extends String> spectrals) {
            if (this.spectrals != null) {
                this.spectrals.clear();
            }
            return this.addSpectrals(spectrals);
        }

        public Builder<_B> addSpectrals(String ... spectrals) {
            this.addSpectrals(Arrays.asList(spectrals));
            return this;
        }

        public Builder<_B> withSpectrals(String ... spectrals) {
            this.withSpectrals(Arrays.asList(spectrals));
            return this;
        }

        public Builder<_B> withFootprint(ServiceReference footprint) {
            this.footprint = footprint == null ? null : new ServiceReference.Builder<Builder>(this, footprint, false);
            return this;
        }

        public ServiceReference.Builder<? extends Builder<_B>> withFootprint() {
            if (this.footprint != null) {
                return this.footprint;
            }
            this.footprint = new ServiceReference.Builder<Builder>(this, null, false);
            return this.footprint;
        }

        public Builder<_B> addWavebands(Iterable<? extends Waveband> wavebands) {
            if (wavebands != null) {
                if (this.wavebands == null) {
                    this.wavebands = new ArrayList<Buildable>();
                }
                for (Waveband waveband : wavebands) {
                    this.wavebands.add((Buildable)new Buildable.PrimitiveBuildable((Object)waveband));
                }
            }
            return this;
        }

        public Builder<_B> withWavebands(Iterable<? extends Waveband> wavebands) {
            if (this.wavebands != null) {
                this.wavebands.clear();
            }
            return this.addWavebands(wavebands);
        }

        public Builder<_B> addWavebands(Waveband ... wavebands) {
            this.addWavebands(Arrays.asList(wavebands));
            return this;
        }

        public Builder<_B> withWavebands(Waveband ... wavebands) {
            this.withWavebands(Arrays.asList(wavebands));
            return this;
        }

        public Builder<_B> withRegionOfRegard(Float regionOfRegard) {
            this.regionOfRegard = regionOfRegard;
            return this;
        }

        public Coverage build() {
            if (this._storedValue == null) {
                return this.init(new Coverage());
            }
            return this._storedValue;
        }

        public Builder<_B> copyOf(Coverage _other) {
            _other.copyTo(this);
            return this;
        }

        public Builder<_B> copyOf(Builder _other) {
            return this.copyOf(_other.build());
        }
    }

    public static class PropInfo {
        public static final transient SinglePropertyInfo<Coverage, AstroSTCDescriptionType> STC_RESOURCE_PROFILE = new SinglePropertyInfo<Coverage, AstroSTCDescriptionType>("stcResourceProfile", Coverage.class, AstroSTCDescriptionType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "STCResourceProfile"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroSTCDescriptionType"), false){

            public AstroSTCDescriptionType get(Coverage _instance_) {
                return _instance_ == null ? null : _instance_.stcResourceProfile;
            }

            public void set(Coverage _instance_, AstroSTCDescriptionType _value_) {
                if (_instance_ != null) {
                    _instance_.stcResourceProfile = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<Coverage, SpatialCoverage> SPATIAL = new SinglePropertyInfo<Coverage, SpatialCoverage>("spatial", Coverage.class, SpatialCoverage.class, false, null, new QName("", "spatial"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "SpatialCoverage"), false){

            public SpatialCoverage get(Coverage _instance_) {
                return _instance_ == null ? null : _instance_.spatial;
            }

            public void set(Coverage _instance_, SpatialCoverage _value_) {
                if (_instance_ != null) {
                    _instance_.spatial = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<Coverage, String> TEMPORALS = new CollectionPropertyInfo<Coverage, String>("temporals", Coverage.class, String.class, true, null, new QName("", "temporal"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "FloatInterval"), false){

            public List<String> get(Coverage _instance_) {
                return _instance_ == null ? null : _instance_.temporals;
            }

            public void set(Coverage _instance_, List<String> _value_) {
                if (_instance_ != null) {
                    _instance_.temporals = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<Coverage, String> SPECTRALS = new CollectionPropertyInfo<Coverage, String>("spectrals", Coverage.class, String.class, true, null, new QName("", "spectral"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "FloatInterval"), false){

            public List<String> get(Coverage _instance_) {
                return _instance_ == null ? null : _instance_.spectrals;
            }

            public void set(Coverage _instance_, List<String> _value_) {
                if (_instance_ != null) {
                    _instance_.spectrals = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<Coverage, ServiceReference> FOOTPRINT = new SinglePropertyInfo<Coverage, ServiceReference>("footprint", Coverage.class, ServiceReference.class, false, null, new QName("", "footprint"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "ServiceReference"), false){

            public ServiceReference get(Coverage _instance_) {
                return _instance_ == null ? null : _instance_.footprint;
            }

            public void set(Coverage _instance_, ServiceReference _value_) {
                if (_instance_ != null) {
                    _instance_.footprint = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<Coverage, Waveband> WAVEBANDS = new CollectionPropertyInfo<Coverage, Waveband>("wavebands", Coverage.class, Waveband.class, true, null, new QName("", "waveband"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "Waveband"), false){

            public List<Waveband> get(Coverage _instance_) {
                return _instance_ == null ? null : _instance_.wavebands;
            }

            public void set(Coverage _instance_, List<Waveband> _value_) {
                if (_instance_ != null) {
                    _instance_.wavebands = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<Coverage, Float> REGION_OF_REGARD = new SinglePropertyInfo<Coverage, Float>("regionOfRegard", Coverage.class, Float.class, false, null, new QName("", "regionOfRegard"), new QName("http://www.w3.org/2001/XMLSchema", "float"), false){

            public Float get(Coverage _instance_) {
                return _instance_ == null ? null : _instance_.regionOfRegard;
            }

            public void set(Coverage _instance_, Float _value_) {
                if (_instance_ != null) {
                    _instance_.regionOfRegard = _value_;
                }
            }
        };
    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?>, TParent>
    extends com.kscs.util.jaxb.Selector<TRoot, TParent> {
        private AstroSTCDescriptionType.Selector<TRoot, Selector<TRoot, TParent>> stcResourceProfile = null;
        private SpatialCoverage.Selector<TRoot, Selector<TRoot, TParent>> spatial = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> temporals = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> spectrals = null;
        private ServiceReference.Selector<TRoot, Selector<TRoot, TParent>> footprint = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> wavebands = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> regionOfRegard = null;

        public Selector(TRoot root, TParent parent, String propertyName) {
            super(root, parent, propertyName);
        }

        public Map<String, PropertyTree> buildChildren() {
            HashMap<String, PropertyTree> products = new HashMap<String, PropertyTree>();
            products.putAll(super.buildChildren());
            if (this.stcResourceProfile != null) {
                products.put("stcResourceProfile", this.stcResourceProfile.init());
            }
            if (this.spatial != null) {
                products.put("spatial", this.spatial.init());
            }
            if (this.temporals != null) {
                products.put("temporals", this.temporals.init());
            }
            if (this.spectrals != null) {
                products.put("spectrals", this.spectrals.init());
            }
            if (this.footprint != null) {
                products.put("footprint", this.footprint.init());
            }
            if (this.wavebands != null) {
                products.put("wavebands", this.wavebands.init());
            }
            if (this.regionOfRegard != null) {
                products.put("regionOfRegard", this.regionOfRegard.init());
            }
            return products;
        }

        public AstroSTCDescriptionType.Selector<TRoot, Selector<TRoot, TParent>> stcResourceProfile() {
            return this.stcResourceProfile == null ? (this.stcResourceProfile = new AstroSTCDescriptionType.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "stcResourceProfile")) : this.stcResourceProfile;
        }

        public SpatialCoverage.Selector<TRoot, Selector<TRoot, TParent>> spatial() {
            return this.spatial == null ? (this.spatial = new SpatialCoverage.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "spatial")) : this.spatial;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> temporals() {
            return this.temporals == null ? (this.temporals = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "temporals")) : this.temporals;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> spectrals() {
            return this.spectrals == null ? (this.spectrals = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "spectrals")) : this.spectrals;
        }

        public ServiceReference.Selector<TRoot, Selector<TRoot, TParent>> footprint() {
            return this.footprint == null ? (this.footprint = new ServiceReference.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "footprint")) : this.footprint;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> wavebands() {
            return this.wavebands == null ? (this.wavebands = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "wavebands")) : this.wavebands;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> regionOfRegard() {
            return this.regionOfRegard == null ? (this.regionOfRegard = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "regionOfRegard")) : this.regionOfRegard;
        }
    }

    public static class Select
    extends Selector<Select, Void> {
        Select() {
            super(null, null, null);
        }

        public static Select _root() {
            return new Select();
        }
    }
}

