/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.resource.ssap;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.javastro.ivoa.entities.resource.Capability;
import org.javastro.ivoa.entities.resource.ServiceInterface;
import org.javastro.ivoa.entities.resource.Validation;
import org.javastro.ivoa.entities.resource.ssap.ComplianceLevel;
import org.javastro.ivoa.entities.resource.ssap.CreationType;
import org.javastro.ivoa.entities.resource.ssap.DataSource;
import org.javastro.ivoa.entities.resource.ssap.Query;
import org.javastro.ivoa.entities.resource.ssap.SupportedFrame;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SimpleSpectralAccess", propOrder={"complianceLevel", "dataSources", "creationTypes", "supportedFrames", "maxSearchRadius", "maxRecords", "defaultMaxRecords", "maxAperture", "maxFileSize", "testQuery"})
public class SimpleSpectralAccess
extends Capability
implements Cloneable,
Copyable,
PartialCopyable,
MergeFrom,
ToString {
    @XmlElement(required=true)
    @XmlSchemaType(name="token")
    protected ComplianceLevel complianceLevel;
    @XmlElement(name="dataSource", required=true)
    @XmlSchemaType(name="token")
    protected List<DataSource> dataSources;
    @XmlElement(name="creationType", required=true)
    @XmlSchemaType(name="token")
    protected List<CreationType> creationTypes;
    @XmlElement(name="supportedFrame", required=true)
    @XmlSchemaType(name="token")
    protected List<SupportedFrame> supportedFrames;
    protected Double maxSearchRadius;
    @XmlSchemaType(name="positiveInteger")
    protected BigInteger maxRecords;
    @XmlSchemaType(name="positiveInteger")
    protected BigInteger defaultMaxRecords;
    protected Double maxAperture;
    @XmlSchemaType(name="positiveInteger")
    protected BigInteger maxFileSize;
    protected Query testQuery;

    public SimpleSpectralAccess() {
    }

    public SimpleSpectralAccess(List<Validation> validationLevels, String description, List<ServiceInterface> interfaces, String standardID, ComplianceLevel complianceLevel, List<DataSource> dataSources, List<CreationType> creationTypes, List<SupportedFrame> supportedFrames, Double maxSearchRadius, BigInteger maxRecords, BigInteger defaultMaxRecords, Double maxAperture, BigInteger maxFileSize, Query testQuery) {
        super(validationLevels, description, interfaces, standardID);
        this.complianceLevel = complianceLevel;
        this.dataSources = dataSources;
        this.creationTypes = creationTypes;
        this.supportedFrames = supportedFrames;
        this.maxSearchRadius = maxSearchRadius;
        this.maxRecords = maxRecords;
        this.defaultMaxRecords = defaultMaxRecords;
        this.maxAperture = maxAperture;
        this.maxFileSize = maxFileSize;
        this.testQuery = testQuery;
    }

    public ComplianceLevel getComplianceLevel() {
        return this.complianceLevel;
    }

    public void setComplianceLevel(ComplianceLevel value) {
        this.complianceLevel = value;
    }

    public List<DataSource> getDataSources() {
        if (this.dataSources == null) {
            this.dataSources = new ArrayList<DataSource>();
        }
        return this.dataSources;
    }

    public List<CreationType> getCreationTypes() {
        if (this.creationTypes == null) {
            this.creationTypes = new ArrayList<CreationType>();
        }
        return this.creationTypes;
    }

    public List<SupportedFrame> getSupportedFrames() {
        if (this.supportedFrames == null) {
            this.supportedFrames = new ArrayList<SupportedFrame>();
        }
        return this.supportedFrames;
    }

    public Double getMaxSearchRadius() {
        return this.maxSearchRadius;
    }

    public void setMaxSearchRadius(Double value) {
        this.maxSearchRadius = value;
    }

    public BigInteger getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(BigInteger value) {
        this.maxRecords = value;
    }

    public BigInteger getDefaultMaxRecords() {
        return this.defaultMaxRecords;
    }

    public void setDefaultMaxRecords(BigInteger value) {
        this.defaultMaxRecords = value;
    }

    public Double getMaxAperture() {
        return this.maxAperture;
    }

    public void setMaxAperture(Double value) {
        this.maxAperture = value;
    }

    public BigInteger getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(BigInteger value) {
        this.maxFileSize = value;
    }

    public Query getTestQuery() {
        return this.testQuery;
    }

    public void setTestQuery(Query value) {
        this.testQuery = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<SupportedFrame> rightSupportedFrames;
        List<CreationType> rightCreationTypes;
        List<DataSource> rightDataSources;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SimpleSpectralAccess that = (SimpleSpectralAccess)object;
        ComplianceLevel leftComplianceLevel = this.getComplianceLevel();
        ComplianceLevel rightComplianceLevel = that.getComplianceLevel();
        if (this.complianceLevel != null) {
            if (that.complianceLevel == null) return false;
            if (!leftComplianceLevel.equals((Object)rightComplianceLevel)) {
                return false;
            }
        } else if (that.complianceLevel != null) {
            return false;
        }
        List<DataSource> leftDataSources = this.dataSources != null && !this.dataSources.isEmpty() ? this.getDataSources() : null;
        List<DataSource> list = rightDataSources = that.dataSources != null && !that.dataSources.isEmpty() ? that.getDataSources() : null;
        if (this.dataSources != null && !this.dataSources.isEmpty()) {
            if (that.dataSources == null || that.dataSources.isEmpty()) return false;
            if (!leftDataSources.equals(rightDataSources)) {
                return false;
            }
        } else if (that.dataSources != null && !that.dataSources.isEmpty()) {
            return false;
        }
        List<CreationType> leftCreationTypes = this.creationTypes != null && !this.creationTypes.isEmpty() ? this.getCreationTypes() : null;
        List<CreationType> list2 = rightCreationTypes = that.creationTypes != null && !that.creationTypes.isEmpty() ? that.getCreationTypes() : null;
        if (this.creationTypes != null && !this.creationTypes.isEmpty()) {
            if (that.creationTypes == null || that.creationTypes.isEmpty()) return false;
            if (!leftCreationTypes.equals(rightCreationTypes)) {
                return false;
            }
        } else if (that.creationTypes != null && !that.creationTypes.isEmpty()) {
            return false;
        }
        List<SupportedFrame> leftSupportedFrames = this.supportedFrames != null && !this.supportedFrames.isEmpty() ? this.getSupportedFrames() : null;
        List<SupportedFrame> list3 = rightSupportedFrames = that.supportedFrames != null && !that.supportedFrames.isEmpty() ? that.getSupportedFrames() : null;
        if (this.supportedFrames != null && !this.supportedFrames.isEmpty()) {
            if (that.supportedFrames == null || that.supportedFrames.isEmpty()) return false;
            if (!leftSupportedFrames.equals(rightSupportedFrames)) {
                return false;
            }
        } else if (that.supportedFrames != null && !that.supportedFrames.isEmpty()) {
            return false;
        }
        Double leftMaxSearchRadius = this.getMaxSearchRadius();
        Double rightMaxSearchRadius = that.getMaxSearchRadius();
        if (this.maxSearchRadius != null) {
            if (that.maxSearchRadius == null) return false;
            if (!leftMaxSearchRadius.equals(rightMaxSearchRadius)) {
                return false;
            }
        } else if (that.maxSearchRadius != null) {
            return false;
        }
        BigInteger leftMaxRecords = this.getMaxRecords();
        BigInteger rightMaxRecords = that.getMaxRecords();
        if (this.maxRecords != null) {
            if (that.maxRecords == null) return false;
            if (!leftMaxRecords.equals(rightMaxRecords)) {
                return false;
            }
        } else if (that.maxRecords != null) {
            return false;
        }
        BigInteger leftDefaultMaxRecords = this.getDefaultMaxRecords();
        BigInteger rightDefaultMaxRecords = that.getDefaultMaxRecords();
        if (this.defaultMaxRecords != null) {
            if (that.defaultMaxRecords == null) return false;
            if (!leftDefaultMaxRecords.equals(rightDefaultMaxRecords)) {
                return false;
            }
        } else if (that.defaultMaxRecords != null) {
            return false;
        }
        Double leftMaxAperture = this.getMaxAperture();
        Double rightMaxAperture = that.getMaxAperture();
        if (this.maxAperture != null) {
            if (that.maxAperture == null) return false;
            if (!leftMaxAperture.equals(rightMaxAperture)) {
                return false;
            }
        } else if (that.maxAperture != null) {
            return false;
        }
        BigInteger leftMaxFileSize = this.getMaxFileSize();
        BigInteger rightMaxFileSize = that.getMaxFileSize();
        if (this.maxFileSize != null) {
            if (that.maxFileSize == null) return false;
            if (!leftMaxFileSize.equals(rightMaxFileSize)) {
                return false;
            }
        } else if (that.maxFileSize != null) {
            return false;
        }
        Query leftTestQuery = this.getTestQuery();
        Query rightTestQuery = that.getTestQuery();
        if (this.testQuery != null) {
            if (that.testQuery == null) return false;
            if (leftTestQuery.equals(rightTestQuery)) return true;
            return false;
        }
        if (that.testQuery == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<SupportedFrame> theSupportedFrames;
        List<CreationType> theCreationTypes;
        List<DataSource> theDataSources;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        ComplianceLevel theComplianceLevel = this.getComplianceLevel();
        if (this.complianceLevel != null) {
            currentHashCode += theComplianceLevel.hashCode();
        }
        currentHashCode *= 31;
        List<DataSource> list = theDataSources = this.dataSources != null && !this.dataSources.isEmpty() ? this.getDataSources() : null;
        if (this.dataSources != null && !this.dataSources.isEmpty()) {
            currentHashCode += theDataSources.hashCode();
        }
        currentHashCode *= 31;
        List<CreationType> list2 = theCreationTypes = this.creationTypes != null && !this.creationTypes.isEmpty() ? this.getCreationTypes() : null;
        if (this.creationTypes != null && !this.creationTypes.isEmpty()) {
            currentHashCode += theCreationTypes.hashCode();
        }
        currentHashCode *= 31;
        List<SupportedFrame> list3 = theSupportedFrames = this.supportedFrames != null && !this.supportedFrames.isEmpty() ? this.getSupportedFrames() : null;
        if (this.supportedFrames != null && !this.supportedFrames.isEmpty()) {
            currentHashCode += theSupportedFrames.hashCode();
        }
        currentHashCode *= 31;
        Double theMaxSearchRadius = this.getMaxSearchRadius();
        if (this.maxSearchRadius != null) {
            currentHashCode += theMaxSearchRadius.hashCode();
        }
        currentHashCode *= 31;
        BigInteger theMaxRecords = this.getMaxRecords();
        if (this.maxRecords != null) {
            currentHashCode += theMaxRecords.hashCode();
        }
        currentHashCode *= 31;
        BigInteger theDefaultMaxRecords = this.getDefaultMaxRecords();
        if (this.defaultMaxRecords != null) {
            currentHashCode += theDefaultMaxRecords.hashCode();
        }
        currentHashCode *= 31;
        Double theMaxAperture = this.getMaxAperture();
        if (this.maxAperture != null) {
            currentHashCode += theMaxAperture.hashCode();
        }
        currentHashCode *= 31;
        BigInteger theMaxFileSize = this.getMaxFileSize();
        if (this.maxFileSize != null) {
            currentHashCode += theMaxFileSize.hashCode();
        }
        currentHashCode *= 31;
        Query theTestQuery = this.getTestQuery();
        if (this.testQuery != null) {
            currentHashCode += theTestQuery.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        ComplianceLevel theComplianceLevel = this.getComplianceLevel();
        strategy.appendField(locator, (Object)this, "complianceLevel", buffer, (Object)theComplianceLevel, this.complianceLevel != null);
        List<DataSource> theDataSources = this.dataSources != null && !this.dataSources.isEmpty() ? this.getDataSources() : null;
        strategy.appendField(locator, (Object)this, "dataSources", buffer, theDataSources, this.dataSources != null && !this.dataSources.isEmpty());
        List<CreationType> theCreationTypes = this.creationTypes != null && !this.creationTypes.isEmpty() ? this.getCreationTypes() : null;
        strategy.appendField(locator, (Object)this, "creationTypes", buffer, theCreationTypes, this.creationTypes != null && !this.creationTypes.isEmpty());
        List<SupportedFrame> theSupportedFrames = this.supportedFrames != null && !this.supportedFrames.isEmpty() ? this.getSupportedFrames() : null;
        strategy.appendField(locator, (Object)this, "supportedFrames", buffer, theSupportedFrames, this.supportedFrames != null && !this.supportedFrames.isEmpty());
        Double theMaxSearchRadius = this.getMaxSearchRadius();
        strategy.appendField(locator, (Object)this, "maxSearchRadius", buffer, (Object)theMaxSearchRadius, this.maxSearchRadius != null);
        BigInteger theMaxRecords = this.getMaxRecords();
        strategy.appendField(locator, (Object)this, "maxRecords", buffer, (Object)theMaxRecords, this.maxRecords != null);
        BigInteger theDefaultMaxRecords = this.getDefaultMaxRecords();
        strategy.appendField(locator, (Object)this, "defaultMaxRecords", buffer, (Object)theDefaultMaxRecords, this.defaultMaxRecords != null);
        Double theMaxAperture = this.getMaxAperture();
        strategy.appendField(locator, (Object)this, "maxAperture", buffer, (Object)theMaxAperture, this.maxAperture != null);
        BigInteger theMaxFileSize = this.getMaxFileSize();
        strategy.appendField(locator, (Object)this, "maxFileSize", buffer, (Object)theMaxFileSize, this.maxFileSize != null);
        Query theTestQuery = this.getTestQuery();
        strategy.appendField(locator, (Object)this, "testQuery", buffer, (Object)theTestQuery, this.testQuery != null);
        return buffer;
    }

    @Override
    public void mergeFrom(Object left, Object right) {
        JAXBMergeStrategy strategy = JAXBMergeStrategy.getInstance();
        this.mergeFrom(null, null, left, right, (MergeStrategy)strategy);
    }

    @Override
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof SimpleSpectralAccess) {
            SimpleSpectralAccess target = this;
            SimpleSpectralAccess leftObject = (SimpleSpectralAccess)left;
            SimpleSpectralAccess rightObject = (SimpleSpectralAccess)right;
            Boolean complianceLevelShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.complianceLevel != null, rightObject.complianceLevel != null);
            if (complianceLevelShouldBeMergedAndSet == Boolean.TRUE) {
                ComplianceLevel lhsComplianceLevel = leftObject.getComplianceLevel();
                ComplianceLevel rhsComplianceLevel = rightObject.getComplianceLevel();
                ComplianceLevel mergedComplianceLevel = (ComplianceLevel)((Object)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"complianceLevel", (Object)((Object)lhsComplianceLevel)), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"complianceLevel", (Object)((Object)rhsComplianceLevel)), (Object)lhsComplianceLevel, (Object)rhsComplianceLevel, leftObject.complianceLevel != null, rightObject.complianceLevel != null));
                target.setComplianceLevel(mergedComplianceLevel);
            } else if (complianceLevelShouldBeMergedAndSet == Boolean.FALSE) {
                target.complianceLevel = null;
            }
            Boolean dataSourcesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.dataSources != null && !leftObject.dataSources.isEmpty(), rightObject.dataSources != null && !rightObject.dataSources.isEmpty());
            if (dataSourcesShouldBeMergedAndSet == Boolean.TRUE) {
                List<DataSource> lhsDataSources = leftObject.dataSources != null && !leftObject.dataSources.isEmpty() ? leftObject.getDataSources() : null;
                List<DataSource> rhsDataSources = rightObject.dataSources != null && !rightObject.dataSources.isEmpty() ? rightObject.getDataSources() : null;
                List mergedDataSources = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"dataSources", lhsDataSources), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"dataSources", rhsDataSources), lhsDataSources, rhsDataSources, leftObject.dataSources != null && !leftObject.dataSources.isEmpty(), rightObject.dataSources != null && !rightObject.dataSources.isEmpty());
                target.dataSources = null;
                if (mergedDataSources != null) {
                    List<DataSource> uniqueDataSourcesl = target.getDataSources();
                    uniqueDataSourcesl.addAll(mergedDataSources);
                }
            } else if (dataSourcesShouldBeMergedAndSet == Boolean.FALSE) {
                target.dataSources = null;
            }
            Boolean creationTypesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.creationTypes != null && !leftObject.creationTypes.isEmpty(), rightObject.creationTypes != null && !rightObject.creationTypes.isEmpty());
            if (creationTypesShouldBeMergedAndSet == Boolean.TRUE) {
                List<CreationType> lhsCreationTypes = leftObject.creationTypes != null && !leftObject.creationTypes.isEmpty() ? leftObject.getCreationTypes() : null;
                List<CreationType> rhsCreationTypes = rightObject.creationTypes != null && !rightObject.creationTypes.isEmpty() ? rightObject.getCreationTypes() : null;
                List mergedCreationTypes = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"creationTypes", lhsCreationTypes), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"creationTypes", rhsCreationTypes), lhsCreationTypes, rhsCreationTypes, leftObject.creationTypes != null && !leftObject.creationTypes.isEmpty(), rightObject.creationTypes != null && !rightObject.creationTypes.isEmpty());
                target.creationTypes = null;
                if (mergedCreationTypes != null) {
                    List<CreationType> uniqueCreationTypesl = target.getCreationTypes();
                    uniqueCreationTypesl.addAll(mergedCreationTypes);
                }
            } else if (creationTypesShouldBeMergedAndSet == Boolean.FALSE) {
                target.creationTypes = null;
            }
            Boolean supportedFramesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.supportedFrames != null && !leftObject.supportedFrames.isEmpty(), rightObject.supportedFrames != null && !rightObject.supportedFrames.isEmpty());
            if (supportedFramesShouldBeMergedAndSet == Boolean.TRUE) {
                List<SupportedFrame> lhsSupportedFrames = leftObject.supportedFrames != null && !leftObject.supportedFrames.isEmpty() ? leftObject.getSupportedFrames() : null;
                List<SupportedFrame> rhsSupportedFrames = rightObject.supportedFrames != null && !rightObject.supportedFrames.isEmpty() ? rightObject.getSupportedFrames() : null;
                List mergedSupportedFrames = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"supportedFrames", lhsSupportedFrames), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"supportedFrames", rhsSupportedFrames), lhsSupportedFrames, rhsSupportedFrames, leftObject.supportedFrames != null && !leftObject.supportedFrames.isEmpty(), rightObject.supportedFrames != null && !rightObject.supportedFrames.isEmpty());
                target.supportedFrames = null;
                if (mergedSupportedFrames != null) {
                    List<SupportedFrame> uniqueSupportedFramesl = target.getSupportedFrames();
                    uniqueSupportedFramesl.addAll(mergedSupportedFrames);
                }
            } else if (supportedFramesShouldBeMergedAndSet == Boolean.FALSE) {
                target.supportedFrames = null;
            }
            Boolean maxSearchRadiusShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.maxSearchRadius != null, rightObject.maxSearchRadius != null);
            if (maxSearchRadiusShouldBeMergedAndSet == Boolean.TRUE) {
                Double lhsMaxSearchRadius = leftObject.getMaxSearchRadius();
                Double rhsMaxSearchRadius = rightObject.getMaxSearchRadius();
                Double mergedMaxSearchRadius = (Double)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"maxSearchRadius", (Object)lhsMaxSearchRadius), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"maxSearchRadius", (Object)rhsMaxSearchRadius), (Object)lhsMaxSearchRadius, (Object)rhsMaxSearchRadius, leftObject.maxSearchRadius != null, rightObject.maxSearchRadius != null);
                target.setMaxSearchRadius(mergedMaxSearchRadius);
            } else if (maxSearchRadiusShouldBeMergedAndSet == Boolean.FALSE) {
                target.maxSearchRadius = null;
            }
            Boolean maxRecordsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.maxRecords != null, rightObject.maxRecords != null);
            if (maxRecordsShouldBeMergedAndSet == Boolean.TRUE) {
                BigInteger lhsMaxRecords = leftObject.getMaxRecords();
                BigInteger rhsMaxRecords = rightObject.getMaxRecords();
                BigInteger mergedMaxRecords = (BigInteger)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"maxRecords", (Object)lhsMaxRecords), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"maxRecords", (Object)rhsMaxRecords), (Object)lhsMaxRecords, (Object)rhsMaxRecords, leftObject.maxRecords != null, rightObject.maxRecords != null);
                target.setMaxRecords(mergedMaxRecords);
            } else if (maxRecordsShouldBeMergedAndSet == Boolean.FALSE) {
                target.maxRecords = null;
            }
            Boolean defaultMaxRecordsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.defaultMaxRecords != null, rightObject.defaultMaxRecords != null);
            if (defaultMaxRecordsShouldBeMergedAndSet == Boolean.TRUE) {
                BigInteger lhsDefaultMaxRecords = leftObject.getDefaultMaxRecords();
                BigInteger rhsDefaultMaxRecords = rightObject.getDefaultMaxRecords();
                BigInteger mergedDefaultMaxRecords = (BigInteger)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"defaultMaxRecords", (Object)lhsDefaultMaxRecords), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"defaultMaxRecords", (Object)rhsDefaultMaxRecords), (Object)lhsDefaultMaxRecords, (Object)rhsDefaultMaxRecords, leftObject.defaultMaxRecords != null, rightObject.defaultMaxRecords != null);
                target.setDefaultMaxRecords(mergedDefaultMaxRecords);
            } else if (defaultMaxRecordsShouldBeMergedAndSet == Boolean.FALSE) {
                target.defaultMaxRecords = null;
            }
            Boolean maxApertureShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.maxAperture != null, rightObject.maxAperture != null);
            if (maxApertureShouldBeMergedAndSet == Boolean.TRUE) {
                Double lhsMaxAperture = leftObject.getMaxAperture();
                Double rhsMaxAperture = rightObject.getMaxAperture();
                Double mergedMaxAperture = (Double)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"maxAperture", (Object)lhsMaxAperture), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"maxAperture", (Object)rhsMaxAperture), (Object)lhsMaxAperture, (Object)rhsMaxAperture, leftObject.maxAperture != null, rightObject.maxAperture != null);
                target.setMaxAperture(mergedMaxAperture);
            } else if (maxApertureShouldBeMergedAndSet == Boolean.FALSE) {
                target.maxAperture = null;
            }
            Boolean maxFileSizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.maxFileSize != null, rightObject.maxFileSize != null);
            if (maxFileSizeShouldBeMergedAndSet == Boolean.TRUE) {
                BigInteger lhsMaxFileSize = leftObject.getMaxFileSize();
                BigInteger rhsMaxFileSize = rightObject.getMaxFileSize();
                BigInteger mergedMaxFileSize = (BigInteger)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"maxFileSize", (Object)lhsMaxFileSize), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"maxFileSize", (Object)rhsMaxFileSize), (Object)lhsMaxFileSize, (Object)rhsMaxFileSize, leftObject.maxFileSize != null, rightObject.maxFileSize != null);
                target.setMaxFileSize(mergedMaxFileSize);
            } else if (maxFileSizeShouldBeMergedAndSet == Boolean.FALSE) {
                target.maxFileSize = null;
            }
            Boolean testQueryShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.testQuery != null, rightObject.testQuery != null);
            if (testQueryShouldBeMergedAndSet == Boolean.TRUE) {
                Query lhsTestQuery = leftObject.getTestQuery();
                Query rhsTestQuery = rightObject.getTestQuery();
                Query mergedTestQuery = (Query)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"testQuery", (Object)lhsTestQuery), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"testQuery", (Object)rhsTestQuery), (Object)lhsTestQuery, (Object)rhsTestQuery, leftObject.testQuery != null, rightObject.testQuery != null);
                target.setTestQuery(mergedTestQuery);
            } else if (testQueryShouldBeMergedAndSet == Boolean.FALSE) {
                target.testQuery = null;
            }
        }
    }

    @Override
    public Object createNewInstance() {
        return new SimpleSpectralAccess();
    }

    @Override
    public SimpleSpectralAccess clone() {
        SimpleSpectralAccess _newObject = (SimpleSpectralAccess)super.clone();
        _newObject.dataSources = this.dataSources == null ? null : new ArrayList<DataSource>(this.dataSources);
        _newObject.creationTypes = this.creationTypes == null ? null : new ArrayList<CreationType>(this.creationTypes);
        _newObject.supportedFrames = this.supportedFrames == null ? null : new ArrayList<SupportedFrame>(this.supportedFrames);
        _newObject.testQuery = this.testQuery == null ? null : this.testQuery.clone();
        return _newObject;
    }

    @Override
    public SimpleSpectralAccess createCopy() {
        SimpleSpectralAccess _newObject = (SimpleSpectralAccess)super.createCopy();
        _newObject.complianceLevel = this.complianceLevel;
        _newObject.dataSources = this.dataSources == null ? null : new ArrayList<DataSource>(this.dataSources);
        _newObject.creationTypes = this.creationTypes == null ? null : new ArrayList<CreationType>(this.creationTypes);
        _newObject.supportedFrames = this.supportedFrames == null ? null : new ArrayList<SupportedFrame>(this.supportedFrames);
        _newObject.maxSearchRadius = this.maxSearchRadius;
        _newObject.maxRecords = this.maxRecords;
        _newObject.defaultMaxRecords = this.defaultMaxRecords;
        _newObject.maxAperture = this.maxAperture;
        _newObject.maxFileSize = this.maxFileSize;
        _newObject.testQuery = this.testQuery == null ? null : this.testQuery.createCopy();
        return _newObject;
    }

    @Override
    public SimpleSpectralAccess createCopy(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree testQueryPropertyTree;
        PropertyTree maxFileSizePropertyTree;
        PropertyTree maxAperturePropertyTree;
        PropertyTree defaultMaxRecordsPropertyTree;
        PropertyTree maxRecordsPropertyTree;
        PropertyTree maxSearchRadiusPropertyTree;
        PropertyTree supportedFramesPropertyTree;
        PropertyTree creationTypesPropertyTree;
        PropertyTree dataSourcesPropertyTree;
        PropertyTree complianceLevelPropertyTree;
        SimpleSpectralAccess _newObject = (SimpleSpectralAccess)super.createCopy(_propertyTree, _propertyTreeUse);
        PropertyTree propertyTree = complianceLevelPropertyTree = _propertyTree == null ? null : _propertyTree.get("complianceLevel");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? complianceLevelPropertyTree != null : complianceLevelPropertyTree == null || !complianceLevelPropertyTree.isLeaf()) {
            _newObject.complianceLevel = this.complianceLevel;
        }
        PropertyTree propertyTree2 = dataSourcesPropertyTree = _propertyTree == null ? null : _propertyTree.get("dataSources");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? dataSourcesPropertyTree != null : dataSourcesPropertyTree == null || !dataSourcesPropertyTree.isLeaf()) {
            _newObject.dataSources = this.dataSources == null ? null : new ArrayList<DataSource>(this.dataSources);
        }
        PropertyTree propertyTree3 = creationTypesPropertyTree = _propertyTree == null ? null : _propertyTree.get("creationTypes");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? creationTypesPropertyTree != null : creationTypesPropertyTree == null || !creationTypesPropertyTree.isLeaf()) {
            _newObject.creationTypes = this.creationTypes == null ? null : new ArrayList<CreationType>(this.creationTypes);
        }
        PropertyTree propertyTree4 = supportedFramesPropertyTree = _propertyTree == null ? null : _propertyTree.get("supportedFrames");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? supportedFramesPropertyTree != null : supportedFramesPropertyTree == null || !supportedFramesPropertyTree.isLeaf()) {
            _newObject.supportedFrames = this.supportedFrames == null ? null : new ArrayList<SupportedFrame>(this.supportedFrames);
        }
        PropertyTree propertyTree5 = maxSearchRadiusPropertyTree = _propertyTree == null ? null : _propertyTree.get("maxSearchRadius");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxSearchRadiusPropertyTree != null : maxSearchRadiusPropertyTree == null || !maxSearchRadiusPropertyTree.isLeaf()) {
            _newObject.maxSearchRadius = this.maxSearchRadius;
        }
        PropertyTree propertyTree6 = maxRecordsPropertyTree = _propertyTree == null ? null : _propertyTree.get("maxRecords");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxRecordsPropertyTree != null : maxRecordsPropertyTree == null || !maxRecordsPropertyTree.isLeaf()) {
            _newObject.maxRecords = this.maxRecords;
        }
        PropertyTree propertyTree7 = defaultMaxRecordsPropertyTree = _propertyTree == null ? null : _propertyTree.get("defaultMaxRecords");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? defaultMaxRecordsPropertyTree != null : defaultMaxRecordsPropertyTree == null || !defaultMaxRecordsPropertyTree.isLeaf()) {
            _newObject.defaultMaxRecords = this.defaultMaxRecords;
        }
        PropertyTree propertyTree8 = maxAperturePropertyTree = _propertyTree == null ? null : _propertyTree.get("maxAperture");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxAperturePropertyTree != null : maxAperturePropertyTree == null || !maxAperturePropertyTree.isLeaf()) {
            _newObject.maxAperture = this.maxAperture;
        }
        PropertyTree propertyTree9 = maxFileSizePropertyTree = _propertyTree == null ? null : _propertyTree.get("maxFileSize");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxFileSizePropertyTree != null : maxFileSizePropertyTree == null || !maxFileSizePropertyTree.isLeaf()) {
            _newObject.maxFileSize = this.maxFileSize;
        }
        PropertyTree propertyTree10 = testQueryPropertyTree = _propertyTree == null ? null : _propertyTree.get("testQuery");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? testQueryPropertyTree != null : testQueryPropertyTree == null || !testQueryPropertyTree.isLeaf()) {
            _newObject.testQuery = this.testQuery == null ? null : this.testQuery.createCopy(testQueryPropertyTree, _propertyTreeUse);
        }
        return _newObject;
    }

    @Override
    public SimpleSpectralAccess copyExcept(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    public SimpleSpectralAccess copyOnly(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Modifier();
        }
        return (Modifier)this.__cachedModifier__;
    }

    public <_B> void copyTo(Builder<_B> _other) {
        super.copyTo(_other);
        _other.complianceLevel = this.complianceLevel;
        if (this.dataSources == null) {
            _other.dataSources = null;
        } else {
            _other.dataSources = new ArrayList<Buildable>();
            for (DataSource dataSource : this.dataSources) {
                _other.dataSources.add((Buildable)(dataSource == null ? null : new Buildable.PrimitiveBuildable((Object)dataSource)));
            }
        }
        if (this.creationTypes == null) {
            _other.creationTypes = null;
        } else {
            _other.creationTypes = new ArrayList<Buildable>();
            for (CreationType creationType : this.creationTypes) {
                _other.creationTypes.add((Buildable)(creationType == null ? null : new Buildable.PrimitiveBuildable((Object)creationType)));
            }
        }
        if (this.supportedFrames == null) {
            _other.supportedFrames = null;
        } else {
            _other.supportedFrames = new ArrayList<Buildable>();
            for (SupportedFrame supportedFrame : this.supportedFrames) {
                _other.supportedFrames.add((Buildable)(supportedFrame == null ? null : new Buildable.PrimitiveBuildable((Object)supportedFrame)));
            }
        }
        _other.maxSearchRadius = this.maxSearchRadius;
        _other.maxRecords = this.maxRecords;
        _other.defaultMaxRecords = this.defaultMaxRecords;
        _other.maxAperture = this.maxAperture;
        _other.maxFileSize = this.maxFileSize;
        _other.testQuery = this.testQuery == null ? null : this.testQuery.newCopyBuilder(_other);
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder) {
        return new Builder<_B>(_parentBuilder, this, true);
    }

    public Builder<Void> newCopyBuilder() {
        return this.newCopyBuilder((Object)null);
    }

    public static Builder<Void> builder() {
        return new Builder<Object>(null, null, false);
    }

    public static <_B> Builder<_B> copyOf(Capability _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(SimpleSpectralAccess _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public <_B> void copyTo(Builder<_B> _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree testQueryPropertyTree;
        PropertyTree maxFileSizePropertyTree;
        PropertyTree maxAperturePropertyTree;
        PropertyTree defaultMaxRecordsPropertyTree;
        PropertyTree maxRecordsPropertyTree;
        PropertyTree propertyTree;
        PropertyTree propertyTree2;
        PropertyTree creationTypesPropertyTree;
        PropertyTree dataSourcesPropertyTree;
        PropertyTree complianceLevelPropertyTree;
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        PropertyTree propertyTree3 = complianceLevelPropertyTree = _propertyTree == null ? null : _propertyTree.get("complianceLevel");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? complianceLevelPropertyTree != null : complianceLevelPropertyTree == null || !complianceLevelPropertyTree.isLeaf()) {
            _other.complianceLevel = this.complianceLevel;
        }
        PropertyTree propertyTree4 = dataSourcesPropertyTree = _propertyTree == null ? null : _propertyTree.get("dataSources");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? dataSourcesPropertyTree != null : dataSourcesPropertyTree == null || !dataSourcesPropertyTree.isLeaf()) {
            if (this.dataSources == null) {
                _other.dataSources = null;
            } else {
                _other.dataSources = new ArrayList<Buildable>();
                for (DataSource dataSource : this.dataSources) {
                    _other.dataSources.add((Buildable)(dataSource == null ? null : new Buildable.PrimitiveBuildable((Object)dataSource)));
                }
            }
        }
        PropertyTree propertyTree5 = creationTypesPropertyTree = _propertyTree == null ? null : _propertyTree.get("creationTypes");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? creationTypesPropertyTree != null : creationTypesPropertyTree == null || !creationTypesPropertyTree.isLeaf()) {
            if (this.creationTypes == null) {
                _other.creationTypes = null;
            } else {
                _other.creationTypes = new ArrayList<Buildable>();
                for (CreationType creationType : this.creationTypes) {
                    _other.creationTypes.add((Buildable)(creationType == null ? null : new Buildable.PrimitiveBuildable((Object)creationType)));
                }
            }
        }
        PropertyTree propertyTree6 = propertyTree2 = _propertyTree == null ? null : _propertyTree.get("supportedFrames");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree2 != null : propertyTree2 == null || !propertyTree2.isLeaf()) {
            if (this.supportedFrames == null) {
                _other.supportedFrames = null;
            } else {
                _other.supportedFrames = new ArrayList<Buildable>();
                for (SupportedFrame _item : this.supportedFrames) {
                    _other.supportedFrames.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable((Object)_item)));
                }
            }
        }
        PropertyTree propertyTree7 = propertyTree = _propertyTree == null ? null : _propertyTree.get("maxSearchRadius");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
            _other.maxSearchRadius = this.maxSearchRadius;
        }
        PropertyTree propertyTree8 = maxRecordsPropertyTree = _propertyTree == null ? null : _propertyTree.get("maxRecords");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxRecordsPropertyTree != null : maxRecordsPropertyTree == null || !maxRecordsPropertyTree.isLeaf()) {
            _other.maxRecords = this.maxRecords;
        }
        PropertyTree propertyTree9 = defaultMaxRecordsPropertyTree = _propertyTree == null ? null : _propertyTree.get("defaultMaxRecords");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? defaultMaxRecordsPropertyTree != null : defaultMaxRecordsPropertyTree == null || !defaultMaxRecordsPropertyTree.isLeaf()) {
            _other.defaultMaxRecords = this.defaultMaxRecords;
        }
        PropertyTree propertyTree10 = maxAperturePropertyTree = _propertyTree == null ? null : _propertyTree.get("maxAperture");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxAperturePropertyTree != null : maxAperturePropertyTree == null || !maxAperturePropertyTree.isLeaf()) {
            _other.maxAperture = this.maxAperture;
        }
        PropertyTree propertyTree11 = maxFileSizePropertyTree = _propertyTree == null ? null : _propertyTree.get("maxFileSize");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxFileSizePropertyTree != null : maxFileSizePropertyTree == null || !maxFileSizePropertyTree.isLeaf()) {
            _other.maxFileSize = this.maxFileSize;
        }
        PropertyTree propertyTree12 = testQueryPropertyTree = _propertyTree == null ? null : _propertyTree.get("testQuery");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? testQueryPropertyTree != null : testQueryPropertyTree == null || !testQueryPropertyTree.isLeaf()) {
            _other.testQuery = this.testQuery == null ? null : this.testQuery.newCopyBuilder(_other, testQueryPropertyTree, _propertyTreeUse);
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return new Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    public Builder<Void> newCopyBuilder(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return this.newCopyBuilder((Object)null, _propertyTree, _propertyTreeUse);
    }

    public static <_B> Builder<_B> copyOf(Capability _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(SimpleSpectralAccess _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static Builder<Void> copyExcept(Capability _other, PropertyTree _propertyTree) {
        return SimpleSpectralAccess.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(SimpleSpectralAccess _other, PropertyTree _propertyTree) {
        return SimpleSpectralAccess.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyOnly(Capability _other, PropertyTree _propertyTree) {
        return SimpleSpectralAccess.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(SimpleSpectralAccess _other, PropertyTree _propertyTree) {
        return SimpleSpectralAccess.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public SimpleSpectralAccess visit(PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty(PropInfo.COMPLIANCE_LEVEL, (Object)this));
        _visitor_.visit(new CollectionProperty(PropInfo.DATA_SOURCES, (Object)this));
        _visitor_.visit(new CollectionProperty(PropInfo.CREATION_TYPES, (Object)this));
        _visitor_.visit(new CollectionProperty(PropInfo.SUPPORTED_FRAMES, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.MAX_SEARCH_RADIUS, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.MAX_RECORDS, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.DEFAULT_MAX_RECORDS, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.MAX_APERTURE, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.MAX_FILE_SIZE, (Object)this));
        if (_visitor_.visit(new SingleProperty(PropInfo.TEST_QUERY, (Object)this)) && this.testQuery != null) {
            this.testQuery.visit(_visitor_);
        }
        return this;
    }

    public class Modifier
    extends Capability.Modifier {
        public void setComplianceLevel(ComplianceLevel complianceLevel) {
            SimpleSpectralAccess.this.setComplianceLevel(complianceLevel);
        }

        public List<DataSource> getDataSources() {
            if (SimpleSpectralAccess.this.dataSources == null) {
                SimpleSpectralAccess.this.dataSources = new ArrayList<DataSource>();
            }
            return SimpleSpectralAccess.this.dataSources;
        }

        public List<CreationType> getCreationTypes() {
            if (SimpleSpectralAccess.this.creationTypes == null) {
                SimpleSpectralAccess.this.creationTypes = new ArrayList<CreationType>();
            }
            return SimpleSpectralAccess.this.creationTypes;
        }

        public List<SupportedFrame> getSupportedFrames() {
            if (SimpleSpectralAccess.this.supportedFrames == null) {
                SimpleSpectralAccess.this.supportedFrames = new ArrayList<SupportedFrame>();
            }
            return SimpleSpectralAccess.this.supportedFrames;
        }

        public void setMaxSearchRadius(Double maxSearchRadius) {
            SimpleSpectralAccess.this.setMaxSearchRadius(maxSearchRadius);
        }

        public void setMaxRecords(BigInteger maxRecords) {
            SimpleSpectralAccess.this.setMaxRecords(maxRecords);
        }

        public void setDefaultMaxRecords(BigInteger defaultMaxRecords) {
            SimpleSpectralAccess.this.setDefaultMaxRecords(defaultMaxRecords);
        }

        public void setMaxAperture(Double maxAperture) {
            SimpleSpectralAccess.this.setMaxAperture(maxAperture);
        }

        public void setMaxFileSize(BigInteger maxFileSize) {
            SimpleSpectralAccess.this.setMaxFileSize(maxFileSize);
        }

        public void setTestQuery(Query testQuery) {
            SimpleSpectralAccess.this.setTestQuery(testQuery);
        }
    }

    public static class Builder<_B>
    extends Capability.Builder<_B>
    implements Buildable {
        private ComplianceLevel complianceLevel;
        private List<Buildable> dataSources;
        private List<Buildable> creationTypes;
        private List<Buildable> supportedFrames;
        private Double maxSearchRadius;
        private BigInteger maxRecords;
        private BigInteger defaultMaxRecords;
        private Double maxAperture;
        private BigInteger maxFileSize;
        private Query.Builder<Builder<_B>> testQuery;

        public Builder(_B _parentBuilder, SimpleSpectralAccess _other, boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other != null) {
                this.complianceLevel = _other.complianceLevel;
                if (_other.dataSources == null) {
                    this.dataSources = null;
                } else {
                    this.dataSources = new ArrayList<Buildable>();
                    for (DataSource dataSource : _other.dataSources) {
                        this.dataSources.add((Buildable)(dataSource == null ? null : new Buildable.PrimitiveBuildable((Object)dataSource)));
                    }
                }
                if (_other.creationTypes == null) {
                    this.creationTypes = null;
                } else {
                    this.creationTypes = new ArrayList<Buildable>();
                    for (CreationType creationType : _other.creationTypes) {
                        this.creationTypes.add((Buildable)(creationType == null ? null : new Buildable.PrimitiveBuildable((Object)creationType)));
                    }
                }
                if (_other.supportedFrames == null) {
                    this.supportedFrames = null;
                } else {
                    this.supportedFrames = new ArrayList<Buildable>();
                    for (SupportedFrame supportedFrame : _other.supportedFrames) {
                        this.supportedFrames.add((Buildable)(supportedFrame == null ? null : new Buildable.PrimitiveBuildable((Object)supportedFrame)));
                    }
                }
                this.maxSearchRadius = _other.maxSearchRadius;
                this.maxRecords = _other.maxRecords;
                this.defaultMaxRecords = _other.defaultMaxRecords;
                this.maxAperture = _other.maxAperture;
                this.maxFileSize = _other.maxFileSize;
                this.testQuery = _other.testQuery == null ? null : _other.testQuery.newCopyBuilder(this);
            }
        }

        public Builder(_B _parentBuilder, SimpleSpectralAccess _other, boolean _copy, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other != null) {
                PropertyTree testQueryPropertyTree;
                PropertyTree maxFileSizePropertyTree;
                PropertyTree maxAperturePropertyTree;
                PropertyTree defaultMaxRecordsPropertyTree;
                PropertyTree maxRecordsPropertyTree;
                PropertyTree maxSearchRadiusPropertyTree;
                PropertyTree supportedFramesPropertyTree;
                PropertyTree creationTypesPropertyTree;
                PropertyTree dataSourcesPropertyTree;
                PropertyTree complianceLevelPropertyTree;
                PropertyTree propertyTree = complianceLevelPropertyTree = _propertyTree == null ? null : _propertyTree.get("complianceLevel");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? complianceLevelPropertyTree != null : complianceLevelPropertyTree == null || !complianceLevelPropertyTree.isLeaf()) {
                    this.complianceLevel = _other.complianceLevel;
                }
                PropertyTree propertyTree2 = dataSourcesPropertyTree = _propertyTree == null ? null : _propertyTree.get("dataSources");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? dataSourcesPropertyTree != null : dataSourcesPropertyTree == null || !dataSourcesPropertyTree.isLeaf()) {
                    if (_other.dataSources == null) {
                        this.dataSources = null;
                    } else {
                        this.dataSources = new ArrayList<Buildable>();
                        for (Object _item : _other.dataSources) {
                            this.dataSources.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
                PropertyTree propertyTree3 = creationTypesPropertyTree = _propertyTree == null ? null : _propertyTree.get("creationTypes");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? creationTypesPropertyTree != null : creationTypesPropertyTree == null || !creationTypesPropertyTree.isLeaf()) {
                    if (_other.creationTypes == null) {
                        this.creationTypes = null;
                    } else {
                        this.creationTypes = new ArrayList<Buildable>();
                        for (Object _item : _other.creationTypes) {
                            this.creationTypes.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
                PropertyTree propertyTree4 = supportedFramesPropertyTree = _propertyTree == null ? null : _propertyTree.get("supportedFrames");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? supportedFramesPropertyTree != null : supportedFramesPropertyTree == null || !supportedFramesPropertyTree.isLeaf()) {
                    if (_other.supportedFrames == null) {
                        this.supportedFrames = null;
                    } else {
                        this.supportedFrames = new ArrayList<Buildable>();
                        for (SupportedFrame _item : _other.supportedFrames) {
                            this.supportedFrames.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable((Object)_item)));
                        }
                    }
                }
                PropertyTree propertyTree5 = maxSearchRadiusPropertyTree = _propertyTree == null ? null : _propertyTree.get("maxSearchRadius");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxSearchRadiusPropertyTree != null : maxSearchRadiusPropertyTree == null || !maxSearchRadiusPropertyTree.isLeaf()) {
                    this.maxSearchRadius = _other.maxSearchRadius;
                }
                PropertyTree propertyTree6 = maxRecordsPropertyTree = _propertyTree == null ? null : _propertyTree.get("maxRecords");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxRecordsPropertyTree != null : maxRecordsPropertyTree == null || !maxRecordsPropertyTree.isLeaf()) {
                    this.maxRecords = _other.maxRecords;
                }
                PropertyTree propertyTree7 = defaultMaxRecordsPropertyTree = _propertyTree == null ? null : _propertyTree.get("defaultMaxRecords");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? defaultMaxRecordsPropertyTree != null : defaultMaxRecordsPropertyTree == null || !defaultMaxRecordsPropertyTree.isLeaf()) {
                    this.defaultMaxRecords = _other.defaultMaxRecords;
                }
                PropertyTree propertyTree8 = maxAperturePropertyTree = _propertyTree == null ? null : _propertyTree.get("maxAperture");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxAperturePropertyTree != null : maxAperturePropertyTree == null || !maxAperturePropertyTree.isLeaf()) {
                    this.maxAperture = _other.maxAperture;
                }
                PropertyTree propertyTree9 = maxFileSizePropertyTree = _propertyTree == null ? null : _propertyTree.get("maxFileSize");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? maxFileSizePropertyTree != null : maxFileSizePropertyTree == null || !maxFileSizePropertyTree.isLeaf()) {
                    this.maxFileSize = _other.maxFileSize;
                }
                PropertyTree propertyTree10 = testQueryPropertyTree = _propertyTree == null ? null : _propertyTree.get("testQuery");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? testQueryPropertyTree != null : testQueryPropertyTree == null || !testQueryPropertyTree.isLeaf()) {
                    this.testQuery = _other.testQuery == null ? null : _other.testQuery.newCopyBuilder(this, testQueryPropertyTree, _propertyTreeUse);
                }
            }
        }

        @Override
        protected <_P extends SimpleSpectralAccess> _P init(_P _product) {
            _product.complianceLevel = this.complianceLevel;
            if (this.dataSources != null) {
                ArrayList<DataSource> dataSources = new ArrayList<DataSource>(this.dataSources.size());
                for (Buildable _item : this.dataSources) {
                    dataSources.add((DataSource)((Object)_item.build()));
                }
                _product.dataSources = dataSources;
            }
            if (this.creationTypes != null) {
                ArrayList<CreationType> creationTypes = new ArrayList<CreationType>(this.creationTypes.size());
                for (Buildable _item : this.creationTypes) {
                    creationTypes.add((CreationType)((Object)_item.build()));
                }
                _product.creationTypes = creationTypes;
            }
            if (this.supportedFrames != null) {
                ArrayList<SupportedFrame> supportedFrames = new ArrayList<SupportedFrame>(this.supportedFrames.size());
                for (Buildable _item : this.supportedFrames) {
                    supportedFrames.add((SupportedFrame)((Object)_item.build()));
                }
                _product.supportedFrames = supportedFrames;
            }
            _product.maxSearchRadius = this.maxSearchRadius;
            _product.maxRecords = this.maxRecords;
            _product.defaultMaxRecords = this.defaultMaxRecords;
            _product.maxAperture = this.maxAperture;
            _product.maxFileSize = this.maxFileSize;
            _product.testQuery = this.testQuery == null ? null : this.testQuery.build();
            return super.init(_product);
        }

        public Builder<_B> withComplianceLevel(ComplianceLevel complianceLevel) {
            this.complianceLevel = complianceLevel;
            return this;
        }

        public Builder<_B> addDataSources(Iterable<? extends DataSource> dataSources) {
            if (dataSources != null) {
                if (this.dataSources == null) {
                    this.dataSources = new ArrayList<Buildable>();
                }
                for (DataSource dataSource : dataSources) {
                    this.dataSources.add((Buildable)new Buildable.PrimitiveBuildable((Object)dataSource));
                }
            }
            return this;
        }

        public Builder<_B> withDataSources(Iterable<? extends DataSource> dataSources) {
            if (this.dataSources != null) {
                this.dataSources.clear();
            }
            return this.addDataSources(dataSources);
        }

        public Builder<_B> addDataSources(DataSource ... dataSources) {
            this.addDataSources(Arrays.asList(dataSources));
            return this;
        }

        public Builder<_B> withDataSources(DataSource ... dataSources) {
            this.withDataSources(Arrays.asList(dataSources));
            return this;
        }

        public Builder<_B> addCreationTypes(Iterable<? extends CreationType> creationTypes) {
            if (creationTypes != null) {
                if (this.creationTypes == null) {
                    this.creationTypes = new ArrayList<Buildable>();
                }
                for (CreationType creationType : creationTypes) {
                    this.creationTypes.add((Buildable)new Buildable.PrimitiveBuildable((Object)creationType));
                }
            }
            return this;
        }

        public Builder<_B> withCreationTypes(Iterable<? extends CreationType> creationTypes) {
            if (this.creationTypes != null) {
                this.creationTypes.clear();
            }
            return this.addCreationTypes(creationTypes);
        }

        public Builder<_B> addCreationTypes(CreationType ... creationTypes) {
            this.addCreationTypes(Arrays.asList(creationTypes));
            return this;
        }

        public Builder<_B> withCreationTypes(CreationType ... creationTypes) {
            this.withCreationTypes(Arrays.asList(creationTypes));
            return this;
        }

        public Builder<_B> addSupportedFrames(Iterable<? extends SupportedFrame> supportedFrames) {
            if (supportedFrames != null) {
                if (this.supportedFrames == null) {
                    this.supportedFrames = new ArrayList<Buildable>();
                }
                for (SupportedFrame supportedFrame : supportedFrames) {
                    this.supportedFrames.add((Buildable)new Buildable.PrimitiveBuildable((Object)supportedFrame));
                }
            }
            return this;
        }

        public Builder<_B> withSupportedFrames(Iterable<? extends SupportedFrame> supportedFrames) {
            if (this.supportedFrames != null) {
                this.supportedFrames.clear();
            }
            return this.addSupportedFrames(supportedFrames);
        }

        public Builder<_B> addSupportedFrames(SupportedFrame ... supportedFrames) {
            this.addSupportedFrames(Arrays.asList(supportedFrames));
            return this;
        }

        public Builder<_B> withSupportedFrames(SupportedFrame ... supportedFrames) {
            this.withSupportedFrames(Arrays.asList(supportedFrames));
            return this;
        }

        public Builder<_B> withMaxSearchRadius(Double maxSearchRadius) {
            this.maxSearchRadius = maxSearchRadius;
            return this;
        }

        public Builder<_B> withMaxRecords(BigInteger maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public Builder<_B> withDefaultMaxRecords(BigInteger defaultMaxRecords) {
            this.defaultMaxRecords = defaultMaxRecords;
            return this;
        }

        public Builder<_B> withMaxAperture(Double maxAperture) {
            this.maxAperture = maxAperture;
            return this;
        }

        public Builder<_B> withMaxFileSize(BigInteger maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public Builder<_B> withTestQuery(Query testQuery) {
            this.testQuery = testQuery == null ? null : new Query.Builder<Builder>(this, testQuery, false);
            return this;
        }

        public Query.Builder<? extends Builder<_B>> withTestQuery() {
            if (this.testQuery != null) {
                return this.testQuery;
            }
            this.testQuery = new Query.Builder<Builder>(this, null, false);
            return this.testQuery;
        }

        @Override
        public Builder<_B> addValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> addValidationLevels(Validation ... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Validation ... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withDescription(String description) {
            super.withDescription(description);
            return this;
        }

        @Override
        public Builder<_B> addInterfaces(Iterable<? extends ServiceInterface> interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        @Override
        public Builder<_B> addInterfaces(ServiceInterface ... interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        @Override
        public Builder<_B> withInterfaces(Iterable<? extends ServiceInterface> interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        @Override
        public Builder<_B> withInterfaces(ServiceInterface ... interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        @Override
        public Builder<_B> withStandardID(String standardID) {
            super.withStandardID(standardID);
            return this;
        }

        @Override
        public SimpleSpectralAccess build() {
            if (this._storedValue == null) {
                return this.init(new SimpleSpectralAccess());
            }
            return (SimpleSpectralAccess)this._storedValue;
        }

        public Builder<_B> copyOf(SimpleSpectralAccess _other) {
            _other.copyTo(this);
            return this;
        }

        public Builder<_B> copyOf(Builder _other) {
            return this.copyOf(_other.build());
        }
    }

    public static class PropInfo {
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, ComplianceLevel> COMPLIANCE_LEVEL = new SinglePropertyInfo<SimpleSpectralAccess, ComplianceLevel>("complianceLevel", SimpleSpectralAccess.class, ComplianceLevel.class, false, null, new QName("", "complianceLevel"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "ComplianceLevel"), false){

            public ComplianceLevel get(SimpleSpectralAccess _instance_) {
                return _instance_ == null ? null : _instance_.complianceLevel;
            }

            public void set(SimpleSpectralAccess _instance_, ComplianceLevel _value_) {
                if (_instance_ != null) {
                    _instance_.complianceLevel = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<SimpleSpectralAccess, DataSource> DATA_SOURCES = new CollectionPropertyInfo<SimpleSpectralAccess, DataSource>("dataSources", SimpleSpectralAccess.class, DataSource.class, true, null, new QName("", "dataSource"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "DataSource"), false){

            public List<DataSource> get(SimpleSpectralAccess _instance_) {
                return _instance_ == null ? null : _instance_.dataSources;
            }

            public void set(SimpleSpectralAccess _instance_, List<DataSource> _value_) {
                if (_instance_ != null) {
                    _instance_.dataSources = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<SimpleSpectralAccess, CreationType> CREATION_TYPES = new CollectionPropertyInfo<SimpleSpectralAccess, CreationType>("creationTypes", SimpleSpectralAccess.class, CreationType.class, true, null, new QName("", "creationType"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "CreationType"), false){

            public List<CreationType> get(SimpleSpectralAccess _instance_) {
                return _instance_ == null ? null : _instance_.creationTypes;
            }

            public void set(SimpleSpectralAccess _instance_, List<CreationType> _value_) {
                if (_instance_ != null) {
                    _instance_.creationTypes = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<SimpleSpectralAccess, SupportedFrame> SUPPORTED_FRAMES = new CollectionPropertyInfo<SimpleSpectralAccess, SupportedFrame>("supportedFrames", SimpleSpectralAccess.class, SupportedFrame.class, true, null, new QName("", "supportedFrame"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "SupportedFrame"), false){

            public List<SupportedFrame> get(SimpleSpectralAccess _instance_) {
                return _instance_ == null ? null : _instance_.supportedFrames;
            }

            public void set(SimpleSpectralAccess _instance_, List<SupportedFrame> _value_) {
                if (_instance_ != null) {
                    _instance_.supportedFrames = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, Double> MAX_SEARCH_RADIUS = new SinglePropertyInfo<SimpleSpectralAccess, Double>("maxSearchRadius", SimpleSpectralAccess.class, Double.class, false, null, new QName("", "maxSearchRadius"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false){

            public Double get(SimpleSpectralAccess _instance_) {
                return _instance_ == null ? null : _instance_.maxSearchRadius;
            }

            public void set(SimpleSpectralAccess _instance_, Double _value_) {
                if (_instance_ != null) {
                    _instance_.maxSearchRadius = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, BigInteger> MAX_RECORDS = new SinglePropertyInfo<SimpleSpectralAccess, BigInteger>("maxRecords", SimpleSpectralAccess.class, BigInteger.class, false, null, new QName("", "maxRecords"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false){

            public BigInteger get(SimpleSpectralAccess _instance_) {
                return _instance_ == null ? null : _instance_.maxRecords;
            }

            public void set(SimpleSpectralAccess _instance_, BigInteger _value_) {
                if (_instance_ != null) {
                    _instance_.maxRecords = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, BigInteger> DEFAULT_MAX_RECORDS = new SinglePropertyInfo<SimpleSpectralAccess, BigInteger>("defaultMaxRecords", SimpleSpectralAccess.class, BigInteger.class, false, null, new QName("", "defaultMaxRecords"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false){

            public BigInteger get(SimpleSpectralAccess _instance_) {
                return _instance_ == null ? null : _instance_.defaultMaxRecords;
            }

            public void set(SimpleSpectralAccess _instance_, BigInteger _value_) {
                if (_instance_ != null) {
                    _instance_.defaultMaxRecords = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, Double> MAX_APERTURE = new SinglePropertyInfo<SimpleSpectralAccess, Double>("maxAperture", SimpleSpectralAccess.class, Double.class, false, null, new QName("", "maxAperture"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false){

            public Double get(SimpleSpectralAccess _instance_) {
                return _instance_ == null ? null : _instance_.maxAperture;
            }

            public void set(SimpleSpectralAccess _instance_, Double _value_) {
                if (_instance_ != null) {
                    _instance_.maxAperture = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, BigInteger> MAX_FILE_SIZE = new SinglePropertyInfo<SimpleSpectralAccess, BigInteger>("maxFileSize", SimpleSpectralAccess.class, BigInteger.class, false, null, new QName("", "maxFileSize"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false){

            public BigInteger get(SimpleSpectralAccess _instance_) {
                return _instance_ == null ? null : _instance_.maxFileSize;
            }

            public void set(SimpleSpectralAccess _instance_, BigInteger _value_) {
                if (_instance_ != null) {
                    _instance_.maxFileSize = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, Query> TEST_QUERY = new SinglePropertyInfo<SimpleSpectralAccess, Query>("testQuery", SimpleSpectralAccess.class, Query.class, false, null, new QName("", "testQuery"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "Query"), false){

            public Query get(SimpleSpectralAccess _instance_) {
                return _instance_ == null ? null : _instance_.testQuery;
            }

            public void set(SimpleSpectralAccess _instance_, Query _value_) {
                if (_instance_ != null) {
                    _instance_.testQuery = _value_;
                }
            }
        };
    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?>, TParent>
    extends Capability.Selector<TRoot, TParent> {
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> complianceLevel = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> dataSources = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> creationTypes = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> supportedFrames = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> maxSearchRadius = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> maxRecords = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> defaultMaxRecords = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> maxAperture = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> maxFileSize = null;
        private Query.Selector<TRoot, Selector<TRoot, TParent>> testQuery = null;

        public Selector(TRoot root, TParent parent, String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            HashMap<String, PropertyTree> products = new HashMap<String, PropertyTree>();
            products.putAll(super.buildChildren());
            if (this.complianceLevel != null) {
                products.put("complianceLevel", this.complianceLevel.init());
            }
            if (this.dataSources != null) {
                products.put("dataSources", this.dataSources.init());
            }
            if (this.creationTypes != null) {
                products.put("creationTypes", this.creationTypes.init());
            }
            if (this.supportedFrames != null) {
                products.put("supportedFrames", this.supportedFrames.init());
            }
            if (this.maxSearchRadius != null) {
                products.put("maxSearchRadius", this.maxSearchRadius.init());
            }
            if (this.maxRecords != null) {
                products.put("maxRecords", this.maxRecords.init());
            }
            if (this.defaultMaxRecords != null) {
                products.put("defaultMaxRecords", this.defaultMaxRecords.init());
            }
            if (this.maxAperture != null) {
                products.put("maxAperture", this.maxAperture.init());
            }
            if (this.maxFileSize != null) {
                products.put("maxFileSize", this.maxFileSize.init());
            }
            if (this.testQuery != null) {
                products.put("testQuery", this.testQuery.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> complianceLevel() {
            return this.complianceLevel == null ? (this.complianceLevel = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "complianceLevel")) : this.complianceLevel;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> dataSources() {
            return this.dataSources == null ? (this.dataSources = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "dataSources")) : this.dataSources;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> creationTypes() {
            return this.creationTypes == null ? (this.creationTypes = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "creationTypes")) : this.creationTypes;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> supportedFrames() {
            return this.supportedFrames == null ? (this.supportedFrames = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "supportedFrames")) : this.supportedFrames;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> maxSearchRadius() {
            return this.maxSearchRadius == null ? (this.maxSearchRadius = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "maxSearchRadius")) : this.maxSearchRadius;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> maxRecords() {
            return this.maxRecords == null ? (this.maxRecords = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "maxRecords")) : this.maxRecords;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> defaultMaxRecords() {
            return this.defaultMaxRecords == null ? (this.defaultMaxRecords = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "defaultMaxRecords")) : this.defaultMaxRecords;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> maxAperture() {
            return this.maxAperture == null ? (this.maxAperture = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "maxAperture")) : this.maxAperture;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> maxFileSize() {
            return this.maxFileSize == null ? (this.maxFileSize = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "maxFileSize")) : this.maxFileSize;
        }

        public Query.Selector<TRoot, Selector<TRoot, TParent>> testQuery() {
            return this.testQuery == null ? (this.testQuery = new Query.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "testQuery")) : this.testQuery;
        }
    }

    public static class Select
    extends Selector<Select, Void> {
        Select() {
            super(null, null, null);
        }

        public static Select _root() {
            return new Select();
        }
    }
}

