/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.List;
import org.junit.jupiter.api.extension.PreInterruptCallback;
import org.junit.jupiter.engine.extension.DefaultPreInterruptContext;
import org.junit.jupiter.engine.extension.ExtensionContextInternal;
import org.junit.jupiter.engine.extension.PreInterruptCallbackInvocation;
import org.junit.platform.commons.util.UnrecoverableExceptions;

final class PreInterruptCallbackInvocationFactory {
    private PreInterruptCallbackInvocationFactory() {
    }

    static PreInterruptCallbackInvocation create(ExtensionContextInternal extensionContext) {
        List<PreInterruptCallback> callbacks = extensionContext.getExtensions(PreInterruptCallback.class);
        if (callbacks.isEmpty()) {
            return PreInterruptCallbackInvocation.NOOP;
        }
        return (thread, errorHandler) -> {
            DefaultPreInterruptContext preInterruptContext = new DefaultPreInterruptContext(thread);
            for (PreInterruptCallback callback : callbacks) {
                try {
                    callback.beforeThreadInterrupt(preInterruptContext, extensionContext);
                }
                catch (Throwable ex) {
                    UnrecoverableExceptions.rethrowIfUnrecoverable(ex);
                    errorHandler.accept(ex);
                }
            }
        };
    }
}

