/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import org.xmlresolver.ResolvedResource;
import org.xmlresolver.ResolverConstants;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceRequest;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.XMLResolver;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.logging.ResolverLogger;

public class CatalogResolver {
    private final ResolverLogger logger;
    private final XMLResolverConfiguration config;
    private final XMLResolver resolver;

    public CatalogResolver() {
        this(new XMLResolverConfiguration());
    }

    public CatalogResolver(XMLResolverConfiguration config) {
        this.config = config;
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
        this.resolver = new XMLResolver(config);
    }

    public XMLResolverConfiguration getConfiguration() {
        return this.config;
    }

    public ResolvedResource resolveURI(String href, String baseURI) {
        ResourceRequest req = this.resolver.getRequest(href, baseURI);
        ResourceResponse resp = this.resolver.resolve(req);
        if (resp.isResolved()) {
            return new ResolvedResource(resp);
        }
        return null;
    }

    public ResolvedResource resolveEntity(String name, String publicId, String systemId, String baseURI) {
        ResourceRequest req = this.resolver.getRequest(systemId, baseURI);
        req.setEntityName(name);
        req.setPublicId(publicId);
        ResourceResponse resp = this.resolver.resolve(req);
        if (resp.isResolved()) {
            return new ResolvedResource(resp);
        }
        return null;
    }

    public ResolvedResource resolveDoctype(String name, String baseURI) {
        ResourceRequest req = this.resolver.getRequest(baseURI, "https://www.iana.org/assignments/media-types/application/xml-dtd", ResolverConstants.ANY_PURPOSE);
        req.setEntityName(name);
        ResourceResponse resp = this.resolver.resolve(req);
        if (resp.isResolved()) {
            return new ResolvedResource(resp);
        }
        return null;
    }

    public ResolvedResource resolveNamespace(String uri, String baseURI, String nature, String purpose) {
        ResourceRequest req = this.resolver.getRequest(uri, baseURI, nature, purpose);
        req.setAlwaysResolve(false);
        ResourceResponse resp = this.resolver.resolve(req);
        if (resp.isResolved()) {
            return new ResolvedResource(resp);
        }
        return null;
    }
}

