/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceConnection;
import org.xmlresolver.ResourceRequest;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.ResourceResponseImpl;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.spi.SchemeResolver;
import org.xmlresolver.spi.SchemeResolverManager;
import org.xmlresolver.spi.SchemeResolverProvider;
import org.xmlresolver.utils.URIUtils;

public class ResourceAccess {
    protected final ResolverLogger logger;
    final Map<String, ArrayList<SchemeResolver>> schemeResolvers = new HashMap<String, ArrayList<SchemeResolver>>();
    private boolean loadedSPI = false;

    public ResourceAccess(XMLResolverConfiguration config) {
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public ResourceResponse getResource(ResourceRequest request) throws URISyntaxException, IOException {
        URI uri = request.getAbsoluteURI();
        if (uri == null && request.getURI() != null) {
            uri = new URI(request.getURI());
        }
        if (uri == null) {
            throw new NullPointerException("URI must not be null in getResource");
        }
        if (!uri.isAbsolute()) {
            uri = URIUtils.resolve(URIUtils.cwd(), uri.toString());
        }
        ResourceResponse resp = this.getResourceFromURI(request, uri);
        this.logger.log("response", "getResource: " + resp.isResolved() + ": " + resp.getURI(), new Object[0]);
        return resp;
    }

    public ResourceResponse getResource(ResourceResponse response) throws URISyntaxException, IOException {
        URI uri = response.getUnmaskedURI();
        if (uri == null && response.getRequest() != null && (uri = response.getRequest().getAbsoluteURI()) == null && response.getRequest().getURI() != null) {
            uri = new URI(response.getRequest().getURI());
        }
        if (uri == null) {
            throw new NullPointerException("URI must not be null in getResource");
        }
        if (!uri.isAbsolute()) {
            if (response.getRequest().getBaseURI() != null) {
                URI base1 = URIUtils.resolve(URIUtils.cwd(), response.getRequest().getBaseURI());
                uri = base1.resolve(uri.toString());
            } else {
                uri = URIUtils.resolve(URIUtils.cwd(), uri.toString());
            }
        }
        ResourceResponse resp = this.getResourceFromURI(response.getRequest(), uri);
        this.logger.log("response", "getResource: " + resp.isResolved() + ": " + resp.getURI(), new Object[0]);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceResponse getResourceFromURI(ResourceRequest request, URI uri) throws URISyntaxException, IOException {
        switch (uri.getScheme()) {
            case "data": {
                return ResourceAccess.getDataResource(request, uri);
            }
            case "classpath": {
                return ResourceAccess.getClasspathResource(request, uri);
            }
            case "jar": {
                return ResourceAccess.getJarResource(request, uri);
            }
        }
        if (!this.loadedSPI) {
            this.loadedSPI = true;
            Map<String, ArrayList<SchemeResolver>> map = this.schemeResolvers;
            synchronized (map) {
                ServiceLoader<SchemeResolverProvider> loader = ServiceLoader.load(SchemeResolverProvider.class);
                for (SchemeResolverProvider provider : loader) {
                    SchemeResolverManager manager = provider.create();
                    for (String scheme : manager.getKnownSchemes()) {
                        if (!this.schemeResolvers.containsKey(scheme)) {
                            this.schemeResolvers.put(scheme, new ArrayList());
                        }
                        try {
                            this.schemeResolvers.get(scheme).add(manager.getSchemeResolver(scheme));
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        String scheme = uri.getScheme();
        Map<String, ArrayList<SchemeResolver>> map = this.schemeResolvers;
        synchronized (map) {
            for (SchemeResolver schemeResolver : this.schemeResolvers.computeIfAbsent(scheme, k -> new ArrayList())) {
                ResourceResponse resp = schemeResolver.getResource(request, uri);
                if (resp == null) continue;
                return resp;
            }
        }
        return ResourceAccess.getNetResource(request, uri);
    }

    private static ResourceResponse getDataResource(ResourceRequest request, URI resourceURI) throws URISyntaxException {
        ByteArrayInputStream inputStream = null;
        String contentType = null;
        String path = resourceURI.toString().substring(5);
        int pos = path.indexOf(",");
        if (pos >= 0) {
            String mediatype = path.substring(0, pos);
            String data = path.substring(pos + 1);
            if (mediatype.endsWith(";base64")) {
                inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
                contentType = mediatype.substring(0, mediatype.length() - 7);
            } else {
                String charset = "UTF-8";
                pos = mediatype.indexOf(";charset=");
                if (pos > 0 && (pos = (charset = mediatype.substring(pos + 9)).indexOf(";")) >= 0) {
                    charset = charset.substring(0, pos);
                }
                try {
                    data = URLDecoder.decode(data, charset);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IllegalArgumentException(ex);
                }
                inputStream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
                contentType = mediatype.isEmpty() ? null : mediatype;
            }
            ResourceResponseImpl resp = new ResourceResponseImpl(request, resourceURI);
            resp.setInputStream(inputStream);
            resp.setContentType(contentType);
            return resp;
        }
        boolean throwExceptions = request.getConfiguration().getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
        ResolverLogger logger = request.getConfiguration().getFeature(ResolverFeature.RESOLVER_LOGGER);
        logger.log("request", "Comma separator missing in data: URI", new Object[0]);
        if (throwExceptions) {
            throw new URISyntaxException(resourceURI.toString(), "Comma separator missing in data: URI");
        }
        return new ResourceResponseImpl(request);
    }

    private static ResourceResponse getClasspathResource(ResourceRequest request, URI resourceURI) {
        URL rsrc;
        String path = resourceURI.getSchemeSpecificPart();
        if (path.startsWith("/")) {
            path = path.substring(1);
            resourceURI = URI.create("classpath:" + path);
        }
        if ((rsrc = request.getConfiguration().getFeature(ResolverFeature.CLASSLOADER).getResource(path)) == null) {
            return new ResourceResponseImpl(request);
        }
        try {
            ResourceResponseImpl resp = new ResourceResponseImpl(request, resourceURI);
            resp.setInputStream(rsrc.openStream());
            return resp;
        }
        catch (IOException ex) {
            boolean throwExceptions = request.getConfiguration().getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
            ResolverLogger logger = request.getConfiguration().getFeature(ResolverFeature.RESOLVER_LOGGER);
            logger.log("request", "I/O error reading %s", resourceURI.toString());
            if (throwExceptions) {
                throw new IllegalArgumentException("I/O error reading " + resourceURI);
            }
            return new ResourceResponseImpl(request);
        }
    }

    private static ResourceResponse getJarResource(ResourceRequest request, URI resourceURI) {
        try {
            ResourceResponseImpl resp = new ResourceResponseImpl(request, resourceURI);
            JarURLConnection conn = (JarURLConnection)resourceURI.toURL().openConnection();
            resp.setUri(request.getAbsoluteURI());
            resp.setInputStream(conn.getInputStream());
            resp.setEncoding(conn.getContentEncoding());
            resp.setContentType(conn.getContentType());
            return resp;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IOException ex) {
            boolean throwExceptions = request.getConfiguration().getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
            ResolverLogger logger = request.getConfiguration().getFeature(ResolverFeature.RESOLVER_LOGGER);
            logger.log("request", "I/O error reading %s", resourceURI.toString());
            if (throwExceptions) {
                throw new IllegalArgumentException("I/O error reading " + resourceURI);
            }
            return new ResourceResponseImpl(request);
        }
    }

    private static ResourceResponse getNetResource(ResourceRequest request, URI resourceURI) {
        ResolverConfiguration config = request.getConfiguration();
        ResolverLogger logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
        boolean mergeHttps = config.getFeature(ResolverFeature.MERGE_HTTPS);
        String accessList = request.isResolvingAsEntity() ? config.getFeature(ResolverFeature.ACCESS_EXTERNAL_ENTITY) : config.getFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT);
        if (URIUtils.forbidAccess(accessList.concat(",file"), resourceURI.toString(), mergeHttps)) {
            if (request.isResolvingAsEntity()) {
                logger.log("request", "resolveEntity, access denied: " + resourceURI, new Object[0]);
                throw new IllegalArgumentException("resolveEntity, access denied: " + resourceURI);
            }
            logger.log("request", "resolveURI, access denied: " + resourceURI, new Object[0]);
            throw new IllegalArgumentException("resolveURI, access denied: " + resourceURI);
        }
        ResourceConnection connx = new ResourceConnection(resourceURI);
        connx.get(request.getConfiguration(), !request.isOpenStream());
        URI redirect = connx.getRedirect();
        URI uri = redirect == null ? resourceURI : redirect;
        ResourceResponseImpl resp = new ResourceResponseImpl(request, uri);
        resp.setResolved(connx.isConnected());
        resp.setResolvedURI(uri);
        resp.setConnection(connx);
        resp.setInputStream(connx.getStream());
        resp.setHeaders(connx.getHeaders());
        resp.setContentType(connx.getContentType());
        resp.setEncoding(connx.getEncoding());
        resp.setStatusCode(connx.getStatusCode());
        if (connx.getStatusCode() >= 400) {
            resp.setResolved(false);
        }
        return resp;
    }
}

