/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.net.URI;
import java.net.URISyntaxException;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverConstants;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceRequest;
import org.xmlresolver.utils.URIUtils;

public class ResourceRequestImpl
implements ResourceRequest {
    private final ResolverConfiguration config;
    private final String nature;
    private final String purpose;
    private String uri = null;
    private String baseURI = null;
    private String entityName = null;
    private String publicId = null;
    private String encoding = null;
    private boolean openStream = true;
    private boolean resolveAsEntity = false;
    private boolean alwaysResolve = false;

    public ResourceRequestImpl(ResolverConfiguration config) {
        this(config, ResolverConstants.ANY_NATURE, ResolverConstants.ANY_PURPOSE);
    }

    public ResourceRequestImpl(ResolverConfiguration config, String nature, String purpose) {
        this.config = config;
        this.nature = nature;
        this.purpose = purpose;
        this.resolveAsEntity = "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity".equals(nature) || "https://www.iana.org/assignments/media-types/application/xml-dtd".equals(nature);
        this.alwaysResolve = config.getFeature(ResolverFeature.ALWAYS_RESOLVE);
    }

    @Override
    public ResolverConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void setAlwaysResolve(boolean always) {
        this.alwaysResolve = always;
    }

    @Override
    public boolean isAlwaysResolve() {
        return this.alwaysResolve;
    }

    @Override
    public String getNature() {
        return this.nature;
    }

    @Override
    public String getPurpose() {
        return this.purpose;
    }

    @Override
    public void setURI(String uri) {
        if (uri != null) {
            this.uri = this.config.getFeature(ResolverFeature.FIX_WINDOWS_SYSTEM_IDENTIFIERS) != false ? URIUtils.windowsPathURI(uri) : uri;
        }
    }

    @Override
    public void setURI(URI uri) {
        this.uri = uri.toString();
    }

    @Override
    public void setBaseURI(String baseURI) {
        if (baseURI != null) {
            this.baseURI = this.config.getFeature(ResolverFeature.FIX_WINDOWS_SYSTEM_IDENTIFIERS) != false ? URIUtils.windowsPathURI(baseURI) : baseURI;
        }
    }

    @Override
    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI.toString();
    }

    @Override
    public void setEntityName(String name) {
        this.entityName = name;
        this.resolveAsEntity = true;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public URI getAbsoluteURI() throws URISyntaxException {
        URI abs;
        if (this.baseURI != null && (abs = new URI(this.baseURI)).isAbsolute()) {
            if (this.uri == null || this.uri.isEmpty()) {
                return abs;
            }
            return URIUtils.resolve(abs, this.uri);
        }
        if (this.uri != null && (abs = new URI(this.uri)).isAbsolute()) {
            return abs;
        }
        return null;
    }

    @Override
    public String getSystemId() {
        return this.uri;
    }

    @Override
    public void setPublicId(String publicId) {
        this.publicId = publicId;
        this.resolveAsEntity = true;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public boolean isResolvingAsEntity() {
        return this.resolveAsEntity;
    }

    @Override
    public void setResolvingAsEntity(boolean asEntity) {
        this.resolveAsEntity = asEntity;
    }

    @Override
    public void setOpenStream(boolean open) {
        this.openStream = open;
    }

    @Override
    public boolean isOpenStream() {
        return this.openStream;
    }

    public String toString() {
        String str = this.entityName == null ? "" : this.entityName + ": ";
        str = str + this.uri;
        if (this.baseURI != null) {
            str = str + " (" + this.baseURI + ")";
        }
        return str;
    }
}

