/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceConnection;
import org.xmlresolver.ResourceRequest;
import org.xmlresolver.ResourceResponse;

public class ResourceResponseImpl
implements ResourceResponse {
    private final ResourceRequest request;
    private URI uri;
    private URI resolvedURI;
    private boolean rejected = false;
    private boolean resolved = false;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private InputStream stream = null;
    private String contentType = null;
    private String encoding = null;
    private int statusCode = -1;
    private ResourceConnection connection = null;

    @Override
    public ResourceRequest getRequest() {
        return this.request;
    }

    public ResourceResponseImpl(ResourceRequest request) {
        this(request, false);
    }

    public ResourceResponseImpl(ResourceRequest request, boolean rejected) {
        this.request = request;
        this.rejected = rejected;
        this.uri = null;
        this.resolvedURI = null;
        this.resolved = false;
    }

    public ResourceResponseImpl(ResourceRequest request, URI uri) {
        this.request = request;
        this.rejected = false;
        this.uri = uri;
        this.resolvedURI = uri;
        this.resolved = false;
        if (uri != null) {
            if (("jar".equals(uri.getScheme()) || "classpath".equals(uri.getScheme())) && request.getConfiguration().getFeature(ResolverFeature.MASK_JAR_URIS).booleanValue()) {
                try {
                    this.uri = request.getAbsoluteURI();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            this.resolved = true;
        }
    }

    public void setConnection(ResourceConnection conn) {
        this.connection = conn;
    }

    @Override
    public ResourceConnection getConnection() {
        return this.connection;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setInputStream(InputStream stream) {
        this.stream = stream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stream;
    }

    public void setRejected(boolean rejected) {
        this.rejected = rejected;
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void setResolvedURI(URI uri) {
        this.resolvedURI = uri;
    }

    @Override
    public URI getResolvedURI() {
        if (this.resolvedURI != null && (this.resolvedURI.getScheme().equals("jar") || this.resolvedURI.getScheme().equals("classpath")) && this.request.getConfiguration().getFeature(ResolverFeature.MASK_JAR_URIS).booleanValue()) {
            return this.uri;
        }
        return this.resolvedURI;
    }

    @Override
    public URI getUnmaskedURI() {
        return this.resolvedURI;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        for (String key : this.headers.keySet()) {
            if ((name != null || key != null) && (name == null || !name.equals(key.toLowerCase()))) continue;
            List<String> value = this.headers.get(key);
            if (value == null || value.isEmpty()) {
                return null;
            }
            return value.get(0);
        }
        return null;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }
}

