/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.adapters;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.xerces.impl.XMLEntityDescription;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.util.SAXInputSource;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLDTDDescription;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.InputSource;
import org.xmlresolver.ResolverConstants;
import org.xmlresolver.ResourceRequest;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.XMLResolver;
import org.xmlresolver.sources.ResolverInputSource;

public class XercesXniAdapter
implements XMLEntityResolver {
    private final XMLResolver resolver;

    public XercesXniAdapter(XMLResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException();
        }
        this.resolver = resolver;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resId) throws XNIException, IOException {
        if (resId instanceof XMLDTDDescription) {
            return this.resolveDTD((XMLDTDDescription)resId);
        }
        if (resId instanceof XMLEntityDescription) {
            return this.resolveEntity((XMLEntityDescription)resId);
        }
        if (resId instanceof XSDDescription) {
            return this.resolveSchema((XSDDescription)resId);
        }
        String publicId = resId.getPublicId();
        String systemId = resId.getLiteralSystemId();
        String baseURI = resId.getBaseSystemId();
        String namespace = resId.getNamespace();
        ResourceRequest request = null;
        ResourceResponse rsrc = null;
        if (namespace == null) {
            request = this.resolver.getRequest(systemId, baseURI, "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity", ResolverConstants.ANY_PURPOSE);
            request.setPublicId(publicId);
            rsrc = this.resolver.resolve(request);
            if (!rsrc.isResolved()) {
                request = this.resolver.getRequest(resId.getExpandedSystemId(), baseURI, "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity", ResolverConstants.ANY_PURPOSE);
                request.setPublicId(publicId);
                rsrc = this.resolver.resolve(request);
            }
        }
        if (rsrc == null || !rsrc.isResolved()) {
            request = this.resolver.getRequest(namespace, resId.getBaseSystemId(), "http://www.w3.org/2001/XMLSchema", "http://www.rddl.org/purposes#schema-validation");
            rsrc = this.resolver.resolve(request);
        }
        if (rsrc == null || !rsrc.isResolved()) {
            request = this.resolver.getRequest(systemId, baseURI, ResolverConstants.ANY_NATURE, ResolverConstants.ANY_PURPOSE);
            request.setResolvingAsEntity(true);
            rsrc = this.safeOpenConnection(request);
        }
        SAXInputSource source = null;
        if (rsrc != null && rsrc.isResolved()) {
            source = new SAXInputSource((InputSource)new ResolverInputSource(rsrc));
        }
        return source;
    }

    private ResourceResponse safeOpenConnection(ResourceRequest request) {
        if (request.isAlwaysResolve()) {
            try {
                return this.resolver.getConfiguration().getResource(request);
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private XMLInputSource resolveDTD(XMLDTDDescription resId) {
        ResourceRequest request = this.resolver.getRequest(resId.getLiteralSystemId(), resId.getBaseSystemId(), "https://www.iana.org/assignments/media-types/application/xml-dtd", "http://www.rddl.org/purposes#validation");
        request.setEntityName(resId.getRootName());
        request.setPublicId(resId.getPublicId());
        ResourceResponse rsrc = this.resolver.resolve(request);
        if (!rsrc.isResolved()) {
            ResourceRequest altRequest = this.resolver.getRequest(resId.getExpandedSystemId(), resId.getBaseSystemId(), "https://www.iana.org/assignments/media-types/application/xml-dtd", "http://www.rddl.org/purposes#validation");
            altRequest.setEntityName(resId.getRootName());
            altRequest.setPublicId(resId.getPublicId());
            rsrc = this.resolver.resolve(altRequest);
        }
        if (!rsrc.isResolved()) {
            rsrc = this.safeOpenConnection(request);
        }
        SAXInputSource source = null;
        if (rsrc != null && rsrc.isResolved()) {
            source = new SAXInputSource((InputSource)new ResolverInputSource(rsrc));
        }
        return source;
    }

    private XMLInputSource resolveEntity(XMLEntityDescription resId) {
        String name = resId.getEntityName();
        if (name.startsWith("%") || name.startsWith("&")) {
            name = name.substring(1);
        }
        ResourceRequest request = this.resolver.getRequest(resId.getLiteralSystemId(), resId.getBaseSystemId(), "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity", ResolverConstants.ANY_PURPOSE);
        request.setEntityName(name);
        request.setPublicId(resId.getPublicId());
        ResourceResponse rsrc = this.resolver.resolve(request);
        if (!rsrc.isResolved()) {
            ResourceRequest altRequest = this.resolver.getRequest(resId.getExpandedSystemId(), resId.getBaseSystemId(), "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity", ResolverConstants.ANY_PURPOSE);
            altRequest.setEntityName(name);
            altRequest.setPublicId(resId.getPublicId());
            rsrc = this.resolver.resolve(altRequest);
        }
        if (rsrc == null) {
            rsrc = this.safeOpenConnection(request);
        }
        return rsrc == null ? null : new SAXInputSource((InputSource)new ResolverInputSource(rsrc));
    }

    private XMLInputSource resolveSchema(XSDDescription resId) {
        ResourceRequest request = null;
        ResourceResponse rsrc = null;
        if (resId.getLiteralSystemId() != null) {
            request = this.resolver.getRequest(resId.getLiteralSystemId(), resId.getBaseSystemId());
            rsrc = this.resolver.resolve(request);
            if (!rsrc.isResolved()) {
                rsrc = this.safeOpenConnection(request);
            }
        } else {
            request = this.resolver.getRequest(resId.getNamespace(), resId.getBaseSystemId(), "http://www.w3.org/2001/XMLSchema", "http://www.rddl.org/purposes#schema-validation");
            rsrc = this.resolver.resolve(request);
        }
        if (rsrc != null && rsrc.isResolved()) {
            ResolverInputSource source = new ResolverInputSource(rsrc);
            source.setSystemId(rsrc.getResolvedURI().toString());
            return new SAXInputSource((InputSource)source);
        }
        return null;
    }
}

