/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.loaders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceRequestImpl;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.XMLResolver;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.catalog.entry.EntryCatalog;
import org.xmlresolver.catalog.entry.EntryNull;
import org.xmlresolver.exceptions.CatalogUnavailableException;
import org.xmlresolver.loaders.CatalogLoader;
import org.xmlresolver.loaders.CatalogLoaderResolver;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.utils.PublicId;
import org.xmlresolver.utils.SaxProducer;
import org.xmlresolver.utils.URIUtils;

public class XmlLoader
implements CatalogLoader {
    protected final ResolverConfiguration config;
    protected final ResolverLogger logger;
    protected final HashMap<URI, EntryCatalog> catalogMap;
    private static XMLResolver loaderResolver = null;
    private boolean preferPublic = true;
    private boolean archivedCatalogs = true;
    private EntityResolver entityResolver = null;

    public XmlLoader(ResolverConfiguration config) {
        this.config = config;
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
        this.entityResolver = new CatalogLoaderResolver();
        this.catalogMap = new HashMap();
    }

    @Override
    public void setPreferPublic(boolean prefer) {
        this.preferPublic = prefer;
    }

    @Override
    public boolean getPreferPublic() {
        return this.preferPublic;
    }

    @Override
    public void setArchivedCatalogs(boolean allow) {
        this.archivedCatalogs = allow;
    }

    @Override
    public boolean getArchivedCatalogs() {
        return this.archivedCatalogs;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public static synchronized XMLResolver getLoaderResolver() {
        if (loaderResolver == null) {
            XMLResolverConfiguration config = new XMLResolverConfiguration(Collections.emptyList(), Collections.emptyList());
            config.setFeature(ResolverFeature.PREFER_PUBLIC, true);
            config.setFeature(ResolverFeature.CATALOG_FILES, Collections.singletonList("classpath:/org/xmlresolver/catalog.xml"));
            config.setFeature(ResolverFeature.ALLOW_CATALOG_PI, false);
            config.setFeature(ResolverFeature.CLASSPATH_CATALOGS, false);
            loaderResolver = new XMLResolver(config);
        }
        return loaderResolver;
    }

    @Override
    public EntryCatalog loadCatalog(URI catalog) {
        if (this.catalogMap.containsKey(catalog)) {
            return this.catalogMap.get(catalog);
        }
        HashMap<URI, EntryCatalog> hashMap = this.catalogMap;
        synchronized (hashMap) {
            EntryCatalog entryCatalog;
            block16: {
                if (this.catalogMap.containsKey(catalog)) {
                    return this.catalogMap.get(catalog);
                }
                ResourceRequestImpl request = new ResourceRequestImpl(this.config);
                request.setURI(catalog);
                request.setOpenStream(true);
                ResourceResponse resp = this.config.getResource(request);
                InputStream is = resp.getInputStream();
                try {
                    InputSource source = new InputSource(is);
                    source.setSystemId(catalog.toString());
                    EntryCatalog entries = this.loadCatalog(catalog, source);
                    this.logger.log("config", "Loaded catalog: %s", catalog);
                    entryCatalog = entries;
                    if (is == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (CatalogUnavailableException ex) {
                        if (ex.getCause() instanceof FileNotFoundException) {
                            this.logger.log("warning", "Failed to load catalog: %s: %s", catalog, ex.getMessage());
                            this.catalogMap.put(catalog, new EntryCatalog(this.config, catalog, null, false));
                            return this.catalogMap.get(catalog);
                        }
                        this.logger.log("error", "Failed to load catalog: %s: %s", catalog, ex.getMessage());
                        this.catalogMap.put(catalog, new EntryCatalog(this.config, catalog, null, false));
                        throw ex;
                    }
                    catch (IOException | URISyntaxException ex) {
                        this.logger.log("error", "Failed to load catalog: %s: %s", catalog, ex.getMessage());
                        this.catalogMap.put(catalog, new EntryCatalog(this.config, catalog, null, false));
                        throw new CatalogUnavailableException(ex);
                    }
                }
                is.close();
            }
            return entryCatalog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryCatalog loadCatalog(URI catalog, InputSource source) {
        if (this.catalogMap.containsKey(catalog)) {
            return this.catalogMap.get(catalog);
        }
        if (!catalog.isAbsolute()) {
            throw new IllegalArgumentException("Catalog URIs must be absolute: " + catalog);
        }
        URI zipcatalog = null;
        HashMap<URI, EntryCatalog> hashMap = this.catalogMap;
        synchronized (hashMap) {
            block12: {
                try {
                    if (this.catalogMap.containsKey(catalog)) {
                        return this.catalogMap.get(catalog);
                    }
                    CatalogContentHandler handler = new CatalogContentHandler(this.config, catalog, this.preferPublic);
                    Supplier<XMLReader> supplier = this.config.getFeature(ResolverFeature.XMLREADER_SUPPLIER);
                    if (supplier != null) {
                        XMLReader reader = supplier.get();
                        reader.setContentHandler(handler);
                        reader.setEntityResolver(this.entityResolver);
                        reader.parse(source);
                    } else {
                        SAXParserFactory spf = SAXParserFactory.newInstance();
                        spf.setNamespaceAware(true);
                        spf.setValidating(false);
                        spf.setXIncludeAware(false);
                        SAXParser parser = spf.newSAXParser();
                        parser.getXMLReader().setEntityResolver(this.entityResolver);
                        parser.parse(source, (DefaultHandler)handler);
                    }
                    EntryCatalog entry = handler.catalog();
                    this.catalogMap.put(catalog, entry);
                }
                catch (IOException | ParserConfigurationException | SAXException ex) {
                    this.logger.log("error", "Failed to load catalog: " + catalog + ": " + ex.getMessage(), new Object[0]);
                    if (this.archivedCatalogs) {
                        zipcatalog = this.archiveCatalog(catalog);
                    }
                    if (zipcatalog != null) break block12;
                    this.catalogMap.put(catalog, new EntryCatalog(this.config, catalog, null, false));
                }
            }
            if (zipcatalog != null) {
                EntryCatalog entries = this.loadCatalog(zipcatalog);
                this.catalogMap.put(catalog, entries);
            }
        }
        return this.catalogMap.get(catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryCatalog loadCatalog(URI catalog, SaxProducer producer) {
        if (this.catalogMap.containsKey(catalog)) {
            return this.catalogMap.get(catalog);
        }
        if (!catalog.isAbsolute()) {
            throw new IllegalArgumentException("Catalog URIs must be absolute: " + catalog);
        }
        URI zipcatalog = null;
        HashMap<URI, EntryCatalog> hashMap = this.catalogMap;
        synchronized (hashMap) {
            block10: {
                if (this.catalogMap.containsKey(catalog)) {
                    return this.catalogMap.get(catalog);
                }
                try {
                    CatalogContentHandler handler = new CatalogContentHandler(this.config, catalog, this.preferPublic);
                    producer.produce(handler, null, null);
                    EntryCatalog entry = handler.catalog();
                    this.catalogMap.put(catalog, entry);
                }
                catch (IOException | SAXException ex) {
                    this.logger.log("error", "Failed to load catalog: " + catalog + ": " + ex.getMessage(), new Object[0]);
                    if (this.archivedCatalogs) {
                        zipcatalog = this.archiveCatalog(catalog);
                    }
                    if (zipcatalog != null) break block10;
                    this.catalogMap.put(catalog, new EntryCatalog(this.config, catalog, null, false));
                }
            }
            if (zipcatalog != null) {
                EntryCatalog entries = this.loadCatalog(zipcatalog);
                this.catalogMap.put(catalog, entries);
            }
        }
        return this.catalogMap.get(catalog);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URI archiveCatalog(URI catalog) {
        if (!"file".equals(catalog.getScheme())) {
            return null;
        }
        HashSet<String> catalogSet = new HashSet<String>();
        boolean firstEntry = true;
        String leadingDir = null;
        try {
            URLConnection conn = catalog.toURL().openConnection();
            try (InputStream is = conn.getInputStream();
                 ZipInputStream zip = new ZipInputStream(is);){
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    int pos;
                    if (firstEntry) {
                        pos = entry.getName().indexOf("/");
                        if (pos >= 0) {
                            leadingDir = entry.getName().substring(0, pos);
                        }
                        firstEntry = false;
                    } else if (!(leadingDir == null || (pos = entry.getName().indexOf("/")) >= 0 && leadingDir.equals(entry.getName().substring(0, pos)))) {
                        leadingDir = null;
                    }
                    if (!entry.isDirectory() && entry.getName().endsWith("catalog.xml")) {
                        catalogSet.add(entry.getName());
                    }
                    entry = zip.getNextEntry();
                }
                zip.close();
                String catpath = null;
                if (leadingDir != null) {
                    if (catalogSet.contains(leadingDir + "/catalog.xml")) {
                        catpath = "/" + leadingDir + "/catalog.xml";
                    }
                    if (catalogSet.contains(leadingDir + "/org/xmlresolver/catalog.xml")) {
                        catpath = "/" + leadingDir + "/org/xmlresolver/catalog.xml";
                    }
                } else {
                    if (catalogSet.contains("catalog.xml")) {
                        catpath = "/catalog.xml";
                    }
                    if (catalogSet.contains("org/xmlresolver/catalog.xml")) {
                        catpath = "/org/xmlresolver/catalog.xml";
                    }
                }
                if (catpath != null) {
                    URI uRI = new URI("jar:file://" + catalog.getPath() + "!" + catpath);
                    return uRI;
                }
            }
            this.logger.log("error", "Failed to find catalog in archived catalog: " + catalog, new Object[0]);
            return null;
        }
        catch (IOException | URISyntaxException ex) {
            this.logger.log("error", "Failed to load archived catalog: " + catalog + ": " + ex.getMessage(), new Object[0]);
        }
        return null;
    }

    private static class CatalogContentHandler
    extends DefaultHandler {
        public final ResolverLogger logger;
        private static final HashSet<String> CATALOG_ELEMENTS = new HashSet<String>(Arrays.asList("group", "public", "system", "rewriteSystem", "delegatePublic", "delegateSystem", "uri", "rewriteURI", "delegateURI", "nextCatalog", "uriSuffix", "systemSuffix"));
        private static final HashSet<String> TR9401_ELEMENTS = new HashSet<String>(Arrays.asList("doctype", "document", "dtddecl", "entity", "linktype", "notation", "sgmldecl"));
        private boolean fixWindows = false;
        private Locator locator = null;
        private final ResolverConfiguration config;
        private final Stack<Entry> parserStack = new Stack();
        private final Stack<Boolean> preferPublicStack = new Stack();
        private final Stack<URI> baseURIStack = new Stack();
        private EntryCatalog catalog = null;

        protected CatalogContentHandler(ResolverConfiguration config, URI uri, boolean preferPublic) {
            this.config = config;
            this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
            this.preferPublicStack.push(preferPublic);
            this.baseURIStack.push(uri);
            this.fixWindows = config.getFeature(ResolverFeature.FIX_WINDOWS_SYSTEM_IDENTIFIERS);
        }

        public EntryCatalog catalog() {
            return this.catalog;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
            if (this.catalog != null) {
                this.catalog.setLocator(locator);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.parserStack.isEmpty()) {
                if ("urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(uri) && "catalog".equals(localName)) {
                    String id = attributes.getValue("", "id");
                    String prefer = attributes.getValue("", "prefer");
                    if (prefer != null) {
                        this.preferPublicStack.push("public".equals(prefer));
                        if (!"public".equals(prefer) && !"system".equals(prefer)) {
                            this.logger.log("error", "Prefer on " + localName + " is neither 'system' nor 'public': " + prefer, new Object[0]);
                        }
                    }
                    this.catalog = new EntryCatalog(this.config, this.baseURIStack.peek(), id, this.preferPublicStack.peek());
                    this.parserStack.push(this.catalog);
                    if (this.locator != null) {
                        this.catalog.setLocator(this.locator);
                    }
                } else {
                    this.logger.log("error", "Catalog document is not an XML Catalog (ignored): " + qName, new Object[0]);
                    this.catalog = new EntryCatalog(this.config, this.baseURIStack.peek(), null, false);
                    this.parserStack.push(new EntryNull(this.config));
                }
                URI baseURI = this.baseURIStack.peek();
                if (attributes.getValue("xml:base") != null) {
                    baseURI = URIUtils.resolve(baseURI, attributes.getValue("xml:base"));
                }
                this.baseURIStack.push(baseURI);
                this.preferPublicStack.push(this.preferPublicStack.peek());
                return;
            }
            Entry top = this.parserStack.peek();
            if (top.getType() == Entry.Type.NULL) {
                this.pushNull();
            } else if ("urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(uri)) {
                if (CATALOG_ELEMENTS.contains(localName) || TR9401_ELEMENTS.contains(localName)) {
                    this.catalogElement(localName, attributes);
                } else {
                    this.logger.log("error", "Unexpected catalog element (ignored): " + localName, new Object[0]);
                    this.pushNull();
                }
            } else if ("urn:oasis:names:tc:entity:xmlns:tr9401:catalog".equals(uri)) {
                if (TR9401_ELEMENTS.contains(localName)) {
                    this.catalogElement(localName, attributes);
                } else {
                    this.logger.log("error", "Unexpected catalog element (ignored): " + localName, new Object[0]);
                    this.pushNull();
                }
            } else {
                this.pushNull();
            }
        }

        private void pushNull() {
            this.parserStack.push(new EntryNull(this.config));
            this.baseURIStack.push(this.baseURIStack.peek());
            this.preferPublicStack.push(this.preferPublicStack.peek());
        }

        private void catalogElement(String localName, Attributes attributes) {
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String uri = attributes.getValue("", "uri");
            String caturi = attributes.getValue("", "catalog");
            URI baseURI = this.baseURIStack.peek();
            if (attributes.getValue("xml:base") != null) {
                baseURI = URIUtils.resolve(baseURI, attributes.getValue("xml:base"));
            }
            boolean preferPublic = this.preferPublicStack.peek();
            Entry entry = new EntryNull(this.config);
            switch (localName) {
                case "group": {
                    String prefer = attributes.getValue("", "prefer");
                    if (prefer != null) {
                        preferPublic = "public".equals(prefer);
                        if (!"public".equals(prefer) && !"system".equals(prefer)) {
                            this.logger.log("error", "Prefer on " + localName + " is neither 'system' nor 'public': " + prefer, new Object[0]);
                        }
                    }
                    entry = this.catalog.addGroup(baseURI, id, preferPublic);
                    break;
                }
                case "public": {
                    String publicId = PublicId.normalize(attributes.getValue("", "publicId"));
                    entry = this.catalog.addPublic(baseURI, id, publicId, uri, preferPublic);
                    break;
                }
                case "system": {
                    String systemId = this.patchedSystemIdentifier(attributes.getValue("", "systemId"));
                    entry = this.catalog.addSystem(baseURI, id, systemId, uri);
                    break;
                }
                case "rewriteSystem": {
                    String start = this.patchedSystemIdentifier(attributes.getValue("", "systemIdStartString"));
                    String prefix = attributes.getValue("", "rewritePrefix");
                    entry = this.catalog.addRewriteSystem(baseURI, id, start, prefix);
                    break;
                }
                case "systemSuffix": {
                    String suffix = this.patchedSystemIdentifier(attributes.getValue("", "systemIdSuffix"));
                    entry = this.catalog.addSystemSuffix(baseURI, id, suffix, uri);
                    break;
                }
                case "delegatePublic": {
                    String start = PublicId.normalize(attributes.getValue("", "publicIdStartString"));
                    entry = this.catalog.addDelegatePublic(baseURI, id, start, caturi, preferPublic);
                    break;
                }
                case "delegateSystem": {
                    String start = this.patchedSystemIdentifier(attributes.getValue("", "systemIdStartString"));
                    entry = this.catalog.addDelegateSystem(baseURI, id, start, caturi);
                    break;
                }
                case "uri": {
                    String nature = attributes.getValue("http://www.rddl.org/", "nature");
                    String purpose = attributes.getValue("http://www.rddl.org/", "purpose");
                    entry = this.catalog.addUri(baseURI, id, name, uri, nature, purpose);
                    break;
                }
                case "uriSuffix": {
                    String suffix = attributes.getValue("", "uriSuffix");
                    entry = this.catalog.addUriSuffix(baseURI, id, suffix, uri);
                    break;
                }
                case "rewriteURI": {
                    String start = attributes.getValue("", "uriStartString");
                    String prefix = attributes.getValue("", "rewritePrefix");
                    entry = this.catalog.addRewriteUri(baseURI, id, start, prefix);
                    break;
                }
                case "delegateURI": {
                    String start = attributes.getValue("", "uriStartString");
                    entry = this.catalog.addDelegateUri(baseURI, id, start, caturi);
                    break;
                }
                case "nextCatalog": {
                    entry = this.catalog.addNextCatalog(baseURI, id, caturi);
                    break;
                }
                case "doctype": {
                    entry = this.catalog.addDoctype(baseURI, id, name, uri);
                    break;
                }
                case "document": {
                    entry = this.catalog.addDocument(baseURI, id, uri);
                    break;
                }
                case "dtddecl": {
                    String publicId = attributes.getValue("", "publicId");
                    entry = this.catalog.addDtdDecl(baseURI, id, publicId, uri);
                    break;
                }
                case "entity": {
                    entry = this.catalog.addEntity(baseURI, id, name, uri);
                    break;
                }
                case "linktype": {
                    entry = this.catalog.addLinktype(baseURI, id, name, uri);
                    break;
                }
                case "notation": {
                    entry = this.catalog.addNotation(baseURI, id, name, uri);
                    break;
                }
                case "sgmldecl": {
                    entry = this.catalog.addSgmlDecl(baseURI, id, uri);
                    break;
                }
            }
            for (int pos = 0; pos < attributes.getLength(); ++pos) {
                if (!"http://xmlresolver.org/ns/catalog".equals(attributes.getURI(pos))) continue;
                entry.setProperty(attributes.getLocalName(pos), attributes.getValue(pos));
            }
            this.parserStack.push(entry);
            this.baseURIStack.push(baseURI);
            this.preferPublicStack.push(preferPublic);
        }

        private String patchedSystemIdentifier(String systemId) {
            if (systemId != null && this.fixWindows) {
                systemId = systemId.replace("\\", "/");
            }
            return systemId;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.parserStack.pop();
            this.baseURIStack.pop();
            this.preferPublicStack.pop();
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return XmlLoader.getLoaderResolver().getEntityResolver().resolveEntity(publicId, systemId);
        }
    }
}

