/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.sources;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.sources.ResolverResourceInfo;
import org.xmlresolver.utils.RsrcUtils;

public class ResolverInputSource
extends InputSource
implements ResolverResourceInfo {
    private final ResourceResponse response;
    private final URI resolvedURI;
    private final int statusCode;
    private final Map<String, List<String>> resolvedHeaders;

    public ResolverInputSource(ResourceResponse rsrc) {
        super(rsrc.getInputStream());
        this.setSystemId(rsrc.getURI().toString());
        this.setPublicId(rsrc.getRequest().getPublicId());
        this.response = rsrc;
        this.resolvedURI = rsrc.getResolvedURI();
        this.statusCode = rsrc.getStatusCode();
        this.resolvedHeaders = rsrc.getHeaders();
    }

    @Override
    public ResourceResponse getResponse() {
        return this.response;
    }

    @Override
    public URI getResolvedURI() {
        return this.resolvedURI;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.resolvedHeaders;
    }

    @Override
    public String getHeader(String headerName) {
        return RsrcUtils.getHeader(headerName, this.resolvedHeaders);
    }
}

