/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.schema;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.javastro.ivoa.schema.LSResourceAdapter;
import org.javastro.ivoa.schema.SchemaMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmlresolver.CatalogManager;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.XMLResolver;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.catalog.entry.EntryCatalog;

public class XMLValidator {
    private static final Logger logger = LoggerFactory.getLogger(XMLValidator.class);
    private SimpleErrorHandler errorHandler = new SimpleErrorHandler();
    private Map<ErrorKind, List<ErrorDesciption>> errorMap = new HashMap<ErrorKind, List<ErrorDesciption>>();

    public static void main(String[] args) {
        XMLValidator validator = new XMLValidator();
        if (args.length >= 1) {
            boolean overallValid = true;
            for (String arg : args) {
                boolean valid;
                try {
                    valid = validator.validate(new File(arg));
                }
                catch (FileNotFoundException e) {
                    valid = false;
                    e.printStackTrace();
                }
                if (!valid) {
                    System.out.println(arg);
                    validator.printErrors(System.out);
                }
                overallValid |= valid;
            }
            System.exit(overallValid ? 0 : 1);
        } else {
            System.err.println("Should specify filename(s) of file(S) to be validated");
            System.exit(1);
        }
    }

    public boolean validate(File file) throws FileNotFoundException {
        return this.validate(new StreamSource(file));
    }

    public boolean validate(URL url) {
        try {
            StreamSource src = new StreamSource(url.openStream());
            return this.validate(src);
        }
        catch (IOException e) {
            logger.error("failed to open url", (Throwable)e);
            return false;
        }
    }

    public boolean validate(Source xmlFile) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        XMLResolver xmlResolver = XMLValidator.makeXMLResolver();
        schemaFactory.setResourceResolver(new LSResourceAdapter(xmlResolver));
        Validator validator = null;
        try {
            schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "file");
            Schema schema = schemaFactory.newSchema(SchemaMap.getRegistrySchemaAsSources());
            validator = schema.newValidator();
        }
        catch (SAXException e) {
            logger.error("cannot create validator", (Throwable)e);
            return false;
        }
        validator.setResourceResolver(new LSResourceAdapter(xmlResolver));
        this.errorMap = new HashMap<ErrorKind, List<ErrorDesciption>>();
        validator.setErrorHandler(this.errorHandler);
        try {
            validator.validate(xmlFile);
            return this.errorMap.isEmpty();
        }
        catch (SAXException e) {
            ErrorDesciption d = new ErrorDesciption(e);
            XMLValidator.put(this.errorMap, d.kind, d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean wasValid() {
        return this.errorMap.isEmpty();
    }

    public void printErrors(PrintStream printStream) {
        this.errorMap.forEach((kind, errors) -> errors.stream().forEach(printStream::println));
    }

    public static XMLResolver makeXMLResolver() {
        XMLResolverConfiguration config = new XMLResolverConfiguration();
        config.setFeature(ResolverFeature.DEFAULT_LOGGER_LOG_LEVEL, (Object)"info");
        config.setFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT, (Object)"all");
        config.setFeature(ResolverFeature.THROW_URI_EXCEPTIONS, (Object)true);
        config.setFeature(ResolverFeature.ALWAYS_RESOLVE, (Object)false);
        config.setFeature(ResolverFeature.PREFER_PUBLIC, (Object)false);
        config.setFeature(ResolverFeature.CLASSPATH_CATALOGS, (Object)true);
        CatalogManager manager = (CatalogManager)config.getFeature(ResolverFeature.CATALOG_MANAGER);
        URI caturi = URI.create("https://javastro.net/xml/catalog.xml");
        config.addCatalog(caturi.toString());
        EntryCatalog cat = manager.loadCatalog(caturi, SchemaMap.asXMLCatalogue());
        try {
            manager.loadCatalog(XMLResolver.class.getResource("/org/xmlresolver/catalog.xml").toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        XMLResolver resolver = new XMLResolver((ResolverConfiguration)config);
        return resolver;
    }

    private static <KEY, VALUE> void put(Map<KEY, List<VALUE>> map, KEY key, VALUE value) {
        map.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    private class SimpleErrorHandler
    implements ErrorHandler {
        private SimpleErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            ErrorKind kind = ErrorKind.Warning;
            ErrorDesciption err = new ErrorDesciption(kind, exception);
            logger.trace(err.toString());
            XMLValidator.put(XMLValidator.this.errorMap, kind, err);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            ErrorKind kind = ErrorKind.Warning;
            ErrorDesciption err = new ErrorDesciption(kind, exception);
            logger.trace(err.toString());
            XMLValidator.put(XMLValidator.this.errorMap, kind, err);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            ErrorKind kind = ErrorKind.Warning;
            ErrorDesciption err = new ErrorDesciption(kind, exception);
            logger.trace(err.toString());
            XMLValidator.put(XMLValidator.this.errorMap, kind, err);
        }
    }

    public class ErrorDesciption {
        String desc;
        ErrorKind kind;
        int line;
        int column;

        public ErrorDesciption(ErrorKind kind, SAXParseException e) {
            this.desc = e.getMessage();
            this.kind = kind;
            this.line = e.getLineNumber();
            this.column = e.getColumnNumber();
        }

        public ErrorDesciption(SAXException e) {
            this.desc = e.getMessage();
            this.kind = ErrorKind.Sax;
            this.line = 0;
            this.column = 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Validation ");
            builder.append((Object)this.kind);
            builder.append(" ").append(this.desc);
            if (this.line > 0) {
                builder.append(" line=");
                builder.append(this.line);
                if (this.column > 0) {
                    builder.append(", column=");
                    builder.append(this.column);
                }
            }
            return builder.toString();
        }
    }

    public static enum ErrorKind {
        Warning,
        Error,
        FatalError,
        Sax;

    }
}

