/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.transform.stream.StreamSource;
import org.javastro.ivoa.schema.Namespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SchemaMap {
    private static final Logger logger = LoggerFactory.getLogger(SchemaMap.class);
    public static final Map<String, String> ALL = new HashMap<String, String>();
    static final Map<String, URL> ALLUrl;
    public static final String xmlCatalogue;

    static {
        ALL.put("http://www.ivoa.net/xml/RegistryInterface/v1.0", "/schema/RegistryInterface-v1.0.xsd");
        ALL.put("http://www.openarchives.org/OAI/2.0/", "/schema/OAI-PMH.xsd");
        ALL.put("http://www.w3.org/1999/xlink", "/schema/xlink.xsd");
        ALL.put("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "/schema/STC-v1.30.xsd");
        ALL.put("http://www.ivoa.net/xml/STC/stc-v1.20.xsd", "/schema/STC-v1.20.xsd");
        ALL.put("http://www.ivoa.net/xml/STC/STCcoords/v1.20", "/schema/STC-coords-v1.20.xsd");
        ALL.put("http://www.ivoa.net/xml/STC/STCregion/v1.20", "/schema/STC-region-v1.20.xsd");
        ALL.put("http://www.ivoa.net/xml/VOTable/v1.0", "/schema/VOTable-1.0.xsd");
        ALL.put("http://www.ivoa.net/xml/VOTable/v1.1", "/schema/VOTable-1.1.xsd");
        ALL.put("http://www.ivoa.net/xml/VOTable/v1.2", "/schema/VOTable-1.2.xsd");
        ALL.put("http://www.ivoa.net/xml/VOTable/v1.3", "/schema/VOTable-1.4.xsd");
        ALL.put("http://www.ivoa.net/xml/ConeSearch/v1.0", "/schema/ConeSearch-v1.0.xsd");
        ALL.put("http://www.ivoa.net/xml/SSA/v1.1", "/schema/SSA-v1.2.xsd");
        ALL.put("http://www.ivoa.net/xml/SIA/v1.0", "/schema/SIA-v1.0.xsd");
        ALL.put("http://www.ivoa.net/xml/SIA/v1.1", "/schema/SIA-v1.1.xsd");
        ALL.put("http://www.ivoa.net/xml/SkyNode/v0.2", "/schema/OpenSkyNode-v0.2.xsd");
        ALL.put("http://www.ivoa.net/xml/VODataService/v1.0", "/schema/VODataService-v1.0.xsd");
        ALL.put("http://www.ivoa.net/xml/VODataService/v1.1", "/schema/VODataService-v1.2.xsd");
        ALL.put("http://www.ivoa.net/xml/VORegistry/v1.0", "/schema/VORegistry-v1.0.xsd");
        ALL.put("http://www.ivoa.net/xml/VOResource/v1.0", "/schema/VOResource-v1.1.xsd");
        ALL.put("http://www.ivoa.net/xml/VOApplication/v1.0rc1", "/schema/VOApplication-1.0.xsd");
        ALL.put("http://www.ivoa.net/xml/StandardsRegExt/v1.0", "/schema/StandardsRegExt-1.0.xsd");
        ALL.put("http://www.ivoa.net/xml/TAPRegExt/v1.0", "/schema/TAPRegExt-v1.0.xsd");
        ALL.put("http://www.ivoa.net/xml/SLAP/v1.0", "/schema/SLAP-v1.1.xsd");
        ALL.put("http://www.ivoa.net/xml/VOSIAvailability/v1.0", "/schema/VOSIAvailability-v1.0.xsd");
        ALL.put("http://www.ivoa.net/xml/VOSICapabilities/v1.0", "/schema/VOSICapabilities-v1.0.xsd");
        ALL.put("http://www.ivoa.net/xml/VOSITables/v1.0", "/schema/VOSITables-v1.1.xsd");
        ALL.put("http://www.ivoa.net/xml/UWS/v1.0", "/schema/UWS-1.1.xsd");
        ALL.put("http://www.ivoa.net/xml/VODML/v1", "/schema/vo-dml-v1.0.xsd");
        ALLUrl = ALL.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> SchemaMap.nameToURL(v)));
        xmlCatalogue = SchemaMap.makeCatalogue();
    }

    private SchemaMap() {
    }

    private static URL nameToURL(Map.Entry<String, String> e) {
        return SchemaMap.class.getResource(e.getValue());
    }

    static String makeCatalogue() {
        StringWriter writer = new StringWriter();
        writer.write("<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">\n");
        ALL.forEach((k, v) -> {
            writer.append("<uri name=\"");
            writer.append((CharSequence)k);
            writer.append("\" uri=\"classpath:");
            writer.append((CharSequence)v);
            writer.append("\"/>\n");
        });
        writer.write("</catalog>");
        return writer.toString();
    }

    public static URL getSchemaURL(String namespace) {
        return ALLUrl.get(namespace);
    }

    public static InputStream getSchemaAsStream(String namespace) {
        return SchemaMap.class.getResourceAsStream(ALL.get(namespace));
    }

    public static StreamSource[] getRegistrySchemaAsSources() {
        List<Namespaces> ns = Arrays.asList(Namespaces.RI, Namespaces.VR, Namespaces.VS, Namespaces.SIA, Namespaces.CS, Namespaces.REG, Namespaces.VA, Namespaces.VSTD, Namespaces.VOSI_TAB, Namespaces.STC);
        return SchemaMap.schemaSourceFromNamespaces(ns);
    }

    public static StreamSource[] getAllSchemaAsSources() {
        return SchemaMap.schemaSourceFromNamespaces(Namespaces.getAllIVOA());
    }

    private static StreamSource[] schemaSourceFromNamespaces(List<Namespaces> ns) {
        return (StreamSource[])ns.stream().map(n -> SchemaMap.getSchemaURL(n.getNamespace())).map(u -> {
            try {
                return new StreamSource(u.openStream(), u.toExternalForm());
            }
            catch (IOException e) {
                logger.error("problem with getting url for schema", (Throwable)e);
                return new StreamSource();
            }
        }).toArray(StreamSource[]::new);
    }

    public static InputSource asXMLCatalogue() {
        return new InputSource(new StringReader(xmlCatalogue));
    }
}

