
package org.ivoa.vodml.stdtypes;

import javax.persistence.*;

import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.annotation.VodmlType;

/**
 * UML PrimitiveType complex : Represents a complex number, consisting of a real
 * and imaginary component, both of which are reals. Note that in many contexts
 * there is no native mapping for this type and it must be treated with a custom
 * mapping.
 *
 * @author generated by VO-URP tools VO-URP Home
 * @author Laurent Bourges (voparis) / Gerard Lemson (mpe)
 */
@VoDml(ref = "ivoa:complex", type=VodmlType.primitiveType)
@Embeddable
public class Complex {

    /** string representation */
    private double re;
    private double im;

    /**
     * Creates a new complex Primitive Type instance, wrapping a base type.
     *
     * @param _re real part
     * @param _im imqginary part
     */
    public Complex(final double _re, final double _im) {
        this.re = _re;
        this.im = _im;
    }

    /**
     * TODO Implement better parser
     * 
     * @param sv a string representation of the complex number.
     */
    public Complex(String sv) {
        String[] words = sv.trim().split("[(,)]");
        if (words.length != 2)
            throw new IllegalArgumentException(
                    "String value in constructor must be of form '(%f,%f)'");
        this.re = Double.parseDouble(words[0]);
        this.im = Double.parseDouble(words[1]);
    }

    public Complex() {
        this(0, 0);
    }

    /**
     * Return the string representation.
     * 
     * @return string representation of the complex.
     */
    @Override
    public final String toString() {
        return String.format("(%f,%f)", re, im);
    }

    public double getRe() {
        return re;
    }

    public double getIm() {
        return im;
    }

 
    public void setRe(double re) {
        this.re = re;
    }

    public void setIm(double im) {
        this.im = im;
    }
}
