/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Map;
import org.ivoa.vodml.ModelDescription;
import org.ivoa.vodml.annotation.VoDml;

public class VodmlTypeResolver
extends TypeIdResolverBase {
    private Map<String, Class> typeMap;

    public VodmlTypeResolver(ModelDescription md) {
        this.typeMap = md.utypeToClassMap();
    }

    public String idFromValue(Object value) {
        VoDml ann = value.getClass().getAnnotation(VoDml.class);
        return ann.ref();
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.idFromValue(value);
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        if (this.typeMap.containsKey(id)) {
            return context.getTypeFactory().constructFromCanonical(this.typeMap.get(id).getCanonicalName());
        }
        return TypeFactory.unknownType();
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }
}

